import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Properties for EmrCancelStep.
 *
 * @stability stable
 */
export interface EmrCancelStepProps extends sfn.TaskStateBaseProps {
    /**
     * The ClusterId to update.
     *
     * @stability stable
     */
    readonly clusterId: string;
    /**
     * The StepId to cancel.
     *
     * @stability stable
     */
    readonly stepId: string;
}
/**
 * A Step Functions Task to to cancel a Step on an EMR Cluster.
 *
 * @stability stable
 */
export declare class EmrCancelStep extends sfn.TaskStateBase {
    private readonly props;
    /**
     * @stability stable
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @stability stable
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: EmrCancelStepProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
}
