# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs

__all__ = [
    'clientcert',
    'connect_timeout',
    'database',
    'database_username',
    'expected_version',
    'host',
    'max_connections',
    'password',
    'port',
    'scheme',
    'ssl_mode',
    'sslmode',
    'sslrootcert',
    'superuser',
    'username',
]

__config__ = pulumi.Config('postgresql')

clientcert = __config__.get('clientcert')
"""
SSL client certificate if required by the database.
"""

connect_timeout = __config__.get('connectTimeout') or (_utilities.get_env_int('PGCONNECT_TIMEOUT') or 180)
"""
Maximum wait for connection, in seconds. Zero or not specified means wait indefinitely.
"""

database = __config__.get('database') or (_utilities.get_env('PGDATABASE') or 'postgres')
"""
The name of the database to connect to in order to conenct to (defaults to `postgres`).
"""

database_username = __config__.get('databaseUsername')
"""
Database username associated to the connected user (for user name maps)
"""

expected_version = __config__.get('expectedVersion')
"""
Specify the expected version of PostgreSQL.
"""

host = __config__.get('host') or _utilities.get_env('PGHOST')
"""
Name of PostgreSQL server address to connect to
"""

max_connections = __config__.get('maxConnections')
"""
Maximum number of connections to establish to the database. Zero means unlimited.
"""

password = __config__.get('password') or _utilities.get_env('PGPASSWORD')
"""
Password to be used if the PostgreSQL server demands password authentication
"""

port = __config__.get('port') or (_utilities.get_env_int('PGPORT') or 5432)
"""
The PostgreSQL port number to connect to at the server host, or socket file name extension for Unix-domain connections
"""

scheme = __config__.get('scheme')

ssl_mode = __config__.get('sslMode')

sslmode = __config__.get('sslmode') or _utilities.get_env('PGSSLMODE')
"""
This option determines whether or with what priority a secure SSL TCP/IP connection will be negotiated with the
PostgreSQL server
"""

sslrootcert = __config__.get('sslrootcert')
"""
The SSL server root certificate file path. The file must contain PEM encoded data.
"""

superuser = __config__.get('superuser')
"""
Specify if the user to connect as is a Postgres superuser or not.If not, some feature might be disabled (e.g.:
Refreshing state password from Postgres)
"""

username = __config__.get('username') or (_utilities.get_env('PGUSER') or 'postgres')
"""
PostgreSQL user name to connect as
"""

