"""
This type stub file was generated by pyright.
"""

from dataclasses import dataclass
from pathlib import Path
from typing import List, Optional, Tuple, Type, Union
from datasets import DownloadMode
from datasets.builder import DatasetBuilder
from datasets.utils.version import Version
from .module import EvaluationModule
from .utils.file_utils import DownloadConfig

"""Access datasets."""
logger = ...
ALL_ALLOWED_EXTENSIONS = ...
def init_dynamic_modules(name: str = ..., hf_modules_cache: Optional[Union[Path, str]] = ...): # -> str:
    """
    Create a module with name `name` in which you can add dynamic modules
    such as metrics or datasets. The module can be imported using its name.
    The module is created in the HF_MODULE_CACHE directory by default (~/.cache/huggingface/modules) but it can
    be overriden by specifying a path to another directory in `hf_modules_cache`.
    """
    ...

def import_main_class(module_path) -> Optional[Union[Type[DatasetBuilder], Type[EvaluationModule]]]:
    """Import a module at module_path and return its main class:
    - a DatasetBuilder if dataset is True
    - a Metric if dataset is False
    """
    ...

def files_to_hash(file_paths: List[str]) -> str:
    """
    Convert a list of scripts or text files provided in file_paths into a hashed filename in a repeatable way.
    """
    ...

def convert_github_url(url_path: str) -> Tuple[str, Optional[str]]:
    """Convert a link to a file on a github repo in a link to the raw github object."""
    ...

def increase_load_count(name: str, resource_type: str): # -> None:
    """Update the download count of a dataset or metric."""
    ...

def get_imports(file_path: str) -> Tuple[str, str, str, str]:
    """Find whether we should import or clone additional files for a given processing script.
        And list the import.

    We allow:
    - library dependencies,
    - local dependencies and
    - external dependencies whose url is specified with a comment starting from "# From:' followed by the raw url to a file, an archive or a github repository.
        external dependencies will be downloaded (and extracted if needed in the dataset folder).
        We also add an `__init__.py` to each sub-folder of a downloaded folder so the user can import from them in the script.

    Note that only direct import in the dataset processing script will be handled
    We don't recursively explore the additional import to download further files.

    Example::

        import tensorflow
        import .c4_utils
        import .clicr.dataset-code.build_json_dataset  # From: https://raw.githubusercontent.com/clips/clicr/master/dataset-code/build_json_dataset
    """
    ...

@dataclass
class ImportableModule:
    module_path: str
    hash: str
    ...


class _EvaluationModuleFactory:
    def get_module(self) -> ImportableModule:
        ...
    


class GithubEvaluationModuleFactory(_EvaluationModuleFactory):
    """Get the module of a metric. The metric script is downloaded from GitHub."""
    def __init__(self, name: str, module_type: str, revision: Optional[Union[str, Version]] = ..., download_config: Optional[DownloadConfig] = ..., download_mode: Optional[DownloadMode] = ..., dynamic_modules_path: Optional[str] = ...) -> None:
        ...
    
    def download_loading_script(self, revision: Optional[str]) -> str:
        ...
    
    def get_module(self) -> ImportableModule:
        ...
    


class LocalEvaluationModuleFactory(_EvaluationModuleFactory):
    """Get the module of a local metric. The metric script is loaded from a local script."""
    def __init__(self, path: str, module_type: str = ..., download_config: Optional[DownloadConfig] = ..., download_mode: Optional[DownloadMode] = ..., dynamic_modules_path: Optional[str] = ...) -> None:
        ...
    
    def get_module(self) -> ImportableModule:
        ...
    


class HubEvaluationModuleFactory(_EvaluationModuleFactory):
    """Get the module of a metric from a metric repository on the Hub."""
    def __init__(self, name: str, module_type: str = ..., revision: Optional[Union[str, Version]] = ..., download_config: Optional[DownloadConfig] = ..., download_mode: Optional[DownloadMode] = ..., dynamic_modules_path: Optional[str] = ...) -> None:
        ...
    
    def download_loading_script(self) -> str:
        ...
    
    def get_module(self) -> ImportableModule:
        ...
    


class CachedEvaluationModuleFactory(_EvaluationModuleFactory):
    """
    Get the module of a metric that has been loaded once already and cached.
    The script that is loaded from the cache is the most recent one with a matching name.
    """
    def __init__(self, name: str, module_type: str = ..., dynamic_modules_path: Optional[str] = ...) -> None:
        ...
    
    def get_module(self) -> ImportableModule:
        ...
    


def evaluation_module_factory(path: str, module_type: Optional[str] = ..., revision: Optional[Union[str, Version]] = ..., download_config: Optional[DownloadConfig] = ..., download_mode: Optional[DownloadMode] = ..., force_local_path: Optional[str] = ..., dynamic_modules_path: Optional[str] = ..., **download_kwargs) -> ImportableModule:
    """
    Download/extract/cache a metric module.

    Metrics codes are cached inside the the dynamic modules cache to allow easy import (avoid ugly sys.path tweaks).

    Args:

        path (str): Path or name of the metric script.

            - if ``path`` is a local metric script or a directory containing a local metric script (if the script has the same name as the directory):
              -> load the module from the metric script
              e.g. ``'./metrics/accuracy'`` or ``'./metrics/accuracy/accuracy.py'``.
            - if ``path`` is a metric on the Hugging Face Hub (ex: `glue`, `squad`)
              -> load the module from the metric script in the github repository at huggingface/datasets
              e.g. ``'accuracy'`` or ``'rouge'``.

        revision (Optional ``Union[str, datasets.Version]``):
            If specified, the module will be loaded from the datasets repository at this version.
            By default:
            - it is set to the local version of the lib.
            - it will also try to load it from the master branch if it's not available at the local version of the lib.
            Specifying a version that is different from your local version of the lib might cause compatibility issues.
        download_config (:class:`DownloadConfig`, optional): Specific download configuration parameters.
        download_mode (:class:`DownloadMode`, default ``REUSE_DATASET_IF_EXISTS``): Download/generate mode.
        force_local_path (Optional str): Optional path to a local path to download and prepare the script to.
            Used to inspect or modify the script folder.
        dynamic_modules_path (Optional str, defaults to HF_MODULES_CACHE / "datasets_modules", i.e. ~/.cache/huggingface/modules/datasets_modules):
            Optional path to the directory in which the dynamic modules are saved. It must have been initialized with :obj:`init_dynamic_modules`.
            By default the datasets and metrics are stored inside the `datasets_modules` module.
        download_kwargs: optional attributes for DownloadConfig() which will override the attributes in download_config if supplied.

    Returns:
        ImportableModule
    """
    ...

def load(path: str, config_name: Optional[str] = ..., module_type: Optional[str] = ..., process_id: int = ..., num_process: int = ..., cache_dir: Optional[str] = ..., experiment_id: Optional[str] = ..., keep_in_memory: bool = ..., download_config: Optional[DownloadConfig] = ..., download_mode: Optional[DownloadMode] = ..., revision: Optional[Union[str, Version]] = ..., **init_kwargs) -> EvaluationModule:
    """Load a `evaluate.EvaluationModule`.

    Args:

        path (``str``):
            path to the evaluation processing script with the evaluation builder. Can be either:
                - a local path to processing script or the directory containing the script (if the script has the same name as the directory),
                    e.g. ``'./metrics/rouge'`` or ``'./metrics/rogue/rouge.py'``
                - a evaluation module identifier on the HuggingFace evaluate repo e.g. ``'rouge'`` or ``'bleu'`` that are in either ``'metrics/'``,
                    ``'comparisons/'``, or ``'measurements/'`` depending on the provided ``module_type``.
        config_name (:obj:`str`, optional): selecting a configuration for the metric (e.g. the GLUE metric has a configuration for each subset)
        module_type (:obj:`str`, default ``'metric'``): type of evaluation module, can be one of ``'metric'``, ``'comparison'``, or ``'measurement'``.
        process_id (:obj:`int`, optional): for distributed evaluation: id of the process
        num_process (:obj:`int`, optional): for distributed evaluation: total number of processes
        cache_dir (Optional str): path to store the temporary predictions and references (default to `~/.cache/huggingface/evaluate/`)
        experiment_id (``str``): A specific experiment id. This is used if several distributed evaluations share the same file system.
            This is useful to compute metrics in distributed setups (in particular non-additive metrics like F1).
        keep_in_memory (bool): Whether to store the temporary results in memory (defaults to False)
        download_config (Optional ``evaluate.DownloadConfig``: specific download configuration parameters.
        download_mode (:class:`DownloadMode`, default ``REUSE_DATASET_IF_EXISTS``): Download/generate mode.
        revision (Optional ``Union[str, evaluate.Version]``): if specified, the module will be loaded from the datasets repository
            at this version. By default it is set to the local version of the lib. Specifying a version that is different from
            your local version of the lib might cause compatibility issues.

    Returns:
        `evaluate.EvaluationModule`
    """
    ...

