"""
This type stub file was generated by pyright.
"""

from typing import List, Optional, Union
from datasets import DownloadManager
from datasets.features import Features
from datasets.utils.filelock import BaseFileLock
from .info import EvaluationModuleInfo
from .utils.file_utils import DownloadConfig

""" EvaluationModule base class."""
logger = ...
class FileFreeLock(BaseFileLock):
    """Thread lock until a file **cannot** be locked"""
    def __init__(self, lock_file, *args, **kwargs) -> None:
        ...
    


def summarize_if_long_list(obj): # -> str:
    ...

class EvaluationModuleInfoMixin:
    """This base class exposes some attributes of EvaluationModuleInfo
    at the base level of the EvaluationModule for easy access.
    """
    def __init__(self, info: EvaluationModuleInfo) -> None:
        ...
    
    @property
    def info(self): # -> EvaluationModuleInfo:
        """:class:`evaluate.EvaluationModuleInfo` object containing all the metadata in the evaluation module."""
        ...
    
    @property
    def name(self) -> str:
        ...
    
    @property
    def experiment_id(self) -> Optional[str]:
        ...
    
    @property
    def description(self) -> str:
        ...
    
    @property
    def citation(self) -> str:
        ...
    
    @property
    def features(self) -> Features:
        ...
    
    @property
    def inputs_description(self) -> str:
        ...
    
    @property
    def homepage(self) -> Optional[str]:
        ...
    
    @property
    def license(self) -> str:
        ...
    
    @property
    def codebase_urls(self) -> Optional[List[str]]:
        ...
    
    @property
    def reference_urls(self) -> Optional[List[str]]:
        ...
    
    @property
    def streamable(self) -> bool:
        ...
    
    @property
    def format(self) -> Optional[str]:
        ...
    
    @property
    def module_type(self) -> str:
        ...
    


class EvaluationModule(EvaluationModuleInfoMixin):
    """A EvaluationModule is the base class and common API for metrics, comparisons, and measurements.

    Args:
        config_name (``str``): This is used to define a hash specific to a module computation script and prevents the module's data
            to be overridden when the module loading script is modified.
        keep_in_memory (:obj:`bool`): keep all predictions and references in memory. Not possible in distributed settings.
        cache_dir (``str``): Path to a directory in which temporary prediction/references data will be stored.
            The data directory should be located on a shared file-system in distributed setups.
        num_process (``int``): specify the total number of nodes in a distributed settings.
            This is useful to compute module in distributed setups (in particular non-additive modules like F1).
        process_id (``int``): specify the id of the current process in a distributed setup (between 0 and num_process-1)
            This is useful to compute module in distributed setups (in particular non-additive metrics like F1).
        seed (:obj:`int`, optional): If specified, this will temporarily set numpy's random seed when :func:`evaluate.EvaluationModule.compute` is run.
        experiment_id (``str``): A specific experiment id. This is used if several distributed evaluations share the same file system.
            This is useful to compute module in distributed setups (in particular non-additive metrics like F1).
        max_concurrent_cache_files (``int``): Max number of concurrent module cache files (default 10000).
        timeout (``Union[int, float]``): Timeout in second for distributed setting synchronization.
    """
    def __init__(self, config_name: Optional[str] = ..., keep_in_memory: bool = ..., cache_dir: Optional[str] = ..., num_process: int = ..., process_id: int = ..., seed: Optional[int] = ..., experiment_id: Optional[str] = ..., max_concurrent_cache_files: int = ..., timeout: Union[int, float] = ..., **kwargs) -> None:
        ...
    
    def __len__(self): # -> int:
        """Return the number of examples (predictions or predictions/references pair)
        currently stored in the evaluation module's cache.
        """
        ...
    
    def __repr__(self): # -> str:
        ...
    
    def compute(self, *, predictions=..., references=..., **kwargs) -> Optional[dict]:
        """Compute the evaluation module.

        Usage of positional arguments is not allowed to prevent mistakes.

        Args:
            predictions (list/array/tensor, optional): Predictions.
            references (list/array/tensor, optional): References.
            **kwargs (optional): Keyword arguments that will be forwarded to the evaluation module :meth:`_compute`
                method (see details in the docstring).

        Return:
            dict or None

            - Dictionary with the results if this evaluation module is run on the main process (``process_id == 0``).
            - None if the evaluation module is not run on the main process (``process_id != 0``).
        """
        ...
    
    def add_batch(self, *, predictions=..., references=..., **kwargs):
        """Add a batch of predictions and references for the evaluation module's stack.

        Args:
            predictions (list/array/tensor, optional): Predictions.
            references (list/array/tensor, optional): References.
        """
        ...
    
    def add(self, *, prediction=..., reference=..., **kwargs): # -> None:
        """Add one prediction and reference for the evaluation module's stack.

        Args:
            prediction (list/array/tensor, optional): Predictions.
            reference (list/array/tensor, optional): References.
        """
        ...
    
    def download_and_prepare(self, download_config: Optional[DownloadConfig] = ..., dl_manager: Optional[DownloadManager] = ...): # -> None:
        """Downloads and prepares dataset for reading.

        Args:
            download_config (:class:`DownloadConfig`, optional): Specific download configuration parameters.
            dl_manager (:class:`DownloadManager`, optional): Specific download manager to use.
        """
        ...
    
    def __del__(self): # -> None:
        ...
    


