"""
This type stub file was generated by pyright.
"""

import io
import requests
from dataclasses import dataclass
from pathlib import Path
from typing import Dict, Optional, TypeVar, Union

"""
Utilities for working with the local dataset cache.
This file is adapted from the AllenNLP library at https://github.com/allenai/allennlp
Copyright by the AllenNLP authors.
"""
logger = ...
INCOMPLETE_SUFFIX = ...
T = TypeVar("T", str, Path)
def init_hf_modules(hf_modules_cache: Optional[Union[Path, str]] = ...) -> str:
    """
    Add hf_modules_cache to the python path.
    By default hf_modules_cache='~/.cache/huggingface/modules'.
    It can also be set with the environment variable HF_MODULES_CACHE.
    This is used to add modules such as `datasets_modules`
    """
    ...

def is_remote_url(url_or_filename: str) -> bool:
    ...

def is_local_path(url_or_filename: str) -> bool:
    ...

def is_relative_path(url_or_filename: str) -> bool:
    ...

def relative_to_absolute_path(path: T) -> T:
    """Convert relative path to absolute path."""
    ...

def hf_bucket_url(identifier: str, filename: str, use_cdn=..., dataset=...) -> str:
    ...

def head_hf_s3(identifier: str, filename: str, use_cdn=..., dataset=..., max_retries=...) -> Union[requests.Response, Exception]:
    ...

def hf_github_url(path: str, name: str, module_type: str, revision: Optional[str] = ...) -> str:
    ...

def hf_hub_url(path: str, name: str, revision: Optional[str] = ...) -> str:
    ...

def url_or_path_join(base_name: str, *pathnames: str) -> str:
    ...

def url_or_path_parent(url_or_path: str) -> str:
    ...

def hash_url_to_filename(url, etag=...): # -> str:
    """
    Convert `url` into a hashed filename in a repeatable way.
    If `etag` is specified, append its hash to the url's, delimited
    by a period.
    If the url ends with .h5 (Keras HDF5 weights) adds '.h5' to the name
    so that TF 2.0 can identify it as a HDF5 file
    (see https://github.com/tensorflow/tensorflow/blob/00fad90125b18b80fe054de1055770cfb8fe4ba3/tensorflow/python/keras/engine/network.py#L1380)
    """
    ...

@dataclass
class DownloadConfig:
    """Configuration for our cached path manager.

    Attributes:
        cache_dir (:obj:`str` or :obj:`Path`, optional): Specify a cache directory to save the file to (overwrite the
            default cache dir).
        force_download (:obj:`bool`, default ``False``): If True, re-dowload the file even if it's already cached in
            the cache dir.
        resume_download (:obj:`bool`, default ``False``): If True, resume the download if incompletly recieved file is
            found.
        proxies (:obj:`dict`, optional):
        user_agent (:obj:`str`, optional): Optional string or dict that will be appended to the user-agent on remote
            requests.
        extract_compressed_file (:obj:`bool`, default ``False``): If True and the path point to a zip or tar file,
            extract the compressed file in a folder along the archive.
        force_extract (:obj:`bool`, default ``False``): If True when extract_compressed_file is True and the archive
            was already extracted, re-extract the archive and override the folder where it was extracted.
        delete_extracted (:obj:`bool`, default ``False``): Whether to delete (or keep) the extracted files.
        use_etag (:obj:`bool`, default ``True``): Whether to use the ETag HTTP response header to validate the cached files.
        num_proc (:obj:`int`, optional): The number of processes to launch to download the files in parallel.
        max_retries (:obj:`int`, default ``1``): The number of times to retry an HTTP request if it fails.
        use_auth_token (:obj:`str` or :obj:`bool`, optional): Optional string or boolean to use as Bearer token
            for remote files on the Datasets Hub. If True, will get token from ~/.huggingface.
        ignore_url_params (:obj:`bool`, default ``False``): Whether to strip all query parameters and #fragments from
            the download URL before using it for caching the file.
        download_desc (:obj:`str`, optional): A description to be displayed alongside with the progress bar while downloading the files.
    """
    cache_dir: Optional[Union[str, Path]] = ...
    force_download: bool = ...
    resume_download: bool = ...
    local_files_only: bool = ...
    proxies: Optional[Dict] = ...
    user_agent: Optional[str] = ...
    extract_compressed_file: bool = ...
    force_extract: bool = ...
    delete_extracted: bool = ...
    use_etag: bool = ...
    num_proc: Optional[int] = ...
    max_retries: int = ...
    use_auth_token: Optional[Union[str, bool]] = ...
    ignore_url_params: bool = ...
    download_desc: Optional[str] = ...
    def copy(self) -> DownloadConfig:
        ...
    


def cached_path(url_or_filename, download_config=..., **download_kwargs) -> str:
    """
    Given something that might be a URL (or might be a local path),
    determine which. If it's a URL, download the file and cache it, and
    return the path to the cached file. If it's already a local path,
    make sure the file exists and then return the path.

    Return:
        Local path (string)

    Raises:
        FileNotFoundError: in case of non-recoverable file
            (non-existent or no cache on disk)
        ConnectionError: in case of unreachable url
            and no cache on disk
        ValueError: if it couldn't parse the url or filename correctly
        requests.exceptions.ConnectionError: in case of internet connection issue
    """
    ...

def get_datasets_user_agent(user_agent: Optional[Union[str, dict]] = ...) -> str:
    ...

def get_authentication_headers_for_url(url: str, use_auth_token: Optional[Union[str, bool]] = ...) -> dict:
    """Handle the HF authentication"""
    ...

class OfflineModeIsEnabled(ConnectionError):
    ...


def ftp_head(url, timeout=...): # -> bool:
    ...

def ftp_get(url, temp_file, timeout=...): # -> None:
    ...

def http_get(url, temp_file, proxies=..., resume_size=..., headers=..., cookies=..., timeout=..., max_retries=..., desc=...): # -> None:
    ...

def http_head(url, proxies=..., headers=..., cookies=..., allow_redirects=..., timeout=..., max_retries=...) -> requests.Response:
    ...

def request_etag(url: str, use_auth_token: Optional[Union[str, bool]] = ...) -> Optional[str]:
    ...

def get_from_cache(url, cache_dir=..., force_download=..., proxies=..., etag_timeout=..., resume_download=..., user_agent=..., local_files_only=..., use_etag=..., max_retries=..., use_auth_token=..., ignore_url_params=..., download_desc=...) -> str:
    """
    Given a URL, look for the corresponding file in the local cache.
    If it's not there, download it. Then return the path to the cached file.

    Return:
        Local path (string)

    Raises:
        FileNotFoundError: in case of non-recoverable file
            (non-existent or no cache on disk)
        ConnectionError: in case of unreachable url
            and no cache on disk
    """
    ...

def add_start_docstrings(*docstr): # -> (fn: Unknown) -> Unknown:
    ...

def add_end_docstrings(*docstr): # -> (fn: Unknown) -> Unknown:
    ...

def estimate_dataset_size(paths): # -> int:
    ...

def readline(f: io.RawIOBase): # -> bytes:
    ...

