# swagger-client
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+ssh://git@github.com/frontrunnerapp/prompt-python-sdk.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: global_token
configuration = swagger_client.Configuration()
configuration.api_key['globalAuthToken'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['globalAuthToken'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.APIKeysApi(swagger_client.ApiClient(configuration))
org_id = 56 # int | 
body = swagger_client.ApiKeyModel() # ApiKeyModel |  (optional)

try:
    # Creates an API Key for an org
    api_response = api_instance.add_api_key(org_id, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling APIKeysApi->add_api_key: %s\n" % e)

# Configure API key authorization: global_token
configuration = swagger_client.Configuration()
configuration.api_key['globalAuthToken'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['globalAuthToken'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.APIKeysApi(swagger_client.ApiClient(configuration))
org_id = 56 # int | 
api_key_id = 56 # int | 

try:
    # Deletes an API Key for an org
    api_instance.delete_api_key(org_id, api_key_id)
except ApiException as e:
    print("Exception when calling APIKeysApi->delete_api_key: %s\n" % e)

# Configure API key authorization: global_token
configuration = swagger_client.Configuration()
configuration.api_key['globalAuthToken'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['globalAuthToken'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.APIKeysApi(swagger_client.ApiClient(configuration))
org_id = 56 # int | 
api_key_id = 56 # int | 

try:
    # Gets a specific API Key for an org
    api_response = api_instance.get_api_key(org_id, api_key_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling APIKeysApi->get_api_key: %s\n" % e)

# Configure API key authorization: global_token
configuration = swagger_client.Configuration()
configuration.api_key['globalAuthToken'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['globalAuthToken'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.APIKeysApi(swagger_client.ApiClient(configuration))
org_id = 56 # int | 
first = 56 # int |  (optional)
max = 56 # int |  (optional)

try:
    # Gets all API Keys for an org
    api_response = api_instance.get_api_keys(org_id, first=first, max=max)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling APIKeysApi->get_api_keys: %s\n" % e)

# Configure API key authorization: global_token
configuration = swagger_client.Configuration()
configuration.api_key['globalAuthToken'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['globalAuthToken'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.APIKeysApi(swagger_client.ApiClient(configuration))
org_id = 56 # int | 
api_key_id = 56 # int | 

try:
    # Resets the secret for an API Key
    api_response = api_instance.reset_token(org_id, api_key_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling APIKeysApi->reset_token: %s\n" % e)

# Configure API key authorization: global_token
configuration = swagger_client.Configuration()
configuration.api_key['globalAuthToken'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['globalAuthToken'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.APIKeysApi(swagger_client.ApiClient(configuration))
org_id = 56 # int | 
api_key_id = 56 # int | 
body = swagger_client.ApiKeyModel() # ApiKeyModel |  (optional)

try:
    # Updates an API Key for an org
    api_response = api_instance.update_api_key(org_id, api_key_id, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling APIKeysApi->update_api_key: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to */rest/1.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIKeysApi* | [**add_api_key**](docs/APIKeysApi.md#add_api_key) | **POST** /orgs/{orgId}/api_keys | Creates an API Key for an org
*APIKeysApi* | [**delete_api_key**](docs/APIKeysApi.md#delete_api_key) | **DELETE** /orgs/{orgId}/api_keys/{apiKeyId} | Deletes an API Key for an org
*APIKeysApi* | [**get_api_key**](docs/APIKeysApi.md#get_api_key) | **GET** /orgs/{orgId}/api_keys/{apiKeyId} | Gets a specific API Key for an org
*APIKeysApi* | [**get_api_keys**](docs/APIKeysApi.md#get_api_keys) | **GET** /orgs/{orgId}/api_keys | Gets all API Keys for an org
*APIKeysApi* | [**reset_token**](docs/APIKeysApi.md#reset_token) | **PUT** /orgs/{orgId}/api_keys/{apiKeyId}/reset_token | Resets the secret for an API Key
*APIKeysApi* | [**update_api_key**](docs/APIKeysApi.md#update_api_key) | **PUT** /orgs/{orgId}/api_keys/{apiKeyId} | Updates an API Key for an org
*AnalyticsApi* | [**get_agent_activity_report**](docs/AnalyticsApi.md#get_agent_activity_report) | **GET** /analytics/agent_activity_report | Get the Agent Activity Report for the org.
*AnalyticsApi* | [**get_agent_activity_report_for_channel**](docs/AnalyticsApi.md#get_agent_activity_report_for_channel) | **GET** /analytics/agent_activity_report/{orgChannelId} | Get the Agent Activity Report for a specific channel.
*AnalyticsApi* | [**get_channel_report**](docs/AnalyticsApi.md#get_channel_report) | **GET** /analytics/channel_report | Get the Channel Report for the org.
*AnalyticsApi* | [**get_contact_action_report**](docs/AnalyticsApi.md#get_contact_action_report) | **GET** /analytics/contact_action_report | Get the Contact Action Report for the org
*AnalyticsApi* | [**get_custom_counters_report**](docs/AnalyticsApi.md#get_custom_counters_report) | **GET** /analytics/custom_counters_report | Get the Custom Counters Report for the org
*AnalyticsApi* | [**get_custom_counters_report_for_schema**](docs/AnalyticsApi.md#get_custom_counters_report_for_schema) | **GET** /analytics/custom_counters_report/{schemaId} | Get the Custom Counters Report for a specific schemaId
*AnalyticsApi* | [**get_customer_engagement_report**](docs/AnalyticsApi.md#get_customer_engagement_report) | **GET** /analytics/customer_engagement_report | Get the Customer Engagement Report for the org
*AnalyticsApi* | [**get_customer_engagement_report_for_channel**](docs/AnalyticsApi.md#get_customer_engagement_report_for_channel) | **GET** /analytics/customer_engagement_report/{orgChannelId} | Get the Customer Engagement Report for a specific channel
*AnalyticsApi* | [**get_error_report**](docs/AnalyticsApi.md#get_error_report) | **GET** /analytics/error_report | Get the Error Report for the org
*AnalyticsApi* | [**get_instant_app_report**](docs/AnalyticsApi.md#get_instant_app_report) | **GET** /analytics/instant_app_report | Get the Instant App Report for the org
*AnalyticsApi* | [**get_instant_app_report_for_schema**](docs/AnalyticsApi.md#get_instant_app_report_for_schema) | **GET** /analytics/instant_app_report/{schemaId} | Get the Instant App Report for a specific schema
*AnalyticsApi* | [**get_instant_app_schema_report**](docs/AnalyticsApi.md#get_instant_app_schema_report) | **GET** /analytics/instant_app_schema_report/{schemaId} | Get the Instant App Report for the org
*AnalyticsApi* | [**get_kpi_report**](docs/AnalyticsApi.md#get_kpi_report) | **GET** /analytics/kpi_report | Get the KPI Report for the org
*AnalyticsApi* | [**get_messaging_report**](docs/AnalyticsApi.md#get_messaging_report) | **GET** /analytics/messaging_report | Get the Messaging Report for the org
*AnalyticsApi* | [**get_messaging_report_for_channel**](docs/AnalyticsApi.md#get_messaging_report_for_channel) | **GET** /analytics/messaging_report/{orgChannelId} | Get the Messaging Report for a specific channel
*AnalyticsApi* | [**get_opt_out_report**](docs/AnalyticsApi.md#get_opt_out_report) | **GET** /analytics/opt_out_report | Get the Opt-Out Report for the org.
*AnalyticsApi* | [**get_opt_out_report_for_channel**](docs/AnalyticsApi.md#get_opt_out_report_for_channel) | **GET** /analytics/opt_out_report/{orgChannelId} | Get the Opt-Out Report for a specific channel
*AnalyticsApi* | [**get_org_activity_report**](docs/AnalyticsApi.md#get_org_activity_report) | **GET** /analytics/org_activity_report | Get the Org Activity Report totals.
*AnalyticsApi* | [**get_org_activity_report_for_channel**](docs/AnalyticsApi.md#get_org_activity_report_for_channel) | **GET** /analytics/org_activity_report/{orgChannelId} | Get the Org Activity Report totals for a specific channel.
*AutomationsApi* | [**add_org_channel**](docs/AutomationsApi.md#add_org_channel) | **POST** /automations/{automationId}/org_channels/{orgChannelId} | Adds an OrgChannel to an automation
*AutomationsApi* | [**create_automation**](docs/AutomationsApi.md#create_automation) | **POST** /automations | Creates a new automation
*AutomationsApi* | [**delete_automation**](docs/AutomationsApi.md#delete_automation) | **DELETE** /automations/{automationId} | Deletes an automation
*AutomationsApi* | [**delete_org_channel**](docs/AutomationsApi.md#delete_org_channel) | **DELETE** /automations/{automationId}/org_channels/{orgChannelId} | Removes an OrgChannel from an automation
*AutomationsApi* | [**get_automation**](docs/AutomationsApi.md#get_automation) | **GET** /automations/{automationId} | Gets the details of a specific automation
*AutomationsApi* | [**get_automations**](docs/AutomationsApi.md#get_automations) | **GET** /automations | Gets all the automations in the org
*AutomationsApi* | [**get_org_channels**](docs/AutomationsApi.md#get_org_channels) | **GET** /automations/{automationId}/org_channels | Gets a list of the OrgChannel from an automation
*AutomationsApi* | [**update_automation**](docs/AutomationsApi.md#update_automation) | **PUT** /automations/{automationId} | Modifies an automation
*BotsApi* | [**create_bot**](docs/BotsApi.md#create_bot) | **POST** /bots | Creates a new bot
*BotsApi* | [**delete_bot**](docs/BotsApi.md#delete_bot) | **DELETE** /bots/{botId} | Deletes a bot
*BotsApi* | [**get_bot**](docs/BotsApi.md#get_bot) | **GET** /bots/{botId} | Gets a bot
*BotsApi* | [**get_bot_intents**](docs/BotsApi.md#get_bot_intents) | **GET** /bots/{botId}/intents | Gets all intents of a bot
*BotsApi* | [**get_bots**](docs/BotsApi.md#get_bots) | **GET** /bots | Gets all bots for the org.
*BotsApi* | [**update_bot**](docs/BotsApi.md#update_bot) | **PUT** /bots/{botId} | Updates an existing bot
*BulkActionsApi* | [**abort_bulk_action**](docs/BulkActionsApi.md#abort_bulk_action) | **DELETE** /bulk_actions/{bulkActionId} | Abort a Bulk Action
*BulkActionsApi* | [**add_bulk_action**](docs/BulkActionsApi.md#add_bulk_action) | **POST** /bulk_actions | Creates a Bulk Action and starts it
*BulkActionsApi* | [**disable_variant**](docs/BulkActionsApi.md#disable_variant) | **DELETE** /bulk_actions/{bulkActionId}/variant/{variantId} | Disable a vairant if the BulkAction is using A/B testing
*BulkActionsApi* | [**get_bulk_action**](docs/BulkActionsApi.md#get_bulk_action) | **GET** /bulk_actions/{bulkActionId} | Gets a specific Bulk Action
*BulkActionsApi* | [**get_bulk_actions**](docs/BulkActionsApi.md#get_bulk_actions) | **GET** /bulk_actions | Gets all Bulk Actions
*BulkActionsApi* | [**get_contacts_for_resolution**](docs/BulkActionsApi.md#get_contacts_for_resolution) | **GET** /bulk_actions/{bulkActionId}/resolution/{resolution} | Get a list of customers for a particular Resolution string for this Bulk Action
*BulkActionsApi* | [**get_resolution_counts**](docs/BulkActionsApi.md#get_resolution_counts) | **GET** /bulk_actions/{bulkActionId}/resolutionCounts | Retrieves the counts for each resolution string for this Bulk Action
*BulkActionsApi* | [**perform_action**](docs/BulkActionsApi.md#perform_action) | **POST** /bulk_actions/{bulkActionId}/perform_action | Performs an action on the contacts or subset of contacts in the Bulk Action
*BulkActionsApi* | [**set_bulk_resolution**](docs/BulkActionsApi.md#set_bulk_resolution) | **POST** /bulk_actions/{bulkActionId}/contacts/{customerId}/resolution | Set a bulk action resolution string for a contact.
*BulkActionsApi* | [**unlock_bulk_action_contact**](docs/BulkActionsApi.md#unlock_bulk_action_contact) | **POST** /bulk_actions/confirm/{bulkActionId}/{bulkActionContactId} | Confirms a Bulk Action that is set to require manual sending
*ChannelIdIntegrationApi* | [**verfiy**](docs/ChannelIdIntegrationApi.md#verfiy) | **GET** /integrations/channel_id | Verifies a channel ID code.
*ContactListContactsApi* | [**add_contact_list_contacts**](docs/ContactListContactsApi.md#add_contact_list_contacts) | **POST** /contact_lists/{contactListId}/contacts | Add multiple contacts to a Contact List
*ContactListContactsApi* | [**delete_contact_list_member**](docs/ContactListContactsApi.md#delete_contact_list_member) | **DELETE** /contact_lists/{contactListId}/contacts/{identityKey} | Delete a contact from a Contact List
*ContactListContactsApi* | [**get_contacts**](docs/ContactListContactsApi.md#get_contacts) | **GET** /contact_lists/{contactListId}/contacts | Gets all the contacts in a Contact List
*ContactListsApi* | [**add_contact_list**](docs/ContactListsApi.md#add_contact_list) | **POST** /contact_lists | Creates a Contact List
*ContactListsApi* | [**delete_contact_list**](docs/ContactListsApi.md#delete_contact_list) | **DELETE** /contact_lists/{contactListId} | Deletes a Contact List
*ContactListsApi* | [**get_contact_list**](docs/ContactListsApi.md#get_contact_list) | **GET** /contact_lists/{contactListId} | Gets a specific Contact List
*ContactListsApi* | [**get_contact_lists**](docs/ContactListsApi.md#get_contact_lists) | **GET** /contact_lists | Gets all Contact Lists
*ContactListsApi* | [**perform_action1**](docs/ContactListsApi.md#perform_action1) | **POST** /contact_lists/{contactListId}/perform_action | Performs an action on the contacts in a Contact List
*ContactListsApi* | [**update_contact_list**](docs/ContactListsApi.md#update_contact_list) | **PUT** /contact_lists/{contactListId} | Modifies a Contact List
*ConversationsApi* | [**add_conversation**](docs/ConversationsApi.md#add_conversation) | **POST** /conversations | Creates a conversation with customer and the team member
*ConversationsApi* | [**assign**](docs/ConversationsApi.md#assign) | **POST** /conversations/{conversationId}/assign | Takes a conversation and assigns it to one or more groups/users
*ConversationsApi* | [**assign_bot**](docs/ConversationsApi.md#assign_bot) | **POST** /conversations/{conversationId}/assign_bot | Takes a conversation and assigns it to a bot
*ConversationsApi* | [**close**](docs/ConversationsApi.md#close) | **POST** /conversations/{conversationId}/close | Closes the requested conversation
*ConversationsApi* | [**escalate**](docs/ConversationsApi.md#escalate) | **POST** /conversations/{conversationId}/escalate | Takes an active conversation handled by a bot, and escalates it to groups or teamMembers
*ConversationsApi* | [**get_active**](docs/ConversationsApi.md#get_active) | **GET** /conversations/active/team_members/{teamMemberId} | Gets all the active conversations for a team member
*ConversationsApi* | [**get_active_for_bot**](docs/ConversationsApi.md#get_active_for_bot) | **GET** /conversations/active/bots/{botId} | Gets all the active conversations for a bot
*ConversationsApi* | [**get_active_for_customer**](docs/ConversationsApi.md#get_active_for_customer) | **GET** /conversations/active/customers/{customerId} | Gets all the active conversations for a customer
*ConversationsApi* | [**get_active_for_customer_by_channel_id**](docs/ConversationsApi.md#get_active_for_customer_by_channel_id) | **GET** /conversations/active/customer_channels/{customerChannelId} | Gets all the active conversations for a customer
*ConversationsApi* | [**get_active_for_customer_by_channel_key**](docs/ConversationsApi.md#get_active_for_customer_by_channel_key) | **GET** /conversations/active/customer_channels/channel_types/{type}/channel_keys/{key} | Gets all the active conversations for a customer
*ConversationsApi* | [**get_conversation**](docs/ConversationsApi.md#get_conversation) | **GET** /conversations/{conversationId} | Gets a conversation based on its internal id.
*ConversationsApi* | [**get_conversation_messages**](docs/ConversationsApi.md#get_conversation_messages) | **GET** /conversations/{conversationId}/messages | Gets messages for a conversation
*ConversationsApi* | [**get_for_customer**](docs/ConversationsApi.md#get_for_customer) | **GET** /conversations/customers/{customerId}/messages | Gets all messages for a customer, as visible by a team member
*ConversationsApi* | [**get_inbox**](docs/ConversationsApi.md#get_inbox) | **GET** /conversations/inbox/team_members/{teamMemberId} | Gets all the conversations in the team members inbox.
*ConversationsApi* | [**get_smart_link**](docs/ConversationsApi.md#get_smart_link) | **GET** /conversations/{conversationId}/smart_link/{smartLinkId} | Creates a smart link for the customer involved in the conversation
*ConversationsApi* | [**opt_out**](docs/ConversationsApi.md#opt_out) | **POST** /conversations/{conversationId}/optOut | Opted out customers can not receive any additional messages from this conversations until opted back in
*ConversationsApi* | [**post_message**](docs/ConversationsApi.md#post_message) | **POST** /conversations/{conversationId}/message | Posts a message to an active conversation
*ConversationsApi* | [**post_whisper**](docs/ConversationsApi.md#post_whisper) | **POST** /conversations/{conversationId}/whisper | Posts a whisper to an active conversation
*ConversationsApi* | [**remove_team_member_from_conversation**](docs/ConversationsApi.md#remove_team_member_from_conversation) | **DELETE** /conversations/{conversationId}/team_members/{teamMemberId} | Removes a team member from a conversation.
*ConversationsApi* | [**take**](docs/ConversationsApi.md#take) | **POST** /conversations/{conversationId}/take | Takes a pending conversation and moves it into an active state, ready for communication
*ConversationsApi* | [**update_membership**](docs/ConversationsApi.md#update_membership) | **POST** /conversations/{conversationId}/update_membership | Updates the team members presences in conversation, optionally add it to their Inbox, Active Chats, or removing it altogether
*CustomersApi* | [**add_customer**](docs/CustomersApi.md#add_customer) | **POST** /customers | Creates a customer
*CustomersApi* | [**add_customer_tags**](docs/CustomersApi.md#add_customer_tags) | **POST** /customers/{customerId}/tags | Adds tags to a customer
*CustomersApi* | [**add_identity**](docs/CustomersApi.md#add_identity) | **POST** /customers/{customerId}/identities | Adds an identity to a customer
*CustomersApi* | [**add_or_update_customer**](docs/CustomersApi.md#add_or_update_customer) | **PUT** /customers | Creates or updates a customer
*CustomersApi* | [**create_instant_app**](docs/CustomersApi.md#create_instant_app) | **POST** /customers/{customerId}/instant_apps | Creates an Instant App for the customer.
*CustomersApi* | [**delete_identity**](docs/CustomersApi.md#delete_identity) | **DELETE** /customers/{customerId}/identities | Deletes an identity from a customer
*CustomersApi* | [**get_customer**](docs/CustomersApi.md#get_customer) | **GET** /customers/{customerId} | Gets the details for a specific customer
*CustomersApi* | [**get_customer_by_channel**](docs/CustomersApi.md#get_customer_by_channel) | **GET** /customers/channel_types/{type}/channel_keys/{key} | Gets the details for a specific customer based on an the channel type and channel key
*CustomersApi* | [**get_customer_by_identity**](docs/CustomersApi.md#get_customer_by_identity) | **GET** /customers/identity_types/{type}/identity_keys/{key} | Gets the details for a specific customer based on an identity
*CustomersApi* | [**get_customer_tags**](docs/CustomersApi.md#get_customer_tags) | **GET** /customers/{customerId}/tags | Gets the tags for a specific customer
*CustomersApi* | [**get_customers**](docs/CustomersApi.md#get_customers) | **GET** /customers | Gets all the customers in the org ordered by their create date
*CustomersApi* | [**get_instant_apps**](docs/CustomersApi.md#get_instant_apps) | **GET** /customers/{customerId}/instant_apps | Gets all the Instant Apps for the customer
*CustomersApi* | [**remove_tag**](docs/CustomersApi.md#remove_tag) | **DELETE** /customers/{customerId}/tags/{tagName} | Removes a tag from a customer
*CustomersApi* | [**remove_tags**](docs/CustomersApi.md#remove_tags) | **DELETE** /customers/{customerId}/tags | Removes all tags from a customer
*CustomersApi* | [**update_customer**](docs/CustomersApi.md#update_customer) | **PUT** /customers/{customerId} | Updates a customer
*CustomersApi* | [**update_customer_location**](docs/CustomersApi.md#update_customer_location) | **PUT** /customers/{customerId}/location | Updates a customers location
*DataApi* | [**delete_data**](docs/DataApi.md#delete_data) | **DELETE** /data/{dataType}/{dataId}/keys/{key} | Deletes one key of data for a specific data entity
*DataApi* | [**get_data**](docs/DataApi.md#get_data) | **GET** /data/{dataType}/{dataId} | Gets all the data for a specific data entity
*DataApi* | [**get_data_by_key**](docs/DataApi.md#get_data_by_key) | **GET** /data/{dataType}/{dataId}/keys/{key} | Gets one key of data for a specific data entity
*DataApi* | [**get_data_default**](docs/DataApi.md#get_data_default) | **GET** /data/defaults/{key} | Get the default values for a specific customer data key
*DataApi* | [**get_data_defaults**](docs/DataApi.md#get_data_defaults) | **GET** /data/defaults | Get the default values for customer data keys
*DataApi* | [**set_data**](docs/DataApi.md#set_data) | **POST** /data/{dataType}/{dataId} | Sets all the data for a specific data entity (unmentioned keys are removed)
*DataApi* | [**set_data_default**](docs/DataApi.md#set_data_default) | **PUT** /data/defaults/{key} | Set the default value for a specific customer data key
*DataApi* | [**update_data**](docs/DataApi.md#update_data) | **PUT** /data/{dataType}/{dataId} | Updates data for a specific data entity (does not modify unmentioned keys)
*EventEndpointsApi* | [**add_event_endpoint**](docs/EventEndpointsApi.md#add_event_endpoint) | **POST** /event_endpoints | Creates an Event Endpoint
*EventEndpointsApi* | [**delete_event_endpoint**](docs/EventEndpointsApi.md#delete_event_endpoint) | **DELETE** /event_endpoints/{eventEndpointId} | Deletes an Event Endpoint
*EventEndpointsApi* | [**get_event_endpoint**](docs/EventEndpointsApi.md#get_event_endpoint) | **GET** /event_endpoints/{eventEndpointId} | Gets a specific Event Endpoint
*EventEndpointsApi* | [**get_event_endpoints**](docs/EventEndpointsApi.md#get_event_endpoints) | **GET** /event_endpoints | Gets all Event Endpoints
*EventEndpointsApi* | [**reset_secret**](docs/EventEndpointsApi.md#reset_secret) | **PUT** /event_endpoints/{eventEndpointId}/reset_secret | Resets the secret for an Event Endpoint
*EventEndpointsApi* | [**update_event_endpoint**](docs/EventEndpointsApi.md#update_event_endpoint) | **PUT** /event_endpoints/{eventEndpointId} | Updates an Event Endpoint
*GroupMembersApi* | [**add_group_member**](docs/GroupMembersApi.md#add_group_member) | **POST** /groups/{groupId}/members | Add a member to a group
*GroupMembersApi* | [**delete_group_member**](docs/GroupMembersApi.md#delete_group_member) | **DELETE** /groups/{groupId}/members/{teamMemberId} | Delete a member from a group
*GroupMembersApi* | [**get_group_members**](docs/GroupMembersApi.md#get_group_members) | **GET** /groups/{groupId}/members | Gets all the members of a group
*GroupsApi* | [**add_group**](docs/GroupsApi.md#add_group) | **POST** /groups | Creates a group
*GroupsApi* | [**delete_group**](docs/GroupsApi.md#delete_group) | **DELETE** /groups/{groupId} | Deletes a group
*GroupsApi* | [**get_group**](docs/GroupsApi.md#get_group) | **GET** /groups/{groupId} | Gets the details of a specific group
*GroupsApi* | [**get_groups**](docs/GroupsApi.md#get_groups) | **GET** /groups | Gets all the groups in the org
*GroupsApi* | [**get_org_channel_permission**](docs/GroupsApi.md#get_org_channel_permission) | **GET** /groups/{groupId}/org_channels/{orgChannelId}/permissions/{permission} | Gets a group&#x27;s&#x27;s orgChannel permission
*GroupsApi* | [**get_org_channel_permissions**](docs/GroupsApi.md#get_org_channel_permissions) | **GET** /groups/{groupId}/org_channels/{orgChannelId}/permissions | Gets a group&#x27;s&#x27;s orgChannel permissions
*GroupsApi* | [**get_permission**](docs/GroupsApi.md#get_permission) | **GET** /groups/{groupId}/permissions/{permission} | Gets a group&#x27;s permission
*GroupsApi* | [**get_permissions**](docs/GroupsApi.md#get_permissions) | **GET** /groups/{groupId}/permissions | Gets a group&#x27;s permissions
*GroupsApi* | [**set_org_channel_permissions**](docs/GroupsApi.md#set_org_channel_permissions) | **POST** /groups/{groupId}/org_channels/{orgChannelId}/permissions | Sets a group&#x27;s orgChannel permissions
*GroupsApi* | [**set_permissions**](docs/GroupsApi.md#set_permissions) | **POST** /groups/{groupId}/permissions | Sets a group&#x27;s permissions
*GroupsApi* | [**update_group**](docs/GroupsApi.md#update_group) | **PUT** /groups/{groupId} | Modifies a group
*InstantAppSchemasApi* | [**activate_schema**](docs/InstantAppSchemasApi.md#activate_schema) | **PUT** /instant_app_schemas/{schemaId}/active | Activates or deactivates an Instant App Schema
*InstantAppSchemasApi* | [**add_schema**](docs/InstantAppSchemasApi.md#add_schema) | **POST** /instant_app_schemas | Creates an Instant App Schema
*InstantAppSchemasApi* | [**delete_schema**](docs/InstantAppSchemasApi.md#delete_schema) | **DELETE** /instant_app_schemas/{schemaId} | Deletes an Instant App Schema
*InstantAppSchemasApi* | [**get_schema**](docs/InstantAppSchemasApi.md#get_schema) | **GET** /instant_app_schemas/{schemaId} | Gets a specific Instant App Schema
*InstantAppSchemasApi* | [**get_schema_info**](docs/InstantAppSchemasApi.md#get_schema_info) | **GET** /instant_app_schemas/{schemaId}/info | Gets details about a specific Instant App Schema
*InstantAppSchemasApi* | [**get_schema_infos**](docs/InstantAppSchemasApi.md#get_schema_infos) | **GET** /instant_app_schemas | Gets details about all of the Instant App Schemas in the org
*InstantAppSchemasApi* | [**is_schema_active**](docs/InstantAppSchemasApi.md#is_schema_active) | **GET** /instant_app_schemas/{schemaId}/active | Gets the active status of an Instant App Schema
*InstantAppSchemasApi* | [**update_schema**](docs/InstantAppSchemasApi.md#update_schema) | **PUT** /instant_app_schemas/{schemaId} | Modifies an Instant App Schema
*InstantAppsApi* | [**add_audit_message**](docs/InstantAppsApi.md#add_audit_message) | **POST** /instant_apps/{instantAppId}/audit_messages | Add a new audit message
*InstantAppsApi* | [**cancel_timers**](docs/InstantAppsApi.md#cancel_timers) | **PUT** /instant_apps/{instantAppId}/timers/cancel | Cancels any outstanding timers matching the params
*InstantAppsApi* | [**get_audit_messages**](docs/InstantAppsApi.md#get_audit_messages) | **GET** /instant_apps/{instantAppId}/audit_messages | Gets the audit trail messages of an Instant App
*InstantAppsApi* | [**get_data1**](docs/InstantAppsApi.md#get_data1) | **GET** /instant_apps/{instantAppId}/elements | Gets the value for every element of the Instant App
*InstantAppsApi* | [**get_instant_app**](docs/InstantAppsApi.md#get_instant_app) | **GET** /instant_apps/{instantAppId} | Gets the details of a specific Instant App
*InstantAppsApi* | [**is_instant_app_locked**](docs/InstantAppsApi.md#is_instant_app_locked) | **GET** /instant_apps/{instantAppId}/locked | Gets the lock status of an Instant App
*InstantAppsApi* | [**save_data**](docs/InstantAppsApi.md#save_data) | **PUT** /instant_apps/{instantAppId}/elements | Updates the value for every element of the Instant App given
*InstantAppsApi* | [**set_icon**](docs/InstantAppsApi.md#set_icon) | **PUT** /instant_apps/{instantAppId}/icon | Updates the icon and icon label for an instant app
*InstantAppsApi* | [**set_instant_app_locked**](docs/InstantAppsApi.md#set_instant_app_locked) | **POST** /instant_apps/{instantAppId}/locked | Set whether an Instant App is locked
*IntegrationsApi* | [**add_integration**](docs/IntegrationsApi.md#add_integration) | **POST** /integrations | Creates an integration
*IntegrationsApi* | [**delete_integration**](docs/IntegrationsApi.md#delete_integration) | **DELETE** /integrations/{integrationId} | Deletes a integration
*IntegrationsApi* | [**get_integration**](docs/IntegrationsApi.md#get_integration) | **GET** /integrations/{integrationId} | Gets a single integration
*IntegrationsApi* | [**get_integrations**](docs/IntegrationsApi.md#get_integrations) | **GET** /integrations | Gets all the integrations
*IntegrationsApi* | [**update_integration**](docs/IntegrationsApi.md#update_integration) | **PUT** /integrations/{integrationId} | Update an integration
*MapsApi* | [**add_customer_to_map**](docs/MapsApi.md#add_customer_to_map) | **POST** /maps/{mapId}/customers/{customerId} | Adds a customer location to a map
*MapsApi* | [**add_google_map**](docs/MapsApi.md#add_google_map) | **POST** /maps | Creates a map
*MapsApi* | [**delete_google_map**](docs/MapsApi.md#delete_google_map) | **DELETE** /maps/{mapId} | Deletes a map
*MapsApi* | [**get_google_map**](docs/MapsApi.md#get_google_map) | **GET** /maps/{mapId} | Gets a map
*MapsApi* | [**remove_customer_from_map**](docs/MapsApi.md#remove_customer_from_map) | **POST** /maps/{mapId}/customers/{customerId}/remove | Removes a customer location from a map
*MapsApi* | [**update_google_map**](docs/MapsApi.md#update_google_map) | **PUT** /maps/{mapId} | Update a map
*MapsApi* | [**update_google_map_icons**](docs/MapsApi.md#update_google_map_icons) | **PUT** /maps/{mapId}/icon | Update a map&#x27;s icons
*MessagesApi* | [**get_message**](docs/MessagesApi.md#get_message) | **GET** /messages/{messageId} | Gets a single specific message by its internal id
*MessagesApi* | [**get_message_by_external_id**](docs/MessagesApi.md#get_message_by_external_id) | **GET** /messages | Gets a single specific message by its external id
*MessagesApi* | [**get_message_history**](docs/MessagesApi.md#get_message_history) | **GET** /messages/history | Gets historial messages in bulk
*MessagesApi* | [**send_file_to_customer**](docs/MessagesApi.md#send_file_to_customer) | **POST** /messages/send_file_to_customer | Sends a file and an optional message to a customer, creating the customer, customer channel and conversation if needed.
*MessagesApi* | [**send_to_customer**](docs/MessagesApi.md#send_to_customer) | **POST** /messages/send_to_customer | Sends a message and an optional instant app to a customer using API Ids, creating the customer, customer channel and conversation if needed.
*OrgChannelsApi* | [**add_org_channel1**](docs/OrgChannelsApi.md#add_org_channel1) | **POST** /org_channels | Creates an org channel
*OrgChannelsApi* | [**delete_org_channel1**](docs/OrgChannelsApi.md#delete_org_channel1) | **DELETE** /org_channels/{orgChannelId} | Delete an org channel
*OrgChannelsApi* | [**get_org_channel**](docs/OrgChannelsApi.md#get_org_channel) | **GET** /org_channels/{orgChannelId} | Gets the details for a specific org channel
*OrgChannelsApi* | [**get_org_channel_conversations**](docs/OrgChannelsApi.md#get_org_channel_conversations) | **GET** /org_channels/{orgChannelId}/conversations | Gets the conversation details for a specific org channel
*OrgChannelsApi* | [**get_org_channels1**](docs/OrgChannelsApi.md#get_org_channels1) | **GET** /org_channels | Gets all the org channels for the org
*OrgChannelsApi* | [**get_pool_subchannel**](docs/OrgChannelsApi.md#get_pool_subchannel) | **GET** /org_channels/{orgChannelId}/subchannels/{subchannelId} | For pool channels, gets the details of a specific subchannel in the pool
*OrgChannelsApi* | [**get_pool_subchannels**](docs/OrgChannelsApi.md#get_pool_subchannels) | **GET** /org_channels/{orgChannelId}/subchannels | For pool channels, gets the subchannels in the pool
*OrgChannelsApi* | [**update_org_channel**](docs/OrgChannelsApi.md#update_org_channel) | **PUT** /org_channels/{orgChannelId} | Updates an org channel
*OrgSettingsApi* | [**get_messaging_settings**](docs/OrgSettingsApi.md#get_messaging_settings) | **GET** /org-settings/messaging | Gets current messaging settings
*OrgSettingsApi* | [**get_settings**](docs/OrgSettingsApi.md#get_settings) | **GET** /org-settings | Gets current settings
*OrgSettingsApi* | [**update_messaging_settings**](docs/OrgSettingsApi.md#update_messaging_settings) | **PUT** /org-settings/messaging | Updates messaging settings
*OrgSettingsApi* | [**update_settings**](docs/OrgSettingsApi.md#update_settings) | **PUT** /org-settings | Updates settings
*OrgsApi* | [**get_org**](docs/OrgsApi.md#get_org) | **GET** /orgs/{orgId} | Gets information about a specific org based on its ID
*OrgsApi* | [**get_org_by_subdomain**](docs/OrgsApi.md#get_org_by_subdomain) | **GET** /orgs | Gets an org by its subdomain
*OrgsApi* | [**get_org_settings_model**](docs/OrgsApi.md#get_org_settings_model) | **GET** /orgs/{orgId}/org_settings | Gets OrgSettings of the org
*OrgsApi* | [**set_org_settings**](docs/OrgsApi.md#set_org_settings) | **PUT** /orgs/{orgId}/org_settings | Sets OrgSettings of the org
*PoolChannelsApi* | [**add_channels**](docs/PoolChannelsApi.md#add_channels) | **POST** /pools/{poolId}/channels | Provision phone numbers for pool
*PoolChannelsApi* | [**delete**](docs/PoolChannelsApi.md#delete) | **DELETE** /pools/{poolId}/channels/{channelId} | Delete a channel from a pool
*PoolChannelsApi* | [**get**](docs/PoolChannelsApi.md#get) | **GET** /pools/{poolId}/channels/{channelId} | Get a specific channel in a pool
*PoolChannelsApi* | [**get_all**](docs/PoolChannelsApi.md#get_all) | **GET** /pools/{poolId}/channels | Get all the channels in a pool
*PoolChannelsApi* | [**update_status**](docs/PoolChannelsApi.md#update_status) | **PUT** /pools/{poolId}/channels/{channelId}/status | Updates the status of a specific channel in a pool
*PoolsApi* | [**add_pool**](docs/PoolsApi.md#add_pool) | **POST** /pools | Creates a pool
*PoolsApi* | [**delete_pool**](docs/PoolsApi.md#delete_pool) | **DELETE** /pools/{poolId} | Deletes a pool
*PoolsApi* | [**get_available_numbers**](docs/PoolsApi.md#get_available_numbers) | **GET** /pools/available_numbers | Gets phone numbers that are available to be purchased from the given provider
*PoolsApi* | [**get_pool**](docs/PoolsApi.md#get_pool) | **GET** /pools/{poolId} | Gets a specific pool
*PoolsApi* | [**get_pools**](docs/PoolsApi.md#get_pools) | **GET** /pools | Gets all pools
*PoolsApi* | [**update_pool**](docs/PoolsApi.md#update_pool) | **PUT** /pools/{poolId} | Updates a pool
*PouncesApi* | [**add_pounce**](docs/PouncesApi.md#add_pounce) | **POST** /pounces | Creates a pounce
*PouncesApi* | [**delete_pounce**](docs/PouncesApi.md#delete_pounce) | **DELETE** /pounces/{pounceId} | Deletes the pounce
*PouncesApi* | [**get_team_member_pounces**](docs/PouncesApi.md#get_team_member_pounces) | **GET** /pounces/{teamMemberId} | Gets all pounces assigned to a team member
*PresenceApi* | [**get_presence**](docs/PresenceApi.md#get_presence) | **GET** /presence | Gets the presence details
*ScheduledActionsApi* | [**abort_scheduled_action**](docs/ScheduledActionsApi.md#abort_scheduled_action) | **DELETE** /scheduled_actions/{scheduledActionId} | Abort a Scheduled Action
*ScheduledActionsApi* | [**add_scheduled_action**](docs/ScheduledActionsApi.md#add_scheduled_action) | **POST** /scheduled_actions | Creates a Scheduled Action
*ScheduledActionsApi* | [**get_pending_scheduled_actions**](docs/ScheduledActionsApi.md#get_pending_scheduled_actions) | **GET** /scheduled_actions/pending | Gets pending Scheduled Actions
*ScheduledActionsApi* | [**get_scheduled_action**](docs/ScheduledActionsApi.md#get_scheduled_action) | **GET** /scheduled_actions/{scheduledActionId} | Gets a specific Scheduled Action
*ScheduledActionsApi* | [**get_scheduled_actions**](docs/ScheduledActionsApi.md#get_scheduled_actions) | **GET** /scheduled_actions | Gets all Scheduled Actions
*SmartLinksApi* | [**add_smart_link**](docs/SmartLinksApi.md#add_smart_link) | **POST** /smart_links | Creates a Smart Link
*SmartLinksApi* | [**delete_smart_link**](docs/SmartLinksApi.md#delete_smart_link) | **DELETE** /smart_links/{smartLinkId} | Deletes a Smart Link
*SmartLinksApi* | [**get_smart_link1**](docs/SmartLinksApi.md#get_smart_link1) | **GET** /smart_links/{smartLinkId} | Gets the details of a specific Smart Link
*SmartLinksApi* | [**get_smart_links**](docs/SmartLinksApi.md#get_smart_links) | **GET** /smart_links | Gets all the Smart Links in the org
*SmartLinksApi* | [**update_smart_link**](docs/SmartLinksApi.md#update_smart_link) | **PUT** /smart_links/{smartLinkId} | Modifies a Smart Link
*TagGroupsApi* | [**add_tag_group**](docs/TagGroupsApi.md#add_tag_group) | **POST** /tag_groups | Creates a tag group
*TagGroupsApi* | [**add_tag_to_tag_group**](docs/TagGroupsApi.md#add_tag_to_tag_group) | **POST** /tag_groups/{tagGroupId}/tags/{tagId} | Add a tag to a tag group
*TagGroupsApi* | [**delete_tag_group**](docs/TagGroupsApi.md#delete_tag_group) | **DELETE** /tag_groups/{tagGroupId} | Deletes a tag group
*TagGroupsApi* | [**get_tag_group**](docs/TagGroupsApi.md#get_tag_group) | **GET** /tag_groups/{tagGroupId} | Gets the details of a specific tag group
*TagGroupsApi* | [**get_tag_groups**](docs/TagGroupsApi.md#get_tag_groups) | **GET** /tag_groups | Gets all tag groups
*TagGroupsApi* | [**get_tag_in_tag_groups**](docs/TagGroupsApi.md#get_tag_in_tag_groups) | **GET** /tag_groups/{tagGroupId}/tags | Gets all tags in a group
*TagGroupsApi* | [**remove_tag_from_tag_group**](docs/TagGroupsApi.md#remove_tag_from_tag_group) | **DELETE** /tag_groups/{tagGroupId}/tags/{tagId} | Remove a tag from a tag group
*TagGroupsApi* | [**update_tag_group**](docs/TagGroupsApi.md#update_tag_group) | **PUT** /tag_groups/{tagGroupId} | Modifies a tag group
*TagsApi* | [**add_tag**](docs/TagsApi.md#add_tag) | **POST** /tags | Creates a tag
*TagsApi* | [**delete_tag**](docs/TagsApi.md#delete_tag) | **DELETE** /tags/{tagId} | Deletes the tag
*TagsApi* | [**get_customer_tags1**](docs/TagsApi.md#get_customer_tags1) | **GET** /tags/{tagId} | Gets the customers for a specific tag
*TagsApi* | [**get_tags**](docs/TagsApi.md#get_tags) | **GET** /tags | Gets all tags
*TeamMembersApi* | [**add_identity1**](docs/TeamMembersApi.md#add_identity1) | **PUT** /team_members/{teamMemberId}/identity | Adds an identity to a team member
*TeamMembersApi* | [**add_team_member**](docs/TeamMembersApi.md#add_team_member) | **POST** /team_members | Creates a team member
*TeamMembersApi* | [**delete_team_member**](docs/TeamMembersApi.md#delete_team_member) | **DELETE** /team_members/{teamMemberId} | Deletes a team member
*TeamMembersApi* | [**get_aggregate_permissions**](docs/TeamMembersApi.md#get_aggregate_permissions) | **GET** /team_members/{teamMemberId}/aggregate-permissions | Gets a team member&#x27;s permissions
*TeamMembersApi* | [**get_org_channel_permission1**](docs/TeamMembersApi.md#get_org_channel_permission1) | **GET** /team_members/{teamMemberId}/org_channels/{orgChannelId}/permissions/{permission} | Gets a team member&#x27;s orgChannel permission
*TeamMembersApi* | [**get_org_channel_permissions1**](docs/TeamMembersApi.md#get_org_channel_permissions1) | **GET** /team_members/{teamMemberId}/org_channels/{orgChannelId}/permissions | Gets a team member&#x27;s orgChannel permissions
*TeamMembersApi* | [**get_org_channels_with_permissions**](docs/TeamMembersApi.md#get_org_channels_with_permissions) | **GET** /team_members/{teamMemberId}/org_channels | Gets the org channels a team member has permissions for
*TeamMembersApi* | [**get_permission1**](docs/TeamMembersApi.md#get_permission1) | **GET** /team_members/{teamMemberId}/permissions/{permission} | Gets a team member&#x27;s permission
*TeamMembersApi* | [**get_permissions1**](docs/TeamMembersApi.md#get_permissions1) | **GET** /team_members/{teamMemberId}/permissions | Gets a team member&#x27;s permissions
*TeamMembersApi* | [**get_private_apps**](docs/TeamMembersApi.md#get_private_apps) | **GET** /team_members/{teamMemberId}/apps | Installs private agent app for the given agent
*TeamMembersApi* | [**get_shared_apps**](docs/TeamMembersApi.md#get_shared_apps) | **GET** /team_members/apps | Gets installed shared agent apps
*TeamMembersApi* | [**get_team_activity**](docs/TeamMembersApi.md#get_team_activity) | **GET** /team_members/activity | Returns a snapshot of team activity
*TeamMembersApi* | [**get_team_member**](docs/TeamMembersApi.md#get_team_member) | **GET** /team_members/{teamMemberId} | Gets the details for a specific team member
*TeamMembersApi* | [**get_team_member_activity**](docs/TeamMembersApi.md#get_team_member_activity) | **GET** /team_members/{teamMemberId}/activity | Returns a snapshot of a team members activity
*TeamMembersApi* | [**get_team_member_notifications**](docs/TeamMembersApi.md#get_team_member_notifications) | **GET** /team_members/{teamMemberId}/notifications | Gets a team member&#x27;s notification settings
*TeamMembersApi* | [**get_team_members**](docs/TeamMembersApi.md#get_team_members) | **GET** /team_members | Gets all the team members in the org
*TeamMembersApi* | [**install_private_app**](docs/TeamMembersApi.md#install_private_app) | **PUT** /team_members/{teamMemberId}/apps/{schemaId} | Installs private agent app for the given agent
*TeamMembersApi* | [**install_shared_app**](docs/TeamMembersApi.md#install_shared_app) | **PUT** /team_members/apps/{schemaId} | Installs shared agent app for all agents
*TeamMembersApi* | [**set_org_channel_permission**](docs/TeamMembersApi.md#set_org_channel_permission) | **POST** /team_members/{teamMemberId}/org_channels/{orgChannelId}/permissions/{permission} | Sets a team member&#x27;s orgChannel permission
*TeamMembersApi* | [**set_org_channel_permissions1**](docs/TeamMembersApi.md#set_org_channel_permissions1) | **POST** /team_members/{teamMemberId}/org_channels/{orgChannelId}/permissions | Sets a team member&#x27;s orgChannel permissions
*TeamMembersApi* | [**set_permission**](docs/TeamMembersApi.md#set_permission) | **POST** /team_members/{teamMemberId}/permissions/{permission} | Sets a team member&#x27;s permission
*TeamMembersApi* | [**set_permissions1**](docs/TeamMembersApi.md#set_permissions1) | **POST** /team_members/{teamMemberId}/permissions | Sets a team member&#x27;s permissions
*TeamMembersApi* | [**set_team_member_notifications**](docs/TeamMembersApi.md#set_team_member_notifications) | **POST** /team_members/{teamMemberId}/notifications | Sets a team member&#x27;s notification settings
*TeamMembersApi* | [**update_team_member**](docs/TeamMembersApi.md#update_team_member) | **PUT** /team_members/{teamMemberId} | Updates a team member
*TeamMembersApi* | [**upload_file_to_team_members**](docs/TeamMembersApi.md#upload_file_to_team_members) | **POST** /team_members/upload | Upload a file for specific team member(s) to access
*UploadsApi* | [**delete_upload**](docs/UploadsApi.md#delete_upload) | **DELETE** /uploads/{uploadId} | Deletes an Upload
*UploadsApi* | [**delete_upload_by_key**](docs/UploadsApi.md#delete_upload_by_key) | **DELETE** /uploads/key/{key} | Deletes an Upload
*UploadsApi* | [**upload_file**](docs/UploadsApi.md#upload_file) | **POST** /uploads | Upload a file

## Documentation For Models

 - [AddAutomationModel](docs/AddAutomationModel.md)
 - [AddBulkActionFulfillmentModel](docs/AddBulkActionFulfillmentModel.md)
 - [AddBulkActionModel](docs/AddBulkActionModel.md)
 - [AddBulkActionVariantModel](docs/AddBulkActionVariantModel.md)
 - [AddConversationRequestModel](docs/AddConversationRequestModel.md)
 - [AddCustomerModel](docs/AddCustomerModel.md)
 - [AddIdentityTeamMemberRequestModel](docs/AddIdentityTeamMemberRequestModel.md)
 - [AddOrUpdateAutomationFulfillmentModel](docs/AddOrUpdateAutomationFulfillmentModel.md)
 - [AddOrUpdateSmartLinkFulfillmentModel](docs/AddOrUpdateSmartLinkFulfillmentModel.md)
 - [AddOrUpdateSmartLinkModel](docs/AddOrUpdateSmartLinkModel.md)
 - [AddPoolChannelRequestModel](docs/AddPoolChannelRequestModel.md)
 - [AddPoolChannelResponseModel](docs/AddPoolChannelResponseModel.md)
 - [AddScheduledActionModel](docs/AddScheduledActionModel.md)
 - [AddTeamMemberModel](docs/AddTeamMemberModel.md)
 - [AdminOrgSettingsModel](docs/AdminOrgSettingsModel.md)
 - [AnalyticsAgentActivityReportModel](docs/AnalyticsAgentActivityReportModel.md)
 - [AnalyticsApiReportModel](docs/AnalyticsApiReportModel.md)
 - [AnalyticsBulkActionReportModel](docs/AnalyticsBulkActionReportModel.md)
 - [AnalyticsChannelReportModel](docs/AnalyticsChannelReportModel.md)
 - [AnalyticsCustomCountersReportModel](docs/AnalyticsCustomCountersReportModel.md)
 - [AnalyticsCustomerEngagementReportModel](docs/AnalyticsCustomerEngagementReportModel.md)
 - [AnalyticsErrorReportModel](docs/AnalyticsErrorReportModel.md)
 - [AnalyticsInstantAppReportModel](docs/AnalyticsInstantAppReportModel.md)
 - [AnalyticsInstantAppSchemaReportModel](docs/AnalyticsInstantAppSchemaReportModel.md)
 - [AnalyticsKpiReportModel](docs/AnalyticsKpiReportModel.md)
 - [AnalyticsMessagingReportListItemModel](docs/AnalyticsMessagingReportListItemModel.md)
 - [AnalyticsMessagingReportModel](docs/AnalyticsMessagingReportModel.md)
 - [AnalyticsOptOutReportModel](docs/AnalyticsOptOutReportModel.md)
 - [AnalyticsOrgActivityReportModel](docs/AnalyticsOrgActivityReportModel.md)
 - [ApiKeyModel](docs/ApiKeyModel.md)
 - [ApiKeyModelPage](docs/ApiKeyModelPage.md)
 - [AuditMessageModel](docs/AuditMessageModel.md)
 - [AuditMessageModelPage](docs/AuditMessageModelPage.md)
 - [AutomationModel](docs/AutomationModel.md)
 - [AutomationModelPage](docs/AutomationModelPage.md)
 - [BandwidthOrgChannelModel](docs/BandwidthOrgChannelModel.md)
 - [BotFulfillmentModel](docs/BotFulfillmentModel.md)
 - [BotIntentModel](docs/BotIntentModel.md)
 - [BotIntentPhraseModel](docs/BotIntentPhraseModel.md)
 - [BotIntentsModel](docs/BotIntentsModel.md)
 - [BotModel](docs/BotModel.md)
 - [BotRequestModel](docs/BotRequestModel.md)
 - [BotResponseModel](docs/BotResponseModel.md)
 - [BulkActionConfirmationDetailsModel](docs/BulkActionConfirmationDetailsModel.md)
 - [BulkActionFulfillmentModel](docs/BulkActionFulfillmentModel.md)
 - [BulkActionModel](docs/BulkActionModel.md)
 - [BulkActionModelPage](docs/BulkActionModelPage.md)
 - [BulkActionPerformActionModel](docs/BulkActionPerformActionModel.md)
 - [BulkActionRetargetModel](docs/BulkActionRetargetModel.md)
 - [BulkActionVariantModel](docs/BulkActionVariantModel.md)
 - [ChannelIdModel](docs/ChannelIdModel.md)
 - [Contact](docs/Contact.md)
 - [ContactListAddContactsModel](docs/ContactListAddContactsModel.md)
 - [ContactListContactModel](docs/ContactListContactModel.md)
 - [ContactListContactModelPage](docs/ContactListContactModelPage.md)
 - [ContactListModel](docs/ContactListModel.md)
 - [ContactListModelPage](docs/ContactListModelPage.md)
 - [ConversationBotModel](docs/ConversationBotModel.md)
 - [ConversationMemberModel](docs/ConversationMemberModel.md)
 - [ConversationModel](docs/ConversationModel.md)
 - [ConversationModelPage](docs/ConversationModelPage.md)
 - [CustomCounterReportKeyValuePair](docs/CustomCounterReportKeyValuePair.md)
 - [CustomerChannelModel](docs/CustomerChannelModel.md)
 - [CustomerIdentityModel](docs/CustomerIdentityModel.md)
 - [CustomerMessageModel](docs/CustomerMessageModel.md)
 - [CustomerModel](docs/CustomerModel.md)
 - [CustomerModelPage](docs/CustomerModelPage.md)
 - [DataDefaultModel](docs/DataDefaultModel.md)
 - [DataDefaultModelPage](docs/DataDefaultModelPage.md)
 - [DeleteResponse](docs/DeleteResponse.md)
 - [EventEndpointModel](docs/EventEndpointModel.md)
 - [EventEndpointModelPage](docs/EventEndpointModelPage.md)
 - [FacebookOrgChannelModel](docs/FacebookOrgChannelModel.md)
 - [FulfillmentModel](docs/FulfillmentModel.md)
 - [GoogleMapIntegrationModel](docs/GoogleMapIntegrationModel.md)
 - [GoogleSheetsIntegrationModel](docs/GoogleSheetsIntegrationModel.md)
 - [GroupMemberModel](docs/GroupMemberModel.md)
 - [GroupMemberModelPage](docs/GroupMemberModelPage.md)
 - [GroupModel](docs/GroupModel.md)
 - [GroupModelPage](docs/GroupModelPage.md)
 - [HistoricalMessageModel](docs/HistoricalMessageModel.md)
 - [HistoricalMessageModelPage](docs/HistoricalMessageModelPage.md)
 - [InstantAppDataModel](docs/InstantAppDataModel.md)
 - [InstantAppIconModel](docs/InstantAppIconModel.md)
 - [InstantAppModel](docs/InstantAppModel.md)
 - [InstantAppModelPage](docs/InstantAppModelPage.md)
 - [InstantAppReportKeyValuePair](docs/InstantAppReportKeyValuePair.md)
 - [InstantAppSchemaModel](docs/InstantAppSchemaModel.md)
 - [InstantAppSchemaModelPage](docs/InstantAppSchemaModelPage.md)
 - [InstantAppTimersModel](docs/InstantAppTimersModel.md)
 - [IntegrationRequestModel](docs/IntegrationRequestModel.md)
 - [IntegrationResponseModel](docs/IntegrationResponseModel.md)
 - [IntegrationResponseModelPage](docs/IntegrationResponseModelPage.md)
 - [KeyValueDataModel](docs/KeyValueDataModel.md)
 - [LineOrgChannelModel](docs/LineOrgChannelModel.md)
 - [LocationModel](docs/LocationModel.md)
 - [ManagedBandwidthOrgChannelModel](docs/ManagedBandwidthOrgChannelModel.md)
 - [MapIconModel](docs/MapIconModel.md)
 - [MapModel](docs/MapModel.md)
 - [MessageModel](docs/MessageModel.md)
 - [MessagesSendFileToCustomerBody](docs/MessagesSendFileToCustomerBody.md)
 - [NotificationGroupModel](docs/NotificationGroupModel.md)
 - [OrgChannelConversationsModel](docs/OrgChannelConversationsModel.md)
 - [OrgChannelModel](docs/OrgChannelModel.md)
 - [OrgChannelModelPage](docs/OrgChannelModelPage.md)
 - [OrgChannelWithPermissionsModel](docs/OrgChannelWithPermissionsModel.md)
 - [OrgChannelWithPermissionsModelPage](docs/OrgChannelWithPermissionsModelPage.md)
 - [OrgExternalIdModel](docs/OrgExternalIdModel.md)
 - [OrgMessagingSettingsModel](docs/OrgMessagingSettingsModel.md)
 - [OrgModel](docs/OrgModel.md)
 - [OrgSettingsModel](docs/OrgSettingsModel.md)
 - [Parameter](docs/Parameter.md)
 - [PerformActionModel](docs/PerformActionModel.md)
 - [PoolChannelModel](docs/PoolChannelModel.md)
 - [PoolChannelModelPage](docs/PoolChannelModelPage.md)
 - [PoolModel](docs/PoolModel.md)
 - [PoolModelPage](docs/PoolModelPage.md)
 - [PoolSubchannelModel](docs/PoolSubchannelModel.md)
 - [PoolSubchannelModelPage](docs/PoolSubchannelModelPage.md)
 - [PostMessageModel](docs/PostMessageModel.md)
 - [PostWhisperModel](docs/PostWhisperModel.md)
 - [PounceModel](docs/PounceModel.md)
 - [PresenceSummaryModel](docs/PresenceSummaryModel.md)
 - [RemoveTeamMemberFromConversationRequestModel](docs/RemoveTeamMemberFromConversationRequestModel.md)
 - [ResolutionContactModel](docs/ResolutionContactModel.md)
 - [ResolutionCountModel](docs/ResolutionCountModel.md)
 - [ResolutionCountModelPage](docs/ResolutionCountModelPage.md)
 - [SMSOrgChannelModel](docs/SMSOrgChannelModel.md)
 - [SalesforceIntegrationRequestModel](docs/SalesforceIntegrationRequestModel.md)
 - [SalesforceIntegrationResponseModel](docs/SalesforceIntegrationResponseModel.md)
 - [ScheduledActionFulfillmentModel](docs/ScheduledActionFulfillmentModel.md)
 - [ScheduledActionModel](docs/ScheduledActionModel.md)
 - [ScheduledActionModelPage](docs/ScheduledActionModelPage.md)
 - [SendToCustomerMessageModel](docs/SendToCustomerMessageModel.md)
 - [SmartLinkFulfillmentModel](docs/SmartLinkFulfillmentModel.md)
 - [SmartLinkModel](docs/SmartLinkModel.md)
 - [SmartLinkModelPage](docs/SmartLinkModelPage.md)
 - [SmoochChatOrgChannelModel](docs/SmoochChatOrgChannelModel.md)
 - [TagGroupModel](docs/TagGroupModel.md)
 - [TagGroupModelPage](docs/TagGroupModelPage.md)
 - [TagModel](docs/TagModel.md)
 - [TagModelPage](docs/TagModelPage.md)
 - [TeamActivityEventModel](docs/TeamActivityEventModel.md)
 - [TeamActivityModel](docs/TeamActivityModel.md)
 - [TeamMemberFileModelPage](docs/TeamMemberFileModelPage.md)
 - [TeamMemberIdentityModel](docs/TeamMemberIdentityModel.md)
 - [TeamMemberModel](docs/TeamMemberModel.md)
 - [TeamMemberModelPage](docs/TeamMemberModelPage.md)
 - [TeamMemberNotificationModel](docs/TeamMemberNotificationModel.md)
 - [TeamMemberUserModel](docs/TeamMemberUserModel.md)
 - [TeamMembersUploadBody](docs/TeamMembersUploadBody.md)
 - [TimerInfo](docs/TimerInfo.md)
 - [TwilioIntegrationModel](docs/TwilioIntegrationModel.md)
 - [TwilioOrgChannelModel](docs/TwilioOrgChannelModel.md)
 - [UpdateAutomationModel](docs/UpdateAutomationModel.md)
 - [UpdateCustomerRequestModel](docs/UpdateCustomerRequestModel.md)
 - [UpdateInstantAppSchemaActiveModel](docs/UpdateInstantAppSchemaActiveModel.md)
 - [UpdateMapIconModel](docs/UpdateMapIconModel.md)
 - [UpdateMembershipCommand](docs/UpdateMembershipCommand.md)
 - [UpdateMembershipModel](docs/UpdateMembershipModel.md)
 - [UpdatePoolChannelStatusRequestModel](docs/UpdatePoolChannelStatusRequestModel.md)
 - [UpdateTeamMemberRequestModel](docs/UpdateTeamMemberRequestModel.md)
 - [UploadModel](docs/UploadModel.md)
 - [UploadsBody](docs/UploadsBody.md)
 - [UserLocationModel](docs/UserLocationModel.md)
 - [YtelOrgChannelModel](docs/YtelOrgChannelModel.md)
 - [ZipwhipOrgChannelModel](docs/ZipwhipOrgChannelModel.md)

## Documentation For Authorization


## global_token

- **Type**: API key
- **API key parameter name**: globalAuthToken
- **Location**: HTTP header

## org_token

- **Type**: API key
- **API key parameter name**: orgAuthToken
- **Location**: HTTP header


## Author


