# coding: utf-8

"""
    Prompt.io APIs

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class APIKeysApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_api_key(self, org_id, **kwargs):  # noqa: E501
        """Creates an API Key for an org  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_api_key(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int org_id: (required)
        :param ApiKeyModel body:
        :return: ApiKeyModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_api_key_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_api_key_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def add_api_key_with_http_info(self, org_id, **kwargs):  # noqa: E501
        """Creates an API Key for an org  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_api_key_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int org_id: (required)
        :param ApiKeyModel body:
        :return: ApiKeyModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_api_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `add_api_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['orgId'] = params['org_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['global_token']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgId}/api_keys', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiKeyModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_api_key(self, org_id, api_key_id, **kwargs):  # noqa: E501
        """Deletes an API Key for an org  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_api_key(org_id, api_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int org_id: (required)
        :param int api_key_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_api_key_with_http_info(org_id, api_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_api_key_with_http_info(org_id, api_key_id, **kwargs)  # noqa: E501
            return data

    def delete_api_key_with_http_info(self, org_id, api_key_id, **kwargs):  # noqa: E501
        """Deletes an API Key for an org  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_api_key_with_http_info(org_id, api_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int org_id: (required)
        :param int api_key_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_id', 'api_key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_api_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `delete_api_key`")  # noqa: E501
        # verify the required parameter 'api_key_id' is set
        if ('api_key_id' not in params or
                params['api_key_id'] is None):
            raise ValueError("Missing the required parameter `api_key_id` when calling `delete_api_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['orgId'] = params['org_id']  # noqa: E501
        if 'api_key_id' in params:
            path_params['apiKeyId'] = params['api_key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['global_token']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgId}/api_keys/{apiKeyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_api_key(self, org_id, api_key_id, **kwargs):  # noqa: E501
        """Gets a specific API Key for an org  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_key(org_id, api_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int org_id: (required)
        :param int api_key_id: (required)
        :return: ApiKeyModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_api_key_with_http_info(org_id, api_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_api_key_with_http_info(org_id, api_key_id, **kwargs)  # noqa: E501
            return data

    def get_api_key_with_http_info(self, org_id, api_key_id, **kwargs):  # noqa: E501
        """Gets a specific API Key for an org  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_key_with_http_info(org_id, api_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int org_id: (required)
        :param int api_key_id: (required)
        :return: ApiKeyModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_id', 'api_key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_api_key`")  # noqa: E501
        # verify the required parameter 'api_key_id' is set
        if ('api_key_id' not in params or
                params['api_key_id'] is None):
            raise ValueError("Missing the required parameter `api_key_id` when calling `get_api_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['orgId'] = params['org_id']  # noqa: E501
        if 'api_key_id' in params:
            path_params['apiKeyId'] = params['api_key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['global_token']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgId}/api_keys/{apiKeyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiKeyModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_api_keys(self, org_id, **kwargs):  # noqa: E501
        """Gets all API Keys for an org  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_keys(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int org_id: (required)
        :param int first:
        :param int max:
        :return: ApiKeyModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_api_keys_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_api_keys_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_api_keys_with_http_info(self, org_id, **kwargs):  # noqa: E501
        """Gets all API Keys for an org  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_keys_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int org_id: (required)
        :param int first:
        :param int max:
        :return: ApiKeyModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_id', 'first', 'max']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_keys" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_api_keys`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['orgId'] = params['org_id']  # noqa: E501

        query_params = []
        if 'first' in params:
            query_params.append(('first', params['first']))  # noqa: E501
        if 'max' in params:
            query_params.append(('max', params['max']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['global_token']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgId}/api_keys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiKeyModelPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_token(self, org_id, api_key_id, **kwargs):  # noqa: E501
        """Resets the secret for an API Key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_token(org_id, api_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int org_id: (required)
        :param int api_key_id: (required)
        :return: ApiKeyModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_token_with_http_info(org_id, api_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.reset_token_with_http_info(org_id, api_key_id, **kwargs)  # noqa: E501
            return data

    def reset_token_with_http_info(self, org_id, api_key_id, **kwargs):  # noqa: E501
        """Resets the secret for an API Key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_token_with_http_info(org_id, api_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int org_id: (required)
        :param int api_key_id: (required)
        :return: ApiKeyModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_id', 'api_key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `reset_token`")  # noqa: E501
        # verify the required parameter 'api_key_id' is set
        if ('api_key_id' not in params or
                params['api_key_id'] is None):
            raise ValueError("Missing the required parameter `api_key_id` when calling `reset_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['orgId'] = params['org_id']  # noqa: E501
        if 'api_key_id' in params:
            path_params['apiKeyId'] = params['api_key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['global_token']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgId}/api_keys/{apiKeyId}/reset_token', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiKeyModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_api_key(self, org_id, api_key_id, **kwargs):  # noqa: E501
        """Updates an API Key for an org  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_api_key(org_id, api_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int org_id: (required)
        :param int api_key_id: (required)
        :param ApiKeyModel body:
        :return: ApiKeyModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_api_key_with_http_info(org_id, api_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_api_key_with_http_info(org_id, api_key_id, **kwargs)  # noqa: E501
            return data

    def update_api_key_with_http_info(self, org_id, api_key_id, **kwargs):  # noqa: E501
        """Updates an API Key for an org  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_api_key_with_http_info(org_id, api_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int org_id: (required)
        :param int api_key_id: (required)
        :param ApiKeyModel body:
        :return: ApiKeyModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_id', 'api_key_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_api_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `update_api_key`")  # noqa: E501
        # verify the required parameter 'api_key_id' is set
        if ('api_key_id' not in params or
                params['api_key_id'] is None):
            raise ValueError("Missing the required parameter `api_key_id` when calling `update_api_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['orgId'] = params['org_id']  # noqa: E501
        if 'api_key_id' in params:
            path_params['apiKeyId'] = params['api_key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['global_token']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgId}/api_keys/{apiKeyId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiKeyModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
