# coding: utf-8

"""
    Prompt.io APIs

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class ConversationsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_conversation(self, **kwargs):  # noqa: E501
        """Creates a conversation with customer and the team member  # noqa: E501

        _in snippets: platform.api.conversations.addConversation_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_conversation(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddConversationRequestModel body:
        :return: ConversationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_conversation_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_conversation_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_conversation_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a conversation with customer and the team member  # noqa: E501

        _in snippets: platform.api.conversations.addConversation_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_conversation_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddConversationRequestModel body:
        :return: ConversationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_conversation" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def assign(self, conversation_id, **kwargs):  # noqa: E501
        """Takes a conversation and assigns it to one or more groups/users  # noqa: E501

        _in snippets: platform.api.conversations.assign_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param list[str] group_ids: The apiId or internal id
        :param list[int] team_member_ids:
        :return: ConversationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assign_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.assign_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def assign_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Takes a conversation and assigns it to one or more groups/users  # noqa: E501

        _in snippets: platform.api.conversations.assign_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param list[str] group_ids: The apiId or internal id
        :param list[int] team_member_ids:
        :return: ConversationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'group_ids', 'team_member_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `assign`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []
        if 'group_ids' in params:
            query_params.append(('groupIds', params['group_ids']))  # noqa: E501
            collection_formats['groupIds'] = 'multi'  # noqa: E501
        if 'team_member_ids' in params:
            query_params.append(('teamMemberIds', params['team_member_ids']))  # noqa: E501
            collection_formats['teamMemberIds'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/{conversationId}/assign', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def assign_bot(self, conversation_id, **kwargs):  # noqa: E501
        """Takes a conversation and assigns it to a bot  # noqa: E501

        _in snippets: platform.api.conversations.assignBot_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_bot(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param int bot_id:
        :param str bot_api_id:
        :return: ConversationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assign_bot_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.assign_bot_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def assign_bot_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Takes a conversation and assigns it to a bot  # noqa: E501

        _in snippets: platform.api.conversations.assignBot_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_bot_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param int bot_id:
        :param str bot_api_id:
        :return: ConversationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'bot_id', 'bot_api_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_bot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `assign_bot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []
        if 'bot_id' in params:
            query_params.append(('botId', params['bot_id']))  # noqa: E501
        if 'bot_api_id' in params:
            query_params.append(('botApiId', params['bot_api_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/{conversationId}/assign_bot', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def close(self, conversation_id, team_member_id, **kwargs):  # noqa: E501
        """Closes the requested conversation  # noqa: E501

        _in snippets: platform.api.conversations.close_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.close(conversation_id, team_member_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param int team_member_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.close_with_http_info(conversation_id, team_member_id, **kwargs)  # noqa: E501
        else:
            (data) = self.close_with_http_info(conversation_id, team_member_id, **kwargs)  # noqa: E501
            return data

    def close_with_http_info(self, conversation_id, team_member_id, **kwargs):  # noqa: E501
        """Closes the requested conversation  # noqa: E501

        _in snippets: platform.api.conversations.close_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.close_with_http_info(conversation_id, team_member_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param int team_member_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'team_member_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method close" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `close`")  # noqa: E501
        # verify the required parameter 'team_member_id' is set
        if ('team_member_id' not in params or
                params['team_member_id'] is None):
            raise ValueError("Missing the required parameter `team_member_id` when calling `close`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []
        if 'team_member_id' in params:
            query_params.append(('teamMemberId', params['team_member_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/{conversationId}/close', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def escalate(self, conversation_id, **kwargs):  # noqa: E501
        """Takes an active conversation handled by a bot, and escalates it to groups or teamMembers  # noqa: E501

        _in snippets: platform.api.conversations.escalate_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.escalate(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param list[str] group_ids: The apiId or internal id
        :return: ConversationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.escalate_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.escalate_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def escalate_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Takes an active conversation handled by a bot, and escalates it to groups or teamMembers  # noqa: E501

        _in snippets: platform.api.conversations.escalate_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.escalate_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param list[str] group_ids: The apiId or internal id
        :return: ConversationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'group_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method escalate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `escalate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []
        if 'group_ids' in params:
            query_params.append(('groupIds', params['group_ids']))  # noqa: E501
            collection_formats['groupIds'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/{conversationId}/escalate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_active(self, team_member_id, **kwargs):  # noqa: E501
        """Gets all the active conversations for a team member  # noqa: E501

        _in snippets: platform.api.conversations.getActive_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active(team_member_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int team_member_id: (required)
        :param int first:
        :param int max:
        :return: ConversationModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_active_with_http_info(team_member_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_active_with_http_info(team_member_id, **kwargs)  # noqa: E501
            return data

    def get_active_with_http_info(self, team_member_id, **kwargs):  # noqa: E501
        """Gets all the active conversations for a team member  # noqa: E501

        _in snippets: platform.api.conversations.getActive_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_with_http_info(team_member_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int team_member_id: (required)
        :param int first:
        :param int max:
        :return: ConversationModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['team_member_id', 'first', 'max']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'team_member_id' is set
        if ('team_member_id' not in params or
                params['team_member_id'] is None):
            raise ValueError("Missing the required parameter `team_member_id` when calling `get_active`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'team_member_id' in params:
            path_params['teamMemberId'] = params['team_member_id']  # noqa: E501

        query_params = []
        if 'first' in params:
            query_params.append(('first', params['first']))  # noqa: E501
        if 'max' in params:
            query_params.append(('max', params['max']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/active/team_members/{teamMemberId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationModelPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_active_for_bot(self, bot_id, **kwargs):  # noqa: E501
        """Gets all the active conversations for a bot  # noqa: E501

        _in snippets: platform.api.conversations.getActiveForBot_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_for_bot(bot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bot_id: (required)
        :param int first:
        :param int max:
        :return: ConversationModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_active_for_bot_with_http_info(bot_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_active_for_bot_with_http_info(bot_id, **kwargs)  # noqa: E501
            return data

    def get_active_for_bot_with_http_info(self, bot_id, **kwargs):  # noqa: E501
        """Gets all the active conversations for a bot  # noqa: E501

        _in snippets: platform.api.conversations.getActiveForBot_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_for_bot_with_http_info(bot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bot_id: (required)
        :param int first:
        :param int max:
        :return: ConversationModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bot_id', 'first', 'max']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active_for_bot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bot_id' is set
        if ('bot_id' not in params or
                params['bot_id'] is None):
            raise ValueError("Missing the required parameter `bot_id` when calling `get_active_for_bot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bot_id' in params:
            path_params['botId'] = params['bot_id']  # noqa: E501

        query_params = []
        if 'first' in params:
            query_params.append(('first', params['first']))  # noqa: E501
        if 'max' in params:
            query_params.append(('max', params['max']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/active/bots/{botId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationModelPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_active_for_customer(self, customer_id, **kwargs):  # noqa: E501
        """Gets all the active conversations for a customer  # noqa: E501

        _in snippets: platform.api.conversations.getActiveForCustomer_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_for_customer(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param int first:
        :param int max:
        :return: ConversationModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_active_for_customer_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_active_for_customer_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_active_for_customer_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Gets all the active conversations for a customer  # noqa: E501

        _in snippets: platform.api.conversations.getActiveForCustomer_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_for_customer_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param int first:
        :param int max:
        :return: ConversationModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'first', 'max']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active_for_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_active_for_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []
        if 'first' in params:
            query_params.append(('first', params['first']))  # noqa: E501
        if 'max' in params:
            query_params.append(('max', params['max']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/active/customers/{customerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationModelPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_active_for_customer_by_channel_id(self, customer_channel_id, **kwargs):  # noqa: E501
        """Gets all the active conversations for a customer  # noqa: E501

        _in snippets: platform.api.conversations.getActiveForCustomerByChannelId_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_for_customer_by_channel_id(customer_channel_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_channel_id: (required)
        :return: list[ConversationModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_active_for_customer_by_channel_id_with_http_info(customer_channel_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_active_for_customer_by_channel_id_with_http_info(customer_channel_id, **kwargs)  # noqa: E501
            return data

    def get_active_for_customer_by_channel_id_with_http_info(self, customer_channel_id, **kwargs):  # noqa: E501
        """Gets all the active conversations for a customer  # noqa: E501

        _in snippets: platform.api.conversations.getActiveForCustomerByChannelId_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_for_customer_by_channel_id_with_http_info(customer_channel_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_channel_id: (required)
        :return: list[ConversationModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_channel_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active_for_customer_by_channel_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_channel_id' is set
        if ('customer_channel_id' not in params or
                params['customer_channel_id'] is None):
            raise ValueError("Missing the required parameter `customer_channel_id` when calling `get_active_for_customer_by_channel_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_channel_id' in params:
            path_params['customerChannelId'] = params['customer_channel_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/active/customer_channels/{customerChannelId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ConversationModel]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_active_for_customer_by_channel_key(self, type, key, **kwargs):  # noqa: E501
        """Gets all the active conversations for a customer  # noqa: E501

        _in snippets: platform.api.conversations.getActiveForCustomerByChannelKey_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_for_customer_by_channel_key(type, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: (required)
        :param str key: (required)
        :return: list[ConversationModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_active_for_customer_by_channel_key_with_http_info(type, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_active_for_customer_by_channel_key_with_http_info(type, key, **kwargs)  # noqa: E501
            return data

    def get_active_for_customer_by_channel_key_with_http_info(self, type, key, **kwargs):  # noqa: E501
        """Gets all the active conversations for a customer  # noqa: E501

        _in snippets: platform.api.conversations.getActiveForCustomerByChannelKey_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_for_customer_by_channel_key_with_http_info(type, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: (required)
        :param str key: (required)
        :return: list[ConversationModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active_for_customer_by_channel_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_active_for_customer_by_channel_key`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_active_for_customer_by_channel_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/active/customer_channels/channel_types/{type}/channel_keys/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ConversationModel]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_conversation(self, conversation_id, **kwargs):  # noqa: E501
        """Gets a conversation based on its internal id.  # noqa: E501

        _in snippets: platform.api.conversations.getConversation_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_conversation(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :return: ConversationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_conversation_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_conversation_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def get_conversation_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Gets a conversation based on its internal id.  # noqa: E501

        _in snippets: platform.api.conversations.getConversation_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_conversation_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :return: ConversationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/{conversationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_conversation_messages(self, conversation_id, **kwargs):  # noqa: E501
        """Gets messages for a conversation  # noqa: E501

        _in snippets: platform.api.conversations.getConversationMessages_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_conversation_messages(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param int less_or_equal_timestamp:
        :param int desired_max:
        :param bool filter_opted_out:
        :param bool exclude_system_messages:
        :return: list[MessageModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_conversation_messages_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_conversation_messages_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def get_conversation_messages_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Gets messages for a conversation  # noqa: E501

        _in snippets: platform.api.conversations.getConversationMessages_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_conversation_messages_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param int less_or_equal_timestamp:
        :param int desired_max:
        :param bool filter_opted_out:
        :param bool exclude_system_messages:
        :return: list[MessageModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'less_or_equal_timestamp', 'desired_max', 'filter_opted_out', 'exclude_system_messages']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_messages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_messages`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []
        if 'less_or_equal_timestamp' in params:
            query_params.append(('lessOrEqualTimestamp', params['less_or_equal_timestamp']))  # noqa: E501
        if 'desired_max' in params:
            query_params.append(('desiredMax', params['desired_max']))  # noqa: E501
        if 'filter_opted_out' in params:
            query_params.append(('filterOptedOut', params['filter_opted_out']))  # noqa: E501
        if 'exclude_system_messages' in params:
            query_params.append(('excludeSystemMessages', params['exclude_system_messages']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/{conversationId}/messages', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MessageModel]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_for_customer(self, customer_id, **kwargs):  # noqa: E501
        """Gets all messages for a customer, as visible by a team member  # noqa: E501

        _in snippets: platform.api.conversations.getForCustomer_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_for_customer(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param int viewable_by_team_member_id:
        :param int less_or_equal_timestamp:
        :param int desired_max:
        :return: list[MessageModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_for_customer_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_for_customer_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_for_customer_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Gets all messages for a customer, as visible by a team member  # noqa: E501

        _in snippets: platform.api.conversations.getForCustomer_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_for_customer_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param int viewable_by_team_member_id:
        :param int less_or_equal_timestamp:
        :param int desired_max:
        :return: list[MessageModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'viewable_by_team_member_id', 'less_or_equal_timestamp', 'desired_max']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_for_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_for_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []
        if 'viewable_by_team_member_id' in params:
            query_params.append(('viewableByTeamMemberId', params['viewable_by_team_member_id']))  # noqa: E501
        if 'less_or_equal_timestamp' in params:
            query_params.append(('lessOrEqualTimestamp', params['less_or_equal_timestamp']))  # noqa: E501
        if 'desired_max' in params:
            query_params.append(('desiredMax', params['desired_max']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/customers/{customerId}/messages', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MessageModel]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_inbox(self, team_member_id, **kwargs):  # noqa: E501
        """Gets all the conversations in the team members inbox.  # noqa: E501

        _in snippets: platform.api.conversations.getInbox_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbox(team_member_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int team_member_id: (required)
        :param int first:
        :param int max:
        :param bool oldest_first:
        :return: ConversationModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_inbox_with_http_info(team_member_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_inbox_with_http_info(team_member_id, **kwargs)  # noqa: E501
            return data

    def get_inbox_with_http_info(self, team_member_id, **kwargs):  # noqa: E501
        """Gets all the conversations in the team members inbox.  # noqa: E501

        _in snippets: platform.api.conversations.getInbox_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbox_with_http_info(team_member_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int team_member_id: (required)
        :param int first:
        :param int max:
        :param bool oldest_first:
        :return: ConversationModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['team_member_id', 'first', 'max', 'oldest_first']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inbox" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'team_member_id' is set
        if ('team_member_id' not in params or
                params['team_member_id'] is None):
            raise ValueError("Missing the required parameter `team_member_id` when calling `get_inbox`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'team_member_id' in params:
            path_params['teamMemberId'] = params['team_member_id']  # noqa: E501

        query_params = []
        if 'first' in params:
            query_params.append(('first', params['first']))  # noqa: E501
        if 'max' in params:
            query_params.append(('max', params['max']))  # noqa: E501
        if 'oldest_first' in params:
            query_params.append(('oldestFirst', params['oldest_first']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/inbox/team_members/{teamMemberId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationModelPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smart_link(self, conversation_id, smart_link_id, **kwargs):  # noqa: E501
        """Creates a smart link for the customer involved in the conversation  # noqa: E501

        _in snippets: platform.api.conversations.getSmartLink_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smart_link(conversation_id, smart_link_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param int smart_link_id: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_smart_link_with_http_info(conversation_id, smart_link_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_smart_link_with_http_info(conversation_id, smart_link_id, **kwargs)  # noqa: E501
            return data

    def get_smart_link_with_http_info(self, conversation_id, smart_link_id, **kwargs):  # noqa: E501
        """Creates a smart link for the customer involved in the conversation  # noqa: E501

        _in snippets: platform.api.conversations.getSmartLink_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smart_link_with_http_info(conversation_id, smart_link_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param int smart_link_id: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'smart_link_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smart_link" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_smart_link`")  # noqa: E501
        # verify the required parameter 'smart_link_id' is set
        if ('smart_link_id' not in params or
                params['smart_link_id'] is None):
            raise ValueError("Missing the required parameter `smart_link_id` when calling `get_smart_link`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501
        if 'smart_link_id' in params:
            path_params['smartLinkId'] = params['smart_link_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/{conversationId}/smart_link/{smartLinkId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def opt_out(self, conversation_id, **kwargs):  # noqa: E501
        """Opted out customers can not receive any additional messages from this conversations until opted back in  # noqa: E501

        _in snippets: platform.api.conversations.optOut_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.opt_out(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param bool body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.opt_out_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.opt_out_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def opt_out_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Opted out customers can not receive any additional messages from this conversations until opted back in  # noqa: E501

        _in snippets: platform.api.conversations.optOut_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.opt_out_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param bool body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method opt_out" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `opt_out`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/{conversationId}/optOut', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_message(self, conversation_id, **kwargs):  # noqa: E501
        """Posts a message to an active conversation  # noqa: E501

        _in snippets: platform.api.conversations.postMessage_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_message(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param PostMessageModel body:
        :return: MessageModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_message_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_message_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def post_message_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Posts a message to an active conversation  # noqa: E501

        _in snippets: platform.api.conversations.postMessage_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_message_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param PostMessageModel body:
        :return: MessageModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_message" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `post_message`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/{conversationId}/message', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_whisper(self, conversation_id, **kwargs):  # noqa: E501
        """Posts a whisper to an active conversation  # noqa: E501

        _in snippets: platform.api.conversations.postWhisper_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_whisper(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param PostWhisperModel body:
        :return: MessageModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_whisper_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_whisper_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def post_whisper_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Posts a whisper to an active conversation  # noqa: E501

        _in snippets: platform.api.conversations.postWhisper_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_whisper_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param PostWhisperModel body:
        :return: MessageModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_whisper" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `post_whisper`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/{conversationId}/whisper', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_team_member_from_conversation(self, conversation_id, team_member_id, **kwargs):  # noqa: E501
        """Removes a team member from a conversation.  # noqa: E501

        _in snippets: platform.api.conversations.removeTeamMemberFromConversation_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_team_member_from_conversation(conversation_id, team_member_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param int team_member_id: (required)
        :param RemoveTeamMemberFromConversationRequestModel body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_team_member_from_conversation_with_http_info(conversation_id, team_member_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_team_member_from_conversation_with_http_info(conversation_id, team_member_id, **kwargs)  # noqa: E501
            return data

    def remove_team_member_from_conversation_with_http_info(self, conversation_id, team_member_id, **kwargs):  # noqa: E501
        """Removes a team member from a conversation.  # noqa: E501

        _in snippets: platform.api.conversations.removeTeamMemberFromConversation_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_team_member_from_conversation_with_http_info(conversation_id, team_member_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param int team_member_id: (required)
        :param RemoveTeamMemberFromConversationRequestModel body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'team_member_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_team_member_from_conversation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `remove_team_member_from_conversation`")  # noqa: E501
        # verify the required parameter 'team_member_id' is set
        if ('team_member_id' not in params or
                params['team_member_id'] is None):
            raise ValueError("Missing the required parameter `team_member_id` when calling `remove_team_member_from_conversation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501
        if 'team_member_id' in params:
            path_params['teamMemberId'] = params['team_member_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/{conversationId}/team_members/{teamMemberId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def take(self, conversation_id, **kwargs):  # noqa: E501
        """Takes a pending conversation and moves it into an active state, ready for communication  # noqa: E501

        _in snippets: platform.api.conversations.take_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.take(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param int team_member_id:
        :return: ConversationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.take_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.take_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def take_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Takes a pending conversation and moves it into an active state, ready for communication  # noqa: E501

        _in snippets: platform.api.conversations.take_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.take_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param int team_member_id:
        :return: ConversationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'team_member_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method take" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `take`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []
        if 'team_member_id' in params:
            query_params.append(('teamMemberId', params['team_member_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/{conversationId}/take', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_membership(self, conversation_id, **kwargs):  # noqa: E501
        """Updates the team members presences in conversation, optionally add it to their Inbox, Active Chats, or removing it altogether  # noqa: E501

        _in snippets: platform.api.conversations.updateMembership_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_membership(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param UpdateMembershipModel body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_membership_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_membership_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def update_membership_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Updates the team members presences in conversation, optionally add it to their Inbox, Active Chats, or removing it altogether  # noqa: E501

        _in snippets: platform.api.conversations.updateMembership_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_membership_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int conversation_id: (required)
        :param UpdateMembershipModel body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_membership" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `update_membership`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/conversations/{conversationId}/update_membership', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
