# coding: utf-8

"""
    Prompt.io APIs

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class DataApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_data(self, data_type, data_id, key, **kwargs):  # noqa: E501
        """Deletes one key of data for a specific data entity  # noqa: E501

        _in snippets: platform.api.data.deleteData_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_data(data_type, data_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_type: The type of data store being accessed, allowable values are customer,agent,org,schema,channel,app (required)
        :param str data_id: The apiId or internal id (required)
        :param str key: The key (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_data_with_http_info(data_type, data_id, key, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_data_with_http_info(data_type, data_id, key, **kwargs)  # noqa: E501
            return data

    def delete_data_with_http_info(self, data_type, data_id, key, **kwargs):  # noqa: E501
        """Deletes one key of data for a specific data entity  # noqa: E501

        _in snippets: platform.api.data.deleteData_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_data_with_http_info(data_type, data_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_type: The type of data store being accessed, allowable values are customer,agent,org,schema,channel,app (required)
        :param str data_id: The apiId or internal id (required)
        :param str key: The key (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_type', 'data_id', 'key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_type' is set
        if ('data_type' not in params or
                params['data_type'] is None):
            raise ValueError("Missing the required parameter `data_type` when calling `delete_data`")  # noqa: E501
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params or
                params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `delete_data`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `delete_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_type' in params:
            path_params['dataType'] = params['data_type']  # noqa: E501
        if 'data_id' in params:
            path_params['dataId'] = params['data_id']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/data/{dataType}/{dataId}/keys/{key}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, str)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data(self, data_type, data_id, **kwargs):  # noqa: E501
        """Gets all the data for a specific data entity  # noqa: E501

        _in snippets: platform.api.data.getData_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data(data_type, data_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_type: The type of data store being accessed, allowable values are customer,agent,org,schema,channel,app (required)
        :param str data_id: The apiId or internal id (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_data_with_http_info(data_type, data_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_data_with_http_info(data_type, data_id, **kwargs)  # noqa: E501
            return data

    def get_data_with_http_info(self, data_type, data_id, **kwargs):  # noqa: E501
        """Gets all the data for a specific data entity  # noqa: E501

        _in snippets: platform.api.data.getData_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_with_http_info(data_type, data_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_type: The type of data store being accessed, allowable values are customer,agent,org,schema,channel,app (required)
        :param str data_id: The apiId or internal id (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_type', 'data_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_type' is set
        if ('data_type' not in params or
                params['data_type'] is None):
            raise ValueError("Missing the required parameter `data_type` when calling `get_data`")  # noqa: E501
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params or
                params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `get_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_type' in params:
            path_params['dataType'] = params['data_type']  # noqa: E501
        if 'data_id' in params:
            path_params['dataId'] = params['data_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/data/{dataType}/{dataId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, str)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_by_key(self, data_type, data_id, key, **kwargs):  # noqa: E501
        """Gets one key of data for a specific data entity  # noqa: E501

        _in snippets: platform.api.data.getDataByKey_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_by_key(data_type, data_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_type: The type of data store being accessed, allowable values are customer,agent,org,schema,channel,app (required)
        :param str data_id: The apiId or internal id (required)
        :param str key: The key (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_data_by_key_with_http_info(data_type, data_id, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_data_by_key_with_http_info(data_type, data_id, key, **kwargs)  # noqa: E501
            return data

    def get_data_by_key_with_http_info(self, data_type, data_id, key, **kwargs):  # noqa: E501
        """Gets one key of data for a specific data entity  # noqa: E501

        _in snippets: platform.api.data.getDataByKey_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_by_key_with_http_info(data_type, data_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_type: The type of data store being accessed, allowable values are customer,agent,org,schema,channel,app (required)
        :param str data_id: The apiId or internal id (required)
        :param str key: The key (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_type', 'data_id', 'key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_by_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_type' is set
        if ('data_type' not in params or
                params['data_type'] is None):
            raise ValueError("Missing the required parameter `data_type` when calling `get_data_by_key`")  # noqa: E501
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params or
                params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `get_data_by_key`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_data_by_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_type' in params:
            path_params['dataType'] = params['data_type']  # noqa: E501
        if 'data_id' in params:
            path_params['dataId'] = params['data_id']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/data/{dataType}/{dataId}/keys/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, str)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_default(self, key, **kwargs):  # noqa: E501
        """Get the default values for a specific customer data key  # noqa: E501

        _in snippets: platform.api.data.getDataDefault_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_default(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: The key (required)
        :return: DataDefaultModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_data_default_with_http_info(key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_data_default_with_http_info(key, **kwargs)  # noqa: E501
            return data

    def get_data_default_with_http_info(self, key, **kwargs):  # noqa: E501
        """Get the default values for a specific customer data key  # noqa: E501

        _in snippets: platform.api.data.getDataDefault_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_default_with_http_info(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: The key (required)
        :return: DataDefaultModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_default" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_data_default`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/data/defaults/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataDefaultModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_defaults(self, **kwargs):  # noqa: E501
        """Get the default values for customer data keys  # noqa: E501

        _in snippets: platform.api.data.getDataDefaults_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_defaults(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int first:
        :param int max:
        :return: DataDefaultModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_data_defaults_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_data_defaults_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_data_defaults_with_http_info(self, **kwargs):  # noqa: E501
        """Get the default values for customer data keys  # noqa: E501

        _in snippets: platform.api.data.getDataDefaults_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_defaults_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int first:
        :param int max:
        :return: DataDefaultModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['first', 'max']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_defaults" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'first' in params:
            query_params.append(('first', params['first']))  # noqa: E501
        if 'max' in params:
            query_params.append(('max', params['max']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/data/defaults', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataDefaultModelPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_data(self, data_type, data_id, **kwargs):  # noqa: E501
        """Sets all the data for a specific data entity (unmentioned keys are removed)  # noqa: E501

        _in snippets: platform.api.data.setData_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_data(data_type, data_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_type: The type of data store being accessed, allowable values are customer,agent,org,schema,channel,app (required)
        :param str data_id: The apiId or internal id (required)
        :param dict(str, str) body:
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_data_with_http_info(data_type, data_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_data_with_http_info(data_type, data_id, **kwargs)  # noqa: E501
            return data

    def set_data_with_http_info(self, data_type, data_id, **kwargs):  # noqa: E501
        """Sets all the data for a specific data entity (unmentioned keys are removed)  # noqa: E501

        _in snippets: platform.api.data.setData_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_data_with_http_info(data_type, data_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_type: The type of data store being accessed, allowable values are customer,agent,org,schema,channel,app (required)
        :param str data_id: The apiId or internal id (required)
        :param dict(str, str) body:
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_type', 'data_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_type' is set
        if ('data_type' not in params or
                params['data_type'] is None):
            raise ValueError("Missing the required parameter `data_type` when calling `set_data`")  # noqa: E501
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params or
                params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `set_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_type' in params:
            path_params['dataType'] = params['data_type']  # noqa: E501
        if 'data_id' in params:
            path_params['dataId'] = params['data_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/data/{dataType}/{dataId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, str)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_data_default(self, key, **kwargs):  # noqa: E501
        """Set the default value for a specific customer data key  # noqa: E501

        _in snippets: platform.api.data.setDataDefault_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_data_default(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: The key (required)
        :param DataDefaultModel body:
        :return: DataDefaultModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_data_default_with_http_info(key, **kwargs)  # noqa: E501
        else:
            (data) = self.set_data_default_with_http_info(key, **kwargs)  # noqa: E501
            return data

    def set_data_default_with_http_info(self, key, **kwargs):  # noqa: E501
        """Set the default value for a specific customer data key  # noqa: E501

        _in snippets: platform.api.data.setDataDefault_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_data_default_with_http_info(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: The key (required)
        :param DataDefaultModel body:
        :return: DataDefaultModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_data_default" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `set_data_default`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/data/defaults/{key}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataDefaultModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_data(self, data_type, data_id, **kwargs):  # noqa: E501
        """Updates data for a specific data entity (does not modify unmentioned keys)  # noqa: E501

        _in snippets: platform.api.data.updateData_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_data(data_type, data_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_type: The type of data store being accessed, allowable values are customer,agent,org,schema,channel,app (required)
        :param str data_id: The apiId or internal id (required)
        :param dict(str, str) body:
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_data_with_http_info(data_type, data_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_data_with_http_info(data_type, data_id, **kwargs)  # noqa: E501
            return data

    def update_data_with_http_info(self, data_type, data_id, **kwargs):  # noqa: E501
        """Updates data for a specific data entity (does not modify unmentioned keys)  # noqa: E501

        _in snippets: platform.api.data.updateData_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_data_with_http_info(data_type, data_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_type: The type of data store being accessed, allowable values are customer,agent,org,schema,channel,app (required)
        :param str data_id: The apiId or internal id (required)
        :param dict(str, str) body:
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_type', 'data_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_type' is set
        if ('data_type' not in params or
                params['data_type'] is None):
            raise ValueError("Missing the required parameter `data_type` when calling `update_data`")  # noqa: E501
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params or
                params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `update_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_type' in params:
            path_params['dataType'] = params['data_type']  # noqa: E501
        if 'data_id' in params:
            path_params['dataId'] = params['data_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/data/{dataType}/{dataId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, str)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
