# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 2.2.0  # noqa: E501
    The version of the OpenAPI document: 0.10.4
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class NetworkPropertiesDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'identifier': 'str',
        'node_equality_strategy': 'NodeIdentityEqualityStrategy',
        'nemesis_signer_public_key': 'str',
        'generation_hash_seed': 'str',
        'epoch_adjustment': 'str'
    }

    attribute_map = {
        'identifier': 'identifier',
        'node_equality_strategy': 'nodeEqualityStrategy',
        'nemesis_signer_public_key': 'nemesisSignerPublicKey',
        'generation_hash_seed': 'generationHashSeed',
        'epoch_adjustment': 'epochAdjustment'
    }

    def __init__(self, identifier=None, node_equality_strategy=None, nemesis_signer_public_key=None, generation_hash_seed=None, epoch_adjustment=None, local_vars_configuration=None):  # noqa: E501
        """NetworkPropertiesDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._identifier = None
        self._node_equality_strategy = None
        self._nemesis_signer_public_key = None
        self._generation_hash_seed = None
        self._epoch_adjustment = None
        self.discriminator = None

        if identifier is not None:
            self.identifier = identifier
        if node_equality_strategy is not None:
            self.node_equality_strategy = node_equality_strategy
        if nemesis_signer_public_key is not None:
            self.nemesis_signer_public_key = nemesis_signer_public_key
        if generation_hash_seed is not None:
            self.generation_hash_seed = generation_hash_seed
        if epoch_adjustment is not None:
            self.epoch_adjustment = epoch_adjustment

    @property
    def identifier(self):
        """Gets the identifier of this NetworkPropertiesDTO.  # noqa: E501

        Network identifier.  # noqa: E501

        :return: The identifier of this NetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """Sets the identifier of this NetworkPropertiesDTO.

        Network identifier.  # noqa: E501

        :param identifier: The identifier of this NetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._identifier = identifier

    @property
    def node_equality_strategy(self):
        """Gets the node_equality_strategy of this NetworkPropertiesDTO.  # noqa: E501


        :return: The node_equality_strategy of this NetworkPropertiesDTO.  # noqa: E501
        :rtype: NodeIdentityEqualityStrategy
        """
        return self._node_equality_strategy

    @node_equality_strategy.setter
    def node_equality_strategy(self, node_equality_strategy):
        """Sets the node_equality_strategy of this NetworkPropertiesDTO.


        :param node_equality_strategy: The node_equality_strategy of this NetworkPropertiesDTO.  # noqa: E501
        :type: NodeIdentityEqualityStrategy
        """

        self._node_equality_strategy = node_equality_strategy

    @property
    def nemesis_signer_public_key(self):
        """Gets the nemesis_signer_public_key of this NetworkPropertiesDTO.  # noqa: E501

        Public key.  # noqa: E501

        :return: The nemesis_signer_public_key of this NetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._nemesis_signer_public_key

    @nemesis_signer_public_key.setter
    def nemesis_signer_public_key(self, nemesis_signer_public_key):
        """Sets the nemesis_signer_public_key of this NetworkPropertiesDTO.

        Public key.  # noqa: E501

        :param nemesis_signer_public_key: The nemesis_signer_public_key of this NetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._nemesis_signer_public_key = nemesis_signer_public_key

    @property
    def generation_hash_seed(self):
        """Gets the generation_hash_seed of this NetworkPropertiesDTO.  # noqa: E501


        :return: The generation_hash_seed of this NetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._generation_hash_seed

    @generation_hash_seed.setter
    def generation_hash_seed(self, generation_hash_seed):
        """Sets the generation_hash_seed of this NetworkPropertiesDTO.


        :param generation_hash_seed: The generation_hash_seed of this NetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._generation_hash_seed = generation_hash_seed

    @property
    def epoch_adjustment(self):
        """Gets the epoch_adjustment of this NetworkPropertiesDTO.  # noqa: E501

        Nemesis epoch time adjustment.  # noqa: E501

        :return: The epoch_adjustment of this NetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._epoch_adjustment

    @epoch_adjustment.setter
    def epoch_adjustment(self, epoch_adjustment):
        """Sets the epoch_adjustment of this NetworkPropertiesDTO.

        Nemesis epoch time adjustment.  # noqa: E501

        :param epoch_adjustment: The epoch_adjustment of this NetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._epoch_adjustment = epoch_adjustment

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetworkPropertiesDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NetworkPropertiesDTO):
            return True

        return self.to_dict() != other.to_dict()
