/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2tdnego;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.asn1.der.ListArray;
import com.teradata.tdgss.jgssp2gss.GssContext;
import com.teradata.tdgss.jgssp2tdnego.NegMech;
import com.teradata.tdgss.jgssp2tdnego.NegMechHashTable;
import com.teradata.tdgss.jgssp2tdnego.NegTokenInit;
import com.teradata.tdgss.jgssp2tdnego.NegTokenResp;
import com.teradata.tdgss.jgssp2tdnego.TdnegoCredential;
import com.teradata.tdgss.jgssp2tdnego.TdnegoMechanism;
import com.teradata.tdgss.jgssp2tdnego.TdnegoMinorStatus;
import com.teradata.tdgss.jgssp2tdnego.TdnegoName;
import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssName;
import com.teradata.tdgss.jtdgss.TdgssVersion;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class TdnegoContext
implements GSSContext {
    private final TdgssLogger logger;
    TdgssConfigApi capi = TdgssConfigApi.getInstance();
    private int tokenNumber = 0;
    private int negState = 2;
    private int negStateFromPeer = 2;
    private boolean isPolicyAppiled = false;
    private NegMechHashTable initMechHT = null;
    private NegMechHashTable respMechHT = null;
    private String authID = null;
    private String profileID = null;
    private String userID = null;
    private boolean isSSO = false;
    private GSSContext selectedCtx;
    int lifetimeContext = 0;
    private boolean initiator;
    private TdnegoCredential credential;
    private int lifetime;
    private short requestedServices;
    private TdnegoName targetName;
    private Object[] chanBind = null;
    private final Oid KRB5_OID = new Oid("1.2.840.113554.1.2.2");
    private Vector mechObjs = null;
    private NegTokenInit initToken = null;
    private long startTime;
    private static final byte[] TDNEGO_TRAILER = new byte[]{6, 13, 43, 6, 1, 4, 1, -127, -32, 26, 4, -126, 46, 1, 3, 0, 0, 0, 0, 21, 1};
    private StringBuffer logBuffer = new StringBuffer();
    private int recordNumber = 0;
    private int initCall = 1;
    private String Version;
    private TdnegoLogRecord logRecord = null;
    private static final TdnegoRequestDelegate delegateAnonimity = new TdnegoRequestDelegate(){

        public void set(GSSContext gSSContext, boolean bl) throws GSSException {
            gSSContext.requestAnonymity(bl);
        }
    };
    private static final TdnegoRequestDelegate delegateConf = new TdnegoRequestDelegate(){

        public void set(GSSContext gSSContext, boolean bl) throws GSSException {
            gSSContext.requestConf(bl);
        }
    };
    private static final TdnegoRequestDelegate delegateCred = new TdnegoRequestDelegate(){

        public void set(GSSContext gSSContext, boolean bl) throws GSSException {
            gSSContext.requestCredDeleg(bl);
        }
    };
    private static final TdnegoRequestDelegate delegateInteg = new TdnegoRequestDelegate(){

        public void set(GSSContext gSSContext, boolean bl) throws GSSException {
            gSSContext.requestInteg(bl);
        }
    };
    private static final TdnegoRequestDelegate delegateRepDet = new TdnegoRequestDelegate(){

        public void set(GSSContext gSSContext, boolean bl) throws GSSException {
            gSSContext.requestReplayDet(bl);
        }
    };
    private static final TdnegoRequestDelegate delegateSeqDet = new TdnegoRequestDelegate(){

        public void set(GSSContext gSSContext, boolean bl) throws GSSException {
            gSSContext.requestSequenceDet(bl);
        }
    };
    private static final TdnegoRequestDelegate delegateMutuAuth = new TdnegoRequestDelegate(){

        public void set(GSSContext gSSContext, boolean bl) throws GSSException {
            gSSContext.requestMutualAuth(bl);
        }
    };

    public TdnegoContext(TdnegoCredential tdnegoCredential, Object[] objectArray, Vector vector, TdgssLogger tdgssLogger) throws GSSException {
        if (vector == null) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_MECHS_AVAILABLE);
        }
        this.logger = tdgssLogger;
        this.initiator = false;
        this.credential = tdnegoCredential;
        this.requestedServices = TdnegoMechanism.servicesAvailable;
    }

    public TdnegoContext(TdnegoCredential tdnegoCredential, TdnegoName tdnegoName, int n, Object[] objectArray, short s, Vector vector, TdgssLogger tdgssLogger) throws GSSException {
        if (vector == null) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NEGMECHLIST_EMPTY);
        }
        this.mechObjs = vector;
        this.logger = tdgssLogger;
        this.initiator = true;
        this.credential = tdnegoCredential;
        this.targetName = tdnegoName;
        this.lifetime = n;
        this.requestedServices = s;
        this.chanBind = objectArray;
        this.startTime = System.currentTimeMillis();
        this.initialiseData();
    }

    public String getNameForOid(Oid oid) {
        String[] stringArray = this.capi.GetInforForMech(oid);
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    public boolean isEstablished() {
        return this.negState == 1;
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public void dispose() throws GSSException {
        if (this.credential != null) {
            this.credential.dispose();
        }
    }

    public byte[] export() throws GSSException {
        throw new TdgssException(16, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public boolean getAnonymityState() {
        if (this.isEstablished()) {
            return this.selectedCtx.getAnonymityState();
        }
        return false;
    }

    public boolean getConfState() {
        if (this.isEstablished()) {
            return this.selectedCtx.getConfState();
        }
        return false;
    }

    public boolean getCredDelegState() {
        if (this.isEstablished()) {
            return this.selectedCtx.getCredDelegState();
        }
        return false;
    }

    public GSSCredential getDelegCred() throws GSSException {
        throw new TdgssException(16, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public boolean getIntegState() {
        if (this.isEstablished()) {
            return this.selectedCtx.getIntegState();
        }
        return false;
    }

    public int getLifetime() {
        if (this.isEstablished()) {
            return this.selectedCtx.getLifetime();
        }
        return 0;
    }

    public GSSCredential getCredential() {
        return this.credential;
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.isEstablished()) {
            return this.selectedCtx.getMIC(byArray, n, n2, messageProp);
        }
        throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_CONTEXT);
    }

    public Oid getMech() throws GSSException {
        if (this.isEstablished()) {
            return this.selectedCtx.getMech();
        }
        return TdnegoMechanism.MECH_OID;
    }

    public boolean getMutualAuthState() {
        if (this.isEstablished()) {
            return this.selectedCtx.getMutualAuthState();
        }
        return false;
    }

    public boolean getReplayDetState() {
        if (this.isEstablished()) {
            return this.selectedCtx.getReplayDetState();
        }
        return false;
    }

    public boolean getSequenceDetState() {
        if (this.isEstablished()) {
            return this.selectedCtx.getSequenceDetState();
        }
        return false;
    }

    public GSSName getSrcName() throws GSSException {
        if (this.credential != null) {
            return this.credential.getName();
        }
        return null;
    }

    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (!this.isProtReady()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_CONTEXT_NOT_READY);
        }
        return this.selectedCtx.getWrapSizeLimit(n, bl, n2);
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new TdgssException(16, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Token number is now " + this.tokenNumber);
        }
        if (this.tokenNumber == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Establishing TDNEGO context");
            }
            try {
                byArray2 = this.buildInitToken(byArray, n, n2);
            }
            catch (GSSException gSSException) {
                throw new TdgssException(12, TdnegoMinorStatus.TDNEGO_ERR_NO_MECHS_AVAILABLE, gSSException);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Just receive info-data from server");
        }
        try {
            byArray2 = this.buildRespToken(byArray, n, n2);
        }
        catch (GSSException gSSException) {
            throw new TdgssException(12, TdnegoMinorStatus.TDNEGO_ERR_NO_MECHS_AVAILABLE, gSSException);
        }
        ++this.tokenNumber;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving after incrementing msgsequence to " + this.tokenNumber);
        }
        ++this.initCall;
        return byArray2;
    }

    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }

    public boolean isServer() throws GSSException {
        return false;
    }

    public boolean isProtReady() {
        return this.selectedCtx != null;
    }

    public boolean isTransferable() throws GSSException {
        if (!this.isEstablished()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_CONTEXT);
        }
        return false;
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        this.request(delegateAnonimity, bl);
    }

    public void requestConf(boolean bl) throws GSSException {
        this.request(delegateConf, bl);
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        this.request(delegateCred, bl);
    }

    public void requestInteg(boolean bl) throws GSSException {
        this.request(delegateInteg, bl);
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        this.request(delegateRepDet, bl);
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        this.request(delegateSeqDet, bl);
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        this.request(delegateMutuAuth, bl);
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
        int n2 = 0;
        Enumeration enumeration = this.initMechHT.keys();
        while (enumeration.hasMoreElements()) {
            Oid oid = (Oid)enumeration.nextElement();
            NegMech negMech = this.initMechHT.get(oid);
            GSSContext gSSContext = negMech.getContext();
            try {
                if (gSSContext == null) continue;
                gSSContext.requestLifetime(n);
            }
            catch (GSSException gSSException) {
                ++n2;
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug(gSSException.getMessage());
            }
        }
        if (n2 == this.initMechHT.getMechCount()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        throw new TdgssException(16, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (!this.isProtReady()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_CONTEXT);
        }
        return this.selectedCtx.unwrap(byArray, n, n2, messageProp);
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        if (!this.isProtReady()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_CONTEXT);
        }
        this.selectedCtx.verifyMIC(byArray, n, n2, byArray2, n3, n4, messageProp);
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (!this.isProtReady()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_CONTEXT);
        }
        return this.selectedCtx.wrap(byArray, n, n2, messageProp);
    }

    private void initialiseData() throws GSSException {
        InetAddress inetAddress;
        block4: {
            this.logBuffer.append("\nTDNEGO Negotiation Log\n\n\n");
            this.logBuffer.append("Package:  TERAGSSJAVA\n");
            TdgssVersion tdgssVersion = new TdgssVersion();
            this.logBuffer.append("version: " + tdgssVersion.Complete + "\n");
            inetAddress = null;
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug("getLocalHost function failed");
            }
        }
        String string = "unknown";
        if (inetAddress != null) {
            string = inetAddress.getHostName();
        }
        this.logBuffer.append("Run on: " + string + "\n");
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss a");
        this.logBuffer.append("Run at: " + simpleDateFormat.format(date) + "\n\n");
        this.processNames();
        this.initMechData();
        if (this.isSSO) {
            this.rejectNonSSOmechs();
        }
    }

    private void rejectNonSSOmechs() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Informations about mechanism local:");
        }
        Enumeration enumeration = this.initMechHT.keys();
        while (enumeration.hasMoreElements()) {
            Oid oid = (Oid)enumeration.nextElement();
            NegMech negMech = this.initMechHT.get(oid);
            if (negMech.getMechType().equals(this.KRB5_OID)) continue;
            negMech.setNegMechState(3);
            negMech.setNegMechReason(7);
            negMech.setContext(null);
            this.logRecord = new TdnegoLogRecord(negMech, "InitSecContext()", this.initCall, this.recordNumber++, "rejectNonSSOmechs() NonSSO Mechanism is rejected based on credential");
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.logRecord.toString());
            }
            this.logBuffer.append(this.logRecord.toString());
        }
    }

    private void initMechData() throws GSSException {
        Oid oid = null;
        Enumeration enumeration = this.mechObjs.elements();
        this.initMechHT = new NegMechHashTable();
        GSSCredential gSSCredential = null;
        GSSContext gSSContext = null;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Informations about mechanism local:");
        }
        while (enumeration.hasMoreElements()) {
            GSSMechanism gSSMechanism = (GSSMechanism)enumeration.nextElement();
            oid = gSSMechanism.getMech();
            NegMech negMech = new NegMech();
            negMech.setMechType(oid);
            negMech.setNegMechState(1);
            negMech.setNegMechReason(1);
            if (this.authID == null && oid.equals(this.KRB5_OID)) {
                this.isSSO = true;
            }
            try {
                Object object = this.credential.getCredForMech(oid);
                if (object instanceof GSSCredential) {
                    gSSCredential = (GSSCredential)this.credential.getCredForMech(oid);
                } else if (object instanceof GSSException) {
                    throw (GSSException)object;
                }
                gSSContext = gSSMechanism.getContextForInit(gSSCredential, (GSSName)this.targetName.getNameForMech(oid), this.lifetime, this.chanBind, this.requestedServices);
                negMech.setContext(gSSContext);
            }
            catch (GSSException gSSException) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("GetContext failed for mechanism: " + this.getNameForOid(oid));
                }
                negMech.setNegMechState(3);
                negMech.setNegMechReason(2);
                negMech.setMajorStatus(gSSException.getMajor());
                negMech.setMinStatus(gSSException.getMinor());
                negMech.setMinorText(gSSException.getMinorString());
                this.logRecord = new TdnegoLogRecord(negMech, "InitSecContext()", this.initCall, this.recordNumber++, "InitMechData(): Mechanism is rejected at client");
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(this.logRecord.toString());
                }
                this.logBuffer.append(this.logRecord.toString());
                if (!this.isSSO || !oid.equals(this.KRB5_OID)) continue;
                throw new TdgssException(9, TdnegoMinorStatus.TDNEGO_ERR_BAD_CRED_USAGE);
            }
            negMech.setContext(gSSContext);
            negMech.setContextEstablished(false);
            this.logRecord = new TdnegoLogRecord(negMech, "InitSecContext()", this.initCall, this.recordNumber++, "InitMechData(): Mechanism is available for negotiation");
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.logRecord.toString());
            }
            this.logBuffer.append(this.logRecord.toString());
            this.initMechHT.put(oid, negMech);
        }
    }

    private void processNames() {
        GSSName gSSName = null;
        Oid oid = null;
        ListArray listArray = this.credential.returnNames();
        for (int i = 0; i < listArray.size(); ++i) {
            String[] stringArray;
            int n;
            String string;
            String string2;
            block13: {
                gSSName = (GSSName)listArray.get(i);
                string2 = ((Object)gSSName).toString();
                try {
                    oid = gSSName.getStringNameType();
                }
                catch (GSSException gSSException) {
                    if (!this.logger.isDebugEnabled()) break block13;
                    this.logger.debug(gSSException.getMessage());
                }
            }
            if (oid.equals(TdgssName.GSS_C_NT_TDAT_USER)) {
                this.authID = string2;
                continue;
            }
            if (oid.equals(TdgssName.GSS_C_NT_TDAT_PASSWORD) || (string = string2) == null) continue;
            StringBuffer stringBuffer = new StringBuffer(string);
            String[] stringArray2 = new String[]{"user=", "profile=", "authcid="};
            char c = '\u0000';
            boolean bl = false;
            boolean bl2 = false;
            for (n = 0; n < stringArray2.length; ++n) {
                int n2;
                stringArray = stringArray2[n];
                bl = false;
                bl2 = false;
                int n3 = string.indexOf((String)stringArray);
                if (n3 == -1) continue;
                if (string.charAt(n3 + stringArray.length()) == '\'' || string.charAt(n3 + stringArray.length()) == '\"') {
                    c = string.charAt(n3 + stringArray.length());
                    bl = true;
                }
                for (n2 = n3 + stringArray.length() + 1; n2 < string.length(); ++n2) {
                    if (!bl || c != string.charAt(n2)) continue;
                    bl2 = true;
                    break;
                }
                int n4 = bl2 ? n2 + 1 : (string.indexOf(32, n3) == -1 ? string.length() : string.indexOf(32, n3));
                String string3 = string.substring(n3, n4);
                int n5 = 0;
                if (string3 != null) {
                    n5 = string3.indexOf("user=");
                    if (n5 != -1) {
                        this.userID = string3.substring(n5 + 5);
                    }
                    if ((n5 = string3.indexOf("profile=")) != -1) {
                        this.profileID = string3.substring(n5 + 8);
                    }
                    if ((n5 = string3.indexOf("authcid=")) != -1) {
                        this.authID = string3.substring(n5 + 8);
                    }
                }
                stringBuffer.delete(stringBuffer.indexOf(string3), stringBuffer.indexOf(string3) + string3.length());
            }
            if (stringBuffer.length() > 0) {
                string = new String(stringBuffer).trim();
            }
            if ((n = string.indexOf("@@")) != -1) {
                stringArray = string.split("@@");
                this.authID = stringArray[0];
                continue;
            }
            this.authID = string;
        }
    }

    private byte[] buildRespToken(byte[] byArray, int n, int n2) throws GSSException {
        Object object;
        Object object2;
        byte[] byArray2 = null;
        NegTokenResp negTokenResp = new NegTokenResp();
        DER dER = null;
        if (byArray == null) {
            throw new TdgssException(10, TdnegoMinorStatus.TDNEGO_ERR_INVALID_TOKEN);
        }
        dER = new DER(byArray, true);
        if (dER != null) {
            negTokenResp.parseDERObject(dER);
        }
        this.respMechHT = negTokenResp.getNegMechHashTable();
        if (this.respMechHT == null) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NEGMECHLIST_EMPTY);
        }
        this.negStateFromPeer = negTokenResp.getNegState();
        this.isPolicyAppiled = negTokenResp.getNegPolicyApplied();
        boolean bl = negTokenResp.isNegMechSelected();
        Oid oid = null;
        if (bl) {
            oid = negTokenResp.getNegMechSelected();
        }
        NegMechHashTable negMechHashTable = this.initToken.getNegMechHashTable();
        Enumeration enumeration = this.respMechHT.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (Oid)enumeration.nextElement();
            object = this.respMechHT.get((Oid)object2);
            this.logRecord = new TdnegoLogRecord((NegMech)object, "InitSecContext()", this.initCall, this.recordNumber++, "BuildRespToken(): Mechanism Data sent by server");
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.logRecord.toString());
            }
            this.logBuffer.append(this.logRecord.toString());
        }
        if (this.negStateFromPeer == 1 && oid != null) {
            object2 = negMechHashTable.get(oid);
            if (object2 != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Negotiation context established");
                }
                this.selectedCtx = ((NegMech)object2).getContext();
                if (!this.selectedCtx.isEstablished() && (object = (Object)this.respMechHT.get(oid).getMechToken()) != null && ((Object)object).length != 0) {
                    byArray2 = this.selectedCtx.initSecContext((byte[])object, 0, ((Object)object).length);
                }
            }
            ((NegMech)object2).setContextEstablished(true);
            this.negState = 1;
            ++this.recordNumber;
            this.logRecord = new TdnegoLogRecord((NegMech)object2, "InitSecContext()", this.initCall, this.recordNumber, "BuildRespToken() Negotiation State set to Completed due to Server selection");
            this.logBuffer.append(this.logRecord.toString());
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.logBuffer.toString());
            }
            return byArray2;
        }
        if (this.negStateFromPeer == 3) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Negotiation context establishment failed");
                this.logger.info(this.logBuffer.toString());
            }
            throw new TdgssException(12, TdnegoMinorStatus.TDNEGO_ERR_NO_MECH_SELECTED);
        }
        if (this.negStateFromPeer == 2) {
            enumeration = this.respMechHT.keys();
            while (enumeration.hasMoreElements()) {
                object2 = this.respMechHT.get((Oid)enumeration.nextElement());
                this.formrespMechHT((NegMech)object2);
            }
        }
        object2 = new NegTokenResp();
        ((NegTokenResp)object2).setNegState(2);
        if (negMechHashTable != null) {
            ((NegTokenResp)object2).setNegMechHashTable(negMechHashTable);
            byArray2 = ((NegTokenResp)object2).getDERObject().getEncodedValue(true);
        }
        return byArray2;
    }

    private void formrespMechHT(NegMech negMech) {
        NegMech negMech2 = this.initToken.getNegMechHashTable().get(negMech.getMechType());
        if (null != negMech2) {
            if (1 == negMech.getNegMechState()) {
                byte[] byArray;
                byte[] byArray2 = new byte[]{};
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("InitSecContext:" + this.tokenNumber + 1);
                }
                if ((byArray = negMech.getMechToken()) != null) {
                    GSSContext gSSContext = negMech2.getContext();
                    try {
                        byArray2 = gSSContext.initSecContext(byArray, 0, byArray.length);
                        negMech2.setMechToken(byArray2);
                    }
                    catch (GSSException gSSException) {
                        negMech2.setNegMechReason(2);
                        negMech2.setMajorStatus(gSSException.getMajor());
                        negMech2.setMinStatus(gSSException.getMinor());
                        negMech2.setMinorText(gSSException.getMinorString());
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("InitSecContext:1 falied for" + this.getNameForOid(negMech2.getMechType()));
                        }
                    }
                }
            } else {
                negMech2.setNegMechState(3);
                negMech2.setNegMechReason(4);
            }
        }
    }

    private byte[] buildInitToken(byte[] byArray, int n, int n2) throws GSSException {
        Object object;
        NegMech negMech = null;
        byte[] byArray2 = null;
        if (this.initMechHT == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("No mechanism is avilable for negotiation");
            }
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_MECHS_AVAILABLE);
        }
        Enumeration enumeration = this.initMechHT.keys();
        while (enumeration.hasMoreElements()) {
            Object object2;
            Object object3;
            byte[] byArray3 = null;
            negMech = this.initMechHT.get((Oid)enumeration.nextElement());
            if (negMech.getNegMechState() != 1) continue;
            object = negMech.getMechType();
            GSSContext gSSContext = negMech.getContext();
            if (gSSContext != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("InitContext:1 called  for" + this.getNameForOid((Oid)object) + "\n");
                }
                try {
                    byArray3 = gSSContext.initSecContext(byArray, n, n2);
                }
                catch (GSSException gSSException) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("InitSecContext:1 falied for" + this.getNameForOid((Oid)object));
                    }
                    negMech.setNegMechState(3);
                    negMech.setNegMechReason(2);
                    negMech.setMajorStatus(gSSException.getMajor());
                    negMech.setMinStatus(gSSException.getMinor());
                    negMech.setMinorText(gSSException.getMinorString());
                    this.logRecord = new TdnegoLogRecord(negMech, "InitSecContext()", this.initCall, this.recordNumber++, "BuildInitToken() Mechanism is rejected because it failed to generate a token");
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(this.logRecord.toString());
                    }
                    this.logBuffer.append(this.logRecord.toString());
                    continue;
                }
                if (this.isSSO) {
                    object3 = (GssContext)gSSContext;
                    object2 = ((GssContext)object3).getCredential();
                    if (object2 == null) {
                        throw new TdgssException(13, TdnegoMinorStatus.TDNEGO_ERR_MISSING_AUTHENTICATION_ID);
                    }
                    this.authID = ((Object)object2.getName()).toString();
                    negMech.setSsoAuthID(this.authID);
                }
            }
            object3 = new byte[4];
            System.arraycopy(byArray3, byArray3.length - 5, object3, 0, ((byte[])object3).length);
            object2 = new BigInteger((byte[])object3);
            int n3 = ((BigInteger)object2).intValue();
            byte[] byArray4 = new byte[byArray3.length - n3];
            System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
            negMech.setMechToken(byArray4);
            this.logRecord = new TdnegoLogRecord(negMech, "InitSecContext()", this.initCall, this.recordNumber++, "BuildInitToken() Continue needed for mechanism to establish context");
            this.logBuffer.append(this.logRecord.toString());
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info(this.logRecord.toString());
        }
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            object = this.initMechHT.get((Oid)enumeration.nextElement());
            if (((NegMech)object).getNegMechState() != 3) continue;
            ++n4;
        }
        if (this.initMechHT.getMechCount() == n4) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("No mechanism is avilable for negotiation\n");
            }
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_MECHS_AVAILABLE);
        }
        this.initToken = new NegTokenInit();
        this.initToken.setNegState(this.negState);
        this.initToken.setNegMechHashTable(this.initMechHT);
        if (this.profileID != null) {
            this.initToken.setProfileName(this.profileID);
        }
        if (this.userID != null) {
            this.initToken.setUserName(this.userID);
        }
        this.initToken.setAuthenticationID(this.authID);
        if (this.isSSO) {
            this.initToken.setSSO(this.isSSO);
        }
        byArray2 = this.initToken.getDERObject().getEncodedValue();
        object = new byte[byArray2.length + TDNEGO_TRAILER.length];
        System.arraycopy(byArray2, 0, object, 0, byArray2.length);
        System.arraycopy(TDNEGO_TRAILER, 0, object, byArray2.length, TDNEGO_TRAILER.length);
        return object;
    }

    public boolean getPolicyAppiled() {
        return this.isPolicyAppiled;
    }

    public int getNegState() {
        return this.negState;
    }

    public int getNegStatePeer() {
        return this.negStateFromPeer;
    }

    private void request(TdnegoRequestDelegate tdnegoRequestDelegate, boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
        int n = 0;
        Enumeration enumeration = this.initMechHT.keys();
        while (enumeration.hasMoreElements()) {
            Oid oid = (Oid)enumeration.nextElement();
            NegMech negMech = this.initMechHT.get(oid);
            GSSContext gSSContext = negMech.getContext();
            try {
                if (gSSContext == null) continue;
                tdnegoRequestDelegate.set(gSSContext, bl);
            }
            catch (GSSException gSSException) {
                ++n;
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info(gSSException.getMessage());
            }
        }
        if (n == this.initMechHT.getMechCount()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
    }

    static interface TdnegoRequestDelegate {
        public void set(GSSContext var1, boolean var2) throws GSSException;
    }

    class TdnegoLogRecord {
        StringBuffer logRecordBuffer = new StringBuffer();
        int record = 1;

        public TdnegoLogRecord(NegMech negMech, String string, int n, int n2, String string2) {
            this.logRecordBuffer.append("Record:" + n2 + " " + string + " " + n + "\n");
            this.logRecordBuffer.append("    Text:                 " + string2 + "\n");
            this.logRecordBuffer.append(this.getNegLog(negMech));
        }

        public String getNegLog(NegMech negMech) {
            String[] stringArray = new String[]{"Invalid", "Available", "Selected", "Rejected"};
            String[] stringArray2 = new String[]{"Invalid", "Available", "GSSAPI Error", "Not Available at Client", "Not Available at Server", "Due to Policy", "Due to Rank", "Single Sign-On Required", "Authentication ID not Available", "Authorization Required"};
            String[] stringArray3 = new String[]{"Invalid", "Completed", "Incomplete", "Reject", "Request MIC"};
            StringBuffer stringBuffer = new StringBuffer();
            if (null != negMech) {
                stringBuffer.append("    Mechanism:            " + TdnegoContext.this.getNameForOid(negMech.getMechType()) + "\n");
                stringBuffer.append("    MechState:            " + stringArray[negMech.getNegMechState()] + "\n");
                if (negMech.isMechReasonSet()) {
                    stringBuffer.append("    MechReason:           " + stringArray2[negMech.getNegMechReason()] + "\n");
                }
                if (negMech.getNegMechReason() == 2) {
                    if (negMech.isMajorStatusSet()) {
                        stringBuffer.append("    MajorStatus:          " + Integer.toHexString(0 | negMech.getMajorStatus()) + "\n");
                    }
                    if (negMech.isMinorStatusSet()) {
                        stringBuffer.append("    MinorStatus:          " + Integer.toHexString(negMech.getMinStatus()) + "\n");
                    }
                    if (negMech.isMinorTextSet()) {
                        stringBuffer.append("    MinorStatusText       " + negMech.getMinorText() + "\n");
                    }
                }
                if (negMech.isContextEstablished()) {
                    stringBuffer.append("    IsContextEstablished: TRUE\n");
                } else {
                    stringBuffer.append("    IsContextEstablished: FALSE\n");
                }
            }
            if (TdnegoContext.this.getPolicyAppiled()) {
                stringBuffer.append("    IsPolicyApplied:      TRUE\n");
            } else {
                stringBuffer.append("    IsPolicyApplied:      FALSE\n");
            }
            stringBuffer.append("    NegState:             " + stringArray3[TdnegoContext.this.getNegState()] + "\n");
            stringBuffer.append("    NegStatefrompeer:     " + stringArray3[TdnegoContext.this.getNegStatePeer()] + "\n");
            stringBuffer.append("    Elapsed Time:         " + (System.currentTimeMillis() - TdnegoContext.this.startTime) + "ms\n");
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }

        public String toString() {
            return this.logRecordBuffer.toString();
        }
    }
}

