# SPDX-FileCopyrightText: 2022 Martin Stephens
#
# SPDX-License-Identifier: MIT

# pylint: disable=no-self-use, redefined-outer-name, protected-access, invalid-name, too-many-arguments
import pytest
from adafruit_wiznet5k.adafruit_wiznet5k_dns import _parse_dns_response

SHOW_DEBUG_MESSAGES = False


# @pytest.mark.skip(reason="Not currently under development")
@pytest.mark.parametrize(
    "request_id, request_length, dns_bytes_recv, ipv4",
    (
        (
            0x3476,  # Has CNAME answers
            31,
            bytearray(
                b"\x34\x76\x81\x80\x00\x01\x00\x04\x00\x00\x00\x00\x03\x77\x77\x77\x05\x61"
                b"\x70\x70\x6c\x65\x03\x63\x6f\x6d\x00\x00\x01\x00\x01\xc0\x0c\x00\x05\x00"
                b"\x01\x00\x00\x02\xf3\x00\x1b\x03\x77\x77\x77\x05\x61\x70\x70\x6c\x65\x03"
                b"\x63\x6f\x6d\x07\x65\x64\x67\x65\x6b\x65\x79\x03\x6e\x65\x74\x00\xc0\x2b"
                b"\x00\x05\x00\x01\x00\x00\x0a\xf2\x00\x2f\x03\x77\x77\x77\x05\x61\x70\x70"
                b"\x6c\x65\x03\x63\x6f\x6d\x07\x65\x64\x67\x65\x6b\x65\x79\x03\x6e\x65\x74"
                b"\x0b\x67\x6c\x6f\x62\x61\x6c\x72\x65\x64\x69\x72\x06\x61\x6b\x61\x64\x6e"
                b"\x73\xc0\x41\xc0\x52\x00\x05\x00\x01\x00\x00\x01\x7d\x00\x18\x05\x65\x36"
                b"\x38\x35\x38\x04\x64\x73\x63\x78\x0a\x61\x6b\x61\x6d\x61\x69\x65\x64\x67"
                b"\x65\xc0\x41\xc0\x8d\x00\x01\x00\x01\x00\x00\x00\x14\x00\x04\x17\x38\x9c"
                b"\x56"
            ),
            b"\x178\x9cV",
        ),
        (
            0x9912,
            36,
            bytearray(
                b"\x99\x12\x81\x80\x00\x01\x00\x02\x00\x00\x00\x00\x05\x6c\x65\x61\x72\x6e"
                b"\x08\x61\x64\x61\x66\x72\x75\x69\x74\x03\x63\x6f\x6d\x00\x00\x01\x00\x01"
                b"\xc0\x0c\x00\x01\x00\x01\x00\x00\x01\x2c\x00\x04\x68\x14\x27\xf0\xc0\x0c"
                b"\x00\x01\x00\x01\x00\x00\x01\x2c\x00\x04\x68\x14\x26\xf0"
            ),
            b"\x68\x14\x27\xf0",
        ),
    ),
)
def test_parse_response(request_id, request_length, dns_bytes_recv, ipv4):
    ip_address = _parse_dns_response(
        response=dns_bytes_recv,
        query_id=request_id,
        query_length=request_length,
        debug=SHOW_DEBUG_MESSAGES,
    )
    assert ip_address == ipv4
    assert isinstance(ip_address, bytearray)
