/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.impl.pool;

import com.datapps.linkoopdb.jdbc.impl.JDBCConnection;
import com.datapps.linkoopdb.jdbc.impl.pool.JDBCPooledConnection;
import com.datapps.linkoopdb.jdbc.impl.pool.JDBCXAConnectionWrapper;
import com.datapps.linkoopdb.jdbc.impl.pool.JDBCXADataSource;
import com.datapps.linkoopdb.jdbc.impl.pool.JDBCXAResource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class JDBCXAConnection
extends JDBCPooledConnection
implements XAConnection {
    JDBCXAResource xaResource;

    public JDBCXAConnection(JDBCXADataSource dataSource, JDBCConnection connection) {
        super(connection);
        this.xaResource = new JDBCXAResource(dataSource, connection);
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this.xaResource;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this.isInUse) {
            throw new SQLException("Connection in use");
        }
        this.isInUse = true;
        if (this.connection == null) {
            throw new SQLException("Connection in closed");
        }
        return new JDBCXAConnectionWrapper(this.xaResource, this, this.connection);
    }

    @Override
    public void close() throws SQLException {
        super.close();
    }
}

