/**
 * math.js
 * https://github.com/josdejong/mathjs
 *
 * Math.js is an extensive math library for JavaScript and Node.js,
 * It features real and complex numbers, units, matrices, a large set of
 * mathematical functions, and a flexible expression parser.
 *
 * @version 0.22.0
 * @date    2014-05-22
 *
 * @license
 * Copyright (C) 2013-2014 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
!function(e,r){"object"==typeof exports&&"object"==typeof module?module.exports=r(require("crypto")):"function"==typeof define&&define.amd?define(["crypto"],r):"object"==typeof exports?exports.mathjs=r(require("crypto")):e.mathjs=r(e.crypto)}(this,function(e){return function(e){function r(t){if(n[t])return n[t].exports;var i=n[t]={exports:{},id:t,loaded:!1};return e[t].call(i.exports,i,i.exports,r),i.loaded=!0,i.exports}var n={};return r.m=e,r.c=n,r.p="",r(0)}([function(e,r,n){e.exports=n(1)},function(e,r,n){function t(e){if("function"!=typeof Object.create)throw new Error("ES5 not supported by this JavaScript engine. Please load the es5-shim and es5-sham library for compatibility.");var r={},t={matrix:"matrix",number:"number",precision:20,epsilon:1e-14};r.config=function(e){if(e){if(i.deepExtend(t,e),e.precision&&r.type.BigNumber.config({precision:e.precision}),e.number&&e.number.defaultType)throw new Error("setting `number.defaultType` is deprecated. Use `number` instead.");if(e.number&&e.number.precision)throw new Error("setting `number.precision` is deprecated. Use `precision` instead.");if(e.matrix&&e.matrix.defaultType)throw new Error("setting `matrix.defaultType` is deprecated. Use `matrix` instead.");if(e.matrix&&e.matrix["default"])throw new Error("setting `matrix.default` is deprecated. Use `matrix` instead.");if(e.decimals)throw new Error("setting `decimals` is deprecated. Use `precision` instead.")}return i.clone(t)};var o=n(118).constructor();if("function"!=typeof o.prototype.clone&&(o.prototype.clone=function(){return new o(this)}),"function"==typeof o.convert)throw new Error("Cannot add function convert to BigNumber: function already exists");return o.convert=function(e){return digits(e)>15?e:new o(e)},r.error=n(4),r.type={},r.type.Complex=n(5),r.type.Range=n(6),r.type.Index=n(7),r.type.Matrix=n(8),r.type.Unit=n(9),r.type.Help=n(10),r.type.BigNumber=o,r.collection=n(11),r.expression={},r.expression.node=n(14),r.expression.parse=n(12),r.expression.Parser=n(13),r.expression.docs=n(15),n(17)(r,t),n(18)(r,t),n(19)(r,t),n(20)(r,t),n(21)(r,t),n(22)(r,t),n(23)(r,t),n(24)(r,t),n(25)(r,t),n(26)(r,t),n(27)(r,t),n(28)(r,t),n(29)(r,t),n(30)(r,t),n(31)(r,t),n(32)(r,t),n(33)(r,t),n(34)(r,t),n(35)(r,t),n(36)(r,t),n(37)(r,t),n(38)(r,t),n(39)(r,t),n(40)(r,t),n(41)(r,t),n(42)(r,t),n(43)(r,t),n(44)(r,t),n(45)(r,t),n(46)(r,t),n(47)(r,t),n(48)(r,t),n(49)(r,t),n(50)(r,t),n(51)(r,t),n(52)(r,t),n(53)(r,t),n(54)(r,t),n(55)(r,t),n(56)(r,t),n(57)(r,t),n(58)(r,t),n(59)(r,t),n(60)(r,t),n(61)(r,t),n(62)(r,t),n(63)(r,t),n(64)(r,t),n(65)(r,t),n(66)(r,t),n(67)(r,t),n(68)(r,t),n(69)(r,t),n(70)(r,t),n(71)(r,t),n(72)(r,t),n(73)(r,t),n(74)(r,t),n(75)(r,t),n(76)(r,t),n(77)(r,t),n(78)(r,t),n(79)(r,t),n(80)(r,t),n(81)(r,t),n(82)(r,t),n(83)(r,t),n(84)(r,t),n(85)(r,t),n(86)(r,t),n(87)(r,t),n(88)(r,t),n(89)(r,t),n(90)(r,t),n(91)(r,t),n(92)(r,t),n(93)(r,t),n(94)(r,t),n(95)(r,t),n(96)(r,t),n(97)(r,t),n(98)(r,t),n(99)(r,t),n(100)(r,t),n(101)(r,t),n(102)(r,t),n(103)(r,t),n(104)(r,t),n(105)(r,t),n(106)(r,t),n(107)(r,t),n(108)(r,t),n(109)(r,t),n(110)(r,t),n(111)(r,t),n(112)(r,t),n(113)(r,t),n(114)(r,t),n(115)(r,t),n(116)(r,t),n(117)(r,t),n(2)(r,t),r.chaining={},r.chaining.Selector=n(16)(r,t),r.config(e),r}var i=n(3);e.exports=t},function(e,r,n){e.exports=function(e){var r=n(5);e.pi=Math.PI,e.e=Math.E,e.tau=2*Math.PI,e.i=new r(0,1),e.Infinity=1/0,e.NaN=0/0,e["true"]=!0,e["false"]=!1,e.E=Math.E,e.LN2=Math.LN2,e.LN10=Math.LN10,e.LOG2E=Math.LOG2E,e.LOG10E=Math.LOG10E,e.PI=Math.PI,e.SQRT1_2=Math.SQRT1_2,e.SQRT2=Math.SQRT2}},function(e,r){r.clone=function n(e){var r=typeof e;if("number"===r||"string"===r||"boolean"===r||null===e||void 0===e)return e;if("function"==typeof e.clone)return e.clone();if(Array.isArray(e))return e.map(function(e){return n(e)});if(e instanceof Number)return new Number(e.valueOf());if(e instanceof String)return new String(e.valueOf());if(e instanceof Boolean)return new Boolean(e.valueOf());if(e instanceof Date)return new Date(e.valueOf());if(e instanceof RegExp)throw new TypeError("Cannot clone "+e);var t={};for(var i in e)e.hasOwnProperty(i)&&(t[i]=n(e[i]));return t},r.extend=function(e,r){for(var n in r)r.hasOwnProperty(n)&&(e[n]=r[n]);return e},r.deepExtend=function t(e,r){if(Array.isArray(r))throw new TypeError("Arrays are not supported by deepExtend");for(var n in r)if(r.hasOwnProperty(n))if(r[n]&&r[n].constructor===Object)void 0===e[n]&&(e[n]={}),e[n].constructor===Object?t(e[n],r[n]):e[n]=r[n];else{if(Array.isArray(r[n]))throw new TypeError("Arrays are not supported by deepExtend");e[n]=r[n]}return e},r.deepEqual=function(e,n){var t,i,o;if(Array.isArray(e)){if(!Array.isArray(n))return!1;if(e.length!=n.length)return!1;for(i=0,o=e.length;o>i;i++)if(!r.deepEqual(e[i],n[i]))return!1;return!0}if(e instanceof Object){if(Array.isArray(n)||!(n instanceof Object))return!1;for(t in e)if(!r.deepEqual(e[t],n[t]))return!1;for(t in n)if(!r.deepEqual(e[t],n[t]))return!1;return!0}return typeof e==typeof n&&e==n}},function(e,r,n){r.ArgumentsError=n(119),r.DimensionError=n(120),r.IndexError=n(121),r.UnsupportedTypeError=n(122)},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");switch(arguments.length){case 0:this.re=0,this.im=0;break;case 1:var n=arguments[0];if("object"==typeof n){if("re"in n&&"im"in n){var i=new t(n.re,n.im);this.re=i.re,this.im=i.im;break}if("r"in n&&"phi"in n){var i=t.fromPolar(n.r,n.phi);this.re=i.re,this.im=i.im;break}}throw new SyntaxError("Object with the re and im or r and phi properties expected.");case 2:if(!h(e)||!h(r))throw new TypeError("Two numbers expected in Complex constructor");this.re=e,this.im=r;break;default:throw new SyntaxError("One, two or three arguments expected in Complex constructor")}}function i(){for(;" "==w||"	"==w;)s()}function o(e){return e>="0"&&"9">=e||"."==e}function a(e){return e>="0"&&"9">=e}function s(){y++,w=x.charAt(y)}function u(e){y=e,w=x.charAt(y)}function f(){var e,r="";if(e=y,"+"==w?s():"-"==w&&(r+=w,s()),!o(w))return u(e),null;if("."==w){if(r+=w,s(),!a(w))return u(e),null}else{for(;a(w);)r+=w,s();"."==w&&(r+=w,s())}for(;a(w);)r+=w,s();if("E"==w||"e"==w){if(r+=w,s(),("+"==w||"-"==w)&&(r+=w,s()),!a(w))return u(e),null;for(;a(w);)r+=w,s()}return r}function c(){var e=x.charAt(y+1);if("I"==w||"i"==w)return s(),"1";if(!("+"!=w&&"-"!=w||"I"!=e&&"i"!=e)){var r="+"==w?"1":"-1";return s(),s(),r}return null}var l=n(123),p=n(9),m=l.number,h=l.number.isNumber,g=p.isUnit,d=l.string.isString;t.isComplex=function(e){return e instanceof t};var x,y,w;t.parse=function(e){if(x=e,y=-1,w="",!d(x))return null;s(),i();var r=f();if(r){if("I"==w||"i"==w)return s(),i(),w?null:new t(0,Number(r));i();var n=w;if("+"!=n&&"-"!=n)return i(),w?null:new t(Number(r),0);s(),i();var o=f();if(o){if("I"!=w&&"i"!=w)return null;s()}else if(o=c(),!o)return null;return"-"==n&&(o="-"==o[0]?"+"+o.substring(1):"-"+o),s(),i(),w?null:new t(Number(r),Number(o))}return(r=c())?(i(),w?null:new t(0,Number(r))):null},t.fromPolar=function(){switch(arguments.length){case 1:var e=arguments[0];if("object"==typeof e)return t.fromPolar(e.r,e.phi);throw new TypeError("Input has to be an object with r and phi keys.");case 2:var r=arguments[0],n=arguments[1];if(h(r)){if(g(n)&&n.hasBase(p.BASE_UNITS.ANGLE)&&(n=n.toNumber("rad")),h(n))return new t(r*Math.cos(n),r*Math.sin(n));throw new TypeError("Phi is not a number nor an angle unit.")}throw new TypeError("Radius r is not a number.");default:throw new SyntaxError("Wrong number of arguments in function fromPolar")}},t.prototype.toPolar=function(){return{r:Math.sqrt(this.re*this.re+this.im*this.im),phi:Math.atan2(this.im,this.re)}},t.prototype.clone=function(){return new t(this.re,this.im)},t.prototype.equals=function(e){return this.re===e.re&&this.im===e.im},t.prototype.format=function(e){var r="",n=m.format(this.re,e),t=m.format(this.im,e);return r=0==this.im?n:0==this.re?1==this.im?"i":-1==this.im?"-i":t+"i":this.im>0?1==this.im?n+" + i":n+" + "+t+"i":-1==this.im?n+" - i":n+" - "+t.substring(1)+"i"},t.prototype.toString=function(){return this.format()},e.exports=t},function(e,r,n){function t(e,r,n){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(null!=e&&!o.isNumber(e))throw new TypeError("Parameter start must be a number");if(null!=r&&!o.isNumber(r))throw new TypeError("Parameter end must be a number");if(null!=n&&!o.isNumber(n))throw new TypeError("Parameter step must be a number");this.start=null!=e?parseFloat(e):0,this.end=null!=r?parseFloat(r):0,this.step=null!=n?parseFloat(n):1}{var i=n(123),o=i.number,a=i.string;i.array}t.parse=function(e){if(!a.isString(e))return null;var r=e.split(":"),n=r.map(function(e){return parseFloat(e)}),i=n.some(function(e){return isNaN(e)});if(i)return null;switch(n.length){case 2:return new t(n[0],n[1]);case 3:return new t(n[0],n[2],n[1]);default:return null}},t.prototype.clone=function(){return new t(this.start,this.end,this.step)},t.isRange=function(e){return e instanceof t},t.prototype.size=function(){var e=0,r=this.start,n=this.step,t=this.end,i=t-r;return o.sign(n)==o.sign(i)?e=Math.ceil(i/n):0==i&&(e=0),isNaN(e)&&(e=0),[e]},t.prototype.min=function(){var e=this.size()[0];return e>0?this.step>0?this.start:this.start+(e-1)*this.step:void 0},t.prototype.max=function(){var e=this.size()[0];return e>0?this.step>0?this.start+(e-1)*this.step:this.start:void 0},t.prototype.forEach=function(e){var r=this.start,n=this.step,t=this.end,i=0;if(n>0)for(;t>r;)e(r,i,this),r+=n,i++;else if(0>n)for(;r>t;)e(r,i,this),r+=n,i++},t.prototype.map=function(e){var r=[];return this.forEach(function(n,t,i){r[t]=e(n,t,i)}),r},t.prototype.toArray=function(){var e=[];return this.forEach(function(r,n){e[n]=r}),e},t.prototype.valueOf=function(){return this.toArray()},t.prototype.format=function(e){var r=o.format(this.start,e);return 1!=this.step&&(r+=":"+o.format(this.step,e)),r+=":"+o.format(this.end,e)},t.prototype.toString=function(){return this.format()},e.exports=t},function(e,r,n){function t(){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");this._ranges=[];for(var e=0,r=arguments.length;r>e;e++){var n=arguments[e];if(n instanceof a)this._ranges.push(n);else if(c(n))this._ranges.push(i(n));else{if(!u(n))throw new TypeError("Ranges must be an Array, Number, or Range");this._ranges.push(i([n,n+1]))}}}function i(e){for(var r=e.length,n=0;r>n;n++)if(!u(e[n])||!f(e[n]))throw new TypeError("Index parameters must be integer numbers");switch(e.length){case 2:return new a(e[0],e[1]);case 3:return new a(e[0],e[1],e[2]);default:throw new SyntaxError("Wrong number of arguments in Index (2 or 3 expected)")}}{var o=n(123),a=n(6),s=o.number,u=s.isNumber,f=s.isInteger,c=Array.isArray;o.array.validateIndex}t.prototype.clone=function(){var e=new t;return e._ranges=o.object.clone(this._ranges),e},t.isIndex=function(e){return e instanceof t},t.create=function(e){var r=new t;return t.apply(r,e),r},t.prototype.size=function l(){for(var l=[],e=0,r=this._ranges.length;r>e;e++){var n=this._ranges[e];l[e]=n.size()[0]}return l},t.prototype.max=function(){for(var e=[],r=0,n=this._ranges.length;n>r;r++){var t=this._ranges[r];e[r]=t.max()}return e},t.prototype.min=function(){for(var e=[],r=0,n=this._ranges.length;n>r;r++){var t=this._ranges[r];e[r]=t.min()}return e},t.prototype.forEach=function(e){for(var r=0,n=this._ranges.length;n>r;r++)e(this._ranges[r],r,this)},t.prototype.range=function(e){return this._ranges[e]||null},t.prototype.isScalar=function(){for(var e=this.size(),r=0,n=e.length;n>r;r++)if(1!==e[r])return!1;return!0},t.prototype.toArray=function(){for(var e=[],r=0,n=this._ranges.length;n>r;r++){var t=this._ranges[r],i=[],o=t.start,a=t.end,s=t.step;if(s>0)for(;a>o;)i.push(o),o+=s;else if(0>s)for(;o>a;)i.push(o),o+=s;e.push(i)}return e},t.prototype.valueOf=t.prototype.toArray,t.prototype.toString=function(){for(var e=[],r=0,n=this._ranges.length;n>r;r++){var t=this._ranges[r],i=s.format(t.start);1!=t.step&&(i+=":"+s.format(t.step)),i+=":"+s.format(t.end),e.push(i)}return"["+e.join(", ")+"]"},e.exports=t},function(e,r,n){function t(e){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(e instanceof t)this._data=e.clone()._data;else if(d(e))this._data=f(e);else{if(null!=e)throw new TypeError("Unsupported type of data ("+c.types.type(e)+")");this._data=[]}this._size=h.size(this._data)}function i(e,r){if(!(r instanceof p))throw new TypeError("Invalid index");var n=r.isScalar();if(n)return e.get(r.min());var i=r.size();if(i.length!=e._size.length)throw new l(i.length,e._size.length);for(var a=new t(o(e._data,r,i.length,0));d(a._data)&&1==a._data.length;)a._data=a._data[0],a._size.shift();return a}function o(e,r,n,t){var i=t==n-1,a=r.range(t);return a.map(i?function(r){return x(r,e.length),e[r]}:function(i){x(i,e.length);var a=e[i];return o(a,r,n,t+1)})}function a(e,r,n,i){if(!(r instanceof p))throw new TypeError("Invalid index");var o,a=r.size(),f=r.isScalar();if(n instanceof t?(o=n.size(),n=n.valueOf()):o=h.size(n),f){if(0!=o.length)throw new TypeError("Scalar expected");e.set(r.min(),n,i)}else{if(a.length<e._size.length)throw new l(a.length,e._size.length,"<");for(var c=0,m=a.length-o.length;m>c;c++)n=[n],o.unshift(1);if(!g.deepEqual(a,o))throw new l(a,o);var d=r.max().map(function(e){return e+1});u(e,d,i);var x=a.length,y=0;s(e._data,r,n,x,y)}return e}function s(e,r,n,t,i){var o=i==t-1,a=r.range(i);a.forEach(o?function(r,t){x(r),e[r]=n[t]}:function(o,a){x(o),s(e[o],r,n[a],t,i+1)})}function u(e,r,n){for(var t=g.clone(e._size),i=!1;t.length<r.length;)t.unshift(0),i=!0;for(var o=0,a=r.length;a>o;o++)r[o]>t[o]&&(t[o]=r[o],i=!0);i&&e.resize(t,n)}function f(e){for(var r=0,n=e.length;n>r;r++){var i=e[r];d(i)?e[r]=f(i):i instanceof t&&(e[r]=f(i._data))}return e}var c=n(123),l=n(120),p=n(7),m=(c.number,c.string),h=c.array,g=c.object,d=Array.isArray,x=h.validateIndex;t.isMatrix=function(e){return e instanceof t},t.prototype.subset=function(e,r,n){switch(arguments.length){case 1:return i(this,e);case 2:case 3:return a(this,e,r,n);default:throw new SyntaxError("Wrong number of arguments")}},t.prototype.get=function(e){if(!d(e))throw new TypeError("Array expected");if(e.length!=this._size.length)throw new l(e.length,this._size.length);for(var r=this._data,n=0,t=e.length;t>n;n++){var i=e[n];x(i,r.length),r=r[i]}return g.clone(r)},t.prototype.set=function(e,r,n){var t,i;if(!d(e))throw new Error("Array expected");if(e.length<this._size.length)throw new l(e.length,this._size.length,"<");var o=e.map(function(e){return e+1});u(this,o,n);var a=this._data;for(t=0,i=e.length-1;i>t;t++){var s=e[t];x(s,a.length),a=a[s]}return s=e[e.length-1],x(s,a.length),a[s]=r,this},t.prototype.resize=function(e,r){return this._size=g.clone(e),this._data=h.resize(this._data,this._size,r),this},t.prototype.clone=function(){var e=new t;return e._data=g.clone(this._data),e._size=g.clone(this._size),e},t.prototype.size=function(){return this._size},t.prototype.map=function(e){var r=this,n=new t,i=[],o=function(n,t){return d(n)?n.map(function(e,r){return i[t]=r,o(e,t+1)}):e(n,i,r)};return n._data=o(this._data,0),n._size=g.clone(this._size),n},t.prototype.forEach=function(e){var r=this,n=[],t=function(i,o){d(i)?i.forEach(function(e,r){n[o]=r,t(e,o+1)}):e(i,n,r)};t(this._data,0)},t.prototype.toArray=function(){return g.clone(this._data)},t.prototype.valueOf=function(){return this._data},t.prototype.format=function(e){return m.format(this._data,e)},t.prototype.toString=function(){return m.format(this._data)},e.exports=t},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new Error("Constructor must be called with the new operator");if(null!=e&&!y(e))throw new TypeError("First parameter in Unit constructor must be a number");if(null!=r&&(!w(r)||""==r))throw new TypeError("Second parameter in Unit constructor must be a string");if(null!=r){var n=l(r);if(!n)throw new SyntaxError('Unknown unit "'+r+'"');this.unit=n.unit,this.prefix=n.prefix}else this.unit=UNIT_NONE,this.prefix=b;null!=e?(this.value=this._normalize(e),this.fixPrefix=!1):(this.value=null,this.fixPrefix=!0)}function i(){for(;" "==h||"	"==h;)s()}function o(e){return e>="0"&&"9">=e||"."==e}function a(e){return e>="0"&&"9">=e}function s(){m++,h=p.charAt(m)}function u(e){m=e,h=p.charAt(m)}function f(){var e,r="";if(e=m,"+"==h?s():"-"==h&&(r+=h,s()),!o(h))return u(e),null;if("."==h){if(r+=h,s(),!a(h))return u(e),null}else{for(;a(h);)r+=h,s();"."==h&&(r+=h,s())}for(;a(h);)r+=h,s();if("E"==h||"e"==h){if(r+=h,s(),("+"==h||"-"==h)&&(r+=h,s()),!a(h))return u(e),null;for(;a(h);)r+=h,s()}return r}function c(){var e="";for(i();h&&" "!=h&&"	"!=h;)e+=h,s();return e||null}function l(e){for(var r in N)if(N.hasOwnProperty(r)&&x.endsWith(e,r)){var n=N[r],t=e.length-r.length,i=e.substring(0,t),o=n.prefixes[i];if(void 0!==o)return{unit:n,prefix:o}}return null}var p,m,h,g=n(123),d=g.number,x=g.string,y=g.number.isNumber,w=g.string.isString;t.parse=function(e){if(p=e,m=-1,h="",!w(p))return null;s(),i();var r,n=f();if(n){if(r=c(),s(),i(),h)return null;if(n&&r)try{return new t(Number(n),r)}catch(o){}}else{if(r=c(),s(),i(),h)return null;if(r)try{return new t(null,r)}catch(o){}}return null},t.isUnit=function(e){return e instanceof t},t.prototype.clone=function(){var e=new t;for(var r in this)this.hasOwnProperty(r)&&(e[r]=this[r]);return e},t.prototype._normalize=function(e){return(e+this.unit.offset)*this.unit.value*this.prefix.value},t.prototype._unnormalize=function(e,r){return void 0==r?e/this.unit.value/this.prefix.value-this.unit.offset:e/this.unit.value/r-this.unit.offset},t.isValuelessUnit=function(e){return null!=l(e)},t.prototype.hasBase=function(e){return this.unit.base===e},t.prototype.equalBase=function(e){return this.unit.base===e.unit.base},t.prototype.equals=function(e){return this.equalBase(e)&&this.value==e.value},t.prototype.to=function(e){var r;if(w(e)){if(r=new t(null,e),!this.equalBase(r))throw new Error("Units do not match");return r.value=this.value,r}if(e instanceof t){if(!this.equalBase(e))throw new Error("Units do not match");if(null!=e.value)throw new Error("Cannot convert to a unit with a value");return r=e.clone(),r.value=this.value,r.fixPrefix=!0,r}throw new Error("String or Unit expected as parameter")},t.prototype.toNumber=function(e){var r=this.to(e);return r._unnormalize(r.value,r.prefix.value)},t.prototype.toString=function(){return this.format()},t.prototype.format=function(e){var r,n;if(this.fixPrefix)r=this._unnormalize(this.value),n=null!=this.value?d.format(r,e)+" ":"",n+=this.prefix.name+this.unit.name;else{var t=this._bestPrefix();r=this._unnormalize(this.value,t.value),n=d.format(r,e)+" ",n+=t.name+this.unit.name}return n},t.prototype._bestPrefix=function(){var e=Math.abs(this.value/this.unit.value),r=b,n=Math.abs(Math.log(e/r.value)/Math.LN10-1.2),t=this.unit.prefixes;for(var i in t)if(t.hasOwnProperty(i)){var o=t[i];if(o.scientific){var a=Math.abs(Math.log(e/o.value)/Math.LN10-1.2);n>a&&(r=o,n=a)}}return r};var v={NONE:{"":{name:"",value:1,scientific:!0}},SHORT:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:10,scientific:!1},h:{name:"h",value:100,scientific:!1},k:{name:"k",value:1e3,scientific:!0},M:{name:"M",value:1e6,scientific:!0},G:{name:"G",value:1e9,scientific:!0},T:{name:"T",value:1e12,scientific:!0},P:{name:"P",value:1e15,scientific:!0},E:{name:"E",value:1e18,scientific:!0},Z:{name:"Z",value:1e21,scientific:!0},Y:{name:"Y",value:1e24,scientific:!0},d:{name:"d",value:.1,scientific:!1},c:{name:"c",value:.01,scientific:!1},m:{name:"m",value:.001,scientific:!0},u:{name:"u",value:1e-6,scientific:!0},n:{name:"n",value:1e-9,scientific:!0},p:{name:"p",value:1e-12,scientific:!0},f:{name:"f",value:1e-15,scientific:!0},a:{name:"a",value:1e-18,scientific:!0},z:{name:"z",value:1e-21,scientific:!0},y:{name:"y",value:1e-24,scientific:!0}},LONG:{"":{name:"",value:1,scientific:!0},deca:{name:"deca",value:10,scientific:!1},hecto:{name:"hecto",value:100,scientific:!1},kilo:{name:"kilo",value:1e3,scientific:!0},mega:{name:"mega",value:1e6,scientific:!0},giga:{name:"giga",value:1e9,scientific:!0},tera:{name:"tera",value:1e12,scientific:!0},peta:{name:"peta",value:1e15,scientific:!0},exa:{name:"exa",value:1e18,scientific:!0},zetta:{name:"zetta",value:1e21,scientific:!0},yotta:{name:"yotta",value:1e24,scientific:!0},deci:{name:"deci",value:.1,scientific:!1},centi:{name:"centi",value:.01,scientific:!1},milli:{name:"milli",value:.001,scientific:!0},micro:{name:"micro",value:1e-6,scientific:!0},nano:{name:"nano",value:1e-9,scientific:!0},pico:{name:"pico",value:1e-12,scientific:!0},femto:{name:"femto",value:1e-15,scientific:!0},atto:{name:"atto",value:1e-18,scientific:!0},zepto:{name:"zepto",value:1e-21,scientific:!0},yocto:{name:"yocto",value:1e-24,scientific:!0}},SQUARED:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:100,scientific:!1},h:{name:"h",value:1e4,scientific:!1},k:{name:"k",value:1e6,scientific:!0},M:{name:"M",value:1e12,scientific:!0},G:{name:"G",value:1e18,scientific:!0},T:{name:"T",value:1e24,scientific:!0},P:{name:"P",value:1e30,scientific:!0},E:{name:"E",value:1e36,scientific:!0},Z:{name:"Z",value:1e42,scientific:!0},Y:{name:"Y",value:1e48,scientific:!0},d:{name:"d",value:.01,scientific:!1},c:{name:"c",value:1e-4,scientific:!1},m:{name:"m",value:1e-6,scientific:!0},u:{name:"u",value:1e-12,scientific:!0},n:{name:"n",value:1e-18,scientific:!0},p:{name:"p",value:1e-24,scientific:!0},f:{name:"f",value:1e-30,scientific:!0},a:{name:"a",value:1e-36,scientific:!0},z:{name:"z",value:1e-42,scientific:!0},y:{name:"y",value:1e-42,scientific:!0}},CUBIC:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:1e3,scientific:!1},h:{name:"h",value:1e6,scientific:!1},k:{name:"k",value:1e9,scientific:!0},M:{name:"M",value:1e18,scientific:!0},G:{name:"G",value:1e27,scientific:!0},T:{name:"T",value:1e36,scientific:!0},P:{name:"P",value:1e45,scientific:!0},E:{name:"E",value:1e54,scientific:!0},Z:{name:"Z",value:1e63,scientific:!0},Y:{name:"Y",value:1e72,scientific:!0},d:{name:"d",value:.001,scientific:!1},c:{name:"c",value:1e-6,scientific:!1},m:{name:"m",value:1e-9,scientific:!0},u:{name:"u",value:1e-18,scientific:!0},n:{name:"n",value:1e-27,scientific:!0},p:{name:"p",value:1e-36,scientific:!0},f:{name:"f",value:1e-45,scientific:!0},a:{name:"a",value:1e-54,scientific:!0},z:{name:"z",value:1e-63,scientific:!0},y:{name:"y",value:1e-72,scientific:!0}},BINARY_SHORT:{"":{name:"",value:1,scientific:!0},k:{name:"k",value:1024,scientific:!0},M:{name:"M",value:Math.pow(1024,2),scientific:!0},G:{name:"G",value:Math.pow(1024,3),scientific:!0},T:{name:"T",value:Math.pow(1024,4),scientific:!0},P:{name:"P",value:Math.pow(1024,5),scientific:!0},E:{name:"E",value:Math.pow(1024,6),scientific:!0},Z:{name:"Z",value:Math.pow(1024,7),scientific:!0},Y:{name:"Y",value:Math.pow(1024,8),scientific:!0},Ki:{name:"Ki",value:1024,scientific:!0},Mi:{name:"Mi",value:Math.pow(1024,2),scientific:!0},Gi:{name:"Gi",value:Math.pow(1024,3),scientific:!0},Ti:{name:"Ti",value:Math.pow(1024,4),scientific:!0},Pi:{name:"Pi",value:Math.pow(1024,5),scientific:!0},Ei:{name:"Ei",value:Math.pow(1024,6),scientific:!0},Zi:{name:"Zi",value:Math.pow(1024,7),scientific:!0},Yi:{name:"Yi",value:Math.pow(1024,8),scientific:!0}},BINARY_LONG:{"":{name:"",value:1,scientific:!0},kilo:{name:"kilo",value:1024,scientific:!0},mega:{name:"mega",value:Math.pow(1024,2),scientific:!0},giga:{name:"giga",value:Math.pow(1024,3),scientific:!0},tera:{name:"tera",value:Math.pow(1024,4),scientific:!0},peta:{name:"peta",value:Math.pow(1024,5),scientific:!0},exa:{name:"exa",value:Math.pow(1024,6),scientific:!0},zetta:{name:"zetta",value:Math.pow(1024,7),scientific:!0},yotta:{name:"yotta",value:Math.pow(1024,8),scientific:!0},kibi:{name:"kibi",value:1024,scientific:!0},mebi:{name:"mebi",value:Math.pow(1024,2),scientific:!0},gibi:{name:"gibi",value:Math.pow(1024,3),scientific:!0},tebi:{name:"tebi",value:Math.pow(1024,4),scientific:!0},pebi:{name:"pebi",value:Math.pow(1024,5),scientific:!0},exi:{name:"exi",value:Math.pow(1024,6),scientific:!0},zebi:{name:"zebi",value:Math.pow(1024,7),scientific:!0},yobi:{name:"yobi",value:Math.pow(1024,8),scientific:!0}}},b={name:"",value:1,scientific:!0},E={NONE:{},LENGTH:{},MASS:{},TIME:{},CURRENT:{},TEMPERATURE:{},LUMINOUS_INTENSITY:{},AMOUNT_OF_SUBSTANCE:{},FORCE:{},SURFACE:{},VOLUME:{},ANGLE:{},BIT:{}};BASE_UNIT_NONE={},UNIT_NONE={name:"",base:BASE_UNIT_NONE,value:1,offset:0};var N={meter:{name:"meter",base:E.LENGTH,prefixes:v.LONG,value:1,offset:0},inch:{name:"inch",base:E.LENGTH,prefixes:v.NONE,value:.0254,offset:0},foot:{name:"foot",base:E.LENGTH,prefixes:v.NONE,value:.3048,offset:0},yard:{name:"yard",base:E.LENGTH,prefixes:v.NONE,value:.9144,offset:0},mile:{name:"mile",base:E.LENGTH,prefixes:v.NONE,value:1609.344,offset:0},link:{name:"link",base:E.LENGTH,prefixes:v.NONE,value:.201168,offset:0},rod:{name:"rod",base:E.LENGTH,prefixes:v.NONE,value:5.02921,offset:0},chain:{name:"chain",base:E.LENGTH,prefixes:v.NONE,value:20.1168,offset:0},angstrom:{name:"angstrom",base:E.LENGTH,prefixes:v.NONE,value:1e-10,offset:0},m:{name:"m",base:E.LENGTH,prefixes:v.SHORT,value:1,offset:0},"in":{name:"in",base:E.LENGTH,prefixes:v.NONE,value:.0254,offset:0},ft:{name:"ft",base:E.LENGTH,prefixes:v.NONE,value:.3048,offset:0},yd:{name:"yd",base:E.LENGTH,prefixes:v.NONE,value:.9144,offset:0},mi:{name:"mi",base:E.LENGTH,prefixes:v.NONE,value:1609.344,offset:0},li:{name:"li",base:E.LENGTH,prefixes:v.NONE,value:.201168,offset:0},rd:{name:"rd",base:E.LENGTH,prefixes:v.NONE,value:5.02921,offset:0},ch:{name:"ch",base:E.LENGTH,prefixes:v.NONE,value:20.1168,offset:0},mil:{name:"mil",base:E.LENGTH,prefixes:v.NONE,value:254e-7,offset:0},m2:{name:"m2",base:E.SURFACE,prefixes:v.SQUARED,value:1,offset:0},sqin:{name:"sqin",base:E.SURFACE,prefixes:v.NONE,value:64516e-8,offset:0},sqft:{name:"sqft",base:E.SURFACE,prefixes:v.NONE,value:.09290304,offset:0},sqyd:{name:"sqyd",base:E.SURFACE,prefixes:v.NONE,value:.83612736,offset:0},sqmi:{name:"sqmi",base:E.SURFACE,prefixes:v.NONE,value:2589988.110336,offset:0},sqrd:{name:"sqrd",base:E.SURFACE,prefixes:v.NONE,value:25.29295,offset:0},sqch:{name:"sqch",base:E.SURFACE,prefixes:v.NONE,value:404.6873,offset:0},sqmil:{name:"sqmil",base:E.SURFACE,prefixes:v.NONE,value:6.4516e-10,offset:0},m3:{name:"m3",base:E.VOLUME,prefixes:v.CUBIC,value:1,offset:0},L:{name:"L",base:E.VOLUME,prefixes:v.SHORT,value:.001,offset:0},l:{name:"l",base:E.VOLUME,prefixes:v.SHORT,value:.001,offset:0},litre:{name:"litre",base:E.VOLUME,prefixes:v.LONG,value:.001,offset:0},cuin:{name:"cuin",base:E.VOLUME,prefixes:v.NONE,value:16387064e-12,offset:0},cuft:{name:"cuft",base:E.VOLUME,prefixes:v.NONE,value:.028316846592,offset:0},cuyd:{name:"cuyd",base:E.VOLUME,prefixes:v.NONE,value:.764554857984,offset:0},teaspoon:{name:"teaspoon",base:E.VOLUME,prefixes:v.NONE,value:5e-6,offset:0},tablespoon:{name:"tablespoon",base:E.VOLUME,prefixes:v.NONE,value:15e-6,offset:0},minim:{name:"minim",base:E.VOLUME,prefixes:v.NONE,value:6.161152e-8,offset:0},fluiddram:{name:"fluiddram",base:E.VOLUME,prefixes:v.NONE,value:36966911e-13,offset:0},fluidounce:{name:"fluidounce",base:E.VOLUME,prefixes:v.NONE,value:2957353e-11,offset:0},gill:{name:"gill",base:E.VOLUME,prefixes:v.NONE,value:.0001182941,offset:0},cc:{name:"cc",base:E.VOLUME,prefixes:v.NONE,value:1e-6,offset:0},cup:{name:"cup",base:E.VOLUME,prefixes:v.NONE,value:.0002365882,offset:0},pint:{name:"pint",base:E.VOLUME,prefixes:v.NONE,value:.0004731765,offset:0},quart:{name:"quart",base:E.VOLUME,prefixes:v.NONE,value:.0009463529,offset:0},gallon:{name:"gallon",base:E.VOLUME,prefixes:v.NONE,value:.003785412,offset:0},beerbarrel:{name:"beerbarrel",base:E.VOLUME,prefixes:v.NONE,value:.1173478,offset:0},oilbarrel:{name:"oilbarrel",base:E.VOLUME,prefixes:v.NONE,value:.1589873,offset:0},hogshead:{name:"hogshead",base:E.VOLUME,prefixes:v.NONE,value:.238481,offset:0},fldr:{name:"fldr",base:E.VOLUME,prefixes:v.NONE,value:36966911e-13,offset:0},floz:{name:"floz",base:E.VOLUME,prefixes:v.NONE,value:2957353e-11,offset:0},gi:{name:"gi",base:E.VOLUME,prefixes:v.NONE,value:.0001182941,offset:0},cp:{name:"cp",base:E.VOLUME,prefixes:v.NONE,value:.0002365882,offset:0},pt:{name:"pt",base:E.VOLUME,prefixes:v.NONE,value:.0004731765,offset:0},qt:{name:"qt",base:E.VOLUME,prefixes:v.NONE,value:.0009463529,offset:0},gal:{name:"gal",base:E.VOLUME,prefixes:v.NONE,value:.003785412,offset:0},bbl:{name:"bbl",base:E.VOLUME,prefixes:v.NONE,value:.1173478,offset:0},obl:{name:"obl",base:E.VOLUME,prefixes:v.NONE,value:.1589873,offset:0},g:{name:"g",base:E.MASS,prefixes:v.SHORT,value:.001,offset:0},gram:{name:"gram",base:E.MASS,prefixes:v.LONG,value:.001,offset:0},ton:{name:"ton",base:E.MASS,prefixes:v.SHORT,value:907.18474,offset:0},tonne:{name:"tonne",base:E.MASS,prefixes:v.SHORT,value:1e3,offset:0},grain:{name:"grain",base:E.MASS,prefixes:v.NONE,value:6479891e-11,offset:0},dram:{name:"dram",base:E.MASS,prefixes:v.NONE,value:.0017718451953125,offset:0},ounce:{name:"ounce",base:E.MASS,prefixes:v.NONE,value:.028349523125,offset:0},poundmass:{name:"poundmass",base:E.MASS,prefixes:v.NONE,value:.45359237,offset:0},hundredweight:{name:"hundredweight",base:E.MASS,prefixes:v.NONE,value:45.359237,offset:0},stick:{name:"stick",base:E.MASS,prefixes:v.NONE,value:.115,offset:0},gr:{name:"gr",base:E.MASS,prefixes:v.NONE,value:6479891e-11,offset:0},dr:{name:"dr",base:E.MASS,prefixes:v.NONE,value:.0017718451953125,offset:0},oz:{name:"oz",base:E.MASS,prefixes:v.NONE,value:.028349523125,offset:0},lbm:{name:"lbm",base:E.MASS,prefixes:v.NONE,value:.45359237,offset:0},cwt:{name:"cwt",base:E.MASS,prefixes:v.NONE,value:45.359237,offset:0},s:{name:"s",base:E.TIME,prefixes:v.SHORT,value:1,offset:0},min:{name:"min",base:E.TIME,prefixes:v.NONE,value:60,offset:0},h:{name:"h",base:E.TIME,prefixes:v.NONE,value:3600,offset:0},second:{name:"second",base:E.TIME,prefixes:v.LONG,value:1,offset:0},sec:{name:"sec",base:E.TIME,prefixes:v.LONG,value:1,offset:0},minute:{name:"minute",base:E.TIME,prefixes:v.NONE,value:60,offset:0},hour:{name:"hour",base:E.TIME,prefixes:v.NONE,value:3600,offset:0},day:{name:"day",base:E.TIME,prefixes:v.NONE,value:86400,offset:0},rad:{name:"rad",base:E.ANGLE,prefixes:v.NONE,value:1,offset:0},deg:{name:"deg",base:E.ANGLE,prefixes:v.NONE,value:.017453292519943295,offset:0},grad:{name:"grad",base:E.ANGLE,prefixes:v.NONE,value:.015707963267948967,offset:0},cycle:{name:"cycle",base:E.ANGLE,prefixes:v.NONE,value:6.283185307179586,offset:0},A:{name:"A",base:E.CURRENT,prefixes:v.SHORT,value:1,offset:0},ampere:{name:"ampere",base:E.CURRENT,prefixes:v.LONG,value:1,offset:0},K:{name:"K",base:E.TEMPERATURE,prefixes:v.NONE,value:1,offset:0},degC:{name:"degC",base:E.TEMPERATURE,prefixes:v.NONE,value:1,offset:273.15},degF:{name:"degF",base:E.TEMPERATURE,prefixes:v.NONE,value:1/1.8,offset:459.67},degR:{name:"degR",base:E.TEMPERATURE,prefixes:v.NONE,value:1/1.8,offset:0},kelvin:{name:"kelvin",base:E.TEMPERATURE,prefixes:v.NONE,value:1,offset:0},celsius:{name:"celsius",base:E.TEMPERATURE,prefixes:v.NONE,value:1,offset:273.15},fahrenheit:{name:"fahrenheit",base:E.TEMPERATURE,prefixes:v.NONE,value:1/1.8,offset:459.67},rankine:{name:"rankine",base:E.TEMPERATURE,prefixes:v.NONE,value:1/1.8,offset:0},mol:{name:"mol",base:E.AMOUNT_OF_SUBSTANCE,prefixes:v.NONE,value:1,offset:0},mole:{name:"mole",base:E.AMOUNT_OF_SUBSTANCE,prefixes:v.NONE,value:1,offset:0},cd:{name:"cd",base:E.LUMINOUS_INTENSITY,prefixes:v.NONE,value:1,offset:0},candela:{name:"candela",base:E.LUMINOUS_INTENSITY,prefixes:v.NONE,value:1,offset:0},N:{name:"N",base:E.FORCE,prefixes:v.SHORT,value:1,offset:0},newton:{name:"newton",base:E.FORCE,prefixes:v.LONG,value:1,offset:0},lbf:{name:"lbf",base:E.FORCE,prefixes:v.NONE,value:4.4482216152605,offset:0},poundforce:{name:"poundforce",base:E.FORCE,prefixes:v.NONE,value:4.4482216152605,offset:0},b:{name:"b",base:E.BIT,prefixes:v.BINARY_SHORT,value:1,offset:0},bits:{name:"bits",base:E.BIT,prefixes:v.BINARY_LONG,value:1,offset:0},B:{name:"B",base:E.BIT,prefixes:v.BINARY_SHORT,value:8,offset:0},bytes:{name:"bytes",base:E.BIT,prefixes:v.BINARY_LONG,value:8,offset:0}},M={meters:"meter",inches:"inch",feet:"foot",yards:"yard",miles:"mile",links:"link",rods:"rod",chains:"chain",angstroms:"angstrom",litres:"litre",teaspoons:"teaspoon",tablespoons:"tablespoon",minims:"minim",fluiddrams:"fluiddram",fluidounces:"fluidounce",gills:"gill",cups:"cup",pints:"pint",quarts:"quart",gallons:"gallon",beerbarrels:"beerbarrel",oilbarrels:"oilbarrel",hogsheads:"hogshead",grams:"gram",tons:"ton",tonnes:"tonne",grains:"grain",drams:"dram",ounces:"ounce",poundmasses:"poundmass",hundredweights:"hundredweight",sticks:"stick",seconds:"second",minutes:"minute",hours:"hour",days:"day",radians:"rad",degrees:"deg",gradients:"grad",cycles:"cycle",amperes:"ampere",moles:"mole"};
for(var T in M)if(M.hasOwnProperty(T)){var A=N[M[T]],S=Object.create(A);S.name=T,N[T]=S}N.lt=N.l,N.liter=N.litre,N.liters=N.litres,N.lb=N.lbm,N.lbs=N.lbm,t.PREFIXES=v,t.BASE_UNITS=E,t.UNITS=N,e.exports=t},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");this.math=e,this.doc=r}var i=n(123),o=i.object,a=i.string;t.isHelp=function(e){return e instanceof t},t.prototype.toString=function(){var e=this.doc||{},r="\n";if(e.name&&(r+="Name: "+e.name+"\n\n"),e.category&&(r+="Category: "+e.category+"\n\n"),e.description&&(r+="Description:\n    "+e.description+"\n\n"),e.syntax&&(r+="Syntax:\n    "+e.syntax.join("\n    ")+"\n\n"),e.examples){var n=this.math.parser();r+="Examples:\n";for(var i=0;i<e.examples.length;i++){var o,s=e.examples[i];try{o=n.eval(s)}catch(u){o=u}r+="    "+s+"\n",!o||o instanceof t||(r+="        "+a.format(o)+"\n")}r+="\n"}return e.seealso&&(r+="See also: "+e.seealso.join(", ")+"\n"),r},t.prototype.toJSON=function(){return o.clone(this.doc)},e.exports=t},function(e,r,n){function t(e,r,n){var o,a,s,f;if(0>=r){if(u(e[0])){for(f=i(e),a=[],o=0;o<f.length;o++)a[o]=t(f[o],r-1,n);return a}for(s=e[0],o=1;o<e.length;o++)s=n(s,e[o]);return s}for(a=[],o=0;o<e.length;o++)a[o]=t(e[o],r-1,n);return a}function i(e){var r,n,t=e.length,i=e[0].length,o=[];for(n=0;i>n;n++){var a=[];for(r=0;t>r;r++)a.push(e[r][n]);o.push(a)}return o}{var o=n(123),a=n(120),s=n(8),u=o.array.isArray;o.string.isString}r.argsToArray=function(e){var r;return 0==e.length?r=[]:1==e.length?(r=e[0],r instanceof s&&(r=r.valueOf()),u(r)||(r=[r])):r=Array.prototype.slice.apply(e),r},r.isCollection=function(e){return u(e)||e instanceof s},r.deepMap=function f(e,r){return e&&"function"==typeof e.map?e.map(function(e){return f(e,r)}):r(e)},r.deepMap2=function c(e,r,n){var t,i,o;if(u(e))if(u(r)){if(e.length!=r.length)throw new a(e.length,r.length);for(t=[],i=e.length,o=0;i>o;o++)t[o]=c(e[o],r[o],n)}else{if(r instanceof s)return t=c(e,r.valueOf(),n),new s(t);for(t=[],i=e.length,o=0;i>o;o++)t[o]=c(e[o],r,n)}else{if(e instanceof s)return r instanceof s?(t=c(e.valueOf(),r.valueOf(),n),new s(t)):(t=c(e.valueOf(),r,n),new s(t));if(u(r))for(t=[],i=r.length,o=0;i>o;o++)t[o]=c(e,r[o],n);else{if(r instanceof s)return t=c(e,r.valueOf(),n),new s(t);t=n(e,r)}}return t},r.reduce=function(e,r,n){return e instanceof s?new s(t(e.valueOf(),r,n)):t(e,r,n)},r.deepForEach=function l(e,r){e instanceof s&&(e=e.valueOf());for(var n=0,t=e.length;t>n;n++){var i=e[n];u(i)?l(i,r):r(i)}}},function(e,r,n){function t(e,r){if(1!=arguments.length&&2!=arguments.length)throw new F("parse",arguments.length,1,2);if(fr="object"===V(r)?r:{},G(e))return cr=e,p();if(D(e)||e instanceof H)return Y.deepMap(e,function(e){if(!G(e))throw new TypeError("String expected");return cr=e,p()});throw new TypeError("String or matrix expected")}function i(){lr=0,pr=cr.charAt(0)}function o(){lr++,pr=cr.charAt(lr)}function a(){return cr.charAt(lr+1)}function s(){for(hr=ar.NULL,mr="";" "==pr||"	"==pr;)o();if("#"==pr)for(;"\n"!=pr&&""!=pr;)o();if(""==pr)return void(hr=ar.DELIMITER);var e=pr+a();if(sr[e])return hr=ar.DELIMITER,mr=e,o(),void o();if(sr[pr])return hr=ar.DELIMITER,mr=pr,void o();if(!c(pr)){if(f(pr)){for(;f(pr)||l(pr);)mr+=pr,o();return void(hr=ur[mr]?ar.DELIMITER:ar.SYMBOL)}for(hr=ar.UNKNOWN;""!=pr;)mr+=pr,o();throw j('Syntax error in part "'+mr+'"')}if(hr=ar.NUMBER,"."==pr)mr+=pr,o(),l(pr)||(hr=ar.UNKNOWN);else{for(;l(pr);)mr+=pr,o();"."==pr&&(mr+=pr,o())}for(;l(pr);)mr+=pr,o();if("E"==pr||"e"==pr)for(mr+=pr,o(),("+"==pr||"-"==pr)&&(mr+=pr,o()),l(pr)||(hr=ar.UNKNOWN);l(pr);)mr+=pr,o()}function u(){for(;"\n"==mr;)s()}function f(e){return e>="a"&&"z">=e||e>="A"&&"Z">=e||"_"==e}function c(e){return e>="0"&&"9">=e||"."==e}function l(e){return e>="0"&&"9">=e}function p(){i(),s();var e=m();if(""!=mr)throw hr==ar.DELIMITER?k("Unknown operator "+mr):j('Unexpected part "'+mr+'"');return e}function m(){var e,r,n;if(""==mr)return new K("undefined","undefined");for("\n"!=mr&&";"!=mr&&(e=h());"\n"==mr||";"==mr;)r||(r=new Q,e&&(n=";"!=mr,r.add(e,n))),s(),"\n"!=mr&&";"!=mr&&""!=mr&&(e=h(),n=";"!=mr,r.add(e,n));return r?r:e}function h(){var e=g(),r="ans";return new Z(r,e)}function g(){if(hr==ar.SYMBOL&&"function"==mr)throw j('Deprecated keyword "function". Functions can now be assigned without it, like "f(x) = x^2".');return d()}function d(){var e,r,n,t=x();if("="==mr){if(t instanceof nr)return e=t.name,s(),n=d(),new Z(e,n);if(t instanceof J)return s(),n=d(),new or(t,n);if(t instanceof er){var i=!0;if(r=[],t.object instanceof nr?(e=t.object.name,t.params.forEach(function(e,n){e instanceof nr?r[n]=e.name:i=!1})):i=!1,i)return s(),n=d(),new $(e,r,n)}throw j("Invalid left hand side of assignment operator =")}return t}function x(){var e,r=[];if(e=":"==mr?new K("number","1"):y(),":"==mr){for(r.push(e);":"==mr;)s(),r.push(")"==mr||"]"==mr||","==mr||""==mr?new nr("end"):y());if(3==r.length){var n=r[2];r[2]=r[1],r[1]=n}e=new rr(r)}return e}function y(){var e=w();return e}function w(){for(var e=v();"?"==mr;){s();var r=[e];if(r.push(v()),":"!=mr)throw j("False part of conditional expression expected");s(),r.push(w()),e=new tr(["?",":"],"ifElse",r)}return e}function v(){var e,r,n,t,i;for(e=b(),r={"==":"equal","!=":"unequal","<":"smaller",">":"larger","<=":"smallereq",">=":"largereq"};mr in r;)n=mr,t=r[n],s(),i=[e,b()],e=new X(n,t,i);return e}function b(){var e,r,n,t,i;for(e=E(),r={to:"to","in":"to"};mr in r;)n=mr,t=r[n],s(),i=[e,E()],e=new X(n,t,i);return e}function E(){var e,r,n,t,i;for(e=N(),r={"+":"add","-":"subtract"};mr in r;)n=mr,t=r[n],s(),i=[e,N()],e=new X(n,t,i);return e}function N(){var e,r,n,t,i;for(e=M(),r={"*":"multiply",".*":"emultiply","/":"divide","./":"edivide","%":"mod",mod:"mod"};mr in r;)n=mr,t=r[n],s(),i=[e,M()],e=new X(n,t,i);return e}function M(){var e,r;return e=T(),(hr==ar.SYMBOL||"in"==mr)&&(r=mr,s(),e=new ir(e,r)),e}function T(){var e,r,n;return"-"==mr?(e=mr,r="unary",s(),n=[T()],new X(e,r,n)):A()}function A(){var e,r,n,t;return e=S(),("^"==mr||".^"==mr)&&(r=mr,n="^"==r?"pow":"epow",s(),t=[e,T()],e=new X(r,n,t)),e}function S(){var e,r,n,t,i;for(e=O(),r={"!":"factorial","'":"transpose"};mr in r;)n=mr,t=r[n],s(),i=[e],e=new X(n,t,i),e=U(e);return e}function O(){var e,r=[];if(hr==ar.SYMBOL&&fr[mr]){if(e=fr[mr],s(),"("==mr){if(r=[],s(),")"!=mr)for(r.push(x());","==mr;)s(),r.push(x());if(")"!=mr)throw j("Parenthesis ) expected");s()}return new e(r)}return C()}function C(){var e,r;return hr==ar.SYMBOL||hr==ar.DELIMITER&&mr in ur?(r=mr,s(),e=new nr(r),U(e)):B()}function U(e){for(var r,n;"("==mr||"["==mr;){if(r=mr,n=[],s(),")"!=mr&&"]"!=mr)for(n.push(x());","==mr;)s(),n.push(x());if("("==r&&")"!=mr)throw j("Parenthesis ) expected");if("["==r&&"]"!=mr)throw j("Parenthesis ] expected");s(),e="("==r?new er(e,n):new J(e,n)}return e}function B(){var e,r,n;if('"'==mr){for(r="",n="";""!=pr&&('"'!=pr||"\\"==n);)r+=pr,n=pr,o();if(s(),'"'!=mr)throw j('End of string " expected');return s(),e=new K("string",r),e=U(e)}return q()}function q(){var e,r,n,t;if("["==mr){if(s(),u(),"]"!=mr){var i=z();if(";"==mr){for(n=1,r=[i];";"==mr;)s(),u(),r[n]=z(),n++,u();if("]"!=mr)throw j("End of matrix ] expected");s(),t=r[0].nodes.length;for(var o=1;n>o;o++)if(r[o].nodes.length!=t)throw k("Column dimensions mismatch ("+r[o].nodes.length+" != "+t+")");e=new W(r)}else{if("]"!=mr)throw j("End of matrix ] expected");s(),e=i}}else s(),e=new W([]);return e=U(e)}return I()}function z(){for(var e=[d()],r=1;","==mr;)s(),u(),e[r]=d(),r++,u();return new W(e)}function I(){var e,r;return hr==ar.NUMBER?(r=mr,s(),"i"==mr||"I"==mr?(s(),e=new K("complex",r)):e=new K("number",r),e=U(e)):_()}function _(){var e;if("("==mr){if(s(),e=d(),")"!=mr)throw j("Parenthesis ) expected");return s(),e=U(e)}return R()}function R(){throw j(""==mr?"Unexpected end of expression":"Value expected")}function L(){return lr-mr.length+1}function j(e){var r=L(),n=new SyntaxError(e+" (char "+r+")");return n["char"]=r,n}function k(e){var r=L(),n=new Error(e+" (char "+r+")");return n["char"]=r,n}var P=n(123),F=n(119),G=P.string.isString,D=Array.isArray,V=P.types.type,H=(n(5),n(8)),Y=(n(9),n(11)),W=n(124),Z=n(125),Q=n(126),K=n(127),$=n(128),J=n(129),X=n(130),er=n(131),rr=n(132),nr=n(133),tr=n(134),ir=n(135),or=n(136),ar={NULL:0,DELIMITER:1,NUMBER:2,SYMBOL:3,UNKNOWN:4},sr={",":!0,"(":!0,")":!0,"[":!0,"]":!0,'"':!0,"\n":!0,";":!0,"+":!0,"-":!0,"*":!0,".*":!0,"/":!0,"./":!0,"%":!0,"^":!0,".^":!0,"!":!0,"'":!0,"=":!0,":":!0,"?":!0,"==":!0,"!=":!0,"<":!0,">":!0,"<=":!0,">=":!0},ur={mod:!0,to:!0,"in":!0},fr={},cr="",lr=0,pr="",mr="",hr=ar.NULL;e.exports=t},function(e,r,n){function t(e){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if("object"!=typeof e)throw new TypeError("Object expected as parameter math");this.math=e,this.scope={}}var i=n(12);t.prototype.parse=function(){throw new Error("Parser.parse is deprecated. Use math.parse instead.")},t.prototype.compile=function(){throw new Error("Parser.compile is deprecated. Use math.compile instead.")},t.prototype.eval=function(e){return i(e).compile(this.math).eval(this.scope)},t.prototype.get=function(e){return this.scope[e]},t.prototype.set=function(e,r){return this.scope[e]=r},t.prototype.remove=function(e){delete this.scope[e]},t.prototype.clear=function(){for(var e in this.scope)this.scope.hasOwnProperty(e)&&delete this.scope[e]},e.exports=t},function(e,r,n){r.ArrayNode=n(124),r.AssignmentNode=n(125),r.BlockNode=n(126),r.ConstantNode=n(127),r.IndexNode=n(129),r.FunctionNode=n(128),r.Node=n(137),r.OperatorNode=n(130),r.ParamsNode=n(131),r.RangeNode=n(132),r.SymbolNode=n(133),r.TernaryNode=n(134),r.UnitNode=n(135),r.UpdateNode=n(136)},function(e,r,n){r.e=n(139),r.E=n(139),r["false"]=n(140),r.i=n(141),r.Infinity=n(142),r.LN2=n(143),r.LN10=n(144),r.LOG2E=n(145),r.LOG10E=n(146),r.NaN=n(147),r.pi=n(148),r.PI=n(148),r.SQRT1_2=n(149),r.SQRT2=n(150),r.tau=n(151),r["true"]=n(152),r.abs=n(157),r.add=n(158),r.ceil=n(159),r.compare=n(160),r.cube=n(161),r.divide=n(162),r.edivide=n(163),r.emultiply=n(164),r.epow=n(165),r.equal=n(166),r.exp=n(167),r.fix=n(168),r.floor=n(169),r.gcd=n(170),r.larger=n(171),r.largereq=n(172),r.lcm=n(173),r.log=n(174),r.log10=n(175),r.mod=n(176),r.multiply=n(177),r.norm=n(178),r.pow=n(179),r.round=n(180),r.sign=n(181),r.smaller=n(182),r.smallereq=n(183),r.sqrt=n(184),r.square=n(185),r.subtract=n(186),r.unary=n(187),r.unequal=n(188),r.xgcd=n(189),r.arg=n(190),r.conj=n(191),r.re=n(192),r.im=n(193),r.bignumber=n(194),r["boolean"]=n(195),r.complex=n(196),r.index=n(197),r.matrix=n(198),r.number=n(199),r.string=n(200),r.unit=n(201),r.eval=n(202),r.help=n(203),r.concat=n(204),r.det=n(205),r.diag=n(206),r.eye=n(207),r.inv=n(208),r.ones=n(209),r.range=n(210),r.resize=n(211),r.size=n(212),r.squeeze=n(213),r.subset=n(214),r.transpose=n(215),r.zeros=n(216),r.combinations=n(217),r.distribution=n(218),r.factorial=n(219),r.permutations=n(220),r.pickRandom=n(221),r.random=n(222),r.randomInt=n(223),r.max=n(224),r.mean=n(225),r.median=n(226),r.min=n(227),r.prod=n(228),r.std=n(229),r.sum=n(230),r["var"]=n(231),r.acos=n(232),r.asin=n(233),r.atan=n(234),r.atan2=n(235),r.cos=n(236),r.cosh=n(237),r.cot=n(238),r.coth=n(239),r.csc=n(240),r.csch=n(241),r.sec=n(242),r.sech=n(243),r.sin=n(244),r.sinh=n(245),r.tan=n(246),r.tanh=n(247),r.to=n(248),r.clone=n(249),r.map=n(250),r.forEach=n(251),r.format=n(252),r.ifElse=n(253),r["import"]=n(254),r["typeof"]=n(255)},function(e,r,n){e.exports=function(e){function r(e){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");this.value=e instanceof r?e.value:e}function t(e,n){var t=Array.prototype.slice;r.prototype[e]="function"==typeof n?function(){var e=[this.value].concat(t.call(arguments,0));return new r(n.apply(this,e))}:new r(n)}var i=n(138);r.prototype.done=function(){return this.value},r.prototype.valueOf=function(){return this.value},r.prototype.toString=function(){return i.format(this.value)},r.createProxy=t;for(var o in e)e.hasOwnProperty(o)&&t(o,e[o]);return r}},function(e,r,n){e.exports=function(e){var r=n(123),t=n(12),i=n(11),o=r.string.isString,a=i.isCollection;e.compile=function(r){if(1!=arguments.length)throw new e.error.ArgumentsError("compile",arguments.length,1);if(o(r))return t(r).compile(e);if(a(r))return i.deepMap(r,function(r){return t(r).compile(e)});throw new TypeError("String, array, or matrix expected")}}},function(e,r,n){e.exports=function(e){var r=n(123),t=n(12),i=n(11),o=r.string.isString,a=i.isCollection;e.eval=function(r,n){if(1!=arguments.length&&2!=arguments.length)throw new e.error.ArgumentsError("eval",arguments.length,1,2);if(n=n||{},o(r))return t(r).compile(e).eval(n);if(a(r))return i.deepMap(r,function(r){return t(r).compile(e).eval(n)});throw new TypeError("String, array, or matrix expected")}}},function(e,r,n){e.exports=function(e){var r=n(10);e.help=function(n){if(1!=arguments.length)throw new SyntaxError("Wrong number of arguments in function help ("+arguments.length+" provided, 1 expected)");var t=null;if(n instanceof String||"string"==typeof n)t=n;else{var i;for(i in e)if(e.hasOwnProperty(i)&&n===e[i]){t=i;break}}var o=e.expression.docs[t];if(!t||!o)throw new Error('No documentation found on "'+t+'"');return new r(e,o)}}},function(e,r,n){e.exports=function(e){var r=n(12);e.parse=function(){return r.apply(r,arguments)}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=(n(8),n(11)),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.abs=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("abs",arguments.length,1);if(a(r))return Math.abs(r);if(u(r))return Math.sqrt(r.re*r.re+r.im*r.im);if(r instanceof t)return r.abs();if(f(r))return o.deepMap(r,c);if(s(r))return Math.abs(r);throw new e.error.UnsupportedTypeError("abs",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=(n(8),n(9)),a=n(11),s=r["boolean"].isBoolean,u=r.number.isNumber,f=r.string.isString,c=i.isComplex,l=o.isUnit,p=a.isCollection;e.add=function m(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("add",arguments.length,2);if(u(r)){if(u(n))return r+n;if(c(n))return new i(r+n.re,n.im)}if(c(r)){if(c(n))return new i(r.re+n.re,r.im+n.im);if(u(n))return new i(r.re+n,r.im)}if(l(r)&&l(n)){if(null==r.value)throw new Error("Parameter x contains a unit with undefined value");if(null==n.value)throw new Error("Parameter y contains a unit with undefined value");if(!r.equalBase(n))throw new Error("Units do not match");var o=r.clone();return o.value+=n.value,o.fixPrefix=!1,o}if(r instanceof t)return u(n)?n=t.convert(n):s(n)&&(n=new t(n?1:0)),n instanceof t?r.plus(n):m(r.toNumber(),n);if(n instanceof t)return u(r)?r=t.convert(r):s(r)&&(r=new t(r?1:0)),r instanceof t?r.plus(n):m(r,n.toNumber());if(p(r)||p(n))return a.deepMap2(r,n,m);if(f(r)||f(n))return r+n;if(s(r))return m(+r,n);if(s(n))return m(r,+n);throw new e.error.UnsupportedTypeError("add",e["typeof"](r),e["typeof"](n))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number.isNumber,s=r["boolean"].isBoolean,u=o.isCollection,f=i.isComplex;e.ceil=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("ceil",arguments.length,1);if(a(r))return Math.ceil(r);if(f(r))return new i(Math.ceil(r.re),Math.ceil(r.im));if(r instanceof t)return r.ceil();if(u(r))return o.deepMap(r,c);if(s(r))return Math.ceil(r);throw new e.error.UnsupportedTypeError("ceil",e["typeof"](r))}}},function(e,r,n){e.exports=function(e,r){var t=n(123),i=e.type.BigNumber,o=n(5),a=n(9),s=n(11),u=t.number.isNumber,f=t.number.nearlyEqual,c=t["boolean"].isBoolean,l=t.string.isString,p=o.isComplex,m=a.isUnit,h=s.isCollection;e.compare=function g(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("compare",arguments.length,2);if(u(n)&&u(t))return f(n,t,r.epsilon)?0:n>t?1:-1;if(n instanceof i)return u(t)?t=i.convert(t):c(t)&&(t=new i(t?1:0)),t instanceof i?new i(n.cmp(t)):g(n.toNumber(),t);if(t instanceof i)return u(n)?n=i.convert(n):c(n)&&(n=new i(n?1:0)),n instanceof i?new i(n.cmp(t)):g(n,t.toNumber());if(m(n)&&m(t)){if(!n.equalBase(t))throw new Error("Cannot compare units with different base");return n.value>t.value?1:n.value<t.value?-1:0}if(h(n)||h(t))return s.deepMap2(n,t,g);if(l(n)||l(t))return n>t?1:t>n?-1:0;if(c(n))return g(+n,t);if(c(t))return g(n,+t);if(p(n)||p(t))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("compare",e["typeof"](n),e["typeof"](t))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.cube=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("cube",arguments.length,1);if(a(r))return r*r*r;if(u(r))return e.multiply(e.multiply(r,r),r);if(r instanceof t)return r.times(r).times(r);if(f(r))return o.deepMap(r,c);if(s(r))return c(+r);throw new e.error.UnsupportedTypeError("cube",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){function r(e,r){var n=r.re*r.re+r.im*r.im;return 0!=n?new o((e.re*r.re+e.im*r.im)/n,(e.im*r.re-e.re*r.im)/n):new o(0!=e.re?e.re/0:0,0!=e.im?e.im/0:0)}var t=n(123),i=e.type.BigNumber,o=n(5),a=(n(8),n(9)),s=n(11),u=t.number.isNumber,f=t["boolean"].isBoolean,c=o.isComplex,l=a.isUnit,p=s.isCollection;e.divide=function m(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("divide",arguments.length,2);if(u(n)){if(u(t))return n/t;if(c(t))return r(new o(n,0),t)}if(c(n)){if(c(t))return r(n,t);if(u(t))return r(n,new o(t,0))}if(n instanceof i)return u(t)?t=i.convert(t):f(t)&&(t=new i(t?1:0)),t instanceof i?n.div(t):m(n.toNumber(),t);if(t instanceof i)return u(n)?n=i.convert(n):f(n)&&(n=new i(n?1:0)),n instanceof i?n.div(t):m(n,t.toNumber());if(l(n)&&u(t)){var a=n.clone();return a.value/=t,a}if(p(n))return p(t)?e.multiply(n,e.inv(t)):s.deepMap2(n,t,m);if(p(t))return e.multiply(n,e.inv(t));if(f(n))return m(+n,t);if(f(t))return m(n,+t);throw new e.error.UnsupportedTypeError("divide",e["typeof"](n),e["typeof"](t))}}},function(e,r,n){e.exports=function(e){var r=n(11);e.edivide=function(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("edivide",arguments.length,2);return r.deepMap2(n,t,e.divide)}}},function(e,r,n){e.exports=function(e){var r=(n(123),n(11));e.emultiply=function(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("emultiply",arguments.length,2);return r.deepMap2(n,t,e.multiply)}}},function(e,r,n){e.exports=function(e){var r=(n(123),n(11));e.epow=function(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("epow",arguments.length,2);return r.deepMap2(n,t,e.pow)}}},function(e,r,n){e.exports=function(e,r){var t=n(123),i=e.type.BigNumber,o=n(5),a=n(9),s=n(11),u=t.number.isNumber,f=t.number.nearlyEqual,c=t["boolean"].isBoolean,l=t.string.isString,p=o.isComplex,m=a.isUnit,h=s.isCollection;e.equal=function g(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("equal",arguments.length,2);if(u(n)){if(u(t))return f(n,t,r.epsilon);if(p(t))return f(n,t.re,r.epsilon)&&f(t.im,0,r.epsilon)}if(p(n)){if(u(t))return f(n.re,t,r.epsilon)&&f(n.im,0,r.epsilon);if(p(t))return f(n.re,t.re,r.epsilon)&&f(n.im,t.im,r.epsilon)}if(n instanceof i)return u(t)?t=i.convert(t):c(t)&&(t=new i(t?1:0)),t instanceof i?n.eq(t):g(n.toNumber(),t);if(t instanceof i)return u(n)?n=i.convert(n):c(n)&&(n=new i(n?1:0)),n instanceof i?n.eq(t):g(n,t.toNumber());if(m(n)&&m(t)){if(!n.equalBase(t))throw new Error("Cannot compare units with different base");return n.value==t.value}if(h(n)||h(t))return s.deepMap2(n,t,g);if(l(n)||l(t))return n==t;if(c(n))return g(+n,t);if(c(t))return g(n,+t);throw new e.error.UnsupportedTypeError("equal",e["typeof"](n),e["typeof"](t))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=(n(8),n(11)),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.exp=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("exp",arguments.length,1);if(a(r))return Math.exp(r);if(u(r)){var n=Math.exp(r.re);return new i(n*Math.cos(r.im),n*Math.sin(r.im))}if(r instanceof t)return r.exp();if(f(r))return o.deepMap(r,c);if(s(r))return Math.exp(r);throw new e.error.UnsupportedTypeError("exp",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.fix=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("fix",arguments.length,1);if(a(r))return r>0?Math.floor(r):Math.ceil(r);if(u(r))return new i(r.re>0?Math.floor(r.re):Math.ceil(r.re),r.im>0?Math.floor(r.im):Math.ceil(r.im));if(r instanceof t)return r.isNegative()?r.ceil():r.floor();if(f(r))return o.deepMap(r,c);if(s(r))return c(+r);throw new e.error.UnsupportedTypeError("fix",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.floor=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("floor",arguments.length,1);if(a(r))return Math.floor(r);if(u(r))return new i(Math.floor(r.re),Math.floor(r.im));if(r instanceof t)return r.floor();if(f(r))return o.deepMap(r,c);if(s(r))return c(+r);throw new e.error.UnsupportedTypeError("floor",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(11),o=r.number.isNumber,a=r["boolean"].isBoolean,s=r.number.isInteger,u=i.isCollection;e.gcd=function f(){var r,n=arguments[0],c=arguments[1];if(2==arguments.length){if(o(n)&&o(c)){if(!s(n)||!s(c))throw new Error("Parameters in function gcd must be integer numbers");for(;0!=c;)r=n%c,n=c,c=r;return 0>n?-n:n}if(u(n)||u(c))return i.deepMap2(n,c,f);if(n instanceof t)return f(n.toNumber(),c);if(c instanceof t)return f(n,c.toNumber());if(a(n))return f(+n,c);if(a(c))return f(n,+c);throw new e.error.UnsupportedTypeError("gcd",e["typeof"](n),e["typeof"](c))}if(arguments.length>2){for(var l=1;l<arguments.length;l++)n=f(n,arguments[l]);return n}throw new SyntaxError("Function gcd expects two or more arguments")}}},function(e,r,n){e.exports=function(e,r){var t=n(123),i=e.type.BigNumber,o=n(5),a=n(9),s=n(11),u=t.number.isNumber,f=t.number.nearlyEqual,c=t["boolean"].isBoolean,l=t.string.isString,p=o.isComplex,m=a.isUnit,h=s.isCollection;e.larger=function g(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("larger",arguments.length,2);if(u(n)&&u(t))return!f(n,t,r.epsilon)&&n>t;if(n instanceof i)return u(t)?t=i.convert(t):c(t)&&(t=new i(t?1:0)),t instanceof i?n.gt(t):g(n.toNumber(),t);if(t instanceof i)return u(n)?n=i.convert(n):c(n)&&(n=new i(n?1:0)),n instanceof i?n.gt(t):g(n,t.toNumber());if(m(n)&&m(t)){if(!n.equalBase(t))throw new Error("Cannot compare units with different base");return n.value>t.value}if(h(n)||h(t))return s.deepMap2(n,t,g);if(l(n)||l(t))return n>t;if(c(n))return g(+n,t);if(c(t))return g(n,+t);if(p(n)||p(t))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("larger",e["typeof"](n),e["typeof"](t))}}},function(e,r,n){e.exports=function(e,r){var t=n(123),i=e.type.BigNumber,o=n(5),a=n(9),s=n(11),u=t.number.isNumber,f=t.number.nearlyEqual,c=t["boolean"].isBoolean,l=t.string.isString,p=o.isComplex,m=a.isUnit,h=s.isCollection;e.largereq=function g(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("largereq",arguments.length,2);if(u(n)&&u(t))return f(n,t,r.epsilon)||n>t;if(n instanceof i)return u(t)?t=i.convert(t):c(t)&&(t=new i(t?1:0)),t instanceof i?n.gte(t):g(n.toNumber(),t);if(t instanceof i)return u(n)?n=i.convert(n):c(n)&&(n=new i(n?1:0)),n instanceof i?n.gte(t):g(n,t.toNumber());if(m(n)&&m(t)){if(!n.equalBase(t))throw new Error("Cannot compare units with different base");return n.value>=t.value}if(h(n)||h(t))return s.deepMap2(n,t,g);if(l(n)||l(t))return n>=t;if(c(n))return g(+n,t);if(c(t))return g(n,+t);if(p(n)||p(t))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("largereq",e["typeof"](n),e["typeof"](t))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(11),o=r.number.isNumber,a=r["boolean"].isBoolean,s=r.number.isInteger,u=i.isCollection;e.lcm=function f(){var r,n=arguments[0],c=arguments[1];if(2==arguments.length){if(o(n)&&o(c)){if(!s(n)||!s(c))throw new Error("Parameters in function lcm must be integer numbers");if(0==n||0==c)return 0;for(var l=n*c;0!=c;)r=c,c=n%r,n=r;return Math.abs(l/n)}if(u(n)||u(c))return i.deepMap2(n,c,f);if(a(n))return f(+n,c);if(a(c))return f(n,+c);if(n instanceof t)return f(n.toNumber(),c);if(c instanceof t)return f(n,c.toNumber());throw new e.error.UnsupportedTypeError("lcm",e["typeof"](n),e["typeof"](c))}if(arguments.length>2){for(var p=1;p<arguments.length;p++)n=f(n,arguments[p]);return n}throw new SyntaxError("Function lcm expects two or more arguments")}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.log=function c(r,n){if(1==arguments.length){if(a(r))return r>=0?Math.log(r):c(new i(r,0));if(u(r))return new i(Math.log(Math.sqrt(r.re*r.re+r.im*r.im)),Math.atan2(r.im,r.re));if(r instanceof t)return r.isNegative()?c(r.toNumber()):r.ln();if(f(r))return o.deepMap(r,c);if(s(r))return c(+r);throw new e.error.UnsupportedTypeError("log",e["typeof"](r))}if(2==arguments.length)return e.divide(c(r),c(n));throw new e.error.ArgumentsError("log",arguments.length,1,2)}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.log10=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("log10",arguments.length,1);if(a(r))return r>=0?Math.log(r)/Math.LN10:c(new i(r,0));if(r instanceof t)return r.isNegative()?c(r.toNumber()):r.log();if(u(r))return new i(Math.log(Math.sqrt(r.re*r.re+r.im*r.im))/Math.LN10,Math.atan2(r.im,r.re)/Math.LN10);if(f(r))return o.deepMap(r,c);if(s(r))return c(+r);throw new e.error.UnsupportedTypeError("log10",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){function r(e,r){if(r>0)return e-r*Math.floor(e/r);if(0==r)return e;throw new Error("Cannot calculate mod for a negative divisor")}var t=n(123),i=e.type.BigNumber,o=n(11),a=t.number.isNumber,s=t["boolean"].isBoolean,u=o.isCollection;e.mod=function f(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("mod",arguments.length,2);if(a(n)&&a(t))return r(n,t);if(n instanceof i)return a(t)?t=i.convert(t):s(t)&&(t=new i(t?1:0)),t instanceof i?t.isZero()?n:n.mod(t):f(n.toNumber(),t);if(t instanceof i)return a(n)?n=i.convert(n):s(n)&&(n=new i(n?1:0)),n instanceof i?t.isZero()?n:n.mod(t):f(n,t.toNumber());if(u(n)||u(t))return o.deepMap2(n,t,f);if(s(n))return f(+n,t);if(s(t))return f(n,+t);throw new e.error.UnsupportedTypeError("mod",e["typeof"](n),e["typeof"](t))}}},function(e,r,n){e.exports=function(e){function r(r,n){for(var t=[],i=r.length,o=n[0].length,a=r[0].length,s=0;i>s;s++){t[s]=[];for(var u=0;o>u;u++){for(var f=null,c=0;a>c;c++){var l=e.multiply(r[s][c],n[c][u]);f=null===f?l:e.add(f,l)}t[s][u]=f}}return m.squeeze(t)}function t(r,n){for(var t=[],i=n.length,o=n[0].length,a=0;o>a;a++){for(var s=null,u=0;i>u;u++){var f=e.multiply(r[u],n[u][a]);s=0===u?f:e.add(s,f)}t[a]=s}return m.squeeze(t)}function i(r,n){for(var t=[],i=r.length,o=r[0].length,a=0;i>a;a++){for(var s=null,u=0;o>u;u++){var f=e.multiply(r[a][u],n[u]);s=0===u?f:e.add(s,f)}t[a]=s}return m.squeeze(t)}function o(r,n){var t=r.length;if(!t)throw new Error("Cannot multiply two empty vectors");for(var i=0,o=0;t>o;o++)i=e.add(i,e.multiply(r[o],n[o]));return i}function a(e,r){return 0==e.im?0==r.im?new f(e.re*r.re,0):0==r.re?new f(0,e.re*r.im):new f(e.re*r.re,e.re*r.im):0==e.re?0==r.im?new f(0,e.im*r.re):0==r.re?new f(-e.im*r.im,0):new f(-e.im*r.im,e.im*r.re):0==r.im?new f(e.re*r.re,e.im*r.re):0==r.re?new f(-e.im*r.im,e.re*r.im):new f(e.re*r.re-e.im*r.im,e.re*r.im+e.im*r.re)}var s=n(123),u=e.type.BigNumber,f=n(5),c=n(8),l=n(9),p=n(11),m=s.array,h=s.number.isNumber,g=s["boolean"].isBoolean,d=f.isComplex,x=Array.isArray,y=l.isUnit;e.multiply=function w(n,s){var l;if(2!=arguments.length)throw new e.error.ArgumentsError("multiply",arguments.length,2);if(h(n)){if(h(s))return n*s;if(d(s))return a(new f(n,0),s);if(y(s))return l=s.clone(),null===l.value&&(l.value=l._normalize(1)),l.value*=n,l}if(d(n)){if(h(s))return a(n,new f(s,0));if(d(s))return a(n,s)}if(n instanceof u)return h(s)?s=u.convert(s):g(s)&&(s=new u(s?1:0)),s instanceof u?n.times(s):w(n.toNumber(),s);if(s instanceof u)return h(n)?n=u.convert(n):g(n)&&(n=new u(n?1:0)),n instanceof u?n.times(s):w(n,s.toNumber());if(y(n)&&h(s))return l=n.clone(),null===l.value&&(l.value=l._normalize(1)),l.value*=s,l;if(x(n)){if(x(s)){var v=m.size(n),b=m.size(s);if(1==v.length){if(1==b.length){if(v[0]!=b[0])throw new RangeError("Dimension mismatch in multiplication. Length of A must match length of B (A is "+v[0]+", B is "+b[0]+v[0]+" != "+b[0]+")");return o(n,s)}if(2==b.length){if(v[0]!=b[0])throw new RangeError("Dimension mismatch in multiplication. Length of A must match rows of B (A is "+v[0]+", B is "+b[0]+"x"+b[1]+", "+v[0]+" != "+b[0]+")");return t(n,s)}throw new Error("Can only multiply a 1 or 2 dimensional matrix (B has "+b.length+" dimensions)")}if(2==v.length){if(1==b.length){if(v[1]!=b[0])throw new RangeError("Dimension mismatch in multiplication. Columns of A must match length of B (A is "+v[0]+"x"+v[0]+", B is "+b[0]+", "+v[1]+" != "+b[0]+")");return i(n,s)}if(2==b.length){if(v[1]!=b[0])throw new RangeError("Dimension mismatch in multiplication. Columns of A must match rows of B (A is "+v[0]+"x"+v[1]+", B is "+b[0]+"x"+b[1]+", "+v[1]+" != "+b[0]+")");return r(n,s)}throw new Error("Can only multiply a 1 or 2 dimensional matrix (B has "+b.length+" dimensions)")}throw new Error("Can only multiply a 1 or 2 dimensional matrix (A has "+v.length+" dimensions)")}return s instanceof c?(l=w(n,s.valueOf()),x(l)?new c(l):l):p.deepMap2(n,s,w)}if(n instanceof c)return s instanceof c?(l=w(n.valueOf(),s.valueOf()),x(l)?new c(l):l):(l=w(n.valueOf(),s),x(l)?new c(l):l);if(x(s))return p.deepMap2(n,s,w);if(s instanceof c)return new c(p.deepMap2(n,s.valueOf(),w));if(g(n))return w(+n,s);if(g(s))return w(n,+s);throw new e.error.UnsupportedTypeError("multiply",e["typeof"](n),e["typeof"](s))}}},function(e,r,n){e.exports=function(e){{var r=n(123),t=n(153),i=e.type.BigNumber,o=n(5),a=n(8),s=n(11),u=r.number.isNumber,f=r["boolean"].isBoolean,c=o.isComplex;s.isCollection}e.norm=function l(r,n){if(arguments.length<1||arguments.length>2)throw new e.error.ArgumentsError("abs",arguments.length,1,2);if(u(r))return Math.abs(r);if(c(r))return Math.sqrt(r.re*r.re+r.im*r.im);if(r instanceof i)return r.abs();if(f(r))return Math.abs(r);if(isArray(r)){var o=t.size(r);if(null==n&&(n=2),1==o.length){if(n===Number.POSITIVE_INFINITY||"inf"===n){var s;return e.forEach(r,function(r){var n=e.abs(r);(!s||e.larger(n,s))&&(s=n)}),s}if(n===Number.NEGATIVE_INFINITY||"-inf"===n){var s;return e.forEach(r,function(r){var n=e.abs(r);(!s||e.smaller(n,s))&&(s=n)}),s}if("fro"===n)return l(r);if(u(n)&&!isNaN(n)){if(!e.equal(n,0)){var s=0;return e.forEach(r,function(r){s=e.add(e.pow(e.abs(r),n),s)}),e.pow(s,1/n)}return Number.POSITIVE_INFINITY}throw new Error("Unsupported parameter value")}if(2==o.length){if(1==n){for(var p=[],m=0;m<r.length;m++)for(var h=r[m],g=0;g<h.length;g++)p[g]=e.add(p[g]||0,e.abs(h[g]));return e.max(p)}if(n==Number.POSITIVE_INFINITY||"inf"===n){for(var s=0,m=0;m<r.length;m++){for(var d=0,h=r[m],g=0;g<h.length;g++)d=e.add(d,e.abs(h[g]));e.larger(d,s)&&(s=d)}return s}if("fro"===n){var x=e.diag(e.multiply(e.transpose(r),r)),y=0;return e.forEach(x,function(r){y=e.add(r,y)}),e.sqrt(y)
}if(2==n)throw new Error("Unsupported parameter value, missing implementation of matrix singular value decomposition");throw new Error("Unsupported parameter value")}}if(r instanceof a)return l(r.valueOf(),n);throw new e.error.UnsupportedTypeError("norm",r)}}},function(e,r,n){e.exports=function(e){function r(r,n){var t=e.log(r),i=e.multiply(t,n);return e.exp(i)}var t=n(123),i=e.type.BigNumber,o=n(5),a=n(8),s=(n(11),t.array),u=t.number.isNumber,f=t["boolean"].isBoolean,c=Array.isArray,l=t.number.isInteger,p=o.isComplex;e.pow=function m(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("pow",arguments.length,2);if(u(n)){if(u(t))return l(t)||n>=0?Math.pow(n,t):r(new o(n,0),new o(t,0));if(p(t))return r(new o(n,0),t)}if(p(n)){if(u(t))return r(n,new o(t,0));if(p(t))return r(n,t)}if(n instanceof i)return u(t)?t=i.convert(t):f(t)&&(t=new i(t?1:0)),t instanceof i?t.isInteger()&&!n.isNegative()?n.pow(t):m(n.toNumber(),t.toNumber()):m(n.toNumber(),t);if(t instanceof i)return u(n)?n=i.convert(n):f(n)&&(n=new i(n?1:0)),n instanceof i?t.isInteger()&&!n.isNegative()?n.pow(t):m(n.toNumber(),t.toNumber()):m(n,t.toNumber());if(c(n)){if(!u(t)||!l(t)||0>t)throw new TypeError("For A^b, b must be a positive integer (value is "+t+")");var h=s.size(n);if(2!=h.length)throw new Error("For A^b, A must be 2 dimensional (A has "+h.length+" dimensions)");if(h[0]!=h[1])throw new Error("For A^b, A must be square (size is "+h[0]+"x"+h[1]+")");for(var g=e.eye(h[0]).valueOf(),d=n;t>=1;)1==(1&t)&&(g=e.multiply(d,g)),t>>=1,d=e.multiply(d,d);return g}if(n instanceof a)return new a(m(n.valueOf(),t));if(f(n))return m(+n,t);if(f(t))return m(n,+t);throw new e.error.UnsupportedTypeError("pow",e["typeof"](n),e["typeof"](t))}}},function(e,r,n){e.exports=function(e){function r(e,r){var n=Math.pow(10,r);return Math.round(e*n)/n}var t=n(123),i=e.type.BigNumber,o=n(5),a=n(11),s=t.number.isNumber,u=t.number.isInteger,f=t["boolean"].isBoolean,c=o.isComplex,l=a.isCollection;e.round=function p(n,t){if(1!=arguments.length&&2!=arguments.length)throw new e.error.ArgumentsError("round",arguments.length,1,2);if(void 0==t){if(s(n))return Math.round(n);if(c(n))return new o(Math.round(n.re),Math.round(n.im));if(n instanceof i)return n.toDecimalPlaces(0);if(l(n))return a.deepMap(n,p);if(f(n))return Math.round(n);throw new e.error.UnsupportedTypeError("round",e["typeof"](n))}if(!s(t)||!u(t)){if(!(t instanceof i)){if(f(t))return p(n,+t);throw new TypeError("Number of decimals in function round must be an integer")}t=parseFloat(t.valueOf())}if(0>t||t>15)throw new Error("Number of decimals in function round must be in te range of 0-15");if(s(n))return r(n,t);if(c(n))return new o(r(n.re,t),r(n.im,t));if(n instanceof i)return n.toDecimalPlaces(t);if(l(n)||l(t))return a.deepMap2(n,t,p);if(f(n))return p(+n,t);throw new e.error.UnsupportedTypeError("round",e["typeof"](n),e["typeof"](t))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number,s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isCollection;e.sign=function l(r){if(1!=arguments.length)throw new e.error.ArgumentsError("sign",arguments.length,1);if(s(r))return a.sign(r);if(f(r)){var n=Math.sqrt(r.re*r.re+r.im*r.im);return new i(r.re/n,r.im/n)}if(r instanceof t)return new t(r.cmp(0));if(c(r))return o.deepMap(r,l);if(u(r))return a.sign(r);throw new e.error.UnsupportedTypeError("sign",e["typeof"](r))}}},function(e,r,n){e.exports=function(e,r){var t=n(123),i=e.type.BigNumber,o=n(5),a=n(9),s=n(11),u=t.number.isNumber,f=t.number.nearlyEqual,c=t["boolean"].isBoolean,l=t.string.isString,p=o.isComplex,m=a.isUnit,h=s.isCollection;e.smaller=function g(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("smaller",arguments.length,2);if(u(n)&&u(t))return!f(n,t,r.epsilon)&&t>n;if(n instanceof i)return u(t)?t=i.convert(t):c(t)&&(t=new i(t?1:0)),t instanceof i?n.lt(t):g(n.toNumber(),t);if(t instanceof i)return u(n)?n=i.convert(n):c(n)&&(n=new i(n?1:0)),n instanceof i?n.lt(t):g(n,t.toNumber());if(m(n)&&m(t)){if(!n.equalBase(t))throw new Error("Cannot compare units with different base");return n.value<t.value}if(h(n)||h(t))return s.deepMap2(n,t,g);if(l(n)||l(t))return t>n;if(c(n))return g(+n,t);if(c(t))return g(n,+t);if(p(n)||p(t))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("smaller",e["typeof"](n),e["typeof"](t))}}},function(e,r,n){e.exports=function(e,r){var t=n(123),i=e.type.BigNumber,o=n(5),a=n(9),s=n(11),u=t.number.isNumber,f=t.number.nearlyEqual,c=t["boolean"].isBoolean,l=t.string.isString,p=o.isComplex,m=a.isUnit,h=s.isCollection;e.smallereq=function g(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("smallereq",arguments.length,2);if(u(n)&&u(t))return f(n,t,r.epsilon)||t>n;if(n instanceof i)return u(t)?t=i.convert(t):c(t)&&(t=new i(t?1:0)),t instanceof i?n.lte(t):g(n.toNumber(),t);if(t instanceof i)return u(n)?n=i.convert(n):c(n)&&(n=new i(n?1:0)),n instanceof i?n.lte(t):g(n,t.toNumber());if(m(n)&&m(t)){if(!n.equalBase(t))throw new Error("Cannot compare units with different base");return n.value<=t.value}if(h(n)||h(t))return s.deepMap2(n,t,g);if(l(n)||l(t))return t>=n;if(c(n))return g(+n,t);if(c(t))return g(n,+t);if(p(n)||p(t))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("smallereq",e["typeof"](n),e["typeof"](t))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.sqrt=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("sqrt",arguments.length,1);if(a(r))return r>=0?Math.sqrt(r):c(new i(r,0));if(u(r)){var n=Math.sqrt(r.re*r.re+r.im*r.im);return r.im>=0?new i(.5*Math.sqrt(2*(n+r.re)),.5*Math.sqrt(2*(n-r.re))):new i(.5*Math.sqrt(2*(n+r.re)),-.5*Math.sqrt(2*(n-r.re)))}if(r instanceof t)return r.isNegative()?c(r.toNumber()):r.sqrt();if(f(r))return o.deepMap(r,c);if(s(r))return c(+r);throw new e.error.UnsupportedTypeError("sqrt",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.square=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("square",arguments.length,1);if(a(r))return r*r;if(u(r))return e.multiply(r,r);if(r instanceof t)return r.times(r);if(f(r))return o.deepMap(r,c);if(s(r))return r*r;throw new e.error.UnsupportedTypeError("square",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=(n(8),n(9)),a=n(11),s=r["boolean"].isBoolean,u=r.number.isNumber,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.subtract=function p(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("subtract",arguments.length,2);if(u(r)){if(u(n))return r-n;if(f(n))return new i(r-n.re,-n.im)}else if(f(r)){if(u(n))return new i(r.re-n,r.im);if(f(n))return new i(r.re-n.re,r.im-n.im)}if(r instanceof t)return u(n)?n=t.convert(n):s(n)&&(n=new t(n?1:0)),n instanceof t?r.minus(n):p(r.toNumber(),n);if(n instanceof t)return u(r)?r=t.convert(r):s(r)&&(r=new t(r?1:0)),r instanceof t?r.minus(n):p(r,n.toNumber());if(c(r)&&c(n)){if(null==r.value)throw new Error("Parameter x contains a unit with undefined value");if(null==n.value)throw new Error("Parameter y contains a unit with undefined value");if(!r.equalBase(n))throw new Error("Units do not match");var o=r.clone();return o.value-=n.value,o.fixPrefix=!1,o}if(l(r)||l(n))return a.deepMap2(r,n,p);if(s(r))return p(+r,n);if(s(n))return p(r,+n);throw new e.error.UnsupportedTypeError("subtract",e["typeof"](r),e["typeof"](n))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(9),a=n(11),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.unary=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("unary",arguments.length,1);if(s(r))return-r;if(f(r))return new i(-r.re,-r.im);if(r instanceof t)return r.neg();if(c(r)){var n=r.clone();return n.value=-r.value,n}if(l(r))return a.deepMap(r,p);if(u(r))return-r;throw new e.error.UnsupportedTypeError("unary",e["typeof"](r))}}},function(e,r,n){e.exports=function(e,r){var t=n(123),i=e.type.BigNumber,o=n(5),a=n(9),s=n(11),u=t.number.isNumber,f=t.number.nearlyEqual,c=t["boolean"].isBoolean,l=t.string.isString,p=o.isComplex,m=a.isUnit,h=s.isCollection;e.unequal=function g(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("unequal",arguments.length,2);if(u(n)){if(u(t))return!f(n,t,r.epsilon);if(p(t))return!f(n,t.re,r.epsilon)||!f(t.im,0,r.epsilon)}if(p(n)){if(u(t))return!f(n.re,t,r.epsilon)||!f(n.im,0,r.epsilon);if(p(t))return!f(n.re,t.re,r.epsilon)||!f(n.im,t.im,r.epsilon)}if(n instanceof i)return u(t)?t=i.convert(t):c(t)&&(t=new i(t?1:0)),t instanceof i?!n.eq(t):g(n.toNumber(),t);if(t instanceof i)return u(n)?n=i.convert(n):c(n)&&(n=new i(n?1:0)),n instanceof i?!n.eq(t):g(n,t.toNumber());if(m(n)&&m(t)){if(!n.equalBase(t))throw new Error("Cannot compare units with different base");return n.value!=t.value}if(h(n)||h(t))return s.deepMap2(n,t,g);if(l(n)||l(t))return n!=t;if(c(n))return g(+n,t);if(c(t))return g(n,+t);throw new e.error.UnsupportedTypeError("unequal",e["typeof"](n),e["typeof"](t))}}},function(e,r,n){e.exports=function(e){function r(e,r){for(var n,t,i,o=0,a=1,s=1,u=0;r;)t=Math.floor(e/r),i=e%r,n=o,o=a-t*o,a=n,n=s,s=u-t*s,u=n,e=r,r=i;return 0>e?[-e,-a,-u]:[e,e?a:0,u]}var t=n(123),i=e.type.BigNumber,o=t.number.isNumber,a=t["boolean"].isBoolean,s=t.number.isInteger;e.xgcd=function u(n,t){if(2==arguments.length){if(o(n)&&o(t)){if(!s(n)||!s(t))throw new Error("Parameters in function xgcd must be integer numbers");return r(n,t)}if(n instanceof i)return u(n.toNumber(),t);if(t instanceof i)return u(n,t.toNumber());if(a(n))return u(+n,t);if(a(t))return u(n,+t);throw new e.error.UnsupportedTypeError("xgcd",e["typeof"](n),e["typeof"](t))}throw new SyntaxError("Function xgcd expects two arguments")}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number.isNumber,s=r["boolean"].isBoolean,u=o.isCollection,f=i.isComplex;e.arg=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("arg",arguments.length,1);if(a(r))return Math.atan2(0,r);if(f(r))return Math.atan2(r.im,r.re);if(u(r))return o.deepMap(r,c);if(s(r))return c(+r);if(r instanceof t)return c(r.toNumber());throw new e.error.UnsupportedTypeError("arg",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.object,s=r.number.isNumber,u=r["boolean"].isBoolean,f=o.isCollection,c=i.isComplex;e.conj=function l(r){if(1!=arguments.length)throw new e.error.ArgumentsError("conj",arguments.length,1);return s(r)?r:r instanceof t?new t(r):c(r)?new i(r.re,-r.im):f(r)?o.deepMap(r,l):u(r)?+r:a.clone(r)}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.object,s=r.number.isNumber,u=r["boolean"].isBoolean,f=o.isCollection,c=i.isComplex;e.re=function l(r){if(1!=arguments.length)throw new e.error.ArgumentsError("re",arguments.length,1);return s(r)?r:r instanceof t?new t(r):c(r)?r.re:f(r)?o.deepMap(r,l):u(r)?+r:a.clone(r)}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number.isNumber,s=r["boolean"].isBoolean,u=o.isCollection,f=i.isComplex;e.im=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("im",arguments.length,1);return a(r)?0:r instanceof t?new t(0):f(r)?r.im:u(r)?o.deepMap(r,c):s(r)?0:0}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(11),o=i.isCollection,a=r.number.isNumber,s=r.string.isString,u=r["boolean"].isBoolean;e.bignumber=function f(r){if(arguments.length>1)throw new e.error.ArgumentsError("bignumber",arguments.length,0,1);if(r instanceof t||a(r)||s(r))return new t(r);if(u(r))return new t(+r);if(o(r))return i.deepMap(r,f);if(0==arguments.length)return new t(0);throw new e.error.UnsupportedTypeError("bignumber",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(11),o=i.isCollection,a=r.number.isNumber,s=r.string.isString;e["boolean"]=function u(r){if(1!=arguments.length)throw new e.error.ArgumentsError("boolean",arguments.length,0,1);if("true"===r||r===!0)return!0;if("false"===r||r===!1)return!1;if(r instanceof Boolean)return 1==r;if(a(r))return 0!==r;if(r instanceof t)return!r.isZero();if(s(r)){var n=r.toLowerCase();if("true"===n)return!0;if("false"===n)return!1;var f=Number(r);if(""!=r&&!isNaN(f))return 0!==f}if(o(r))return i.deepMap(r,u);throw new SyntaxError(r.toString()+" is no valid boolean")}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=o.isCollection,s=r.number.isNumber,u=r.string.isString,f=i.isComplex;e.complex=function c(){switch(arguments.length){case 0:return new i(0,0);case 1:var r=arguments[0];if(s(r))return new i(r,0);if(r instanceof t)return new i(r.toNumber(),0);if(f(r))return r.clone();if(u(r)){var n=i.parse(r);if(n)return n;throw new SyntaxError('String "'+r+'" is no valid complex number')}if(a(r))return o.deepMap(r,c);if("object"==typeof r){if("re"in r&&"im"in r)return new i(r.re,r.im);if("r"in r&&"phi"in r)return i.fromPolar(r.r,r.phi)}throw new TypeError("Two numbers, single string or an fitting object expected in function complex");case 2:var l=arguments[0],p=arguments[1];if(l instanceof t&&(l=l.toNumber()),p instanceof t&&(p=p.toNumber()),s(l)&&s(p))return new i(l,p);throw new TypeError("Two numbers or a single string expected in function complex");default:throw new e.error.ArgumentsError("complex",arguments.length,0,2)}}}},function(e,r,n){e.exports=function(e){var r=(n(123),e.type.BigNumber),t=n(7);e.index=function(){var e=new t,n=Array.prototype.slice.apply(arguments).map(function(e){return e instanceof r?e.toNumber():Array.isArray(e)?e.map(function(e){return e instanceof r?e.toNumber():e}):e});return t.apply(e,n),e}}},function(e,r,n){e.exports=function(e){var r=(n(123),n(8));e.matrix=function(n){if(arguments.length>1)throw new e.error.ArgumentsError("matrix",arguments.length,0,1);return new r(n)}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(11),o=i.isCollection,a=r.number.isNumber,s=r["boolean"].isBoolean,u=r.string.isString;e.number=function f(r){switch(arguments.length){case 0:return 0;case 1:if(o(r))return i.deepMap(r,f);if(r instanceof t)return r.toNumber();if(u(r)){var n=Number(r);if(isNaN(n)&&(n=Number(r.valueOf())),isNaN(n))throw new SyntaxError(r.toString()+" is no valid number");return n}if(s(r))return r+0;if(a(r))return r;throw new e.error.UnsupportedTypeError("number",e["typeof"](r));default:throw new e.error.ArgumentsError("number",arguments.length,0,1)}}}},function(e,r,n){e.exports=function(e){var r=n(13);e.parser=function(){return new r(e)}}},function(e){e.exports=function(e){e.select=function(r){return new e.chaining.Selector(r)}}},function(e,r,n){e.exports=function(e){var r=n(123),t=n(11),i=r.number,o=r.number.isNumber,a=t.isCollection;e.string=function s(r){switch(arguments.length){case 0:return"";case 1:return o(r)?i.format(r):a(r)?t.deepMap(r,s):null===r?"null":r.toString();default:throw new e.error.ArgumentsError("string",arguments.length,0,1)}}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(9),o=n(11),a=o.isCollection,s=r.string.isString;e.unit=function u(r){switch(arguments.length){case 1:var n=arguments[0];if(n instanceof i)return n.clone();if(s(n)){if(i.isValuelessUnit(n))return new i(null,n);var f=i.parse(n);if(f)return f;throw new SyntaxError('String "'+n+'" is no valid unit')}if(a(r))return o.deepMap(r,u);throw new TypeError("A string or a number and string expected in function unit");case 2:return arguments[0]instanceof t?new i(arguments[0].toNumber(),arguments[1]):new i(arguments[0],arguments[1]);default:throw new e.error.ArgumentsError("unit",arguments.length,1,2)}}}},function(e,r,n){e.exports=function(e){function r(n,t,i,o){if(i>o){if(n.length!=t.length)throw new e.error.DimensionError(n.length,t.length);for(var a=[],s=0;s<n.length;s++)a[s]=r(n[s],t[s],i,o+1);return a}return n.concat(t)}var t=n(123),i=n(8),o=n(11),a=t.object,s=t.array,u=t.number.isNumber,f=t.number.isInteger,c=o.isCollection;e.concat=function(){var n,t,o=arguments.length,l=-1,p=!1,m=[];for(n=0;o>n;n++){var h=arguments[n];if(h instanceof i&&(p=!0),n==o-1&&u(h)){if(t=l,l=h,!f(l)||0>l)throw new TypeError("Dimension number must be a positive integer (dim = "+l+")");if(n>0&&l>t)throw new e.error.DimensionError(l,t,">")}else{if(!c(h))throw new e.error.UnsupportedTypeError("concat",e["typeof"](h));var g=a.clone(h).valueOf(),d=s.size(h.valueOf());if(m[n]=g,t=l,l=d.length-1,n>0&&l!=t)throw new e.error.DimensionError(l,t)}}if(0==m.length)throw new SyntaxError("At least one matrix expected");for(var x=m.shift();m.length;)x=r(x,m.shift(),l,0);return p?new i(x):x}}},function(e,r,n){e.exports=function(e){function r(r,n){function t(r){var n,t,i=new Array(r.length),o=0;for(n=1;n<r.length;n++)o=e.add(o,r[n][n]);for(n=0;n<r.length;n++){for(i[n]=new Array(r.length),i[n][n]=e.unary(o),t=0;n>t;t++)i[n][t]=0;for(t=n+1;t<r.length;t++)i[n][t]=r[n][t];n+1<r.length&&(o=e.subtract(o,r[n+1][n+1]))}return i}if(1==n)return o.clone(r[0][0]);if(2==n)return e.subtract(e.multiply(r[0][0],r[1][1]),e.multiply(r[1][0],r[0][1]));for(var i=r,a=0;n-1>a;a++)i=e.multiply(t(i),r);return n%2==0?e.unary(i[0][0]):i[0][0]}var t=n(123),i=n(8),o=t.object,a=t.string;e.det=function(n){if(1!=arguments.length)throw new e.error.ArgumentsError("det",arguments.length,1);var t;switch(n instanceof i?t=n.size():n instanceof Array?(n=new i(n),t=n.size()):t=[],t.length){case 0:return o.clone(n);case 1:if(1==t[0])return o.clone(n.valueOf()[0]);throw new RangeError("Matrix must be square (size: "+a.format(t)+")");case 2:var s=t[0],u=t[1];if(s==u)return r(n.clone().valueOf(),s,u);throw new RangeError("Matrix must be square (size: "+a.format(t)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+a.format(t)+")")}}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(8),o=r.object,a=r.array.isArray,s=r.number.isNumber,u=r.number.isInteger;e.diag=function(r,n){var f,c,l,p;if(1!=arguments.length&&2!=arguments.length)throw new e.error.ArgumentsError("diag",arguments.length,1,2);if(n){if(n instanceof t&&(n=n.toNumber()),!s(n)||!u(n))throw new TypeError("Second parameter in function diag must be an integer")}else n=0;var m,h=n>0?n:0,g=0>n?-n:0;if(r instanceof i)m=!1;else{if(!a(r))throw new TypeError("First parameter in function diag must be a Matrix or Array");r=new i(r),m=!0}var d=r.size();switch(d.length){case 1:c=r.valueOf();var x=new i,y=c[0]instanceof t?new t(0):0;for(x.resize([c.length+g,c.length+h],y),f=x.valueOf(),p=c.length,l=0;p>l;l++)f[l+g][l+h]=o.clone(c[l]);return m?x.valueOf():x;case 2:for(c=[],f=r.valueOf(),p=Math.min(d[0]-g,d[1]-h),l=0;p>l;l++)c[l]=o.clone(f[l+g][l+h]);return m?c:new i(c);default:throw new RangeError("Matrix for function diag must be 2 dimensional")}}}},function(e,r,n){e.exports=function(e,r){var t=n(123),i=e.type.BigNumber,o=n(8),a=n(11),s=t.number.isNumber,u=t.number.isInteger,f=Array.isArray;e.eye=function(n){var t=a.argsToArray(arguments),c=n instanceof o?!0:f(n)?!1:"matrix"===r.matrix;if(0==t.length)return c?new o:[];if(1==t.length)t[1]=t[0];else if(t.length>2)throw new e.error.ArgumentsError("eye",t.length,0,2);var l=t[0],p=t[1];if(l instanceof i&&(l=l.toNumber()),p instanceof i&&(p=p.toNumber()),!s(l)||!u(l)||1>l)throw new Error("Parameters in function eye must be positive integers");if(!s(p)||!u(p)||1>p)throw new Error("Parameters in function eye must be positive integers");var m=!1;t=t.map(function(e){return e instanceof i?(m=!0,e.toNumber()):e});var h=new o,g=m?new i(1):1,d=m?new i(0):0;h.resize(t,d);for(var x=e.min(t),y=h.valueOf(),w=0;x>w;w++)y[w][w]=g;return c?h:h.valueOf()}}},function(e,r,n){e.exports=function(e){function r(r,n,t){var i,o,a,s,u;if(1==n){if(s=r[0][0],0==s)throw Error("Cannot calculate inverse, determinant is zero");return[[e.divide(1,s)]]}if(2==n){var f=e.det(r);if(0==f)throw Error("Cannot calculate inverse, determinant is zero");return[[e.divide(r[1][1],f),e.divide(e.unary(r[0][1]),f)],[e.divide(e.unary(r[1][0]),f),e.divide(r[0][0],f)]]}var c=r.concat();for(i=0;n>i;i++)c[i]=c[i].concat();for(var l=e.eye(n).valueOf(),p=0;t>p;p++){for(i=p;n>i&&0==c[i][p];)i++;if(i==n||0==c[i][p])throw Error("Cannot calculate inverse, determinant is zero");i!=p&&(u=c[p],c[p]=c[i],c[i]=u,u=l[p],l[p]=l[i],l[i]=u);var m=c[p],h=l[p];for(i=0;n>i;i++){var g=c[i],d=l[i];if(i!=p){if(0!=g[p]){for(a=e.divide(e.unary(g[p]),m[p]),o=p;t>o;o++)g[o]=e.add(g[o],e.multiply(a,m[o]));for(o=0;t>o;o++)d[o]=e.add(d[o],e.multiply(a,h[o]))}}else{for(a=m[p],o=p;t>o;o++)g[o]=e.divide(g[o],a);for(o=0;t>o;o++)d[o]=e.divide(d[o],a)}}}return l}var t=n(123),i=t.string,o=n(8);e.inv=function(n){if(1!=arguments.length)throw new e.error.ArgumentsError("inv",arguments.length,1);var t=e.size(n).valueOf();switch(t.length){case 0:return e.divide(1,n);case 1:if(1==t[0])return n instanceof o?new o([e.divide(1,n.valueOf()[0])]):[e.divide(1,n[0])];throw new RangeError("Matrix must be square (size: "+i.format(t)+")");case 2:var a=t[0],s=t[1];if(a==s)return n instanceof o?new o(r(n.valueOf(),a,s)):r(n,a,s);throw new RangeError("Matrix must be square (size: "+i.format(t)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+i.format(t)+")")}}}},function(e,r,n){e.exports=function(e,r){var t=n(123),i=e.type.BigNumber,o=n(8),a=n(11),s=t.array,u=Array.isArray;e.ones=function(e){var n=a.argsToArray(arguments),t=e instanceof o?!0:u(e)?!1:"matrix"===r.matrix;if(0==n.length)return t?new o:[];var f=!1;n=n.map(function(e){return e instanceof i?(f=!0,e.toNumber()):e});var c=[],l=f?new i(1):1;return c=s.resize(c,n,l),t?new o(c):c}}},function(e,r,n){e.exports=function(e,r){function t(e,r,n){var t=[],i=e;if(n>0)for(;r>i;)t.push(i),i+=n;else if(0>n)for(;i>r;)t.push(i),i+=n;return t}function i(e,r,n){var t=[],i=e;if(n>0)for(;r>=i;)t.push(i),i+=n;else if(0>n)for(;i>=r;)t.push(i),i+=n;return t}function o(e,r,n){var t=[],i=e.clone(),o=new f(0);if(n.gt(o))for(;i.lt(r);)t.push(i),i=i.plus(n);else if(n.lt(o))for(;i.gt(r);)t.push(i),i=i.plus(n);return t}function a(e,r,n){var t=[],i=e.clone(),o=new f(0);if(n.gt(o))for(;i.lte(r);)t.push(i),i=i.plus(n);else if(n.lt(o))for(;i.gte(r);)t.push(i),i=i.plus(n);return t}function s(e){var n=e.split(":"),t=null;if("bignumber"===r.number)try{t=n.map(function(e){return new f(e)})}catch(i){return null}else{t=n.map(function(e){return Number(e)});var o=t.some(function(e){return isNaN(e)});if(o)return null}switch(t.length){case 2:return{start:t[0],end:t[1],step:1};case 3:return{start:t[0],end:t[2],step:t[1]};default:return null}}var u=n(123),f=e.type.BigNumber,c=n(8),l=(n(11),u["boolean"].isBoolean),p=u.string.isString,m=u.number.isNumber;e.range=function(){var n,u,h,g=Array.prototype.slice.call(arguments),d=!1;switch(l(g[g.length-1])&&(d=g.pop()?!0:!1),g.length){case 1:if(!p(g[0]))throw new TypeError("Two or three numbers or a single string expected in function range");var x=s(g[0]);if(!x)throw new SyntaxError('String "'+g[0]+'" is no valid range');n=x.start,u=x.end,h=x.step;break;case 2:n=g[0],u=g[1],h=1;break;case 3:n=g[0],u=g[1],h=g[2];break;case 4:throw new TypeError("Parameter includeEnd must be a boolean");default:throw new e.error.ArgumentsError("range",arguments.length,2,4)}if(!(m(n)||n instanceof f))throw new TypeError("Parameter start must be a number");if(!(m(u)||u instanceof f))throw new TypeError("Parameter end must be a number");if(!(m(h)||h instanceof f))throw new TypeError("Parameter step must be a number");if(n instanceof f||u instanceof f||h instanceof f){var y=!0;n instanceof f||(n=f.convert(n)),u instanceof f||(u=f.convert(u)),h instanceof f||(h=f.convert(h)),n instanceof f&&u instanceof f&&h instanceof f||(y=!1,n instanceof f&&(n=n.toNumber()),u instanceof f&&(u=u.toNumber()),h instanceof f&&(h=h.toNumber()))}var w=y?d?a:o:d?i:t,v=w(n,u,h);return"array"===r.matrix?v:new c(v)}}},function(e,r,n){e.exports=function(e,r){function t(r,n,t){if(void 0!==t){if(!c(t)||1!==t.length)throw new TypeError("Single character expected as defaultValue")}else t=" ";if(1!==n.length)throw new e.error.DimensionError(n.length,1);var i=n[0];if(!l(i)||!p(i))throw new TypeError("Invalid size, must contain positive integers (size: "+f.format(n)+")");if(r.length>i)return r.substring(0,i);if(r.length<i){for(var o=r,a=0,s=i-r.length;s>a;a++)o+=t;return o}return r}var i=n(123),o=e.type.BigNumber,a=n(8),s=i.array,u=i.object.clone,f=i.string,c=i.string.isString,l=i.number.isNumber,p=i.number.isInteger,m=s.isArray;e.resize=function(n,i,f){if(2!=arguments.length&&3!=arguments.length)throw new e.error.ArgumentsError("resize",arguments.length,2,3);var l=n instanceof a?!0:m(n)?!1:"array"!==r.matrix;if(n instanceof a&&(n=n.valueOf()),i instanceof a&&(i=i.valueOf()),i.length&&i[0]instanceof o&&(i=i.map(function(e){return e instanceof o?e.toNumber():e})),c(n))return t(n,i,f);if(0==i.length){for(;m(n);)n=n[0];return u(n)}m(n)||(n=[n]),n=u(n);var p=s.resize(n,i,f);return l?new a(p):p}}},function(e,r,n){e.exports=function(e,r){var t=n(123),i=e.type.BigNumber,o=n(5),a=n(9),s=n(8),u=t.array,f=t.number.isNumber,c=t["boolean"].isBoolean,l=t.string.isString,p=o.isComplex,m=a.isUnit;e.size=function(n){if(1!=arguments.length)throw new e.error.ArgumentsError("size",arguments.length,1);var t="array"===r.matrix;if(f(n)||p(n)||m(n)||c(n)||null==n||n instanceof i)return t?[]:new s([]);if(l(n))return t?[n.length]:new s([n.length]);if(Array.isArray(n))return u.size(n);if(n instanceof s)return new s(n.size());throw new e.error.UnsupportedTypeError("size",e["typeof"](n))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=n(8),i=r.object,o=r.array,a=Array.isArray;e.squeeze=function(r){if(1!=arguments.length)throw new e.error.ArgumentsError("squeeze",arguments.length,1);if(a(r))return o.squeeze(i.clone(r));if(r instanceof t){var n=o.squeeze(r.toArray());return a(n)?new t(n):n}return i.clone(r)}}},function(e,r,n){e.exports=function(e){function r(r,n){var i,o;if(l(r))return i=new s(r),o=i.subset(n),o.valueOf();if(r instanceof s)return r.subset(n);if(c(r))return t(r,n);throw new e.error.UnsupportedTypeError("subset",e["typeof"](r))}function t(r,n){if(!(n instanceof u))throw new TypeError("Index expected");if(1!=n.size().length)throw new e.error.DimensionError(n.size().length,1);var t=n.range(0),i="",o=r.length;return t.forEach(function(e){f.validateIndex(e,o),i+=r.charAt(e)}),i}function i(r,n,t,i){var a;if(l(r))return a=new s(e.clone(r)),a.subset(n,t,i),a.valueOf();if(r instanceof s)return r.clone().subset(n,t,i);if(c(r))return o(r,n,t,i);throw new e.error.UnsupportedTypeError("subset",e["typeof"](r))}function o(r,n,t,i){if(!(n instanceof u))throw new TypeError("Index expected");if(1!=n.size().length)throw new e.error.DimensionError(n.size().length,1);if(void 0!==i){if(!c(i)||1!==i.length)throw new TypeError("Single character expected as defaultValue")}else i=" ";var o=n.range(0),a=o.size()[0];if(a!=t.length)throw new e.error.DimensionError(o.size()[0],t.length);for(var s=r.length,l=[],p=0;s>p;p++)l[p]=r.charAt(p);if(o.forEach(function(e,r){f.validateIndex(e),l[e]=t.charAt(r)}),l.length>s)for(p=s-1,a=l.length;a>p;p++)l[p]||(l[p]=i);return l.join("")}var a=n(123),s=n(8),u=n(7),f=a.array,c=a.string.isString,l=Array.isArray;e.subset=function(){switch(arguments.length){case 2:return r(arguments[0],arguments[1]);case 3:case 4:return i(arguments[0],arguments[1],arguments[2],arguments[3]);default:throw new e.error.ArgumentsError("subset",arguments.length,2,4)}}}},function(e,r,n){e.exports=function(e){var r=n(123),t=n(8),i=r.object,o=r.string;e.transpose=function(r){if(1!=arguments.length)throw new e.error.ArgumentsError("transpose",arguments.length,1);var n=e.size(r).valueOf();switch(n.length){case 0:return i.clone(r);case 1:return i.clone(r);case 2:var a,s=n[1],u=n[0],f=r instanceof t,c=r.valueOf(),l=[],p=i.clone;if(0===s)throw new RangeError("Cannot transpose a 2D matrix with no rows(size: "+o.format(n)+")");for(var m=0;s>m;m++){a=l[m]=[];for(var h=0;u>h;h++)a[h]=p(c[h][m])}return f?new t(l):l;default:throw new RangeError("Matrix must be two dimensional (size: "+o.format(n)+")")}}}},function(e,r,n){e.exports=function(e,r){var t=n(123),i=e.type.BigNumber,o=n(8),a=n(11),s=t.array,u=Array.isArray;e.zeros=function(e){var n=a.argsToArray(arguments),t=e instanceof o?!0:u(e)?!1:"matrix"===r.matrix;if(0==n.length)return t?new o:[];var f=!1;n=n.map(function(e){return e instanceof i?(f=!0,e.toNumber()):e});var c=[],l=f?new i(0):0;return c=s.resize(c,n,l),t?new o(c):c}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(11),o=r.number.isNumber,a=r["boolean"].isBoolean,s=r.number.isInteger,u=i.isCollection;e.factorial=function c(r){var n,l;if(1!=arguments.length)throw new e.error.ArgumentsError("factorial",arguments.length,1);if(o(r)){if(!s(r)||0>r)throw new TypeError("Positive integer value expected in function factorial");for(n=r-1,l=r;n>1;)l*=n,n--;return 0==l&&(l=1),l}if(r instanceof t){if(!f(r))throw new TypeError("Positive integer value expected in function factorial");var p=new t(1);for(n=r.minus(p),l=r;n.gt(p);)l=l.times(n),n=n.minus(p);return l.equals(0)&&(l=p),l}if(a(r))return 1;if(u(r))return i.deepMap(r,c);throw new e.error.UnsupportedTypeError("factorial",e["typeof"](r))};var f=function(e){return e.isInteger()&&e.gte(0)}}},function(e,r,n){e.exports=function(e,r){var t=n(8),i=(n(11),{uniform:function(){return Math.random},normal:function(){return function(){for(var e,r,n=-1;0>n||n>1;)e=Math.random(),r=Math.random(),n=1/6*Math.pow(-2*Math.log(e),.5)*Math.cos(2*Math.PI*r)+.5;return n}}});e.distribution=function(n){if(!i.hasOwnProperty(n))throw new Error("unknown distribution "+n);var o=Array.prototype.slice.call(arguments,1),a=i[n].apply(this,o);return function(n){var i={random:function(n,i,a){var u,f,c;if(arguments.length>3)throw new e.error.ArgumentsError("random",arguments.length,0,3);if(1===arguments.length?Array.isArray(n)?u=n:c=n:2===arguments.length?Array.isArray(n)?u=n:(f=n,c=i):(u=n,f=i,c=a),void 0===c&&(c=1),void 0===f&&(f=0),void 0!==u){var l=s(u,f,c,o);return"array"===r.matrix?l:new t(l)}return o(f,c)},randomInt:function(n,i,o){var u,f,c;if(arguments.length>3||arguments.length<1)throw new e.error.ArgumentsError("randomInt",arguments.length,1,3);if(1===arguments.length?c=n:2===arguments.length?"[object Array]"===Object.prototype.toString.call(n)?u=n:(f=n,c=i):(u=n,f=i,c=o),void 0===f&&(f=0),void 0!==u){var l=s(u,f,c,a);return"array"===r.matrix?l:new t(l)}return a(f,c)},pickRandom:function(r){if(1!==arguments.length)throw new e.error.ArgumentsError("pickRandom",arguments.length,1);if(!Array.isArray(r))throw new e.error.UnsupportedTypeError("pickRandom",e["typeof"](r));return r[Math.floor(Math.random()*r.length)]}},o=function(e,r){return e+n()*(r-e)},a=function(e,r){return Math.floor(e+n()*(r-e))},s=function(e,r,n,t){var i,o,a=[];if(e=e.slice(0),e.length>1)for(o=0,i=e.shift();i>o;o++)a.push(s(e,r,n,t));else for(o=0,i=e.shift();i>o;o++)a.push(t(r,n));return a};return i}(a)};var o=e.distribution("uniform");e.random=o.random,e.randomInt=o.randomInt,e.pickRandom=o.pickRandom}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=r.number.isNumber,o=r.number.isInteger;e.permutations=function(r,n){var s,u,f=arguments.length;if(f>2)throw new e.error.ArgumentsError("permutations",arguments.length,2);if(i(r)){if(!o(r)||0>r)throw new TypeError("Positive integer value expected in function permutations");if(1==f)return e.factorial(r);if(2==f&&i(n)){if(!o(n)||0>n)throw new TypeError("Positive integer value expected in function permutations");if(n>r)throw new TypeError("second argument k must be less than or equal to first argument n");for(s=1,u=r-n+1;r>=u;u++)s*=u;return s
}}if(r instanceof t){if(void 0===n&&a(r))return e.factorial(r);if(n=t.convert(n),!(n instanceof t&&a(r)&&a(n)))throw new TypeError("Positive integer value expected in function permutations");if(n.gt(r))throw new TypeError("second argument k must be less than or equal to first argument n");for(s=new t(1),u=r.minus(n).plus(1);u.lte(r);u=u.plus(1))s=s.times(u);return s}throw new e.error.UnsupportedTypeError("permutations",e["typeof"](r))};var a=function(e){return e.isInteger()&&e.gte(0)}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=(n(11),r.number.isNumber),o=r.number.isInteger;e.combinations=function(r,n){var s,u,f,c,l=arguments.length;if(2!=l)throw new e.error.ArgumentsError("combinations",arguments.length,2);if(i(r)){if(!o(r)||0>r)throw new TypeError("Positive integer value enpected in function combinations");if(n>r)throw new TypeError("k must be less than or equal to n");for(s=Math.max(n,r-n),u=1,f=1;r-s>=f;f++)u=u*(s+f)/f;return u}if(r instanceof t){if(n=t.convert(n),!(n instanceof t&&a(r)&&a(n)))throw new TypeError("Positive integer value expected in function combinations");if(n.gt(r))throw new TypeError("k must be less than n in function combinations");for(s=r.minus(n),n.lt(s)&&(s=n),u=new t(1),f=new t(1),c=r.minus(s);f.lte(c);f=f.plus(1))u=u.times(s.plus(f)).dividedBy(f);return u}throw new e.error.UnsupportedTypeError("combinations",e["typeof"](r))};var a=function(e){return e.isInteger()&&e.gte(0)}}},function(e,r,n){e.exports=function(e){function r(r,n){return e.smaller(r,n)?r:n}function t(r){var n=void 0;if(i.deepForEach(r,function(r){(void 0===n||e.smaller(r,n))&&(n=r)}),void 0===n)throw new Error("Cannot calculate min of an empty array");return n}var i=(n(8),n(11)),o=i.isCollection;e.min=function(e){if(0==arguments.length)throw new SyntaxError("Function min requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return t(e);if(2==arguments.length)return i.reduce(arguments[0],arguments[1],r);throw new SyntaxError("Wrong number of parameters")}return t(arguments)}}},function(e,r,n){e.exports=function(e){function r(r,n){return e.larger(r,n)?r:n}function t(r){var n=void 0;if(i.deepForEach(r,function(r){(void 0===n||e.larger(r,n))&&(n=r)}),void 0===n)throw new Error("Cannot calculate max of an empty array");return n}var i=(n(8),n(11)),o=i.isCollection;e.max=function(e){if(0==arguments.length)throw new SyntaxError("Function max requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return t(e);if(2==arguments.length)return i.reduce(arguments[0],arguments[1],r);throw new SyntaxError("Wrong number of parameters")}return t(arguments)}}},function(e,r,n){e.exports=function(e){function r(r,n){var t;return t=i.reduce(r,n,e.add),e.divide(t,a(r)[n])}function t(r){var n=0,t=0;if(i.deepForEach(r,function(r){n=e.add(n,r),t++}),0===t)throw new Error("Cannot calculate mean of an empty array");return e.divide(n,t)}var i=(n(8),n(11)),o=i.isCollection,a=n(153).size;e.mean=function(e){if(0==arguments.length)throw new SyntaxError("Function mean requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return t(e);if(2==arguments.length)return r(arguments[0],arguments[1]);throw new SyntaxError("Wrong number of parameters")}return t(arguments)}}},function(e,r,n){e.exports=function(e){function r(r){var n=u(r);n.sort(e.compare);var o=n.length;if(0==o)throw new Error("Cannot calculate median of an empty array");if(o%2==0){var s=n[o/2-1],f=n[o/2];if(!(a(s)||s instanceof i||s instanceof t))throw new e.error.UnsupportedTypeError("median",e["typeof"](s));if(!(a(f)||f instanceof i||f instanceof t))throw new e.error.UnsupportedTypeError("median",e["typeof"](f));return e.divide(e.add(s,f),2)}var c=n[(o-1)/2];if(!(a(c)||c instanceof i||c instanceof t))throw new e.error.UnsupportedTypeError("median",e["typeof"](c));return c}var t=(n(8),n(9)),i=e.type.BigNumber,o=n(11),a=n(154).isNumber,s=o.isCollection,u=n(153).flatten;e.median=function(e){if(0==arguments.length)throw new SyntaxError("Function median requires one or more parameters (0 provided)");if(s(e)){if(1==arguments.length)return r(e.valueOf());throw 2==arguments.length?new Error("median(A, dim) is not yet supported"):new SyntaxError("Wrong number of parameters")}return r(Array.prototype.slice.call(arguments))}}},function(e,r,n){e.exports=function(e){function r(r){var n=void 0;if(t.deepForEach(r,function(r){n=void 0===n?r:e.multiply(n,r)}),void 0===n)throw new Error("Cannot calculate prod of an empty array");return n}var t=(n(8),n(11)),i=t.isCollection;e.prod=function(e){if(0==arguments.length)throw new SyntaxError("Function prod requires one or more parameters (0 provided)");if(i(e)){if(1==arguments.length)return r(e);throw 2==arguments.length?new Error("prod(A, dim) is not yet supported"):new SyntaxError("Wrong number of parameters")}return r(arguments)}}},function(e){e.exports=function(e){e.std=function(){if(0==arguments.length)throw new SyntaxError("Function std requires one or more parameters (0 provided)");var r=e["var"].apply(null,arguments);return e.sqrt(r)}}},function(e,r,n){e.exports=function(e){function r(r){var n=void 0;if(t.deepForEach(r,function(r){n=void 0===n?r:e.add(n,r)}),void 0===n)throw new Error("Cannot calculate sum of an empty array");return n}var t=(n(8),n(11)),i=t.isCollection;e.sum=function(e){if(0==arguments.length)throw new SyntaxError("Function sum requires one or more parameters (0 provided)");if(i(e)){if(1==arguments.length)return r(e);throw 2==arguments.length?new Error("sum(A, dim) is not yet supported"):new SyntaxError("Wrong number of parameters")}return r(arguments)}}},function(e,r,n){e.exports=function(e){function r(r,n){var o=0,a=0;if(i.deepForEach(r,function(r){o=e.add(o,r),a++}),0===a)throw new Error("Cannot calculate var of an empty array");var s=e.divide(o,a);switch(o=0,i.deepForEach(r,function(r){var n=e.subtract(r,s);o=e.add(o,e.multiply(n,n))}),n){case"uncorrected":return e.divide(o,a);case"biased":return e.divide(o,a+1);case"unbiased":var u=o instanceof t?new t(0):0;return 1==a?u:e.divide(o,a-1);default:throw new Error('Unknown normalization "'+n+'". Choose "unbiased" (default), "uncorrected", or "biased".')}}var t=(n(8),e.type.BigNumber),i=n(11),o=i.isCollection,a=n(138).isString,s="unbiased";e["var"]=function(e,n){if(0==arguments.length)throw new SyntaxError("Function var requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return r(e,s);if(2==arguments.length){if(!a(n))throw new Error("String expected for parameter normalization");return r(e,n)}throw new SyntaxError("Wrong number of parameters")}return r(arguments,s)}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.acos=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("acos",arguments.length,1);if(a(r))return r>=-1&&1>=r?Math.acos(r):c(new i(r,0));if(u(r)){var n=new i(r.im*r.im-r.re*r.re+1,-2*r.re*r.im),l=e.sqrt(n),p=new i(l.re-r.im,l.im+r.re),m=e.log(p);return new i(1.5707963267948966-m.im,m.re)}if(f(r))return o.deepMap(r,c);if(s(r))return Math.acos(r);if(r instanceof t)return c(r.toNumber());throw new e.error.UnsupportedTypeError("acos",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.asin=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("asin",arguments.length,1);if(a(r))return r>=-1&&1>=r?Math.asin(r):c(new i(r,0));if(u(r)){var n=r.re,l=r.im,p=new i(l*l-n*n+1,-2*n*l),m=e.sqrt(p),h=new i(m.re-l,m.im+n),g=e.log(h);return new i(g.im,-g.re)}if(f(r))return o.deepMap(r,c);if(s(r))return Math.asin(r);if(r instanceof t)return c(r.toNumber());throw new e.error.UnsupportedTypeError("asin",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.atan=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("atan",arguments.length,1);if(a(r))return Math.atan(r);if(u(r)){var n=r.re,l=r.im,p=n*n+(1-l)*(1-l),m=new i((1-l*l-n*n)/p,-2*n/p),h=e.log(m);return new i(-.5*h.im,.5*h.re)}if(f(r))return o.deepMap(r,c);if(s(r))return Math.atan(r);if(r instanceof t)return c(r.toNumber());throw new e.error.UnsupportedTypeError("atan",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(11),a=r.number.isNumber,s=r["boolean"].isBoolean,u=(i.isComplex,o.isCollection);e.atan2=function f(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("atan2",arguments.length,2);if(a(r)&&a(n))return Math.atan2(r,n);if(u(r)||u(n))return o.deepMap2(r,n,f);if(s(r))return f(+r,n);if(s(n))return f(r,+n);if(r instanceof t)return f(r.toNumber(),n);if(n instanceof t)return f(r,n.toNumber());throw new e.error.UnsupportedTypeError("atan2",e["typeof"](r),e["typeof"](n))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(9),a=n(11),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.cos=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("cos",arguments.length,1);if(s(r))return Math.cos(r);if(f(r))return new i(.5*Math.cos(r.re)*(Math.exp(-r.im)+Math.exp(r.im)),.5*Math.sin(r.re)*(Math.exp(-r.im)-Math.exp(r.im)));if(c(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cos is no angle");return Math.cos(r.value)}if(l(r))return a.deepMap(r,p);if(u(r))return Math.cos(r);if(r instanceof t)return p(r.toNumber());throw new e.error.UnsupportedTypeError("cos",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(9),a=n(11),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.cosh=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("cosh",arguments.length,1);if(s(r))return(Math.exp(r)+Math.exp(-r))/2;if(f(r)){var n=Math.exp(r.re),m=Math.exp(-r.re);return new i(Math.cos(r.im)*(n+m)/2,Math.sin(r.im)*(n-m)/2)}if(c(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cosh is no angle");return p(r.value)}if(l(r))return a.deepMap(r,p);if(u(r))return p(r?1:0);if(r instanceof t)return p(r.toNumber());throw new e.error.UnsupportedTypeError("cosh",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(9),a=n(11),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.cot=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("cot",arguments.length,1);if(s(r))return 1/Math.tan(r);if(f(r)){var n=Math.exp(-4*r.im)-2*Math.exp(-2*r.im)*Math.cos(2*r.re)+1;return new i(2*Math.exp(-2*r.im)*Math.sin(2*r.re)/n,(Math.exp(-4*r.im)-1)/n)}if(c(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cot is no angle");return 1/Math.tan(r.value)}if(l(r))return a.deepMap(r,p);if(u(r))return p(+r);if(r instanceof t)return p(r.toNumber());throw new e.error.UnsupportedTypeError("cot",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(9),a=n(11),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.coth=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("coth",arguments.length,1);if(s(r)){var n=Math.exp(2*r);return(n+1)/(n-1)}if(f(r)){var m=Math.exp(2*r.re),h=m*Math.cos(2*r.im),g=m*Math.sin(2*r.im),d=(h-1)*(h-1)+g*g;return new i(((h+1)*(h-1)+g*g)/d,-2*g/d)}if(c(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function coth is no angle");return p(r.value)}if(l(r))return a.deepMap(r,p);if(u(r))return p(r?1:0);if(r instanceof t)return p(r.toNumber());throw new e.error.UnsupportedTypeError("coth",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(9),a=n(11),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.csc=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("csc",arguments.length,1);if(s(r))return 1/Math.sin(r);if(f(r)){var n=.25*(Math.exp(-2*r.im)+Math.exp(2*r.im))-.5*Math.cos(2*r.re);return new i(.5*Math.sin(r.re)*(Math.exp(-r.im)+Math.exp(r.im))/n,.5*Math.cos(r.re)*(Math.exp(-r.im)-Math.exp(r.im))/n)}if(c(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csc is no angle");return 1/Math.sin(r.value)}if(l(r))return a.deepMap(r,p);if(u(r))return p(+r);if(r instanceof t)return p(r.toNumber());throw new e.error.UnsupportedTypeError("csc",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(9),a=n(11),s=r.number,u=r.number.isNumber,f=r["boolean"].isBoolean,c=i.isComplex,l=o.isUnit,p=a.isCollection;e.csch=function m(r){if(1!=arguments.length)throw new e.error.ArgumentsError("csch",arguments.length,1);if(u(r))return 0==r?Number.NaN:Math.abs(2/(Math.exp(r)-Math.exp(-r)))*s.sign(r);if(c(r)){var n=Math.exp(r.re),h=Math.exp(-r.re),g=Math.cos(r.im)*(n-h),d=Math.sin(r.im)*(n+h),x=g*g+d*d;return new i(2*g/x,-2*d/x)}if(l(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csch is no angle");return m(r.value)}if(p(r))return a.deepMap(r,m);if(f(r))return m(r?1:0);if(r instanceof t)return m(r.toNumber());throw new e.error.UnsupportedTypeError("csch",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(9),a=n(11),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.sec=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("sec",arguments.length,1);if(s(r))return 1/Math.cos(r);if(f(r)){var n=.25*(Math.exp(-2*r.im)+Math.exp(2*r.im))+.5*Math.cos(2*r.re);return new i(.5*Math.cos(r.re)*(Math.exp(-r.im)+Math.exp(r.im))/n,.5*Math.sin(r.re)*(Math.exp(r.im)-Math.exp(-r.im))/n)}if(c(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sec is no angle");return 1/Math.cos(r.value)}if(l(r))return a.deepMap(r,p);if(u(r))return p(+r);if(r instanceof t)return p(r.toNumber());throw new e.error.UnsupportedTypeError("sec",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(9),a=n(11),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.sech=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("sech",arguments.length,1);if(s(r))return 2/(Math.exp(r)+Math.exp(-r));if(f(r)){var n=Math.exp(r.re),m=Math.exp(-r.re),h=Math.cos(r.im)*(n+m),g=Math.sin(r.im)*(n-m),d=h*h+g*g;return new i(2*h/d,-2*g/d)}if(c(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sech is no angle");return p(r.value)}if(l(r))return a.deepMap(r,p);if(u(r))return p(r?1:0);if(r instanceof t)return p(r.toNumber());throw new e.error.UnsupportedTypeError("sech",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(9),a=n(11),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.sin=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("sin",arguments.length,1);if(s(r))return Math.sin(r);if(f(r))return new i(.5*Math.sin(r.re)*(Math.exp(-r.im)+Math.exp(r.im)),.5*Math.cos(r.re)*(Math.exp(r.im)-Math.exp(-r.im)));if(c(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sin is no angle");return Math.sin(r.value)}if(l(r))return a.deepMap(r,p);if(u(r))return Math.sin(r);if(r instanceof t)return p(r.toNumber());throw new e.error.UnsupportedTypeError("sin",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(9),a=n(11),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.sinh=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("sinh",arguments.length,1);if(s(r))return(Math.exp(r)-Math.exp(-r))/2;if(f(r)){var n=Math.cos(r.im),m=Math.sin(r.im),h=Math.exp(r.re),g=Math.exp(-r.re);return new i(n*(h-g)/2,m*(h+g)/2)}if(c(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sinh is no angle");return p(r.value)}if(l(r))return a.deepMap(r,p);if(u(r))return p(r?1:0);if(r instanceof t)return p(r.toNumber());throw new e.error.UnsupportedTypeError("sinh",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(9),a=n(11),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.tan=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("tan",arguments.length,1);if(s(r))return Math.tan(r);if(f(r)){var n=Math.exp(-4*r.im)+2*Math.exp(-2*r.im)*Math.cos(2*r.re)+1;return new i(2*Math.exp(-2*r.im)*Math.sin(2*r.re)/n,(1-Math.exp(-4*r.im))/n)}if(c(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tan is no angle");return Math.tan(r.value)}if(l(r))return a.deepMap(r,p);if(u(r))return Math.tan(r);if(r instanceof t)return p(r.toNumber());throw new e.error.UnsupportedTypeError("tan",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=e.type.BigNumber,i=n(5),o=n(9),a=n(11),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.tanh=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("tanh",arguments.length,1);if(s(r)){var n=Math.exp(2*r);return(n-1)/(n+1)}if(f(r)){var m=Math.exp(2*r.re),h=m*Math.cos(2*r.im),g=m*Math.sin(2*r.im),d=(h+1)*(h+1)+g*g;return new i(((h-1)*(h+1)+g*g)/d,2*g/d)}if(c(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tanh is no angle");return p(r.value)}if(l(r))return a.deepMap(r,p);if(u(r))return p(r?1:0);if(r instanceof t)return p(r.toNumber());throw new e.error.UnsupportedTypeError("tanh",e["typeof"](r))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=n(9),i=n(11),o=r.string.isString,a=t.isUnit,s=i.isCollection;e.to=function u(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("to",arguments.length,2);if(a(r)&&(a(n)||o(n)))return r.to(n);if(s(r)||s(n))return i.deepMap2(r,n,u);throw new e.error.UnsupportedTypeError("to",e["typeof"](r),e["typeof"](n))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=r.object;e.clone=function(r){if(1!=arguments.length)throw new e.error.ArgumentsError("clone",arguments.length,1);return t.clone(r)}}},function(e,r,n){e.exports=function(e){var r=n(123),t=r.string;e.format=function(r,n){var i=arguments.length;if(1!==i&&2!==i)throw new e.error.ArgumentsError("format",i,1,2);return t.format(r,n)}}},function(e,r,n){e.exports=function(e){function r(r,n,t){var i=r instanceof o||n instanceof o||t instanceof o;if(r instanceof o||(r=new o(r)),g(n)&&(n instanceof o||(n=new o(n)),!f(r.size(),n.size())))throw new RangeError("Dimension mismatch (["+r.size().join(", ")+"] != ["+n.size().join(", ")+"])");if(g(t)&&(t instanceof o||(t=new o(t)),!f(r.size(),t.size())))throw new e.error.DimensionError(r.size(),t.size());var a=n instanceof o,s=t instanceof o,u=r.map(function(r,i){return e.ifElse(r,a?n.get(i):n,s?t.get(i):t)});return i?u:u.valueOf()}var t=n(123),i=e.type.BigNumber,o=n(8),a=n(5),s=n(9),u=n(11),f=t.object.deepEqual,c=t.number.isNumber,l=t.string.isString,p=t["boolean"].isBoolean,m=a.isComplex,h=s.isUnit,g=u.isCollection;e.ifElse=function(n,t,o){if(3!=arguments.length)throw new e.error.ArgumentsError("ifElse",arguments.length,3);if(c(n)||p(n))return n?t:o;if(n instanceof i)return n.isZero()?o:t;if(l(n))return n?t:o;if(m(n))return n.re||n.im?t:o;if(h(n))return n.value?t:o;if(null===n||void 0===n)return o;if(g(n))return r(n,t,o);throw new e.error.UnsupportedTypeError("ifElse",e["typeof"](n))}}},function(e,r,n){e.exports=function(e){function r(r,n,t){(t.override||void 0===e[r])&&(e[r]=t.wrap&&"function"==typeof n?function(){for(var r=[],t=0,i=arguments.length;i>t;t++)r[t]=arguments[t].valueOf();return n.apply(e,r)}:n,e.chaining.Selector.createProxy(r,n))}function t(e){return"function"==typeof e||s(e)||u(e)||f(e)||c(e)}var i=n(123),o=n(5),a=n(9),s=i.number.isNumber,u=i.string.isString,f=o.isComplex,c=a.isUnit;e["import"]=function l(o,a){var s=arguments.length;if(1!=s&&2!=s)throw new e.error.ArgumentsError("import",s,1,2);var f,c={override:!1,wrap:!0};if(a&&a instanceof Object&&i.object.extend(c,a),u(o)){var p=n(155)(o);l(p)}else{if("object"!=typeof o)throw new TypeError("Object or module name expected");for(f in o)if(o.hasOwnProperty(f)){var m=o[f];t(m)?r(f,m,c):l(m)}}}}},function(e,r,n){e.exports=function(e){function r(e,r){var n=[],t=function(i,o){return Array.isArray(i)?i.map(function(e,r){return n[o]=r,t(e,o+1)}):r(i,n,e)};return t(e,0)}var t=n(8).isMatrix;e.map=function(n,i){if(2!=arguments.length)throw new e.error.ArgumentsError("map",arguments.length,2);if(Array.isArray(n))return r(n,i);if(t(n))return n.map(i);throw new e.error.UnsupportedTypeError("map",e["typeof"](n))}}},function(e,r,n){e.exports=function(e){var r=n(123),t=r.string.isString;e.print=function(r,n,i){var o=arguments.length;if(2!=o&&3!=o)throw new e.error.ArgumentsError("print",o,2,3);if(!t(r))throw new TypeError("String expected as first parameter in function format");if(!(n instanceof Object))throw new TypeError("Object expected as second parameter in function format");return r.replace(/\$([\w\.]+)/g,function(r,o){for(var a=o.split("."),s=n[a.shift()];a.length&&void 0!==s;){var u=a.shift();s=u?s[u]:s+"."}return void 0!==s?t(s)?s:e.format(s,i):r})}}},function(e,r,n){e.exports=function(e){var r=n(156),t=n(5),i=n(8),o=n(9),a=n(7),s=n(6),u=n(10);e["typeof"]=function(n){if(1!=arguments.length)throw new e.error.ArgumentsError("typeof",arguments.length,1);var f=r.type(n);if("object"===f){if(n instanceof t)return"complex";if(n instanceof i)return"matrix";if(n instanceof o)return"unit";if(n instanceof a)return"index";if(n instanceof s)return"range";if(n instanceof u)return"help";if(n instanceof e.type.BigNumber)return"bignumber";if(n instanceof e.chaining.Selector)return"selector"}return f}}},function(e,r,n){e.exports=function(e){function r(e,r){var n=[],t=function(i,o){Array.isArray(i)?i.forEach(function(e,r){n[o]=r,t(e,o+1)}):r(i,n,e)};t(e,0)}var t=n(8).isMatrix;e.forEach=function(n,i){if(2!=arguments.length)throw new e.error.ArgumentsError("forEach",arguments.length,2);if(Array.isArray(n))return r(n,i);if(t(n))return n.forEach(i);throw new e.error.UnsupportedTypeError("forEach",e["typeof"](n))}}},function(e,r,n){var t;(function(e){!function(i){"use strict";function o(e,r,n,t){return!((!(!t&&n>3&&4==e[r]||(t||4>n)&&9==e[r])||9!=e[r+1]||9!=e[r+2]||9!=e[r+3]||null==t&&9!=e[r+4])&&(null!=t||5!=e[r]&&e[r]||e[r+1]||e[r+2]||e[r+3]||e[r+4]))}function a(e,r,n){var t=e.constructor;return null==r||((y=0>r||r>8)||0!==r&&(t.errors?parseInt:parseFloat)(r)!=r)&&!l(t,"rounding mode",r,n,0)?t.rounding:0|r}function s(e,r,n,t){var i=e.constructor;return!(y=(t||0)>r||r>=T+1)&&(0===r||(i.errors?parseInt:parseFloat)(r)==r)||l(i,"argument",r,n,0)}function u(e,r,n,t,i,o){var a=e.constructor,s=e.e-r.e,u=e.s==r.s?1:-1,f=e.c,c=r.c;if(!(f&&f[0]&&c&&c[0]))return new a(e.s&&r.s&&(f?!c||f[0]!=c[0]:c)?f&&0==f[0]||!c?0*u:u/0:0/0);var l,p,m,g,d,x,y=c.slice(),w=x=c.length,v=f.length,b=f.slice(0,x),E=b.length,N=new a(u),M=N.c=[];for(p=u=0;c[p]==(f[p]||0);p++);if(c[p]>(f[p]||0)&&(s--,u=1),N.e=s,null==n?(n=a.precision,t=a.rounding):i&&(n+=s+1),o=o||10,n>=0){for(u+=n;E++<x;b.push(0));y.unshift(p=0);do{for(m=0;o>m;m++){if(x!=(E=b.length))l=x>E?1:-1;else for(g=-1,l=0;++g<x;)if(c[g]!=b[g]){l=c[g]>b[g]?1:-1;break}if(!(0>l))break;for(d=E==x?c:y;E;){if(b[--E]<d[E]){for(g=E;g&&!b[--g];b[g]=o-1);--b[g],b[E]+=o}b[E]-=d[E]}for(;!b[0];b.shift());}M[p++]=l?m:++m,b[0]&&l?b[E]=f[w]||0:b=[f[w]]}while((w++<v||null!=b[0])&&u--);!M[0]&&p>1&&M.shift(),n>=p&&(n=null)}return h(N,n,t,null!=b[0],o)}function f(e,r){var n,t,i,a,s,f,c,l=0,p=0,m=0,g=e.constructor,d=g.ONE,x=g.rounding,y=g.precision;if(!e.c||!e.c[0]||e.e>17)return new g(e.c?e.c[0]?e.s<0?0:1/0:d:e.s?e.s<0?0:e:0/0);for(null==r?(b=!1,s=y):s=r,c=new g(.03125);e.e>-2;)e=e.times(c),m+=5;for(t=Math.log(Math.pow(2,m))/Math.LN10*2+5|0,s+=t,n=a=f=new g(d),g.precision=s;;){if(a=h(a.times(e),s,1),n=n.times(++p),c=f.plus(u(a,n,s,1)),c.c.slice(0,s).join("")===f.c.slice(0,s).join("")){for(i=m;i--;)f=h(f.times(f),s,1);if(null!=r)return g.precision=y,f;if(!(3>l&&o(f.c,s-t,x,l)))return h(f,g.precision=y,x,b=!0);g.precision=s+=10,n=a=c=new g(d),p=0,l++}f=c}}function c(e,r,n,t){var i=e.constructor,o=(e=new i(e)).e,a=e.c;if(!a)return e.toString();for(a.length>++r&&h(e,r,n),o=t?r:r+e.e-o;a.length<o;a.push(0));return o=e.e,1==t||2==t&&(o>=r||o<=i.toExpNeg)?(e.s<0&&a[0]?"-":"")+(a.length>1?a[0]+"."+a.slice(1).join(""):a[0])+(0>o?"e":"e+")+o:e.toString()}function l(e,r,n,t,i){if(e.errors){var o=new Error((t||["new Decimal","cmp","div","eq","gt","gte","lt","lte","minus","mod","plus","times","toFraction","pow","random","log","sqrt","toNearest","divToInt"][v?0>v?-v:v:0>1/v?1:0])+"() "+(["number type has more than 15 significant digits","LN10 out of digits"][r]||r+([y?" out of range":" not an integer"," not a boolean or binary digit"][i]||""))+": "+n);throw o.name="Decimal Error",y=v=0,o}}function p(e,r,n){var t=new e(e.ONE);for(b=!1;1&n&&(t=t.times(r)),n>>=1,n;)r=r.times(r);return b=!0,t}function m(e,r){var n,t,i,a,s,f,c,p,g,d=1,x=10,y=e,w=y.c,v=y.constructor,E=v.ONE,N=v.rounding,M=v.precision;if(y.s<0||!w||!w[0]||!y.e&&1==w[0]&&1==w.length)return new v(w&&!w[0]?-1/0:1!=y.s?0/0:w?0:y);if(null==r?(b=!1,s=M):s=r,v.precision=s+=x,!(Math.abs(t=y.e)<15e14))return y=new v(y),y.e=0,s+2>S.length&&l(v,1,s+2,"ln"),y=m(y,s-x).plus(new v(S.slice(0,s+2)).times(t+"")),v.precision=M,null==r?h(y,M,N,b=!0):y;for(;w[0]<7&&1!=w[0]||1==w[0]&&w[1]>3;)y=y.times(e),w=y.c,d++;for(t=y.e,w[0]>1?(1==d?y=new v("0."+w.join("")):y.e=-1,t++):y=new v("1."+w.slice(1).join("")),p=y,f=i=y=u(y.minus(E),y.plus(E),s,1),g=h(y.times(y),s,1),n=3;;){if(i=h(i.times(g),s,1),c=f.plus(u(i,new v(n),s,1)),c.c.slice(0,s).join("")===f.c.slice(0,s).join("")){if(f=f.times(2),0!==t&&(s+2>S.length&&l(v,1,s+2,"ln"),f=f.plus(new v(S.slice(0,s+2)).times(t+""))),f=u(f,new v(d),s,1),null!=r)return v.precision=M,f;if(!o(f.c,s-x,N,a))return h(f,v.precision=M,N,b=!0);v.precision=s+=x,c=i=y=u(p.minus(E),p.plus(E),s,1),g=h(y.times(y),s,1),n=a=1}f=c,n+=2}}function h(e,r,n,t,i){var o,a,s,u,f=e.constructor;if(r!=o){if(!(u=e.c))return e;if(s=e.s<0,a=(i=i||10)/2,o=u[r],t=t||0>r||null!=u[r+1],t=4>n?(null!=o||t)&&(0==n||2==n&&!s||3==n&&s):o>a||o==a&&(4==n||t||6==n&&1&u[r-1]||7==n&&!s||8==n&&s),1>r||!u[0])return u.length=0,t?(r=r-e.e-1,u[0]=1,e.e=-r||0):u[0]=e.e=0,e;if(u.length>r&&(u.length=r),r--,t){for(o=r;null==u[o];u[o--]=0);for(--i;++u[r]>i;)u[r]=0,r--||(++e.e,u.unshift(1))}for(r=u.length;!u[--r];u.pop());}return b&&(e.e>f.maxE?e.c=e.e=null:e.e<f.minE&&(e.c=[e.e=0])),e}var g,d,x,y,w=Object.prototype.toString,v=0,b=!0,E="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_",N={},M=9e15,T=1e9,A=3e3,S="2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058";N.absoluteValue=N.abs=function(){var e=new this.constructor(this);return e.s<0&&(e.s=1),h(e)},N.ceil=function(){return h(new this.constructor(this),this.e+1,2)},N.comparedTo=N.cmp=function(e,r){var n,t=this,i=t.c,o=(v=-v,e=new t.constructor(e,r),e.c),a=t.s,s=e.s,u=t.e,f=e.e;if(!a||!s)return null;if(n=i&&!i[0],r=o&&!o[0],n||r)return n?r?0:-s:a;if(a!=s)return a;if(n=0>a,!i||!o)return u==f?0:!i^n?1:-1;if(u!=f)return u>f^n?1:-1;for(a=-1,s=(u=i.length)<(f=o.length)?u:f;++a<s;)if(i[a]!=o[a])return i[a]>o[a]^n?1:-1;return u==f?0:u>f^n?1:-1},N.decimalPlaces=N.dp=function(){var e=this;return e.c?Math.max(e.c.length-e.e-1,0):null},N.dividedBy=N.div=function(e,r){return v=2,u(this,new this.constructor(e,r))},N.dividedToIntegerBy=N.divToInt=function(e,r){var n=this,t=n.constructor;return v=18,h(u(n,new t(e,r),0,1,1),t.precision,t.rounding)},N.equals=N.eq=function(e,r){return v=3,0===this.cmp(e,r)},N.exponential=N.exp=function(){return f(this)},N.floor=function(){return h(new this.constructor(this),this.e+1,3)},N.greaterThan=N.gt=function(e,r){return v=4,this.cmp(e,r)>0},N.greaterThanOrEqualTo=N.gte=function(e,r){return v=5,r=this.cmp(e,r),1==r||0===r},N.isFinite=function(){return!!this.c},N.isInteger=N.isInt=function(){return!!this.c&&this.e>this.c.length-2},N.isNaN=function(){return!this.s},N.isNegative=N.isNeg=function(){return this.s<0},N.isZero=function(){return!!this.c&&0==this.c[0]},N.lessThan=N.lt=function(e,r){return v=6,this.cmp(e,r)<0},N.lessThanOrEqualTo=N.lte=function(e,r){return v=7,r=this.cmp(e,r),-1==r||0===r},N.logarithm=N.log=function(e,r){var n,t,i,a,s,f,c,p,g,d=this,x=d.constructor,y=x.precision,w=x.rounding,E=5;if(null==e)e=new x(10),n=!0;else{if(v=15,e=new x(e,r),t=e.c,e.s<0||!t||!t[0]||!e.e&&1==t[0]&&1==t.length)return new x(0/0);n=e.eq(10)}if(t=d.c,d.s<0||!t||!t[0]||!d.e&&1==t[0]&&1==t.length)return new x(t&&!t[0]?-1/0:1!=d.s?0/0:t?0:1/0);if(s=n&&(1!=t[0]||t.length>1)||(1&e.c[e.c.length-1])!=(1&t[t.length-1])||0,b=!1,c=y+E,p=c+10,f=m(d,c),n?(p>S.length&&l(x,1,p,"log"),i=new x(S.slice(0,p))):i=m(e,c),g=u(f,i,c,1),o(g.c,a=y,w))do if(c+=10,f=m(d,c),n?(p=c+10,p>S.length&&l(x,1,p,"log"),i=new x(S.slice(0,p))):i=m(e,c),g=u(f,i,c,1),!s){for(t=g.c;9==t[++a];);a==y+E+10&&(g=h(g,y+1,0));break}while(o(g.c,a+=10,w));return b=!0,h(g,y,w)},N.minus=function(e,r){var n,t,i,o,a=this,s=a.constructor,u=a.s;if(v=8,e=new s(e,r),r=e.s,!u||!r)return new s(0/0);if(u!=r)return e.s=-r,a.plus(e);var f=a.c,c=a.e,l=e.c,p=e.e,m=s.precision,g=s.rounding;if(!c||!p){if(!f||!l)return f?(e.s=-r,e):new s(l?a:0/0);if(!f[0]||!l[0])return a=l[0]?(e.s=-r,e):new s(f[0]?a:3==g?-0:0),b?h(a,m,g):a}if(f=f.slice(),t=f.length,u=c-p){for((o=0>u)?(u=-u,n=f,t=l.length):(p=c,n=l),m>t&&(t=m),u>(t+=2)&&(u=t,n.length=1),n.reverse(),r=u;r--;n.push(0));n.reverse()}else for((o=t<(i=l.length))&&(i=t),u=r=0;i>r;r++)if(f[r]!=l[r]){o=f[r]<l[r];break}if(o&&(n=f,f=l,l=n,e.s=-e.s),(r=-((i=f.length)-l.length))>0)for(;r--;f[i++]=0);for(r=l.length;r>u;){if(f[--r]<l[r]){for(t=r;t&&!f[--t];f[t]=9);--f[t],f[r]+=10}f[r]-=l[r]}for(;0==f[--i];f.pop());for(;0==f[0];f.shift(),--p);return f[0]||(f=[p=0],e.s=3==g?-1:1),e.c=f,e.e=p,b?h(e,m,g):e},N.modulo=N.mod=function(e,r){var n,t,i=this,o=i.constructor,a=o.modulo;return v=9,e=new o(e,r),r=e.s,n=!i.c||!r||e.c&&!e.c[0],n||!e.c||i.c&&!i.c[0]?n?new o(0/0):h(new o(i),o.precision,o.rounding):(b=!1,9==a?(e.s=1,t=u(i,e,0,3,1),e.s=r,t.s*=r):t=u(i,e,0,a,1),t=t.times(e),b=!0,i.minus(t))},N.naturalLogarithm=N.ln=function(){return m(this)},N.negated=N.neg=function(){var e=new this.constructor(this);return e.s=-e.s||null,h(e)},N.plus=function(e,r){var n,t=this,i=t.constructor,o=t.s;if(v=10,e=new i(e,r),r=e.s,!o||!r)return new i(0/0);if(o!=r)return e.s=-r,t.minus(e);var a=t.e,s=t.c,u=e.e,f=e.c,c=i.precision,l=i.rounding;if(!a||!u){if(!s||!f)return new i(o/0);if(!s[0]||!f[0])return t=f[0]?e:new i(s[0]?t:0*o),b?h(t,c,l):t}if(s=s.slice(),o=a-u){for(0>o?(o=-o,n=s,r=f.length):(u=a,n=f,r=s.length),c>r&&(r=c),o>++r&&(o=r,n.length=1),n.reverse();o--;n.push(0));n.reverse()
}for(s.length-f.length<0&&(n=f,f=s,s=n),o=f.length,r=0;o;s[o]%=10)r=(s[--o]=s[o]+f[o]+r)/10|0;for(r&&(s.unshift(r),++u),o=s.length;0==s[--o];s.pop());return e.c=s,e.e=u,b?h(e,c,l):e},N.precision=N.sd=function(e){var r=this;return null!=e&&e!==!!e&&1!==e&&0!==e&&l(r.constructor,"argument",e,"precision",1),r.c?e?Math.max(r.e+1,r.c.length):r.c.length:null},N.round=function(){var e=this,r=e.constructor;return h(new r(e),e.e+1,r.rounding)},N.squareRoot=N.sqrt=function(){var e,r,n,t,i,o=this,a=o.c,s=o.s,f=o.e,c=o.constructor,l=new c(.5);if(1!==s||!a||!a[0])return new c(!s||0>s&&(!a||a[0])?0/0:a?o:1/0);for(b=!1,s=Math.sqrt(+o),0==s||s==1/0?(e=a.join(""),(e.length+f)%2==0&&(e+="0"),n=new c(Math.sqrt(e)+""),n.c||(n.c=[1]),n.e=Math.floor((f+1)/2)-(0>f||f%2)):n=new c(s.toString()),r=(f=c.precision)+3;;)if(i=n,n=l.times(i.plus(u(o,i,r+2,1))),i.c.slice(0,r).join("")===n.c.slice(0,r).join("")){if(a=n.c,9!=a[r-3]&&(t||4!=a[r-3])||9!=a[r-2]||9!=a[r-1]||9!=a[r]){if(!(a[r-3]&&5!=a[r-3]||a[r-2]||a[r-1]||a[r]||(a.length>f+1&&(a.length=f+1),n.times(n).eq(o)))){for(;a.length<f;)a.push(0);a[f]++}break}if(!t&&(i=h(i,f+1,0),i.times(i).eq(o))){n=i;break}r+=4,t=1}return b=!0,h(n,f,c.rounding)},N.times=function(e,r){var n,t=this,i=t.constructor,o=t.c,a=(v=11,e=new i(e,r),e.c),s=t.e,u=e.e,f=t.s;if(r=e.s,e.s=f==r?1:-1,!((s||o&&o[0])&&(u||a&&a[0])))return new i(!f||!r||o&&!o[0]&&!a||a&&!a[0]&&!o?0/0:o&&a?0*e.s:e.s/0);for(e.e=s+u,f=o.length,r=a.length,r>f&&(n=o,o=a,a=n,u=f,f=r,r=u),u=f+r,n=[];u--;n.push(0));for(s=r-1;s>-1;s--){for(r=0,u=f+s;u>s;r=r/10|0)r=n[u]+a[s]*o[u-s-1]+r,n[u--]=r%10|0;r&&(n[u]=(n[u]+r)%10)}for(r&&++e.e,n[0]||n.shift(),u=n.length;!n[--u];n.pop());return e.c=n,b?h(e,i.precision,i.rounding):e},N.toDecimalPlaces=N.toDP=function(e,r){var n=this;return n=new n.constructor(n),null!=e&&s(n,e,"toDP")?h(n,(0|e)+n.e+1,a(n,r,"toDP")):n},N.toExponential=function(e,r){var n=this;return c(n,null!=e&&s(n,e,"toExponential")||!n.c?0|e:n.c.length-1,null!=e&&a(n,r,"toExponential"),1)},N.toFixed=function(e,r){var n,t=this,i=t.constructor,o=i.toExpNeg,u=i.toExpPos;return null!=e&&(e=s(t,e,n="toFixed",-T)?t.e+(0|e):null,r=a(t,r,n)),i.toExpNeg=-(i.toExpPos=1/0),null==e?n=t.toString():(n=c(t,e,r),t.s<0&&t.c&&(t.c[0]?n.indexOf("-")<0&&(n="-"+n):n=n.replace("-",""))),i.toExpNeg=o,i.toExpPos=u,n},N.toFormat=function(e,r,n){var t=this.toFixed(r).split(".");return t[0].replace(/\B(?=(\d{3})+$)/g,null==e?",":e+"")+(t[1]?"."+(n?t[1].replace(/\d{5}\B/g,"$&"+n):t[1]):"")},N.toFraction=function(e){var r,n,t,i,o,a,s,f=this,c=f.constructor,p=r=new c(c.ONE),m=a=new c(0),h=f.c,g=new c(c.ONE),d=c.precision;if(!h)return f.toString();for(t=g.e=h.length-f.e-1,(null==e||(!(v=12,o=new c(e)).s||(y=o.cmp(p)<0||!o.c)||c.errors&&o.e<o.c.length-1)&&!l(c,"max denominator",e,"toFraction",0)||(e=o).cmp(g)>0)&&(e=t>0?g:p),b=!1,o=new c(h.join("")),c.precision=h.length;s=u(o,g,0,1,1),n=r.plus(s.times(m)),1!=n.cmp(e);)r=m,m=n,p=a.plus(s.times(n=p)),a=n,g=o.minus(s.times(n=g)),o=n;return n=u(e.minus(r),m,0,1,1),a=a.plus(n.times(p)),r=r.plus(n.times(m)),a.s=p.s=f.s,t*=2,i=u(p,m,t,1,1).minus(f).abs().cmp(u(a,r,t,1,1).minus(f).abs())<1?[p.toString(),m.toString()]:[a.toString(),r.toString()],b=!0,c.precision=d,i},N.toNearest=function(e,r){var n=this,t=n.constructor;return n=new t(n),null==e?(e=new t(t.ONE),r=t.rounding):(v=17,e=new t(e),r=a(n,r,"toNearest")),e.c?n.c&&(b=!1,4>r&&(r=[4,5,7,8][r]),1==e.c[0]&&1==e.c.length?(n.e-=e.e,h(n,n.e+1,r),n.c[0]&&(n.e+=e.e)):e.c[0]?n=u(n,e,0,r,1).times(e):n.c=[n.e=0],b=!0,h(n)):n.s&&(e.s&&(e.s=n.s),n=e),n},N.toNumber=function(){var e=this;return+e||(e.s?0*e.s:0/0)},N.toPower=N.pow=function(e,r){var n,t,i,a,s=this,u=s.constructor,c=s.s,l=(v=13,+(e=new u(e,r))),g=0>l?-l:l,d=u.precision,x=u.rounding;if(!s.c||!e.c||(i=!s.c[0])||!e.c[0])return new u(Math.pow(i?0*c:+s,l));if(s=new u(s),n=s.c.length,!s.e&&s.c[0]==s.s&&1==n)return s;if(r=e.c.length-1,e.e||e.c[0]!=e.s||r)if(i=e.e>=r,!i&&0>c)a=new u(0/0);else{if(i&&A>n*g){if(a=p(u,s,g),e.s<0)return u.ONE.div(a)}else{if(c=0>c&&1&e.c[Math.max(e.e,r)]?-1:1,r=Math.pow(+s,l),t=0!=r&&isFinite(r)?new u(r+"").e:Math.floor(l*(Math.log("0."+s.c.join(""))/Math.LN10+s.e+1)),t>u.maxE+1||t<u.minE-1)return new u(t>0?c/0:0);if(b=!1,u.rounding=s.s=1,g=Math.min(12,(t+"").length),a=f(e.times(m(s,d+g)),d),a=h(a,d+5,1),o(a.c,d,x)){for(t=d+10,a=h(f(e.times(m(s,t+g)),t),t+5,1),g=d;9==a.c[++g];);g==d+15&&(a=h(a,d+1,0))}a.s=c,b=!0,u.rounding=x}a=h(a,d,x)}else a=h(s,d,x);return a},N.toPrecision=function(e,r){return null!=e&&s(this,e,"toPrecision",1)?c(this,0|--e,a(this,r,"toPrecision"),2):this.toString()},N.toSignificantDigits=N.toSD=function(e,r){var n=this,t=n.constructor;return n=new t(n),null!=e&&s(n,e,"toSD",1)?h(n,0|e,a(n,r,"toSD")):h(n,t.precision,t.rounding)},N.toString=function(e){var r,n,t,i=this,o=i.constructor,a=i.e;if(null===a)n=i.s?"Infinity":"NaN";else{if(e===r&&(a<=o.toExpNeg||a>=o.toExpPos))return c(i,i.c.length-1,o.rounding,1);if(n=i.c.join(""),0>a){for(;++a;n="0"+n);n="0."+n}else if(t=n.length,a>0)if(++a>t)for(a-=t;a--;n+="0");else t>a&&(n=n.slice(0,a)+"."+n.slice(a));else if(r=n.charAt(0),t>1)n=r+"."+n.slice(1);else if("0"==r)return r;if(null!=e)if((y=!(e>=2&&65>e))||e!=(0|e)&&o.errors)l(o,"base",e,"toString",0);else if(n=g(o,n,0|e,10,i.s),"0"==n)return n}return i.s<0?"-"+n:n},N.truncated=N.trunc=function(){return h(new this.constructor(this),this.e+1,1)},N.valueOf=N.toJSON=function(){return this.toString()},g=function(){function e(e,r,n){for(var t,i,o=[0],a=0,s=e.length;s>a;){for(i=o.length;i--;o[i]*=r);for(o[t=0]+=E.indexOf(e.charAt(a++));t<o.length;t++)o[t]>n-1&&(null==o[t+1]&&(o[t+1]=0),o[t+1]+=o[t]/n|0,o[t]%=n)}return o.reverse()}return function(r,n,t,i,o){var a,s,f,c=n.indexOf("."),l=new r(i);for(37>i&&(n=n.toLowerCase()),0>c?(a=new r(l),f=[1]):(a=p(r,l,n.length-c-1),f=e(a.toFixed(),10,t),n=n.replace(".","")),l.c=f,l.e=f.length,s=e(n,i,t),a.c=s,a.e=s.length,a.s=o,a=u(a,l,r.precision,r.rounding,0,t),s=a.c,c=s.length;c--;)s[c]=E.charAt(s[c]);return a.s=1,a.toFixed()}}(),x=function(){function e(e){var r,n,t,i=this,o="config",a=i.errors?parseInt:parseFloat;return e==n||"object"!=typeof e&&!l(i,"object expected",e,o)?i:((t=e[r="precision"])!=n&&((y=1>t||t>T)||a(t)!=t?l(i,r,t,o,0):i[r]=0|t),(t=e[r="rounding"])!=n&&((y=0>t||t>8)||a(t)!=t?l(i,r,t,o,0):i[r]=0|t),(t=e[r="toExpNeg"])!=n&&((y=-M>t||t>0)||a(t)!=t?l(i,r,t,o,0):i[r]=Math.floor(t)),(t=e[r="toExpPos"])!=n&&((y=0>t||t>M)||a(t)!=t?l(i,r,t,o,0):i[r]=Math.floor(t)),(t=e[r="minE"])!=n&&((y=-M>t||t>0)||a(t)!=t?l(i,r,t,o,0):i[r]=Math.floor(t)),(t=e[r="maxE"])!=n&&((y=0>t||t>M)||a(t)!=t?l(i,r,t,o,0):i[r]=Math.floor(t)),(t=e[r="errors"])!=n&&(t===!!t||1===t||0===t?(y=v=0,i[r]=!!t):l(i,r,t,o,1)),(t=e[r="crypto"])!=n&&(t===!!t||1===t||0===t?i[r]=!(!t||!d||"object"!=typeof d):l(i,r,t,o,1)),(t=e[r="modulo"])!=n&&((y=0>t||t>9)||a(t)!=t?l(i,r,t,o,0):i[r]=0|t),i)}function r(e){return new this(e).exp()}function n(e){return new this(e).ln()}function t(e,r){return new this(e).log(r)}function o(e,r,n){var t,i,o=0;for("[object Array]"==w.call(r[0])&&(r=r[0]),t=new e(r[0]);++o<r.length;){if(i=new e(r[o]),!i.s){t=i;break}t[n](i)&&(t=i)}return t}function a(){return o(this,arguments,"lt")}function u(){return o(this,arguments,"gt")}function f(e,r){return new this(e).pow(r)}function c(e){return new this(e).sqrt()}function p(i){function o(e,r){var n=this;if(!(n instanceof o))return l(o,"Decimal called without new",e),new o(e,r);if(e instanceof o){if(null==r)return v=0,n.constructor=e.constructor,n.s=e.s,n.e=e.e,void(n.c=(e=e.c)?e.slice():e);if(10==r)return h(new o(e),o.precision,o.rounding);e+=""}return m(n.constructor=o,n,e,r)}return o.precision=20,o.rounding=4,o.modulo=1,o.toExpNeg=-7,o.toExpPos=21,o.minE=-M,o.maxE=M,o.errors=!0,o.crypto=!1,o.prototype=N,o.ONE=new o(1),o.ROUND_UP=0,o.ROUND_DOWN=1,o.ROUND_CEIL=2,o.ROUND_FLOOR=3,o.ROUND_HALF_UP=4,o.ROUND_HALF_DOWN=5,o.ROUND_HALF_EVEN=6,o.ROUND_HALF_CEIL=7,o.ROUND_HALF_FLOOR=8,o.EUCLID=9,o.config=e,o.constructor=p,o.exp=r,o.ln=n,o.log=t,o.max=a,o.min=u,o.pow=f,o.sqrt=c,o.random=x,null!=i&&o.config(i),o}var m=function(){var e=/^-?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,r=String.prototype.trim||function(){return this.replace(/^\s+|\s+$/g,"")};return function(n,t,i,o){var a,s,u,f,c,p;if("string"!=typeof i&&(i=(f="number"==typeof i||"[object Number]"==w.call(i))&&0===i&&0>1/i?"-0":i+""),c=i,o==s&&e.test(i))t.s="-"==i.charAt(0)?(i=i.slice(1),-1):1;else{if(10==o)return h(new n(i),n.precision,n.rounding);if(i=r.call(i).replace(/^\+(?!-)/,""),t.s="-"==i.charAt(0)?(i=i.replace(/^-(?!-)/,""),-1):1,o!=s?o!=(0|o)&&n.errors||(y=!(o>=2&&65>o))?(l(n,"base",o,0,0),p=e.test(i)):(a="["+E.slice(0,o=0|o)+"]+",i=i.replace(/\.$/,"").replace(/^\./,"0."),(p=new RegExp("^"+a+"(?:\\."+a+")?$",37>o?"i":"").test(i))?(f&&(i.replace(/^0\.0*|\./,"").length>15&&l(n,0,c),f=!f),i=g(n,i,10,o,t.s)):"Infinity"!=i&&"NaN"!=i&&(l(n,"not a base "+o+" number",c),i="NaN")):p=e.test(i),!p)return t.c=t.e=null,"Infinity"!=i&&("NaN"!=i&&l(n,"not a number",c),t.s=null),v=0,t}for((s=i.indexOf("."))>-1&&(i=i.replace(".","")),(u=i.search(/e/i))>0?(0>s&&(s=u),s+=+i.slice(u+1),i=i.substring(0,u)):0>s&&(s=i.length),u=0;"0"==i.charAt(u);u++);if(u==(o=i.length))t.c=[t.e=0];else{for(f&&o>15&&i.slice(u).length>15&&l(n,0,c);"0"==i.charAt(--o););for(t.e=s-u-1,t.c=[],s=0;o>=u;t.c[s++]=+i.charAt(u++));b&&(t.e>n.maxE?t.c=t.e=null:t.e<n.minE&&(t.c=[t.e=0]))}v=0}}(),x=function(){function e(e){var r=Math.random();return e?(r*e|0)+"":(1+r+"").slice(2,-2)}function r(e){var n;return e?(n=d.getRandomValues(new i.Uint8Array(1))[0],n>(256/e|0)*e-1?r(e):n%e+""):(n=d.getRandomValues(new i.Uint32Array(1))[0],n>=4e9?r(e):(n+1e9+"").slice(1))}function n(e){var r,t,i=d.randomBytes;return e?(t=i(1)[0],t>(256/e|0)*e-1?n(e):t%e+""):(r=i(8),r[0]=67,r[1]=15&r[1]|48,t=r.readDoubleBE(0),t>9003599627370495?n(e):(t-0xc72815b398000+"").slice(2))}return function(t,i){var o,a,u,f,c,p,m,h,g=this,x=new g(0),y=e;if(p=t==a||!(v=14,t=new g(t)).c&&!l(g,"limit must be finite",t,"random"))t=new g(g.ONE);else if(!t.c[0])return x;g.crypto&&(d.getRandomValues?y=r:d.randomBytes&&(y=n)),a=t.e,c=(o=t.c).length;do{u=0,h=y(o[0]+1)+y();do f=o[u],m=h.charAt(u++);while(f==m)}while(m>f||u>c||""==m);for(u=0;"0"==h.charAt(u);u++,a--);for(p?i=g.precision:null!=i&&s(t,i,"random",1)?i|=0:i=a+1,i+=u;h.length<i;)h+=y();for(;"0"==h.charAt(--i););if(++i>0)for(x.c=[];i>u;x.c.push(+h.charAt(u++)));else x.c=[a=0];return x.e=a,x.s=t.s,x}}();return p()}(),"undefined"!=typeof e&&e&&e.exports?(e.exports=x,d=n(256)):(d=i.crypto,t=function(){return x}.call(r,n,r,e),!(void 0!==t&&(e.exports=t)))}(this)}).call(r,n(260)(e))},function(e){function r(e,n,t,i){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");this.fn=e,this.count=n,this.min=t,this.max=i,this.message="Wrong number of arguments in function "+e+" ("+n+" provided, "+t+(void 0!=i?"-"+i:"")+" expected)",this.stack=(new Error).stack}r.prototype=new Error,r.prototype.constructor=Error,r.prototype.name="ArgumentsError",e.exports=r},function(e){function r(e,n,t){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");this.actual=e,this.expected=n,this.relation=t,this.message="Dimension mismatch ("+(Array.isArray(e)?"["+e.join(", ")+"]":e)+" "+(this.relation||"!=")+" "+(Array.isArray(n)?"["+n.join(", ")+"]":n)+")",this.stack=(new Error).stack}r.prototype=new RangeError,r.prototype.constructor=RangeError,r.prototype.name="DimensionError",e.exports=r},function(e){function r(e,n,t){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");this.index=e,arguments.length<3?(this.min=0,this.max=n):(this.min=n,this.max=t),this.message=void 0!==this.min&&this.index<this.min?"Index out of range ("+this.index+" < "+this.min+")":void 0!==this.max&&this.index>=this.max?"Index out of range ("+this.index+" > "+(this.max-1)+")":"Index out of range ("+this.index+")",this.stack=(new Error).stack}r.prototype=new RangeError,r.prototype.constructor=RangeError,r.prototype.name="IndexError",e.exports=r},function(e){function r(e){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");this.fn=e,this.types=Array.prototype.splice.call(arguments,1),this.message=e?0==this.types.length?"Unsupported type of argument in function "+e:"Function "+e+"("+this.types.join(", ")+") not supported":"Unsupported type of argument",this.stack=(new Error).stack}r.prototype=new TypeError,r.prototype.constructor=TypeError,r.prototype.name="UnsupportedTypeError",e.exports=r},function(e,r,n){r.array=n(153),r["boolean"]=n(257),r.number=n(154),r.bignumber=n(258),r.object=n(3),r.string=n(138),r.types=n(156)},function(e,r,n){function t(e){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(this.nodes=e||[],!a(this.nodes)||!this.nodes.every(s))throw new TypeError("Array containing Nodes expected")}var i=n(137),o=(n(3),n(138)),a=(n(11),n(123),Array.isArray),s=i.isNode;t.prototype=new i,t.prototype.type="ArrayNode",t.prototype._compile=function(e){var r="array"!==e.math.config().matrix,n=this.nodes.map(function(r){return r._compile(e)});return(r?"math.matrix([":"[")+n.join(",")+(r?"])":"]")},t.prototype.find=function(e){var r=[];this.match(e)&&r.push(this);for(var n=this.nodes,t=0,i=n.length;i>t;t++)r=r.concat(n[t].find(e));return r},t.prototype.toString=function(){return o.format(this.nodes)},t.prototype.toTex=function(e){e=e||"bmatrix";var r="\\begin{"+e+"}";return this.nodes.forEach(function(e){r+=e.nodes?e.nodes.map(function(e){return e.toTex()}).join("&"):e.toTex(),r+="\\\\"}),r+="\\end{"+e+"}"},e.exports=t},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!s(e))throw new TypeError('String expected for parameter "name"');if(!(r instanceof i))throw new TypeError('Node expected for parameter "expr"');this.name=e,this.expr=r}var i=n(137),o=n(124),a=n(259),s=n(138).isString;t.prototype=new i,t.prototype.type="AssignmentNode",t.prototype._compile=function(e){return'scope["'+this.name+'"] = '+this.expr._compile(e)},t.prototype.find=function(e){var r=[];return this.match(e)&&r.push(this),r=r.concat(this.expr.find(e))},t.prototype.toString=function(){return this.name+" = "+this.expr.toString()},t.prototype.toTex=function(){var e;return this.expr instanceof o&&(e=["\\mathbf{","}"]),a.addBraces(a.toSymbol(this.name),e)+"="+a.addBraces(this.expr.toTex())},e.exports=t},function(e,r,n){function t(){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");this.params=[]}var i=n(137),o=n(257).isBoolean;t.prototype=new i,t.prototype.type="BlockNode",t.prototype.add=function(e,r){if(void 0===r&&(r=!0),!(e instanceof i))throw new TypeError('Node expected for parameter "expr"');if(!o(r))throw new TypeError('Boolean expected for parameter "visible"');var n=this.params.length;this.params[n]={node:e,visible:r}},t.prototype._compile=function(e){var r=this.params.map(function(r){var n=r.node._compile(e);return r.visible?"results.push("+n+");":n+";"});return"(function () {var results = [];"+r.join("")+"return results;})()"},t.prototype.find=function(e){var r=[];this.match(e)&&r.push(this);for(var n=this.params,t=0,i=n.length;i>t;t++)r=r.concat(n[t].node.find(e));return r},t.prototype.toString=function(){return this.params.map(function(e){return e.node.toString()+(e.visible?"":";")}).join("\n")},t.prototype.toTex=function(){return this.params.map(function(e){return e.node.toTex()+(e.visible?"":";")}).join("\n")},e.exports=t},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!a(e))throw new TypeError('String expected for parameter "type"');if(!a(r))throw new TypeError('String expected for parameter "value"');this.valueType=e,this.value=r}var i=n(137),o=n(138),a=o.isString;t.prototype=new i,t.prototype.type="ConstantNode",t.prototype._compile=function(e){switch(this.valueType){case"number":return"bignumber"===e.math.config().number?'math.bignumber("'+this.value+'")':this.value.replace(/^(0*)[0-9]/,function(e,r){return e.substring(r.length)});case"string":return'"'+this.value+'"';case"complex":return"math.complex(0, "+this.value+")";case"boolean":return this.value;case"undefined":return this.value;case"null":return this.value;default:throw new TypeError('Unsupported type of constant "'+this.valueType+'"')}},t.prototype.toString=function(){switch(this.valueType){case"string":return'"'+this.value+'"';case"complex":return this.value+"i";default:return this.value}},t.prototype.toTex=function(){var e,r=this.value;switch(this.valueType){case"string":return"\\text{"+r+"}";case"complex":return r+"i";case"number":return e=r.toLowerCase().indexOf("e"),-1!==e?r.substring(0,e)+" \\cdot 10^{"+r.substring(e+1)+"}":r;default:return r}},e.exports=t},function(e,r,n){function t(e,r,n){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!a(e))throw new TypeError('String expected for parameter "name"');if(!isArray(r)||!r.every(a))throw new TypeError('Array containing strings expected for parameter "args"');if(!(n instanceof i))throw new TypeError('Node expected for parameter "expr"');this.name=e,this.args=r,this.expr=n}var i=n(137),o=n(259),a=n(138).isString;isArray=Array.isArray,t.prototype=new i,t.prototype.type="FunctionNode",t.prototype._compile=function(e){return'scope["'+this.name+'"] =   (function (scope) {    scope = Object.create(scope);     var fn = function '+this.name+"("+this.args.join(",")+") {      if (arguments.length != "+this.args.length+') {        throw new SyntaxError("Wrong number of arguments in function '+this.name+' (" + arguments.length + " provided, '+this.args.length+' expected)");      }'+this.args.map(function(e,r){return'scope["'+e+'"] = arguments['+r+"];"}).join("")+"      return "+this.expr._compile(e)+'    };    fn.syntax = "'+this.name+"("+this.args.join(", ")+')";    return fn;  })(scope);'},t.prototype.find=function(e){var r=[];return this.match(e)&&r.push(this),r=r.concat(this.expr.find(e))},t.prototype.toString=function(){return"function "+this.name+"("+this.args.join(", ")+") = "+this.expr.toString()},t.prototype.toTex=function(){return this.name+o.addBraces(this.args.map(o.toSymbol).join(", "),!0)+"="+o.addBraces(this.expr.toTex())},e.exports=t},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!(e instanceof i))throw new TypeError('Node expected for parameter "object"');if(!isArray(r)||!r.every(s))throw new TypeError('Array containing Nodes expected for parameter "ranges"');this.object=e,this.ranges=r}var i=n(137),o=n(132),a=n(133),s=i.isNode;t.prototype=new i,t.prototype.type="IndexNode",t.prototype._compile=function(e){return this.compileSubset(e)},t.prototype.compileSubset=function(e,r){var n={type:a,properties:{name:"end"}},t=!1,i=this.ranges.map(function(e){var r=e.find(n).length>0;return t=r?r:t,r}),s=this.ranges.map(function(r,n){var t=i[n];return r instanceof o?t?'(function (scope) {  scope = Object.create(scope);   scope["end"] = size['+n+"];  var step = "+(r.step?r.step._compile(e):"1")+";  return [    "+r.start._compile(e)+" - 1,     "+r.end._compile(e)+" - (step > 0 ? 0 : 2),     step  ];})(scope)":"(function () {  var step = "+(r.step?r.step._compile(e):"1")+";  return [    "+r.start._compile(e)+" - 1,     "+r.end._compile(e)+" - (step > 0 ? 0 : 2),     step  ];})()":t?'(function (scope) {  scope = Object.create(scope);   scope["end"] = size['+n+"];  return "+r._compile(e)+" - 1;})(scope)":r._compile(e)+" - 1"});return t?"(function () {  var obj = "+this.object._compile(e)+";  var size = math.size(obj).valueOf();  return math.subset(    obj,     math.index("+s.join(", ")+")    "+(r?", "+r:"")+"  );})()":"math.subset("+this.object._compile(e)+",math.index("+s.join(", ")+")"+(r?", "+r:"")+")"},t.prototype.find=function(e){var r=[];this.match(e)&&r.push(this),r=r.concat(this.object.find(e));for(var n=this.ranges,t=0,i=n.length;i>t;t++)r=r.concat(n[t].find(e));return r},t.prototype.objectName=function(){return this.object.name},t.prototype.toString=function(){return this.object.toString()+"["+this.ranges.join(", ")+"]"},t.prototype.toTex=function(){return this.object.toTex()+"["+this.ranges.join(", ")+"]"},e.exports=t},function(e,r,n){function t(e,r,n){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");this.op=e,this.fn=r,this.params=n}var i=n(137),o=n(127),a=n(133),s=n(131),u=n(259);t.prototype=new i,t.prototype.type="OperatorNode",t.prototype._compile=function(e){if(!(this.fn in e.math))throw new Error("Function "+this.fn+' missing in provided namespace "math"');var r=this.params.map(function(r){return r._compile(e)});return"math."+this.fn+"("+r.join(", ")+")"},t.prototype.find=function(e){var r=[];this.match(e)&&r.push(this);var n=this.params;if(n)for(var t=0,i=n.length;i>t;t++)r=r.concat(n[t].find(e));return r},t.prototype.toString=function(){var e=this.params;switch(e.length){case 1:return"-"==this.op?"-"+e[0].toString():e[0].toString()+this.op;case 2:var r=e[0].toString();e[0]instanceof t&&(r="("+r+")");var n=e[1].toString();return e[1]instanceof t&&(n="("+n+")"),r+" "+this.op+" "+n;default:return this.op+"("+this.params.join(", ")+")"}},t.prototype.toTex=function(){var e=this.params,r=u.toOperator(this.op),n=e[0],i=e[1];switch(e.length){case 1:return"-"===this.op||"+"===this.op?this.op+n.toTex():n.toTex()+this.op;case 2:var f=n.toTex(),c=!1,l=i.toTex(),p=!1,m="",h="";switch(this.op){case"/":m=r,r="";break;case"*":n instanceof t&&("+"===n.op||"-"===n.op)&&(c=!0),i instanceof t&&("+"===i.op||"-"===i.op?p=!0:"*"===i.op&&(p=!0)),r=(n instanceof o||n instanceof t)&&(i instanceof o||i instanceof t)?" \\cdot ":" \\, ";break;case"^":n instanceof t||n instanceof s?c=!0:n instanceof a&&(c=null);break;case"to":l=u.toUnit(l,!0)}return f=u.addBraces(f,c),l=u.addBraces(l,p),m+f+r+l+h;default:return r+"("+this.params.map(u.toSymbol).join(", ")+")"}},e.exports=t},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!(e instanceof i))throw new TypeError('Node expected for parameter "object"');if(!isArray(r)||!r.every(a))throw new TypeError('Array containing Nodes expected for parameter "params"');this.object=e,this.params=r}var i=n(137),o=n(259),a=i.isNode;t.prototype=new i,t.prototype.type="ParamsNode",t.prototype._compile=function(e){var r=this.params.map(function(r){return r._compile(e)});return this.object._compile(e)+"("+r.join(", ")+")"},t.prototype.find=function(e){var r=[];this.match(e)&&r.push(this),r=r.concat(this.object.find(e));for(var n=this.params,t=0,i=n.length;i>t;t++)r=r.concat(n[t].find(e));return r},t.prototype.toString=function(){return this.object.toString()+"("+this.params.join(", ")+")"},t.prototype.toTex=function(){return o.toParams(this)},e.exports=t},function(e,r,n){function t(e){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!Array.isArray(e)||2!=e.length&&3!=e.length||!e.every(o))throw new TypeError('Expected an Array containing 2 or 3 Nodes as parameter "params"');this.start=e[0],this.end=e[1],this.step=e[2]}var i=n(137),o=i.isNode;t.prototype=new i,t.prototype.type="RangeNode",t.prototype._compile=function(e){return"math.range("+this.start._compile(e)+", "+this.end._compile(e)+", "+(this.step?this.step._compile(e)+", ":"")+"true)"},t.prototype.find=function(e){var r=[];return this.match(e)&&r.push(this),r=r.concat(this.start.find(e)),this.step&&(r=r.concat(this.step.find(e))),r=r.concat(this.end.find(e))},t.prototype.toString=function(){var e=this.start.toString();return this.step&&(e+=":"+this.step.toString()),e+=":"+this.end.toString()},t.prototype.toTex=function(){var e=this.start.toTex();return this.step&&(e+=":"+this.step.toTex()),e+=":"+this.end.toTex()},e.exports=t},function(e,r,n){function t(e){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!u(e))throw new TypeError('String expected for parameter "name"');this.name=e}function i(e){throw new Error("Undefined symbol "+e)}var o=n(137),a=n(9),s=n(259),u=n(138).isString;t.prototype=new o,t.prototype.type="SymbolNode",t.prototype._compile=function(e){return e.undef=i,e.Unit=a,'(scope["'+this.name+'"] !== undefined ? scope["'+this.name+'"] : math["'+this.name+'"] !== undefined ? math["'+this.name+'"] : '+(a.isValuelessUnit(this.name)?'new Unit(null, "'+this.name+'")':'undef("'+this.name+'")')+")"},t.prototype.toString=function(){return this.name},t.prototype.toTex=function(){return s.toSymbol(this.name)},e.exports=t},function(e,r,n){function t(e,r,n){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");this.ops=e,this.fn=r,this.params=n}var i=n(130),o=n(259);t.prototype=new i,t.prototype.type="TernaryNode",t.prototype.toString=function(){return this.params[0]+" "+this.ops[0]+" "+this.params[1]+" "+this.ops[1]+" "+this.params[2]},t.prototype.toTex=function(){var e=o.addBraces(this.params[1].toTex())+", &\\quad"+o.addBraces("\\text{if}\\;"+this.params[0].toTex())+"\\\\"+(o.addBraces(this.params[2].toTex())+", &\\quad"+o.addBraces("\\text{otherwise}"));return o.addBraces(e,["\\left\\{\\begin{array}{l l}","\\end{array}\\right."])},e.exports=t},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!(e instanceof i))throw new TypeError('Node expected for parameter "value"');if(!a(r))throw new TypeError('String expected for parameter "unit"');this.value=e,this.unit=r}var i=n(137),o=(n(9),n(259)),a=n(138).isString;t.prototype=new i,t.prototype.type="UnitNode",t.prototype._compile=function(e){return"math.unit("+this.value._compile(e)+', "'+this.unit+'")'},t.prototype.find=function(e){var r=[];return this.match(e)&&r.push(this),r=r.concat(this.value.find(e))},t.prototype.toString=function(){return this.value+" "+this.unit},t.prototype.toTex=function(){return this.value+o.toUnit(this.unit)},e.exports=t},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!(e instanceof o))throw new TypeError('Expected IndexNode for parameter "index"');if(!(r instanceof i))throw new TypeError('Expected Node for parameter "expr"');this.index=e,this.expr=r}var i=n(137),o=n(129);t.prototype=new i,t.prototype.type="UpdateNode",t.prototype._compile=function(e){return'scope["'+this.index.objectName()+'"] = '+this.index.compileSubset(e,this.expr._compile(e))},t.prototype.find=function(e){var r=[];return this.match(e)&&r.push(this),r=r.concat(this.index.find(e)),r=r.concat(this.expr.find(e))},t.prototype.toString=function(){return this.index.toString()+" = "+this.expr.toString()},t.prototype.toTex=function(){return this.index.toTex()+" = "+this.expr.toTex()},e.exports=t},function(e,r,n){function t(){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator")}var i=n(4);t.prototype.eval=function(){throw new Error("Node.eval is deprecated. Use Node.compile(math).eval([scope]) instead.")},t.prototype.type="Node",t.prototype.compile=function(e){if("object"!=typeof e)throw new TypeError("Object expected for parameter math");var r={math:e,error:i},n=this._compile(r),t=Object.keys(r).map(function(e){return"    var "+e+' = defs["'+e+'"];'}),o=t.join(" ")+'return {  "eval": function (scope) {    try {      scope = scope || {};      return '+n+";    } catch (err) {      if (err instanceof defs.error.IndexError) {        err = new defs.error.IndexError(err.index + 1, err.min + 1, err.max + 1);      }      throw err;    }  }};",a=new Function("defs",o);return a(r)},t.prototype._compile=function(){throw new Error("Cannot compile a Node interface")},t.prototype.find=function(e){return this.match(e)?[this]:[]},t.prototype.match=function(e){var r=!0;if(e){!e.type||this instanceof e.type||(r=!1);var n=e.properties;if(r&&n)for(var t in n)if(n.hasOwnProperty(t)&&this[t]!==n[t]){r=!1;break}}return r},t.prototype.toString=function(){return""},t.prototype.toTex=function(){return""},t.isNode=function(e){return e instanceof t},e.exports=t},function(e,r,n){function t(e,n){if(Array.isArray(e)){for(var i="[",o=e.length,a=0;o>a;a++)0!=a&&(i+=", "),i+=t(e[a],n);return i+="]"}return r.format(e,n)}var i=n(154),o=n(258),a=n(118);r.isString=function(e){return e instanceof String||"string"==typeof e},r.endsWith=function(e,r){var n=e.length-r.length,t=e.length;return e.substring(n,t)===r},r.format=function(e,n){return i.isNumber(e)?i.format(e,n):e instanceof a?o.format(e,n):Array.isArray(e)?t(e,n):r.isString(e)?'"'+e+'"':"function"==typeof e?e.syntax?e.syntax+"":"function":e instanceof Object?"function"==typeof e.format?e.format(n):e.toString():String(e)}},function(e){e.exports={name:"e",category:"Constants",syntax:["e"],description:"Euler's number, the base of the natural logarithm. Approximately equal to 2.71828",examples:["e","e ^ 2","exp(2)","log(e)"],seealso:["exp"]}},function(e){e.exports={name:"false",category:"Constants",syntax:["false"],description:"Boolean value false",examples:["false"],seealso:["true"]}},function(e){e.exports={name:"i",category:"Constants",syntax:["i"],description:"Imaginary unit, defined as i*i=-1. A complex number is described as a + b*i, where a is the real part, and b is the imaginary part.",examples:["i","i * i","sqrt(-1)"],seealso:[]}},function(e){e.exports={name:"Infinity",category:"Constants",syntax:["Infinity"],description:"Infinity, a number which is larger than the maximum number that can be handled by a floating point number.",examples:["Infinity","1 / 0"],seealso:[]}},function(e){e.exports={name:"LN2",category:"Constants",syntax:["LN2"],description:"Returns the natural logarithm of 2, approximately equal to 0.693",examples:["LN2","log(2)"],seealso:[]}},function(e){e.exports={name:"LN10",category:"Constants",syntax:["LN10"],description:"Returns the natural logarithm of 10, approximately equal to 2.302",examples:["LN10","log(10)"],seealso:[]}},function(e){e.exports={name:"LOG2E",category:"Constants",syntax:["LOG2E"],description:"Returns the base-2 logarithm of E, approximately equal to 1.442",examples:["LOG2E","log(e, 2)"],seealso:[]}},function(e){e.exports={name:"LOG10E",category:"Constants",syntax:["LOG10E"],description:"Returns the base-10 logarithm of E, approximately equal to 0.434",examples:["LOG10E","log(e, 10)"],seealso:[]}},function(e){e.exports={name:"NaN",category:"Constants",syntax:["NaN"],description:"Not a number",examples:["NaN","0 / 0"],seealso:[]}},function(e){e.exports={name:"pi",category:"Constants",syntax:["pi"],description:"The number pi is a mathematical constant that is the ratio of a circle's circumference to its diameter, and is approximately equal to 3.14159",examples:["pi","sin(pi/2)"],seealso:["tau"]}},function(e){e.exports={name:"SQRT1_2",category:"Constants",syntax:["SQRT1_2"],description:"Returns the square root of 1/2, approximately equal to 0.707",examples:["SQRT1_2","sqrt(1/2)"],seealso:[]}},function(e){e.exports={name:"SQRT2",category:"Constants",syntax:["SQRT2"],description:"Returns the square root of 2, approximately equal to 1.414",examples:["SQRT2","sqrt(2)"],seealso:[]}},function(e){e.exports={name:"tau",category:"Constants",syntax:["pi"],description:"Tau is the ratio constant of a circle's circumference to radius, equal to 2 * pi, approximately 6.2832.",examples:["tau","2 * pi"],seealso:["pi"]}},function(e){e.exports={name:"true",category:"Constants",syntax:["true"],description:"Boolean value true",examples:["true"],seealso:["false"]}},function(e,r,n){function t(e){for(var r=[];l(e);)r.push(e.length),e=e[0];return r}function i(e,r,n){var t,o=e.length;if(o!=r[n])throw new f(o,r[n]);if(n<r.length-1){var a=n+1;for(t=0;o>t;t++){var s=e[t];
if(!l(s))throw new f(r.length-1,r.length,"<");i(e[t],r,a)}}else for(t=0;o>t;t++)if(l(e[t]))throw new f(r.length+1,r.length,">")}function o(e,r,n,t){if(!l(e))throw Error("Array expected");var i,a,s=e.length,f=r[n],c=Math.min(s,f);if(e.length=f,n<r.length-1){var p=n+1;for(i=0;c>i;i++)a=e[i],o(a,r,p,t);for(i=c;f>i;i++)a=[],e[i]=a,o(a,r,p,t)}else if(void 0!==t)for(i=s;f>i;i++)e[i]=u.clone(t)}var a=n(154),s=n(138),u=n(3),f=(n(156),n(120)),c=n(121),l=Array.isArray;r.size=function(e){var n=t(e);return r.validate(e,n),n},r.validate=function(e,r){var n=0==r.length;if(n){if(l(e))throw new f(e.length,0)}else i(e,r,0)},r.validateIndex=function(e,r){if(!a.isNumber(e)||!a.isInteger(e))throw new TypeError("Index must be an integer (value: "+e+")");if(0>e)throw new c(e);if(void 0!==r&&e>=r)throw new c(e,r)},r.resize=function(e,r,n){if(!l(e)||!l(r))throw new TypeError("Array expected");if(0===r.length)throw new Error("Resizing to scalar is not supported");r.forEach(function(e){if(!a.isNumber(e)||!a.isInteger(e)||0>e)throw new TypeError("Invalid size, must contain positive integers (size: "+s.format(r)+")")});for(var t=1,i=e[0];l(i);)t++,i=i[0];for(;t<r.length;)e=[e],t++;for(;t>r.length;)e=e[0],t--;return o(e,r,0,n),e},r.squeeze=function(e){for(;l(e)&&1===e.length;)e=e[0];return e},r.unsqueeze=function(e,n){for(var t=r.size(e),i=0,o=n-t.length;o>i;i++)e=[e];return e},r.flatten=function(e){for(var r=e,n=Array.isArray;n(r[0]);){for(var t=[],i=0,o=r.length;o>i;i++)t=t.concat.apply(t,r[i]);r=t}return r},r.isArray=l},function(e,r){r.isNumber=function(e){return e instanceof Number||"number"==typeof e},r.isInteger=function(e){return e==Math.round(e)},r.sign=function(e){return e>0?1:0>e?-1:0},r.format=function(e,n){if("function"==typeof n)return n(e);if(1/0===e)return"Infinity";if(e===-1/0)return"-Infinity";if(isNaN(e))return"NaN";var t="auto",i=void 0;switch(void 0!==n&&(n.notation&&(t=n.notation),r.isNumber(n)?i=n:n.precision&&(i=n.precision)),t){case"fixed":return r.toFixed(e,i);case"exponential":return r.toExponential(e,i);case"auto":var o=.001,a=1e5;if(n&&n.exponential&&(void 0!==n.exponential.lower&&(o=n.exponential.lower),void 0!==n.exponential.upper&&(a=n.exponential.upper)),0===e)return"0";var s,u=Math.abs(e);if(u>=o&&a>u){var f=i?e.toPrecision(Math.min(i,21)):e.toPrecision();s=parseFloat(f)+""}else s=r.toExponential(e,i);return s.replace(/((\.\d*?)(0+))($|e)/,function(){var e=arguments[2],r=arguments[4];return"."!==e?e+r:r});default:throw new Error('Unknown notation "'+t+'". Choose "auto", "exponential", or "fixed".')}},r.toExponential=function(e,r){return void 0!==r?e.toExponential(Math.min(r-1,20)):e.toExponential()},r.toFixed=function(e,r){return e.toFixed(Math.min(r,20))},r.digits=function(e){return e.toExponential().replace(/e.*$/,"").replace(/^0\.?0*|\./,"").length},r.DBL_EPSILON=Number.EPSILON||2.220446049250313e-16,r.nearlyEqual=function(e,n,t){if(null==t)return e==n;if(e==n)return!0;if(isNaN(e)||isNaN(n))return!1;if(isFinite(e)&&isFinite(n)){var i=Math.abs(e-n);return i<r.DBL_EPSILON?!0:i<=Math.max(Math.abs(e),Math.abs(n))*t}return!1}},function(e,r,n){function t(e){return n(i(e))}function i(e){return o[e]||function(){throw new Error("Cannot find module '"+e+"'.")}()}var o={"./clone":110,"./clone.js":110,"./forEach":117,"./forEach.js":117,"./format":111,"./format.js":111,"./ifElse":112,"./ifElse.js":112,"./import":113,"./import.js":113,"./map":114,"./map.js":114,"./print":115,"./print.js":115,"./typeof":116,"./typeof.js":116};t.keys=function(){return Object.keys(o)},t.resolve=i,e.exports=t},function(e,r){r.type=function n(e){var n=typeof e;if("object"===n){if(null===e)return"null";if(e instanceof Boolean)return"boolean";if(e instanceof Number)return"number";if(e instanceof String)return"string";if(Array.isArray(e))return"array";if(e instanceof Date)return"date"}return n}},function(e){e.exports={name:"abs",category:"Arithmetic",syntax:["abs(x)"],description:"Compute the absolute value.",examples:["abs(3.5)","abs(-4.2)"],seealso:["sign"]}},function(e){e.exports={name:"add",category:"Operators",syntax:["x + y","add(x, y)"],description:"Add two values.",examples:["2.1 + 3.6","ans - 3.6","3 + 2i",'"hello" + " world"',"3 cm + 2 inch"],seealso:["subtract"]}},function(e){e.exports={name:"ceil",category:"Arithmetic",syntax:["ceil(x)"],description:"Round a value towards plus infinity. If x is complex, both real and imaginary part are rounded towards plus infinity.",examples:["ceil(3.2)","ceil(3.8)","ceil(-4.2)"],seealso:["floor","fix","round"]}},function(e){e.exports={name:"compare",category:"Operators",syntax:["compare(x, y)"],description:"Compare two values. Returns 1 if x is larger than y, -1 if x is smaller than y, and 0 if x and y are equal.",examples:["compare(2, 3)","compare(3, 2)","compare(2, 2)","compare(5cm, 40mm)","compare(2, [1, 2, 3])"],seealso:["equal","unequal","smaller","smallereq","largereq"]}},function(e){e.exports={name:"cube",category:"Arithmetic",syntax:["cube(x)"],description:"Compute the cube of a value. The cube of x is x * x * x.",examples:["cube(2)","2^3","2 * 2 * 2"],seealso:["multiply","square","pow"]}},function(e){e.exports={name:"divide",category:"Operators",syntax:["x / y","divide(x, y)"],description:"Divide two values.",examples:["2 / 3","ans * 3","4.5 / 2","3 + 4 / 2","(3 + 4) / 2","18 km / 4.5"],seealso:["multiply"]}},function(e){e.exports={name:"edivide",category:"Operators",syntax:["x ./ y","edivide(x, y)"],description:"divide two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a ./ b"],seealso:["multiply","emultiply","divide"]}},function(e){e.exports={name:"emultiply",category:"Operators",syntax:["x .* y","emultiply(x, y)"],description:"multiply two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a .* b"],seealso:["multiply","divide","edivide"]}},function(e){e.exports={name:"epow",category:"Operators",syntax:["x .^ y","epow(x, y)"],description:"Calculates the power of x to y element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","a .^ 2"],seealso:["pow"]}},function(e){e.exports={name:"equal",category:"Operators",syntax:["x == y","equal(x, y)"],description:"Check equality of two values. Returns true if the values are equal, and false if not.",examples:["2+2 == 3","2+2 == 4","a = 3.2","b = 6-2.8","a == b","50cm == 0.5m"],seealso:["unequal","smaller","larger","smallereq","largereq","compare"]}},function(e){e.exports={name:"exp",category:"Arithmetic",syntax:["exp(x)"],description:"Calculate the exponent of a value.",examples:["exp(1.3)","e ^ 1.3","log(exp(1.3))","x = 2.4","(exp(i*x) == cos(x) + i*sin(x))   # Euler's formula"],seealso:["pow","log"]}},function(e){e.exports={name:"fix",category:"Arithmetic",syntax:["fix(x)"],description:"Round a value towards zero. If x is complex, both real and imaginary part are rounded towards zero.",examples:["fix(3.2)","fix(3.8)","fix(-4.2)","fix(-4.8)"],seealso:["ceil","floor","round"]}},function(e){e.exports={name:"floor",category:"Arithmetic",syntax:["floor(x)"],description:"Round a value towards minus infinity.If x is complex, both real and imaginary part are rounded towards minus infinity.",examples:["floor(3.2)","floor(3.8)","floor(-4.2)"],seealso:["ceil","fix","round"]}},function(e){e.exports={name:"gcd",category:"Arithmetic",syntax:["gcd(a, b)","gcd(a, b, c, ...)"],description:"Compute the greatest common divisor.",examples:["gcd(8, 12)","gcd(-4, 6)","gcd(25, 15, -10)"],seealso:["lcm","xgcd"]}},function(e){e.exports={name:"larger",category:"Operators",syntax:["x > y","larger(x, y)"],description:"Check if value x is larger than y. Returns true if x is larger than y, and false if not.",examples:["2 > 3","5 > 2*2","a = 3.3","b = 6-2.8","(a > b)","(b < a)","5 cm > 2 inch"],seealso:["equal","unequal","smaller","smallereq","largereq","compare"]}},function(e){e.exports={name:"largereq",category:"Operators",syntax:["x >= y","largereq(x, y)"],description:"Check if value x is larger or equal to y. Returns true if x is larger or equal to y, and false if not.",examples:["2 > 1+1","2 >= 1+1","a = 3.2","b = 6-2.8","(a > b)"],seealso:["equal","unequal","smallereq","smaller","largereq","compare"]}},function(e){e.exports={name:"lcm",category:"Arithmetic",syntax:["lcm(x, y)"],description:"Compute the least common multiple.",examples:["lcm(4, 6)","lcm(6, 21)","lcm(6, 21, 5)"],seealso:["gcd"]}},function(e){e.exports={name:"log",category:"Arithmetic",syntax:["log(x)","log(x, base)"],description:"Compute the logarithm of a value. If no base is provided, the natural logarithm of x is calculated. If base if provided, the logarithm is calculated for the specified base. log(x, base) is defined as log(x) / log(base).",examples:["log(3.5)","a = log(2.4)","exp(a)","10 ^ 4","log(10000, 10)","log(10000) / log(10)","b = log(1024, 2)","2 ^ b"],seealso:["exp","log10"]}},function(e){e.exports={name:"log10",category:"Arithmetic",syntax:["log10(x)"],description:"Compute the 10-base logarithm of a value.",examples:["log10(0.00001)","log10(10000)","10 ^ 4","log(10000) / log(10)","log(10000, 10)"],seealso:["exp","log"]}},function(e){e.exports={name:"mod",category:"Operators",syntax:["x % y","x mod y","mod(x, y)"],description:"Calculates the modulus, the remainder of an integer division.",examples:["7 % 3","11 % 2","10 mod 4","function isOdd(x) = x % 2","isOdd(2)","isOdd(3)"],seealso:["divide"]}},function(e){e.exports={name:"multiply",category:"Operators",syntax:["x * y","multiply(x, y)"],description:"multiply two values.",examples:["2.1 * 3.4","ans / 3.4","2 * 3 + 4","2 * (3 + 4)","3 * 2.1 km"],seealso:["divide"]}},function(e){e.exports={name:"norm",category:"Arithmetic",syntax:["norm(x)","norm(x, p)"],description:"Calculate the norm of a number, vector or matrix.",examples:["abs(-3.5)","norm(-3.5)","norm(3 - 4i))","norm([1, 2, -3], Infinity)","norm([1, 2, -3], -Infinity)","norm([3, 4], 2)","norm([[1, 2], [3, 4]], 1)","norm([[1, 2], [3, 4]], 'inf')","norm([[1, 2], [3, 4]], 'fro')"]}},function(e){e.exports={name:"pow",category:"Operators",syntax:["x ^ y","pow(x, y)"],description:"Calculates the power of x to y, x^y.",examples:["2^3 = 8","2*2*2","1 + e ^ (pi * i)"],seealso:["multiply"]}},function(e){e.exports={name:"round",category:"Arithmetic",syntax:["round(x)","round(x, n)"],description:"round a value towards the nearest integer.If x is complex, both real and imaginary part are rounded towards the nearest integer. When n is specified, the value is rounded to n decimals.",examples:["round(3.2)","round(3.8)","round(-4.2)","round(-4.8)","round(pi, 3)","round(123.45678, 2)"],seealso:["ceil","floor","fix"]}},function(e){e.exports={name:"sign",category:"Arithmetic",syntax:["sign(x)"],description:"Compute the sign of a value. The sign of a value x is 1 when x>1, -1 when x<0, and 0 when x=0.",examples:["sign(3.5)","sign(-4.2)","sign(0)"],seealso:["abs"]}},function(e){e.exports={name:"smaller",category:"Operators",syntax:["x < y","smaller(x, y)"],description:"Check if value x is smaller than value y. Returns true if x is smaller than y, and false if not.",examples:["2 < 3","5 < 2*2","a = 3.3","b = 6-2.8","(a < b)","5 cm < 2 inch"],seealso:["equal","unequal","larger","smallereq","largereq","compare"]}},function(e){e.exports={name:"smallereq",category:"Operators",syntax:["x <= y","smallereq(x, y)"],description:"Check if value x is smaller or equal to value y. Returns true if x is smaller than y, and false if not.",examples:["2 < 1+1","2 <= 1+1","a = 3.2","b = 6-2.8","(a < b)"],seealso:["equal","unequal","larger","smaller","largereq","compare"]}},function(e){e.exports={name:"sqrt",category:"Arithmetic",syntax:["sqrt(x)"],description:"Compute the square root value. If x = y * y, then y is the square root of x.",examples:["sqrt(25)","5 * 5","sqrt(-1)"],seealso:["square","multiply"]}},function(e){e.exports={name:"square",category:"Arithmetic",syntax:["square(x)"],description:"Compute the square of a value. The square of x is x * x.",examples:["square(3)","sqrt(9)","3^2","3 * 3"],seealso:["multiply","pow","sqrt","cube"]}},function(e){e.exports={name:"subtract",category:"Operators",syntax:["x - y","subtract(x, y)"],description:"subtract two values.",examples:["5.3 - 2","ans + 2","2/3 - 1/6","2 * 3 - 3","2.1 km - 500m"],seealso:["add"]}},function(e){e.exports={name:"unary",category:"Operators",syntax:["-x","unary(x)"],description:"Inverse the sign of a value.",examples:["-4.5","-(-5.6)"],seealso:["add","subtract"]}},function(e){e.exports={name:"unequal",category:"Operators",syntax:["x != y","unequal(x, y)"],description:"Check unequality of two values. Returns true if the values are unequal, and false if they are equal.",examples:["2+2 != 3","2+2 != 4","a = 3.2","b = 6-2.8","a != b","50cm != 0.5m","5 cm != 2 inch"],seealso:["equal","smaller","larger","smallereq","largereq","compare"]}},function(e){e.exports={name:"xgcd",category:"Arithmetic",syntax:["xgcd(a, b)"],description:"Calculate the extended greatest common divisor for two values",examples:["xgcd(8, 12)","gcd(8, 12)","xgcd(36163, 21199)"],seealso:["gcd","lcm"]}},function(e){e.exports={name:"arg",category:"Complex",syntax:["arg(x)"],description:"Compute the argument of a complex value. If x = a+bi, the argument is computed as atan2(b, a).",examples:["arg(2 + 2i)","atan2(3, 2)","arg(2 + 3i)"],seealso:["re","im","conj","abs"]}},function(e){e.exports={name:"conj",category:"Complex",syntax:["conj(x)"],description:"Compute the complex conjugate of a complex value. If x = a+bi, the complex conjugate is a-bi.",examples:["conj(2 + 3i)","conj(2 - 3i)","conj(-5.2i)"],seealso:["re","im","abs","arg"]}},function(e){e.exports={name:"re",category:"Complex",syntax:["re(x)"],description:"Get the real part of a complex number.",examples:["re(2 + 3i)","im(2 + 3i)","re(-5.2i)","re(2.4)"],seealso:["im","conj","abs","arg"]}},function(e){e.exports={name:"im",category:"Complex",syntax:["im(x)"],description:"Get the imaginary part of a complex number.",examples:["im(2 + 3i)","re(2 + 3i)","im(-5.2i)","im(2.4)"],seealso:["re","conj","abs","arg"]}},function(e){e.exports={name:"bignumber",category:"Type",syntax:["bignumber(x)"],description:"Create a big number from a number or string.",examples:["0.1 + 0.2","bignumber(0.1) + bignumber(0.2)",'bignumber("7.2")','bignumber("7.2e500")',"bignumber([0.1, 0.2, 0.3])"],seealso:["boolean","complex","index","matrix","string","unit"]}},function(e){e.exports={name:"boolean",category:"Type",syntax:["x","boolean(x)"],description:"Convert a string or number into a boolean.",examples:["boolean(0)","boolean(1)","boolean(3)",'boolean("true")','boolean("false")',"boolean([1, 0, 1, 1])"],seealso:["bignumber","complex","index","matrix","number","string","unit"]}},function(e){e.exports={name:"complex",category:"Type",syntax:["complex()","complex(re, im)","complex(string)"],description:"Create a complex number.",examples:["complex()","complex(2, 3)",'complex("7 - 2i")'],seealso:["bignumber","boolean","index","matrix","number","string","unit"]}},function(e){e.exports={name:"index",category:"Type",syntax:["[start]","[start:end]","[start:step:end]","[start1, start 2, ...]","[start1:end1, start2:end2, ...]","[start1:step1:end1, start2:step2:end2, ...]"],description:"Create an index to get or replace a subset of a matrix",examples:["[]","[1, 2, 3]","A = [1, 2, 3; 4, 5, 6]","A[1, :]","A[1, 2] = 50","A[0:2, 0:2] = ones(2, 2)"],seealso:["bignumber","boolean","complex","matrix,","number","range","string","unit"]}},function(e){e.exports={name:"matrix",category:"Type",syntax:["[]","[a1, b1, ...; a2, b2, ...]","matrix()","matrix([...])"],description:"Create a matrix.",examples:["[]","[1, 2, 3]","[1, 2, 3; 4, 5, 6]","matrix()","matrix([3, 4])"],seealso:["bignumber","boolean","complex","index","number","string","unit"]}},function(e){e.exports={name:"number",category:"Type",syntax:["x","number(x)"],description:"Create a number or convert a string or boolean into a number.",examples:["2","2e3","4.05","number(2)",'number("7.2")',"number(true)","number([true, false, true, true])"],seealso:["bignumber","boolean","complex","index","matrix","string","unit"]}},function(e){e.exports={name:"string",category:"Type",syntax:['"text"',"string(x)"],description:"Create a string or convert a value to a string",examples:['"Hello World!"',"string(4.2)","string(3 + 2i)"],seealso:["bignumber","boolean","complex","index","matrix","number","unit"]}},function(e){e.exports={name:"unit",category:"Type",syntax:["value unit","unit(value, unit)","unit(string)"],description:"Create a unit.",examples:["5.5 mm","3 inch",'unit(7.1, "kilogram")','unit("23 deg")'],seealso:["bignumber","boolean","complex","index","matrix","number","string"]}},function(e){e.exports={name:"eval",category:"Expression",syntax:["eval(expression)","eval([expr1, expr2, expr3, ...])"],description:"Evaluate an expression or an array with expressions.",examples:['eval("2 + 3")','eval("sqrt(" + 4 + ")")'],seealso:[]}},function(e){e.exports={name:"help",category:"Expression",syntax:["help(object)","help(string)"],description:"Display documentation on a function or data type.",examples:["help(sqrt)",'help("complex")'],seealso:[]}},function(e){e.exports={name:"concat",category:"Matrix",syntax:["concat(A, B, C, ...)","concat(A, B, C, ..., dim)"],description:"Concatenate matrices. By default, the matrices are concatenated by the first dimension. The dimension on which to concatenate can be provided as last argument.",examples:["A = [1, 2; 5, 6]","B = [3, 4; 7, 8]","concat(A, B)","[A, B]","concat(A, B, 1)","[A; B]"],seealso:["det","diag","eye","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"det",category:"Matrix",syntax:["det(x)"],description:"Calculate the determinant of a matrix",examples:["det([1, 2; 3, 4])","det([-2, 2, 3; -1, 1, 3; 2, 0, -1])"],seealso:["concat","diag","eye","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"diag",category:"Matrix",syntax:["diag(x)","diag(x, k)"],description:"Create a diagonal matrix or retrieve the diagonal of a matrix. When x is a vector, a matrix with the vector values on the diagonal will be returned. When x is a matrix, a vector with the diagonal values of the matrix is returned. When k is provided, the k-th diagonal will be filled in or retrieved, if k is positive, the values are placed on the super diagonal. When k is negative, the values are placed on the sub diagonal.",examples:["diag(1:3)","diag(1:3, 1)","a = [1, 2, 3; 4, 5, 6; 7, 8, 9]","diag(a)"],seealso:["concat","det","eye","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"eye",category:"Matrix",syntax:["eye(n)","eye(m, n)","eye([m, n])","eye"],description:"Returns the identity matrix with size m-by-n. The matrix has ones on the diagonal and zeros elsewhere.",examples:["eye(3)","eye(3, 5)","a = [1, 2, 3; 4, 5, 6]","eye(size(a))"],seealso:["concat","det","diag","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"inv",category:"Matrix",syntax:["inv(x)"],description:"Calculate the inverse of a matrix",examples:["inv([1, 2; 3, 4])","inv(4)","1 / 4"],seealso:["concat","det","diag","eye","ones","range","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"ones",category:"Matrix",syntax:["ones(m)","ones(m, n)","ones(m, n, p, ...)","ones([m])","ones([m, n])","ones([m, n, p, ...])","ones"],description:"Create a matrix containing ones.",examples:["ones(3)","ones(3, 5)","ones([2,3]) * 4.5","a = [1, 2, 3; 4, 5, 6]","ones(size(a))"],seealso:["concat","det","diag","eye","inv","range","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"range",category:"Type",syntax:["start:end","start:step:end","range(start, end)","range(start, end, step)","range(string)"],description:"Create a range. Lower bound of the range is included, upper bound is excluded.",examples:["1:5","3:-1:-3","range(3, 7)","range(0, 12, 2)",'range("4:10")',"a = [1, 2, 3, 4; 5, 6, 7, 8]","a[1:2, 1:2]"],seealso:["concat","det","diag","eye","inv","ones","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"resize",category:"Matrix",syntax:["resize(x, size)","resize(x, size, defaultValue)"],description:"Resize a matrix.",examples:["resize([1,2,3,4,5], [3])","resize([1,2,3], [5], 0)","resize(2, [2, 3], 0)",'resize("hello", [8], "!")'],seealso:["size","subset","squeeze"]}},function(e){e.exports={name:"size",category:"Matrix",syntax:["size(x)"],description:"Calculate the size of a matrix.",examples:["size(2.3)",'size("hello world")',"a = [1, 2; 3, 4; 5, 6]","size(a)","size(1:6)"],seealso:["concat","det","diag","eye","inv","ones","range","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"squeeze",category:"Matrix",syntax:["squeeze(x)"],description:"Remove singleton dimensions from a matrix.",examples:["a = zeros(1,3,2)","size(squeeze(a))","b = zeros(3,1,1)","size(squeeze(b))"],seealso:["concat","det","diag","eye","inv","ones","range","size","subset","transpose","zeros"]}},function(e){e.exports={name:"subset",category:"Matrix",syntax:["value(index)","value(index) = replacement","subset(value, [index])","subset(value, [index], replacement)"],description:"Get or set a subset of a matrix or string. Indexes are one-based. Both the ranges lower-bound and upper-bound are included.",examples:["d = [1, 2; 3, 4]","e = []","e[1, 1:2] = [5, 6]","e[2, :] = [7, 8]","f = d * e","f[2, 1]","f[:, 1]"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","transpose","zeros"]}},function(e){e.exports={name:"transpose",category:"Matrix",syntax:["x'","transpose(x)"],description:"Transpose a matrix",examples:["a = [1, 2, 3; 4, 5, 6]","a'","transpose(a)"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","zeros"]}},function(e){e.exports={name:"zeros",category:"Matrix",syntax:["zeros(m)","zeros(m, n)","zeros(m, n, p, ...)","zeros([m])","zeros([m, n])","zeros([m, n, p, ...])","zeros"],description:"Create a matrix containing zeros.",examples:["zeros(3)","zeros(3, 5)","a = [1, 2, 3; 4, 5, 6]","zeros(size(a))"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","transpose"]}},function(e){e.exports={name:"combinations",category:"Probability",syntax:["combinations(n, k)"],description:"Compute the number of combinations of n items taken k at a time",examples:["combinations(7, 5)"],seealso:["permutations","factorial"]}},function(e){e.exports={name:"distribution",category:"Probability",syntax:["distribution(name)","distribution(name, arg1, arg2, ...)"],description:'Create a distribution object of a specific type. A distribution object contains functions `random([size,] [min,] [max])`, `randomInt([size,] [min,] [max])`, and `pickRandom(array)`. Available types of distributions: "uniform", "normal". Note that the function distribution is currently not available via the expression parser.',examples:[],seealso:["random","randomInt"]}},function(e){e.exports={name:"factorial",category:"Probability",syntax:["n!","factorial(n)"],description:"Compute the factorial of a value",examples:["5!","5*4*3*2*1","3!"],seealso:["combinations","permutations"]}},function(e){e.exports={name:"permutations",category:"Probability",syntax:["permutations(n)","permutations(n, k)"],description:"Compute the number of permutations of n items taken k at a time",examples:["permutations(5)","permutations(5, 3)"],seealso:["combinations","factorial"]}},function(e){e.exports={name:"pickRandom",category:"Probability",syntax:["pickRandom(array)"],description:"Pick a random entry from a given array.",examples:["pickRandom(0:10)","pickRandom([1, 3, 1, 6])"],seealso:["distribution","random","randomInt"]}},function(e){e.exports={name:"random",category:"Probability",syntax:["random()","random(max)","random(min, max)","random(size)","random(size, max)","random(size, min, max)"],description:"Return a random number.",examples:["random()","random(10, 20)","random([2, 3])"],seealso:["distribution","pickRandom","randomInt"]}},function(e){e.exports={name:"randInt",category:"Probability",syntax:["randInt()","randInt(max)","randInt(min, max)","randInt(size)","randInt(size, max)","randInt(size, min, max)"],description:"Return a random integer number",examples:["randInt()","randInt(10, 20)","randInt([2, 3], 10)"],seealso:["distribution","pickRandom","random"]}},function(e){e.exports={name:"max",category:"Statistics",syntax:["max(a, b, c, ...)","max(A)","max(A, dim)"],description:"Compute the maximum value of a list of values.",examples:["max(2, 3, 4, 1)","max([2, 3, 4, 1])","max([2, 5; 4, 3], 0)","max([2, 5; 4, 3], 1)","max(2.7, 7.1, -4.5, 2.0, 4.1)","min(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["mean","median","min","prod","std","sum","var"]}},function(e){e.exports={name:"mean",category:"Statistics",syntax:["mean(a, b, c, ...)","mean(A)","mean(A, dim)"],description:"Compute the arithmetic mean of a list of values.",examples:["mean(2, 3, 4, 1)","mean([2, 3, 4, 1])","mean([2, 5; 4, 3], 0)","mean([2, 5; 4, 3], 1)","mean([1.0, 2.7, 3.2, 4.0])"],seealso:["max","median","min","prod","std","sum","var"]}},function(e){e.exports={name:"median",category:"Statistics",syntax:["median(a, b, c, ...)","median(A)"],description:"Compute the median of all values. The values are sorted and the middle value is returned. In case of an even number of values, the average of the two middle values is returned.",examples:["median(5, 2, 7)","median([3, -1, 5, 7])"],seealso:["max","mean","min","prod","std","sum","var"]}},function(e){e.exports={name:"min",category:"Statistics",syntax:["min(a, b, c, ...)","min(A)","min(A, dim)"],description:"Compute the minimum value of a list of values.",examples:["min(2, 3, 4, 1)","min([2, 3, 4, 1])","min([2, 5; 4, 3], 0)","min([2, 5; 4, 3], 1)","min(2.7, 7.1, -4.5, 2.0, 4.1)","max(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["max","mean","median","prod","std","sum","var"]}},function(e){e.exports={name:"prod",category:"Statistics",syntax:["prod(a, b, c, ...)","prod(A)"],description:"Compute the product of all values.",examples:["prod(2, 3, 4)","prod([2, 3, 4])","prod([2, 5; 4, 3])"],seealso:["max","mean","min","median","min","std","sum","var"]}},function(e){e.exports={name:"std",category:"Statistics",syntax:["std(a, b, c, ...)","std(A)","std(A, normalization)"],description:'Compute the standard deviation of all values, defined as std(A) = sqrt(var(A)). Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',examples:["std(2, 4, 6)","std([2, 4, 6, 8])",'std([2, 4, 6, 8], "uncorrected")','std([2, 4, 6, 8], "biased")',"std([1, 2, 3; 4, 5, 6])"],seealso:["max","mean","min","median","min","prod","sum","var"]}},function(e){e.exports={name:"sum",category:"Statistics",syntax:["sum(a, b, c, ...)","sum(A)"],description:"Compute the sum of all values.",examples:["sum(2, 3, 4, 1)","sum([2, 3, 4, 1])","sum([2, 5; 4, 3])"],seealso:["max","mean","median","min","prod","std","sum","var"]}},function(e){e.exports={name:"var",category:"Statistics",syntax:["var(a, b, c, ...)","var(A)","var(A, normalization)"],description:'Compute the variance of all values. Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',examples:["var(2, 4, 6)","var([2, 4, 6, 8])",'var([2, 4, 6, 8], "uncorrected")','var([2, 4, 6, 8], "biased")',"var([1, 2, 3; 4, 5, 6])"],seealso:["max","mean","min","median","min","prod","std","sum"]}},function(e){e.exports={name:"acos",category:"Trigonometry",syntax:["acos(x)"],description:"Compute the inverse cosine of a value in radians.",examples:["acos(0.5)","acos(cos(2.3))"],seealso:["cos","atan","asin"]}},function(e){e.exports={name:"asin",category:"Trigonometry",syntax:["asin(x)"],description:"Compute the inverse sine of a value in radians.",examples:["asin(0.5)","asin(sin(2.3))"],seealso:["sin","acos","atan"]}},function(e){e.exports={name:"atan",category:"Trigonometry",syntax:["atan(x)"],description:"Compute the inverse tangent of a value in radians.",examples:["atan(0.5)","atan(tan(2.3))"],seealso:["tan","acos","asin"]}},function(e){e.exports={name:"atan2",category:"Trigonometry",syntax:["atan2(y, x)"],description:"Computes the principal value of the arc tangent of y/x in radians.",examples:["atan2(2, 2) / pi","angle = 60 deg in rad","x = cos(angle)","y = sin(angle)","atan2(y, x)"],seealso:["sin","cos","tan"]}},function(e){e.exports={name:"cos",category:"Trigonometry",syntax:["cos(x)"],description:"Compute the cosine of x in radians.",examples:["cos(2)","cos(pi / 4) ^ 2","cos(180 deg)","cos(60 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["acos","sin","tan"]}},function(e){e.exports={name:"cosh",category:"Trigonometry",syntax:["cosh(x)"],description:"Compute the hyperbolic cosine of x in radians.",examples:["cosh(0.5)"],seealso:["sinh","tanh","coth"]}},function(e){e.exports={name:"cot",category:"Trigonometry",syntax:["cot(x)"],description:"Compute the cotangent of x in radians. Defined as 1/tan(x)",examples:["cot(2)","1 / tan(2)"],seealso:["sec","csc","tan"]}},function(e){e.exports={name:"coth",category:"Trigonometry",syntax:["coth(x)"],description:"Compute the hyperbolic cotangent of x in radians.",examples:["coth(2)","1 / tanh(2)"],seealso:["sech","csch","tanh"]}},function(e){e.exports={name:"csc",category:"Trigonometry",syntax:["csc(x)"],description:"Compute the cosecant of x in radians. Defined as 1/sin(x)",examples:["csc(2)","1 / sin(2)"],seealso:["sec","cot","sin"]}},function(e){e.exports={name:"csch",category:"Trigonometry",syntax:["csch(x)"],description:"Compute the hyperbolic cosecant of x in radians. Defined as 1/sinh(x)",examples:["csch(2)","1 / sinh(2)"],seealso:["sech","coth","sinh"]}},function(e){e.exports={name:"sec",category:"Trigonometry",syntax:["sec(x)"],description:"Compute the secant of x in radians. Defined as 1/cos(x)",examples:["sec(2)","1 / cos(2)"],seealso:["cot","csc","cos"]}},function(e){e.exports={name:"sech",category:"Trigonometry",syntax:["sech(x)"],description:"Compute the hyperbolic secant of x in radians. Defined as 1/cosh(x)",examples:["sech(2)","1 / cosh(2)"],seealso:["coth","csch","cosh"]}},function(e){e.exports={name:"sin",category:"Trigonometry",syntax:["sin(x)"],description:"Compute the sine of x in radians.",examples:["sin(2)","sin(pi / 4) ^ 2","sin(90 deg)","sin(30 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["asin","cos","tan"]}},function(e){e.exports={name:"sinh",category:"Trigonometry",syntax:["sinh(x)"],description:"Compute the hyperbolic sine of x in radians.",examples:["sinh(0.5)"],seealso:["cosh","tanh"]}},function(e){e.exports={name:"tan",category:"Trigonometry",syntax:["tan(x)"],description:"Compute the tangent of x in radians.",examples:["tan(0.5)","sin(0.5) / cos(0.5)","tan(pi / 4)","tan(45 deg)"],seealso:["atan","sin","cos"]}},function(e){e.exports={name:"tanh",category:"Trigonometry",syntax:["tanh(x)"],description:"Compute the hyperbolic tangent of x in radians.",examples:["tanh(0.5)","sinh(0.5) / cosh(0.5)"],seealso:["sinh","cosh"]}},function(e){e.exports={name:"to",category:"Units",syntax:["x to unit","to(x, unit)"],description:"Change the unit of a value.",examples:["5 inch to cm","3.2kg to g","16 bytes in bits"],seealso:[]}},function(e){e.exports={name:"clone",category:"Utils",syntax:["clone(x)"],description:"Clone a variable. Creates a copy of primitive variables,and a deep copy of matrices",examples:["clone(3.5)","clone(2 - 4i)","clone(45 deg)","clone([1, 2; 3, 4])",'clone("hello world")'],seealso:[]}},function(e){e.exports={name:"map",category:"Utils",syntax:["map(x, callback)"],description:"Create a new matrix or array with the results of the callback function executed on each entry of the matrix/array.",examples:["map([1, 2, 3], function(val) { return value * value })"],seealso:[]}},function(e){e.exports={name:"forEach",category:"Utils",syntax:["forEach(x, callback)"],description:"Iterates over all elements of a matrix/array, and executes the given callback function.",examples:["forEach([1, 2, 3], function(val) { console.log(val) })"],seealso:["unit"]}
},function(e){e.exports={name:"format",category:"Utils",syntax:["format(value)","format(value, precision)"],description:"Format a value of any type as string.",examples:["format(2.3)","format(3 - 4i)","format([])","format(pi, 3)"],seealso:["print"]}},function(e){e.exports={name:"ifElse",category:"Utils",syntax:["ifElse(conditional, trueExpr, falseExpr)"],description:"Executes a conditional expression.",examples:["ifElse(10 > 0, 1, 0)",'ifElse("", true, false)',"ifElse([4, 6, 0, -1], true, false)"],seealso:[]}},function(e){e.exports={name:"import",category:"Utils",syntax:["import(string)"],description:"Import functions from a file.",examples:['import("numbers")','import("./mylib.js")'],seealso:[]}},function(e){e.exports={name:"typeof",category:"Utils",syntax:["typeof(x)"],description:"Get the type of a variable.",examples:["typeof(3.5)","typeof(2 - 4i)","typeof(45 deg)",'typeof("hello world")'],seealso:[]}},function(r){r.exports=e},function(e,r){r.isBoolean=function(e){return e instanceof Boolean||"boolean"==typeof e}},function(e,r,n){var t=n(118),i=n(154).isNumber;digits=n(154).digits,r.isBigNumber=function(e){return e instanceof t},r.format=function(e,n){if("function"==typeof n)return n(e);if(!e.isFinite())return e.isNaN()?"NaN":e.gt(0)?"Infinity":"-Infinity";var t="auto",o=void 0;switch(void 0!==n&&(n.notation&&(t=n.notation),i(n)?o=n:n.precision&&(o=n.precision)),t){case"fixed":return r.toFixed(e,o);case"exponential":return r.toExponential(e,o);case"auto":var a=.001,s=1e5;n&&n.exponential&&(void 0!==n.exponential.lower&&(a=n.exponential.lower),void 0!==n.exponential.upper&&(s=n.exponential.upper));{({toExpNeg:e.constructor.toExpNeg,toExpPos:e.constructor.toExpPos})}if(e.constructor.config({toExpNeg:Math.round(Math.log(a)/Math.LN10),toExpPos:Math.round(Math.log(s)/Math.LN10)}),e.isZero())return"0";var u,f=e.abs();return u=f.gte(a)&&f.lt(s)?e.toSignificantDigits(o).toFixed():r.toExponential(e,o),u.replace(/((\.\d*?)(0+))($|e)/,function(){var e=arguments[2],r=arguments[4];return"."!==e?e+r:r});default:throw new Error('Unknown notation "'+t+'". Choose "auto", "exponential", or "fixed".')}},r.toExponential=function(e,r){return void 0!==r?e.toExponential(r-1):e.toExponential()},r.toFixed=function(e,r){return e.toFixed(r||0)}},function(e,r,n){function t(){for(var e,r=Array.prototype.slice.call(arguments),n=0,t=r.length;t>n;n++){e=r[n];for(var i in e)e.hasOwnProperty(i)&&(x[i]=e[i])}}function i(e,r){return"undefined"!=typeof e[r]}function o(e){return function(r){return i(e,r)}}function a(e){return function(n){if("boolean"==typeof e[n])n=e[n]===!0?"\\"+n:"\\mathrm{"+n+"}";else if("string"==typeof e[n])n=e[n];else if("string"==typeof n){var t=n.indexOf("_");-1!==t&&(n=r.toSymbol(n.substring(0,t))+"_{"+r.toSymbol(n.substring(t+1))+"}")}return n}}var s=n(124),u=n(130),f={Alpha:"A",alpha:!0,Beta:"B",beta:!0,Gamma:!0,gamma:!0,Delta:!0,delta:!0,Epsilon:"E",epsilon:!0,varepsilon:!0,Zeta:"Z",zeta:!0,Eta:"H",eta:!0,Theta:!0,theta:!0,vartheta:!0,Iota:"I",iota:!0,Kappa:"K",kappa:!0,varkappa:!0,Lambda:!0,lambda:!0,Mu:"M",mu:!0,Nu:"N",nu:!0,Xi:!0,xi:!0,Omicron:"O",omicron:!0,Pi:!0,pi:!0,varpi:!0,Rho:"P",rho:!0,varrho:!0,Sigma:!0,sigma:!0,varsigma:!0,Tau:"T",tau:!0,Upsilon:!0,upsilon:!0,Phi:!0,phi:!0,varphi:!0,Chi:"X",chi:!0,Psi:!0,psi:!0,Omega:!0,omega:!0},c={dots:!0,ldots:!0,cdots:!0,vdots:!0,ddots:!0,idots:!0},l={"true":"\\mathrm{True}","false":"\\mathrm{False}"},p={inf:"\\infty",Inf:"\\infty",infinity:"\\infty",Infinity:"\\infty",oo:"\\infty",lim:!0,undefined:"\\mathbf{?}"},m={acos:"\\cos^{-1}",arccos:"\\cos^{-1}",cos:!0,csc:!0,csch:!1,exp:!0,ker:!0,limsup:!0,min:!0,sinh:!0,asin:"\\sin^{-1}",arcsin:"\\sin^{-1}",cosh:!0,deg:!0,gcd:!0,lg:!0,ln:!0,Pr:!0,sup:!0,atan:"\\tan^{-1}",atan2:"\\tan2^{-1}",arctan:"\\tan^{-1}",cot:!0,det:!0,hom:!0,log:!0,log10:"\\log_{10}",sec:!0,sech:!1,tan:!0,arg:!0,coth:!0,dim:!0,inf:!0,max:!0,sin:!0,tanh:!0,fix:!1,lcm:!1,sign:!1,xgcd:!1,unary:!1,complex:!1,conj:!1,im:!1,re:!1,diag:!1,resize:!1,size:!1,squeeze:!1,subset:!1,index:!1,ones:!1,zeros:!1,range:!1,random:!1,mean:"\\mu",median:!1,prod:!1,std:"\\sigma","var":"\\sigma^2"},h={sqrt:!0,inv:!0,"int":"\\int",Int:"\\int",integrate:"\\int",eigenvalues:"\\lambda",liminf:!0,lim:!0,exp:"e^",sum:!0,eye:"\\mathbf{I}"},g={"<=":"\\leq",">=":"\\geq","!=":"\\neq","in":!0,"*":"\\cdot","/":"\\frac",mod:"\\bmod",to:"\\rightarrow"},d={deg:"^{\\circ}"},x={};t(m,h,f,c,l,p),r.isSymbol=o(x),r.toSymbol=a(x),r.isFunction=o(m),r.toFunction=a(m),r.isCurlyFunction=o(h),r.toCurlyFunction=a(h),r.isOperator=o(g),r.toOperator=a(g),r.isUnit=o(d),r.toUnit=function(){var e=a(d);return function(n,t){return r.isUnit(n)?e(n):(t?"":"\\,")+"\\mathrm{"+n+"}"}}(),r.addBraces=function(e,r,n){if(null===r)return e;var t=["",""];switch(n=n||"normal","undefined"==typeof r||r===!1?t=["{","}"]:r===!0?(t=["(",")"],n="lr"):t=Array.isArray(r)&&2===r.length?r:[r,r],n){case"normal":case!1:return t[0]+e+t[1];case"lr":return"\\left"+t[0]+"{"+e+"}\\right"+t[1];case"be":return"\\begin{"+t[0]+"}"+e+"\\end{"+t[1]+"}"}return t[0]+e+t[1]},r.toParams=function(e){var n=e.object,t=e.params,i=n.toTex(),o=null,a=null,f=!1,c=!1,l="",p="",m=null;switch(n.name){case"add":m="+";break;case"subtract":m="-";break;case"larger":m=">";break;case"largereq":m=">=";break;case"smaller":m="<";break;case"smallereq":m="<=";break;case"unequal":m="!=";break;case"equal":m="=";break;case"mod":m="mod";break;case"multiply":m="*";break;case"pow":m="^";break;case"concat":m="||";break;case"factorial":m="!";break;case"permutations":if(1!==t.length){var h=t[0].toTex(),g=t[1].toTex();return"\\frac{"+h+"!}{\\left("+h+" - "+g+"\\right)!}"}m="!";break;case"combinations":m="\\choose";break;case"abs":a="|",f="lr";break;case"norm":if(a="\\|",f="lr",2===t.length){var d=t[1].toTex();"\\text{inf}"===d?d="\\infty":"\\text{-inf}"===d?d="{- \\infty}":"\\text{fro}"===d&&(d="F"),p="_{"+d+"}",t=[t[0]]}break;case"ceil":a=["\\lceil","\\rceil"],f="lr";break;case"floor":a=["\\lfloor","\\rfloor"],f="lr";break;case"round":a=["\\lfloor","\\rceil"],f="lr",2===t.length&&(p="_"+r.addBraces(t[1].toTex()),t=[t[0]]);break;case"inv":p="^{-1}";break;case"transpose":p="^{T}",a=!1;break;case"log":var x="e";2===t.length&&(x=t[1].toTex(),i="\\log_{"+x+"}",t=[t[0]]),"e"===x&&(i="\\ln"),c=!0;break;case"square":p="^{2}";break;case"cube":p="^{3}";break;case"eye":c=!0,a=!1,i+="_";break;case"det":if(e.params[0]instanceof s)return e.params[0].toTex("vmatrix");a="vmatrix",f="be";break;default:c=!0}return null!==m?(a="+"===m||"-"===m,o=new u(m,n.name,t).toTex()):m=", ",null!==a||r.isCurlyFunction(n.name)||(a=!0),o=o||t.map(function(e){return"{"+e.toTex()+"}"}).join(m),l+(c?i:"")+r.addBraces(o,a,f)+p}},function(e){e.exports=function(e){return e.webpackPolyfill||(e.deprecate=function(){},e.paths=[],e.children=[],e.webpackPolyfill=1),e}}])});
//# sourceMappingURL=math.map