# coding: utf-8

"""
    Component Database API

    The API that provides access to Component Database data.  # noqa: E501

    The version of the OpenAPI document: 3.8.0
    Contact: djarosz@anl.gov
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from cdbApi.configuration import Configuration


class ItemSource(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'part_number': 'str',
        'cost': 'float',
        'description': 'str',
        'is_vendor': 'bool',
        'is_manufacturer': 'bool',
        'contact_info': 'str',
        'url': 'str',
        'item': 'Item',
        'source': 'Source',
        'target_url': 'str',
        'display_url': 'str',
        'is_vendor_string': 'str',
        'is_manufacturer_string': 'str'
    }

    attribute_map = {
        'id': 'id',
        'part_number': 'partNumber',
        'cost': 'cost',
        'description': 'description',
        'is_vendor': 'isVendor',
        'is_manufacturer': 'isManufacturer',
        'contact_info': 'contactInfo',
        'url': 'url',
        'item': 'item',
        'source': 'source',
        'target_url': 'targetUrl',
        'display_url': 'displayUrl',
        'is_vendor_string': 'isVendorString',
        'is_manufacturer_string': 'isManufacturerString'
    }

    def __init__(self, id=None, part_number=None, cost=None, description=None, is_vendor=None, is_manufacturer=None, contact_info=None, url=None, item=None, source=None, target_url=None, display_url=None, is_vendor_string=None, is_manufacturer_string=None, local_vars_configuration=None):  # noqa: E501
        """ItemSource - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._part_number = None
        self._cost = None
        self._description = None
        self._is_vendor = None
        self._is_manufacturer = None
        self._contact_info = None
        self._url = None
        self._item = None
        self._source = None
        self._target_url = None
        self._display_url = None
        self._is_vendor_string = None
        self._is_manufacturer_string = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if part_number is not None:
            self.part_number = part_number
        if cost is not None:
            self.cost = cost
        if description is not None:
            self.description = description
        self.is_vendor = is_vendor
        self.is_manufacturer = is_manufacturer
        if contact_info is not None:
            self.contact_info = contact_info
        if url is not None:
            self.url = url
        if item is not None:
            self.item = item
        if source is not None:
            self.source = source
        if target_url is not None:
            self.target_url = target_url
        if display_url is not None:
            self.display_url = display_url
        if is_vendor_string is not None:
            self.is_vendor_string = is_vendor_string
        if is_manufacturer_string is not None:
            self.is_manufacturer_string = is_manufacturer_string

    @property
    def id(self):
        """Gets the id of this ItemSource.  # noqa: E501


        :return: The id of this ItemSource.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ItemSource.


        :param id: The id of this ItemSource.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def part_number(self):
        """Gets the part_number of this ItemSource.  # noqa: E501


        :return: The part_number of this ItemSource.  # noqa: E501
        :rtype: str
        """
        return self._part_number

    @part_number.setter
    def part_number(self, part_number):
        """Sets the part_number of this ItemSource.


        :param part_number: The part_number of this ItemSource.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                part_number is not None and len(part_number) > 64):
            raise ValueError("Invalid value for `part_number`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                part_number is not None and len(part_number) < 0):
            raise ValueError("Invalid value for `part_number`, length must be greater than or equal to `0`")  # noqa: E501

        self._part_number = part_number

    @property
    def cost(self):
        """Gets the cost of this ItemSource.  # noqa: E501


        :return: The cost of this ItemSource.  # noqa: E501
        :rtype: float
        """
        return self._cost

    @cost.setter
    def cost(self, cost):
        """Sets the cost of this ItemSource.


        :param cost: The cost of this ItemSource.  # noqa: E501
        :type: float
        """

        self._cost = cost

    @property
    def description(self):
        """Gets the description of this ItemSource.  # noqa: E501


        :return: The description of this ItemSource.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ItemSource.


        :param description: The description of this ItemSource.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) > 256):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `256`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) < 0):
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `0`")  # noqa: E501

        self._description = description

    @property
    def is_vendor(self):
        """Gets the is_vendor of this ItemSource.  # noqa: E501


        :return: The is_vendor of this ItemSource.  # noqa: E501
        :rtype: bool
        """
        return self._is_vendor

    @is_vendor.setter
    def is_vendor(self, is_vendor):
        """Sets the is_vendor of this ItemSource.


        :param is_vendor: The is_vendor of this ItemSource.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_vendor is None:  # noqa: E501
            raise ValueError("Invalid value for `is_vendor`, must not be `None`")  # noqa: E501

        self._is_vendor = is_vendor

    @property
    def is_manufacturer(self):
        """Gets the is_manufacturer of this ItemSource.  # noqa: E501


        :return: The is_manufacturer of this ItemSource.  # noqa: E501
        :rtype: bool
        """
        return self._is_manufacturer

    @is_manufacturer.setter
    def is_manufacturer(self, is_manufacturer):
        """Sets the is_manufacturer of this ItemSource.


        :param is_manufacturer: The is_manufacturer of this ItemSource.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_manufacturer is None:  # noqa: E501
            raise ValueError("Invalid value for `is_manufacturer`, must not be `None`")  # noqa: E501

        self._is_manufacturer = is_manufacturer

    @property
    def contact_info(self):
        """Gets the contact_info of this ItemSource.  # noqa: E501


        :return: The contact_info of this ItemSource.  # noqa: E501
        :rtype: str
        """
        return self._contact_info

    @contact_info.setter
    def contact_info(self, contact_info):
        """Sets the contact_info of this ItemSource.


        :param contact_info: The contact_info of this ItemSource.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                contact_info is not None and len(contact_info) > 64):
            raise ValueError("Invalid value for `contact_info`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                contact_info is not None and len(contact_info) < 0):
            raise ValueError("Invalid value for `contact_info`, length must be greater than or equal to `0`")  # noqa: E501

        self._contact_info = contact_info

    @property
    def url(self):
        """Gets the url of this ItemSource.  # noqa: E501


        :return: The url of this ItemSource.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this ItemSource.


        :param url: The url of this ItemSource.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                url is not None and len(url) > 256):
            raise ValueError("Invalid value for `url`, length must be less than or equal to `256`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                url is not None and len(url) < 0):
            raise ValueError("Invalid value for `url`, length must be greater than or equal to `0`")  # noqa: E501

        self._url = url

    @property
    def item(self):
        """Gets the item of this ItemSource.  # noqa: E501


        :return: The item of this ItemSource.  # noqa: E501
        :rtype: Item
        """
        return self._item

    @item.setter
    def item(self, item):
        """Sets the item of this ItemSource.


        :param item: The item of this ItemSource.  # noqa: E501
        :type: Item
        """

        self._item = item

    @property
    def source(self):
        """Gets the source of this ItemSource.  # noqa: E501


        :return: The source of this ItemSource.  # noqa: E501
        :rtype: Source
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this ItemSource.


        :param source: The source of this ItemSource.  # noqa: E501
        :type: Source
        """

        self._source = source

    @property
    def target_url(self):
        """Gets the target_url of this ItemSource.  # noqa: E501


        :return: The target_url of this ItemSource.  # noqa: E501
        :rtype: str
        """
        return self._target_url

    @target_url.setter
    def target_url(self, target_url):
        """Sets the target_url of this ItemSource.


        :param target_url: The target_url of this ItemSource.  # noqa: E501
        :type: str
        """

        self._target_url = target_url

    @property
    def display_url(self):
        """Gets the display_url of this ItemSource.  # noqa: E501


        :return: The display_url of this ItemSource.  # noqa: E501
        :rtype: str
        """
        return self._display_url

    @display_url.setter
    def display_url(self, display_url):
        """Sets the display_url of this ItemSource.


        :param display_url: The display_url of this ItemSource.  # noqa: E501
        :type: str
        """

        self._display_url = display_url

    @property
    def is_vendor_string(self):
        """Gets the is_vendor_string of this ItemSource.  # noqa: E501


        :return: The is_vendor_string of this ItemSource.  # noqa: E501
        :rtype: str
        """
        return self._is_vendor_string

    @is_vendor_string.setter
    def is_vendor_string(self, is_vendor_string):
        """Sets the is_vendor_string of this ItemSource.


        :param is_vendor_string: The is_vendor_string of this ItemSource.  # noqa: E501
        :type: str
        """

        self._is_vendor_string = is_vendor_string

    @property
    def is_manufacturer_string(self):
        """Gets the is_manufacturer_string of this ItemSource.  # noqa: E501


        :return: The is_manufacturer_string of this ItemSource.  # noqa: E501
        :rtype: str
        """
        return self._is_manufacturer_string

    @is_manufacturer_string.setter
    def is_manufacturer_string(self, is_manufacturer_string):
        """Sets the is_manufacturer_string of this ItemSource.


        :param is_manufacturer_string: The is_manufacturer_string of this ItemSource.  # noqa: E501
        :type: str
        """

        self._is_manufacturer_string = is_manufacturer_string

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ItemSource):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ItemSource):
            return True

        return self.to_dict() != other.to_dict()
