# coding: utf-8

"""
    Component Database API

    The API that provides access to Component Database data.  # noqa: E501

    The version of the OpenAPI document: 3.8.0
    Contact: djarosz@anl.gov
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from cdbApi.configuration import Configuration


class Log(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'text': 'str',
        'entered_on_date_time': 'datetime',
        'effective_from_date_time': 'datetime',
        'effective_to_date_time': 'datetime',
        'attachment_list': 'list[Attachment]',
        'log_level_list': 'list[LogLevel]',
        'item_element_list': 'list[ItemElement]',
        'entered_by_user': 'UserInfo',
        'log_topic': 'LogTopic',
        'log_topic_id': 'LogTopic',
        'entered_by_user_id': 'UserInfo',
        'short_display_entered_on_date_time': 'str'
    }

    attribute_map = {
        'id': 'id',
        'text': 'text',
        'entered_on_date_time': 'enteredOnDateTime',
        'effective_from_date_time': 'effectiveFromDateTime',
        'effective_to_date_time': 'effectiveToDateTime',
        'attachment_list': 'attachmentList',
        'log_level_list': 'logLevelList',
        'item_element_list': 'itemElementList',
        'entered_by_user': 'enteredByUser',
        'log_topic': 'logTopic',
        'log_topic_id': 'logTopicId',
        'entered_by_user_id': 'enteredByUserId',
        'short_display_entered_on_date_time': 'shortDisplayEnteredOnDateTime'
    }

    def __init__(self, id=None, text=None, entered_on_date_time=None, effective_from_date_time=None, effective_to_date_time=None, attachment_list=None, log_level_list=None, item_element_list=None, entered_by_user=None, log_topic=None, log_topic_id=None, entered_by_user_id=None, short_display_entered_on_date_time=None, local_vars_configuration=None):  # noqa: E501
        """Log - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._text = None
        self._entered_on_date_time = None
        self._effective_from_date_time = None
        self._effective_to_date_time = None
        self._attachment_list = None
        self._log_level_list = None
        self._item_element_list = None
        self._entered_by_user = None
        self._log_topic = None
        self._log_topic_id = None
        self._entered_by_user_id = None
        self._short_display_entered_on_date_time = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.text = text
        self.entered_on_date_time = entered_on_date_time
        if effective_from_date_time is not None:
            self.effective_from_date_time = effective_from_date_time
        if effective_to_date_time is not None:
            self.effective_to_date_time = effective_to_date_time
        if attachment_list is not None:
            self.attachment_list = attachment_list
        if log_level_list is not None:
            self.log_level_list = log_level_list
        if item_element_list is not None:
            self.item_element_list = item_element_list
        if entered_by_user is not None:
            self.entered_by_user = entered_by_user
        if log_topic is not None:
            self.log_topic = log_topic
        if log_topic_id is not None:
            self.log_topic_id = log_topic_id
        if entered_by_user_id is not None:
            self.entered_by_user_id = entered_by_user_id
        if short_display_entered_on_date_time is not None:
            self.short_display_entered_on_date_time = short_display_entered_on_date_time

    @property
    def id(self):
        """Gets the id of this Log.  # noqa: E501


        :return: The id of this Log.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Log.


        :param id: The id of this Log.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def text(self):
        """Gets the text of this Log.  # noqa: E501


        :return: The text of this Log.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this Log.


        :param text: The text of this Log.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and text is None:  # noqa: E501
            raise ValueError("Invalid value for `text`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                text is not None and len(text) > 65535):
            raise ValueError("Invalid value for `text`, length must be less than or equal to `65535`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                text is not None and len(text) < 0):
            raise ValueError("Invalid value for `text`, length must be greater than or equal to `0`")  # noqa: E501

        self._text = text

    @property
    def entered_on_date_time(self):
        """Gets the entered_on_date_time of this Log.  # noqa: E501


        :return: The entered_on_date_time of this Log.  # noqa: E501
        :rtype: datetime
        """
        return self._entered_on_date_time

    @entered_on_date_time.setter
    def entered_on_date_time(self, entered_on_date_time):
        """Sets the entered_on_date_time of this Log.


        :param entered_on_date_time: The entered_on_date_time of this Log.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and entered_on_date_time is None:  # noqa: E501
            raise ValueError("Invalid value for `entered_on_date_time`, must not be `None`")  # noqa: E501

        self._entered_on_date_time = entered_on_date_time

    @property
    def effective_from_date_time(self):
        """Gets the effective_from_date_time of this Log.  # noqa: E501


        :return: The effective_from_date_time of this Log.  # noqa: E501
        :rtype: datetime
        """
        return self._effective_from_date_time

    @effective_from_date_time.setter
    def effective_from_date_time(self, effective_from_date_time):
        """Sets the effective_from_date_time of this Log.


        :param effective_from_date_time: The effective_from_date_time of this Log.  # noqa: E501
        :type: datetime
        """

        self._effective_from_date_time = effective_from_date_time

    @property
    def effective_to_date_time(self):
        """Gets the effective_to_date_time of this Log.  # noqa: E501


        :return: The effective_to_date_time of this Log.  # noqa: E501
        :rtype: datetime
        """
        return self._effective_to_date_time

    @effective_to_date_time.setter
    def effective_to_date_time(self, effective_to_date_time):
        """Sets the effective_to_date_time of this Log.


        :param effective_to_date_time: The effective_to_date_time of this Log.  # noqa: E501
        :type: datetime
        """

        self._effective_to_date_time = effective_to_date_time

    @property
    def attachment_list(self):
        """Gets the attachment_list of this Log.  # noqa: E501


        :return: The attachment_list of this Log.  # noqa: E501
        :rtype: list[Attachment]
        """
        return self._attachment_list

    @attachment_list.setter
    def attachment_list(self, attachment_list):
        """Sets the attachment_list of this Log.


        :param attachment_list: The attachment_list of this Log.  # noqa: E501
        :type: list[Attachment]
        """

        self._attachment_list = attachment_list

    @property
    def log_level_list(self):
        """Gets the log_level_list of this Log.  # noqa: E501


        :return: The log_level_list of this Log.  # noqa: E501
        :rtype: list[LogLevel]
        """
        return self._log_level_list

    @log_level_list.setter
    def log_level_list(self, log_level_list):
        """Sets the log_level_list of this Log.


        :param log_level_list: The log_level_list of this Log.  # noqa: E501
        :type: list[LogLevel]
        """

        self._log_level_list = log_level_list

    @property
    def item_element_list(self):
        """Gets the item_element_list of this Log.  # noqa: E501


        :return: The item_element_list of this Log.  # noqa: E501
        :rtype: list[ItemElement]
        """
        return self._item_element_list

    @item_element_list.setter
    def item_element_list(self, item_element_list):
        """Sets the item_element_list of this Log.


        :param item_element_list: The item_element_list of this Log.  # noqa: E501
        :type: list[ItemElement]
        """

        self._item_element_list = item_element_list

    @property
    def entered_by_user(self):
        """Gets the entered_by_user of this Log.  # noqa: E501


        :return: The entered_by_user of this Log.  # noqa: E501
        :rtype: UserInfo
        """
        return self._entered_by_user

    @entered_by_user.setter
    def entered_by_user(self, entered_by_user):
        """Sets the entered_by_user of this Log.


        :param entered_by_user: The entered_by_user of this Log.  # noqa: E501
        :type: UserInfo
        """

        self._entered_by_user = entered_by_user

    @property
    def log_topic(self):
        """Gets the log_topic of this Log.  # noqa: E501


        :return: The log_topic of this Log.  # noqa: E501
        :rtype: LogTopic
        """
        return self._log_topic

    @log_topic.setter
    def log_topic(self, log_topic):
        """Sets the log_topic of this Log.


        :param log_topic: The log_topic of this Log.  # noqa: E501
        :type: LogTopic
        """

        self._log_topic = log_topic

    @property
    def log_topic_id(self):
        """Gets the log_topic_id of this Log.  # noqa: E501


        :return: The log_topic_id of this Log.  # noqa: E501
        :rtype: LogTopic
        """
        return self._log_topic_id

    @log_topic_id.setter
    def log_topic_id(self, log_topic_id):
        """Sets the log_topic_id of this Log.


        :param log_topic_id: The log_topic_id of this Log.  # noqa: E501
        :type: LogTopic
        """

        self._log_topic_id = log_topic_id

    @property
    def entered_by_user_id(self):
        """Gets the entered_by_user_id of this Log.  # noqa: E501


        :return: The entered_by_user_id of this Log.  # noqa: E501
        :rtype: UserInfo
        """
        return self._entered_by_user_id

    @entered_by_user_id.setter
    def entered_by_user_id(self, entered_by_user_id):
        """Sets the entered_by_user_id of this Log.


        :param entered_by_user_id: The entered_by_user_id of this Log.  # noqa: E501
        :type: UserInfo
        """

        self._entered_by_user_id = entered_by_user_id

    @property
    def short_display_entered_on_date_time(self):
        """Gets the short_display_entered_on_date_time of this Log.  # noqa: E501


        :return: The short_display_entered_on_date_time of this Log.  # noqa: E501
        :rtype: str
        """
        return self._short_display_entered_on_date_time

    @short_display_entered_on_date_time.setter
    def short_display_entered_on_date_time(self, short_display_entered_on_date_time):
        """Sets the short_display_entered_on_date_time of this Log.


        :param short_display_entered_on_date_time: The short_display_entered_on_date_time of this Log.  # noqa: E501
        :type: str
        """

        self._short_display_entered_on_date_time = short_display_entered_on_date_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Log):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Log):
            return True

        return self.to_dict() != other.to_dict()
