# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ExecArgs', 'Exec']

@pulumi.input_type
class ExecArgs:
    def __init__(__self__, *,
                 create_sql: pulumi.Input[str],
                 destroy_sql: pulumi.Input[str]):
        """
        The set of arguments for constructing a Exec resource.
        :param pulumi.Input[str] create_sql: The SQL to execute when the resource is created.
        :param pulumi.Input[str] destroy_sql: The SQL to execute when the resource is destroyed.
        """
        pulumi.set(__self__, "create_sql", create_sql)
        pulumi.set(__self__, "destroy_sql", destroy_sql)

    @property
    @pulumi.getter(name="createSql")
    def create_sql(self) -> pulumi.Input[str]:
        """
        The SQL to execute when the resource is created.
        """
        return pulumi.get(self, "create_sql")

    @create_sql.setter
    def create_sql(self, value: pulumi.Input[str]):
        pulumi.set(self, "create_sql", value)

    @property
    @pulumi.getter(name="destroySql")
    def destroy_sql(self) -> pulumi.Input[str]:
        """
        The SQL to execute when the resource is destroyed.
        """
        return pulumi.get(self, "destroy_sql")

    @destroy_sql.setter
    def destroy_sql(self, value: pulumi.Input[str]):
        pulumi.set(self, "destroy_sql", value)


class Exec(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_sql: Optional[pulumi.Input[str]] = None,
                 destroy_sql: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Executes SQL against a PostgreSQL server.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_sql: The SQL to execute when the resource is created.
        :param pulumi.Input[str] destroy_sql: The SQL to execute when the resource is destroyed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExecArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Executes SQL against a PostgreSQL server.

        :param str resource_name: The name of the resource.
        :param ExecArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExecArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_sql: Optional[pulumi.Input[str]] = None,
                 destroy_sql: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExecArgs.__new__(ExecArgs)

            if create_sql is None and not opts.urn:
                raise TypeError("Missing required property 'create_sql'")
            __props__.__dict__["create_sql"] = create_sql
            if destroy_sql is None and not opts.urn:
                raise TypeError("Missing required property 'destroy_sql'")
            __props__.__dict__["destroy_sql"] = destroy_sql
        super(Exec, __self__).__init__(
            'postgresql-exec:index:Exec',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Exec':
        """
        Get an existing Exec resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ExecArgs.__new__(ExecArgs)

        __props__.__dict__["create_sql"] = None
        __props__.__dict__["destroy_sql"] = None
        return Exec(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createSql")
    def create_sql(self) -> pulumi.Output[str]:
        """
        The SQL to execute when the resource is created.
        """
        return pulumi.get(self, "create_sql")

    @property
    @pulumi.getter(name="destroySql")
    def destroy_sql(self) -> pulumi.Output[str]:
        """
        The SQL to execute when the resource is destroyed.
        """
        return pulumi.get(self, "destroy_sql")

