/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.tools;

import com.datapps.linkoopdb.jdbc.tools.FieldMeta;
import com.datapps.linkoopdb.jdbc.tools.util.FileUtil;
import com.datapps.linkoopdb.jdbc.tools.util.JdbcUtil;
import com.datapps.linkoopdb.jdbc.tools.util.Md5Util;
import com.datapps.linkoopdb.jdbc.tools.util.TableUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DataImportTool {
    private Connection connection;
    private String baseLdbUrl;
    private boolean override = false;
    private boolean isSkipCsvHeader = false;
    private String delimiter = ",";
    private String localFileName = null;
    private boolean isFileDelete = true;
    private boolean isExternalTableDelete = true;
    private boolean debug = false;

    public DataImportTool(Connection connection, String ldbdistBaseUrl) {
        this.connection = connection;
        this.baseLdbUrl = ldbdistBaseUrl.endsWith("/") ? ldbdistBaseUrl : ldbdistBaseUrl + "/";
    }

    public boolean importCsv(String filename, String tablename) {
        this.validateParams(filename, tablename);
        File tempFile = new File(filename);
        try {
            File file = new File(filename);
            FileInputStream stream = new FileInputStream(file);
            this.setLocalFileName(Md5Util.md5(file.getName()).toLowerCase());
            return this.importCsv(stream, tablename);
        }
        catch (Exception e) {
            throw new RuntimeException("import csv failure", e);
        }
    }

    public boolean importRemoteCsv(String ldbFileName, String tablename) {
        this.validateParams(ldbFileName, tablename);
        if (this.baseLdbUrl == null || !this.baseLdbUrl.startsWith("ldbdist")) {
            throw new IllegalArgumentException("ldb dist url is error");
        }
        String schema = "";
        String table = "";
        if (tablename.indexOf(".") != -1) {
            String[] array = tablename.split("\\.");
            if (array.length == 2) {
                schema = array[0];
                table = array[1];
            }
        } else {
            schema = JdbcUtil.getCurrentSchema(this.connection);
            table = tablename;
        }
        String externalTable = table + this.getCurrentTime();
        String ldbFilePath = this.baseLdbUrl + Md5Util.md5(ldbFileName).toLowerCase();
        boolean isLdbFileExist = FileUtil.isLdbFileExist(ldbFilePath);
        if (!isLdbFileExist) {
            throw new IllegalArgumentException("ldbfile is not exist");
        }
        boolean isCreated = this.createExternalTable(schema, table, externalTable, ldbFilePath, this.isSkipCsvHeader, this.delimiter);
        int i = this.importData(schema, table, externalTable, this.override);
        if (this.isFileDelete) {
            boolean bl = FileUtil.deleteLdbFile(ldbFilePath, false);
        }
        if (this.isExternalTableDelete) {
            this.dropExternalTable(schema, externalTable);
        }
        return i > 0;
    }

    public String exportCsvFromTable(String externalTable, String fileSavePath) {
        String externalLocation = JdbcUtil.getShowCreateTable(this.connection, externalTable);
        return this.exportCsvFromPath(externalLocation, fileSavePath);
    }

    public String exportCsvFromPath(String ldbDistPath, String fileSavePath) {
        return FileUtil.downloadStreamToLdbDist(ldbDistPath, fileSavePath);
    }

    public boolean importCsv(InputStream stream, String tablename) {
        if (stream == null) {
            throw new IllegalArgumentException("input stream is empty");
        }
        if (tablename == null || tablename.isEmpty()) {
            throw new IllegalArgumentException("table name is empty");
        }
        if (this.baseLdbUrl == null || !this.baseLdbUrl.startsWith("ldbdist")) {
            throw new IllegalArgumentException("ldb dist url is error");
        }
        String ldbFilePath = null;
        ldbFilePath = this.localFileName == null || this.localFileName.isEmpty() ? this.baseLdbUrl + this.getCurrentTime() + "-" + UUID.randomUUID().toString() : this.baseLdbUrl + this.localFileName;
        String result = FileUtil.uploadStreamToLdbDist(stream, ldbFilePath);
        if (result == null) {
            return false;
        }
        String schema = "";
        String table = "";
        if (tablename.indexOf(".") != -1) {
            String[] array = tablename.split("\\.");
            if (array.length == 2) {
                schema = array[0];
                table = array[1];
            }
        } else {
            schema = JdbcUtil.getCurrentSchema(this.connection);
            table = tablename;
        }
        String externalTable = table + this.getCurrentTime();
        boolean isCreated = this.createExternalTable(schema, table, externalTable, ldbFilePath, this.isSkipCsvHeader, this.delimiter);
        int i = this.importData(schema, table, externalTable, this.override);
        if (this.isFileDelete) {
            boolean bl = FileUtil.deleteLdbFile(ldbFilePath, false);
        }
        if (this.isExternalTableDelete) {
            this.dropExternalTable(schema, externalTable);
        }
        return i > 0;
    }

    public void validateParams(String filename, String tablename) {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("file name is empty");
        }
        if (tablename == null || tablename.isEmpty()) {
            throw new IllegalArgumentException("table name is empty");
        }
    }

    private String getCurrentTime() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public boolean deleteLdbDistFile(String filename) {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("file name is empty");
        }
        return FileUtil.deleteLdbFile(this.baseLdbUrl + Md5Util.md5(filename).toLowerCase(), false);
    }

    public boolean isLdbDistFileExist(String filename) {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("file name is empty");
        }
        return FileUtil.isLdbFileExist(this.baseLdbUrl + Md5Util.md5(filename).toLowerCase());
    }

    private boolean createExternalTable(String schema, String tableName, String exTablename, String ldbFilePath, boolean isSkipCsvHeader, String delimiter) {
        List<FieldMeta> fieldMetaList = this.queryTableFiled(schema, tableName);
        if (fieldMetaList == null || fieldMetaList.size() == 0) {
            throw new RuntimeException("table field is null");
        }
        List<String> primaryList = this.queryPrimaryNameList(schema, tableName);
        String createTableFiledSql = TableUtil.createTableFiledSql(schema, tableName, exTablename, fieldMetaList, primaryList);
        String createTableSql = TableUtil.createExternalTableSql(createTableFiledSql, ldbFilePath, isSkipCsvHeader, delimiter);
        JdbcUtil.createTable(this.connection, createTableSql);
        return true;
    }

    public boolean createExternalTable(String createExternalDdl, String filePath) {
        return this.createExternalTable(createExternalDdl, filePath, false, ",", '\\', '\"');
    }

    public boolean createExternalTable(String createExternalDdl, String filePath, boolean isSkipCsvHeader, String delimiter) {
        return this.createExternalTable(createExternalDdl, filePath, isSkipCsvHeader, delimiter, '\\', '\"');
    }

    public boolean createExternalTable(String createExternalDdl, String filePath, boolean isSkipCsvHeader, String delimiter, char escape, char quote) {
        String ldbFilePath = null;
        ldbFilePath = this.localFileName == null || this.localFileName.isEmpty() ? this.baseLdbUrl + this.getCurrentTime() + "-" + UUID.randomUUID().toString() + "/" + UUID.randomUUID() : this.baseLdbUrl + this.localFileName;
        try {
            File file = new File(filePath);
            FileInputStream stream = new FileInputStream(file);
            String result = FileUtil.uploadStreamToLdbDist(stream, ldbFilePath);
            if (result == null) {
                return false;
            }
            String createTableSql = TableUtil.createExternalTableForLocation(createExternalDdl, ldbFilePath, isSkipCsvHeader, delimiter, escape, quote);
            return JdbcUtil.createTable(this.connection, createTableSql);
        }
        catch (Exception e) {
            throw new RuntimeException("import csv failure", e);
        }
    }

    public boolean createExternalTable(String createExternalDdl) {
        return this.createExternalTable(createExternalDdl, false, ",", '\\', '\"');
    }

    public boolean createExternalTable(String createExternalDdl, boolean isSkipCsvHeader, String delimiter) {
        return this.createExternalTable(createExternalDdl, isSkipCsvHeader, delimiter, '\\', '\"');
    }

    public boolean createExternalTable(String createExternalDdl, boolean isSkipCsvHeader, String delimiter, char escape, char quote) {
        String ldbFilePath = null;
        ldbFilePath = this.localFileName == null || this.localFileName.isEmpty() ? this.baseLdbUrl + this.getCurrentTime() + "-" + UUID.randomUUID().toString() + "/" : this.baseLdbUrl + this.localFileName;
        try {
            String result = FileUtil.uploadStreamToLdbDist(ldbFilePath);
            if (result == null) {
                return false;
            }
            String createTableSql = TableUtil.createExternalTableForLocation(createExternalDdl, ldbFilePath, isSkipCsvHeader, delimiter, escape, quote);
            return JdbcUtil.createTable(this.connection, createTableSql);
        }
        catch (Exception e) {
            throw new RuntimeException("import csv failure", e);
        }
    }

    private boolean createExternalTableByTempTable(String schema, String tableName, String exTablename, String ldbFilePath, boolean isSkipCsvHeader, String delimiter) {
        StringBuilder externalTableSql = new StringBuilder();
        externalTableSql.append("CREATE EXTERNAL TABLE").append(" ").append(schema).append(".").append(exTablename).append(" as (select * from ").append(schema).append(".").append(tableName).append(") with no data ").append("LOCATION").append(" ").append("(").append("'").append(ldbFilePath).append("'").append(")").append(" ").append("FORMAT").append(" ").append("'").append("csv").append("'").append(" ").append("(").append("DELIMITER").append(" ").append("'").append(delimiter).append("'").append(" header '").append(isSkipCsvHeader).append("'").append(")").append(";");
        JdbcUtil.createTable(this.connection, externalTableSql.toString());
        return true;
    }

    private List<String> queryPrimaryNameList(String schema, String table) {
        String primaryKeySql = TableUtil.queryTablePrimaryKey(schema, table);
        ArrayList<String> list = new ArrayList<String>();
        List<Map<String, Object>> mapList = JdbcUtil.executeQuery(this.connection, primaryKeySql);
        if (mapList == null || mapList.size() == 0) {
            return null;
        }
        for (Map<String, Object> map : mapList) {
            if (!map.containsKey("COLUMN_NAME")) continue;
            list.add((String)map.get("COLUMN_NAME"));
        }
        return list;
    }

    private void dropExternalTable(String schema, String table) {
        String dropTableSql = TableUtil.dropTableSql(schema, table);
        JdbcUtil.dropTable(this.connection, dropTableSql);
    }

    private List<FieldMeta> queryTableFiled(String schema, String table) {
        String primaryKeySql = TableUtil.queryColumnTypeSql(schema, table.toUpperCase());
        ArrayList<FieldMeta> list = new ArrayList<FieldMeta>();
        List<Map<String, Object>> mapList = JdbcUtil.executeQuery(this.connection, primaryKeySql);
        if (mapList == null || mapList.size() == 0) {
            return null;
        }
        for (Map<String, Object> map : mapList) {
            String typeName;
            FieldMeta fieldMeta = new FieldMeta();
            if (map.containsKey("COLUMN_NAME") && map.get("COLUMN_NAME") != null) {
                fieldMeta.setColumnName(String.valueOf(map.get("COLUMN_NAME")));
            }
            if (map.containsKey("IS_NULLABLE") && map.get("IS_NULLABLE") != null) {
                fieldMeta.setNullability("YES".equals(String.valueOf(map.get("IS_NULLABLE"))));
            }
            if (map.containsKey("COLUMN_DEF") && map.get("COLUMN_DEF") != null) {
                fieldMeta.setDefaultValue(String.valueOf(map.get("COLUMN_DEF")));
            }
            if (map.containsKey("TYPE_NAME") && (typeName = (String)map.get("TYPE_NAME")) != null) {
                if ("ARRAY".equals(typeName) || typeName.contains("ARRAY")) {
                    fieldMeta.setArray(true);
                } else {
                    fieldMeta.setDataType(typeName);
                }
            }
            if (map.containsKey("CHAR_OCTET_LENGTH") && map.get("CHAR_OCTET_LENGTH") != null) {
                fieldMeta.setLength((Integer)map.get("CHAR_OCTET_LENGTH"));
            }
            if (map.containsKey("DECIMAL_DIGITS") && map.get("DECIMAL_DIGITS") != null) {
                fieldMeta.setScale((Integer)map.get("DECIMAL_DIGITS"));
                if (map.containsKey("COLUMN_SIZE") && map.get("COLUMN_SIZE") != null && fieldMeta.getScale() > 0) {
                    fieldMeta.setPrecision((Integer)map.get("COLUMN_SIZE"));
                }
            }
            list.add(fieldMeta);
        }
        return list;
    }

    private int importData(String schema, String targetTable, String externalTable) {
        return this.importData(schema, targetTable, externalTable, false);
    }

    private int importData(String schema, String targetTable, String externalTable, boolean override) {
        String upsert = JdbcUtil.getTableProperty(this.connection, schema + "." + targetTable, "upsert");
        if (override && !"true".equalsIgnoreCase(upsert)) {
            JdbcUtil.setTableProperty(this.connection, schema + "." + targetTable, "upsert", "true");
        }
        String insertSql = String.format("INSERT INTO %s.%s SELECT * FROM %s.%s", schema, targetTable, schema, externalTable);
        int count = JdbcUtil.executeUpdate(this.connection, insertSql);
        if (override && !"true".equalsIgnoreCase(upsert)) {
            if (upsert == null) {
                JdbcUtil.unsetTableProperty(this.connection, schema + "." + targetTable, "upsert");
            } else {
                JdbcUtil.setTableProperty(this.connection, schema + "." + targetTable, "upsert", "false");
            }
        }
        return count;
    }

    public boolean importCsv(String filename, String structureTable, String[] sqlArray) {
        boolean flag;
        this.validateParams(filename, structureTable);
        if (this.baseLdbUrl == null || !this.baseLdbUrl.startsWith("ldbdist")) {
            throw new IllegalArgumentException("ldb dist url is error");
        }
        if (sqlArray == null || sqlArray.length == 0) {
            throw new IllegalArgumentException("sql array is empty");
        }
        String schema = "";
        String table = "";
        if (structureTable.indexOf(".") != -1) {
            String[] array = structureTable.split("\\.");
            if (array.length == 2) {
                schema = array[0];
                table = array[1];
            }
        } else {
            schema = JdbcUtil.getCurrentSchema(this.connection);
            table = structureTable;
        }
        if (schema == null || schema.isEmpty()) {
            schema = JdbcUtil.getCurrentSchema(this.connection);
        }
        if (!(flag = JdbcUtil.isTableExist(this.connection, schema.toUpperCase(), table.toUpperCase()))) {
            throw new IllegalArgumentException("temp table is not exist");
        }
        File tempFile = new File(filename);
        String ldbFilePath = null;
        try {
            File file = new File(filename);
            if (this.isDebug()) {
                System.out.println("use local file " + file.getAbsolutePath());
            }
            FileInputStream stream = new FileInputStream(file);
            this.setLocalFileName(Md5Util.md5(file.getName()).toLowerCase());
            ldbFilePath = this.localFileName == null || this.localFileName.isEmpty() ? this.baseLdbUrl + this.getCurrentTime() + "-" + UUID.randomUUID().toString() : this.baseLdbUrl + this.localFileName;
            long start = System.currentTimeMillis();
            if (this.isDebug()) {
                System.out.println("upload file to server: " + ldbFilePath);
                System.out.println("upload start at: " + new Date());
            }
            String result = FileUtil.uploadStreamToLdbDist(stream, ldbFilePath);
            if (this.isDebug()) {
                System.out.println("upload end at: " + new Date());
                long end = System.currentTimeMillis();
                System.out.println("upload cost: " + (end - start) + "ms");
            }
            if (result == null) {
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("upload file to ldbdist failure", e);
        }
        String externalTable = table + this.getCurrentTime();
        if (this.isDebug()) {
            System.out.println("create external table start: " + new Date());
        }
        boolean isCreated = this.createExternalTableByTempTable(schema, table, externalTable, ldbFilePath, this.isSkipCsvHeader, this.delimiter);
        if (this.isDebug()) {
            System.out.println("create external table end: " + new Date());
            System.out.println("SET SESSION COUNT OFF;");
        }
        JdbcUtil.execute(this.connection, "SET SESSION COUNT OFF;");
        for (String sqlStr : sqlArray) {
            sqlStr = sqlStr.replace("#{table}", schema + "." + externalTable);
            long start = System.currentTimeMillis();
            if (this.isDebug()) {
                System.out.println("exec sql: " + sqlStr);
                System.out.println("exec sql start: " + new Date());
            }
            if (sqlStr.indexOf("load") != -1) {
                JdbcUtil.execute(this.connection, sqlStr);
            } else {
                JdbcUtil.executeUpdate(this.connection, sqlStr);
            }
            long end = System.currentTimeMillis();
            if (!this.isDebug()) continue;
            System.out.println("exec sql end: " + new Date());
            System.out.println("exec sql cost: " + (end - start) + "ms");
        }
        if (this.isDebug()) {
            System.out.println("SET SESSION COUNT ON;");
        }
        JdbcUtil.execute(this.connection, "SET SESSION COUNT ON;");
        if (this.isFileDelete) {
            boolean delFlag = FileUtil.deleteLdbFile(ldbFilePath, false);
            if (this.isDebug()) {
                System.out.println("clean temp file: " + ldbFilePath);
            }
        }
        if (this.isExternalTableDelete) {
            this.dropExternalTable(schema, externalTable);
        }
        return true;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public boolean isSkipCsvHeader() {
        return this.isSkipCsvHeader;
    }

    public void setSkipCsvHeader(boolean skipCsvHeader) {
        this.isSkipCsvHeader = skipCsvHeader;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getLocalFileName() {
        return this.localFileName;
    }

    public void setLocalFileName(String localFileName) {
        this.localFileName = localFileName;
    }

    public boolean isFileDelete() {
        return this.isFileDelete;
    }

    public void setFileDelete(boolean fileDelete) {
        this.isFileDelete = fileDelete;
    }

    public boolean isExternalTableDelete() {
        return this.isExternalTableDelete;
    }

    public void setExternalTableDelete(boolean externalTableDelete) {
        this.isExternalTableDelete = externalTableDelete;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public static void main(String[] args) throws Exception {
        String driver = "com.datapps.linkoopdb.jdbc.JdbcDriver";
        String url = "jdbc:linkoopdb:tcp://192.168.1.79:9197/ldb";
        String username = "admin";
        String password = "123456";
        String ldbdistBaseUrl = "ldbdist://node9:54322/";
        Connection connection = JdbcUtil.getConnection(driver, url, username, password);
        DataImportTool importTool = new DataImportTool(connection, ldbdistBaseUrl);
        importTool.setOverride(true);
        boolean result = importTool.importCsv("emp.csv", "PUBLIC.EMP");
        System.out.println("import with csv file: " + result);
        importTool.setOverride(true);
        boolean result2 = importTool.importCsv(new FileInputStream("emp.csv"), "EMP");
        System.out.println("import with input stream: " + result2);
    }
}

