import inspect

def logger(important_params=None, output_file=None):
    def wrapper(func):
        def inner(*args, **kwargs):
            values = [arg for arg in args]
            params = inspect.getfullargspec(func)[0]
            result = func(*args, **kwargs)

            curframe = inspect.currentframe()
            calframe = inspect.getouterframes(curframe, 2)
            output_line = ""

            if important_params:
                param_list = []
                if important_params:
                    for param in important_params:
                        for i, p in enumerate(params):
                            if str(p) == param:
                                param_list.append(str(param + "=" + str(values[i])))
                param_list = ', '.join(param_list)
                output_line = "Executing function: [" + func.__name__ + "] Called by: [" + calframe[1][3] + "] Selected Args: " + param_list + " - Result: " + str(result)
            else:
                output_line = "Executing function: [" + func.__name__ + "] Called by: [" + calframe[1][3] + "]" + "- Result: " + str(result)
            
            if not output_file:
                with open(output_file, "w") as file:
                    file.write(output_line + '\n')
            else:
                print(output_line)
            
            return result
        return inner
    return wrapper