function _aws_cdk_aws_lambda_nodejs_NodejsFunctionProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.bundling))
            _aws_cdk_aws_lambda_nodejs_BundlingOptions(p.bundling);
        if ("architectures" in p)
            print("@aws-cdk/aws-lambda.FunctionOptions#architectures", "use `architecture`");
        if (p.architectures != null)
            for (const o of p.architectures)
                if (!visitedObjects.has(o))
                    require("@aws-cdk/aws-lambda/.warnings.jsii.js")._aws_cdk_aws_lambda_Architecture(o);
        if (p.events != null)
            for (const o of p.events)
                if (!visitedObjects.has(o))
                    require("@aws-cdk/aws-lambda/.warnings.jsii.js")._aws_cdk_aws_lambda_IEventSource(o);
        if (p.initialPolicy != null)
            for (const o of p.initialPolicy)
                if (!visitedObjects.has(o))
                    require("@aws-cdk/aws-iam/.warnings.jsii.js")._aws_cdk_aws_iam_PolicyStatement(o);
        if (p.layers != null)
            for (const o of p.layers)
                if (!visitedObjects.has(o))
                    require("@aws-cdk/aws-lambda/.warnings.jsii.js")._aws_cdk_aws_lambda_ILayerVersion(o);
        if ("securityGroup" in p)
            print("@aws-cdk/aws-lambda.FunctionOptions#securityGroup", "- This property is deprecated, use securityGroups instead");
        if (p.securityGroups != null)
            for (const o of p.securityGroups)
                if (!visitedObjects.has(o))
                    require("@aws-cdk/aws-ec2/.warnings.jsii.js")._aws_cdk_aws_ec2_ISecurityGroup(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_lambda_nodejs_NodejsFunction(p) {
}
function _aws_cdk_aws_lambda_nodejs_BundlingOptions(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.charset))
            _aws_cdk_aws_lambda_nodejs_Charset(p.charset);
        if (!visitedObjects.has(p.commandHooks))
            _aws_cdk_aws_lambda_nodejs_ICommandHooks(p.commandHooks);
        if (!visitedObjects.has(p.format))
            _aws_cdk_aws_lambda_nodejs_OutputFormat(p.format);
        if (!visitedObjects.has(p.logLevel))
            _aws_cdk_aws_lambda_nodejs_LogLevel(p.logLevel);
        if (!visitedObjects.has(p.sourceMapMode))
            _aws_cdk_aws_lambda_nodejs_SourceMapMode(p.sourceMapMode);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_lambda_nodejs_OutputFormat(p) {
}
function _aws_cdk_aws_lambda_nodejs_ICommandHooks(p) {
}
function _aws_cdk_aws_lambda_nodejs_LogLevel(p) {
}
function _aws_cdk_aws_lambda_nodejs_SourceMapMode(p) {
}
function _aws_cdk_aws_lambda_nodejs_Charset(p) {
}
function print(name, deprecationMessage) {
    const deprecated = process.env.JSII_DEPRECATED;
    const deprecationMode = ["warn", "fail", "quiet"].includes(deprecated) ? deprecated : "warn";
    const message = `${name} is deprecated.\n  ${deprecationMessage.trim()}\n  This API will be removed in the next major release.`;
    switch (deprecationMode) {
        case "fail":
            throw new DeprecationError(message);
        case "warn":
            console.warn("[WARNING]", message);
            break;
    }
}
function getPropertyDescriptor(obj, prop) {
    const descriptor = Object.getOwnPropertyDescriptor(obj, prop);
    if (descriptor) {
        return descriptor;
    }
    const proto = Object.getPrototypeOf(obj);
    const prototypeDescriptor = proto && getPropertyDescriptor(proto, prop);
    if (prototypeDescriptor) {
        return prototypeDescriptor;
    }
    return {};
}
const visitedObjects = new Set();
class DeprecationError extends Error {
    constructor(...args) {
        super(...args);
        Object.defineProperty(this, "name", {
            configurable: false,
            enumerable: true,
            value: "DeprecationError",
            writable: false,
        });
    }
}
module.exports = { print, getPropertyDescriptor, DeprecationError, _aws_cdk_aws_lambda_nodejs_NodejsFunctionProps, _aws_cdk_aws_lambda_nodejs_NodejsFunction, _aws_cdk_aws_lambda_nodejs_BundlingOptions, _aws_cdk_aws_lambda_nodejs_OutputFormat, _aws_cdk_aws_lambda_nodejs_ICommandHooks, _aws_cdk_aws_lambda_nodejs_LogLevel, _aws_cdk_aws_lambda_nodejs_SourceMapMode, _aws_cdk_aws_lambda_nodejs_Charset };
