# trivium-python-sdk

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.2.9
- Package version: 0.2.9
- Generator version: 7.12.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

```bash
pip install trivium-python-sdk
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import trivium_python_sdk
from trivium_python_sdk.rest import ApiException
from pprint import pprint
import os

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = trivium_python_sdk.Configuration(
    host = "https://staging.api.triviumcapital.tech" # staging
    # host = "https://production.api.triviumcapital.tech" # production
    api_key={"apiKeyAuth": os.environ["TRIVIUM_API_KEY"]}
    access_token = os.environ["TRIVIUM_API_SECRET"]
)

# Enter a context with an instance of the API client
with trivium_python_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = trivium_python_sdk.CashApi(api_client)
    account_id = '40117016-ac89-4690-9986-01102be1ac9b' # str | 

    try:
        api_response = api_instance.get_api_v1_cash_account_accountid(account_id)
        print("The response of CashApi->get_api_v1_cash_account_accountid:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling CashApi->get_api_v1_cash_account_accountid: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CashApi* | [**get_api_v1_cash_account_accountid**](docs/CashApi.md#get_api_v1_cash_account_accountid) | **GET** /api/v1/cash/account/{accountId} | 
*CashApi* | [**get_api_v1_cash_account_user_userid**](docs/CashApi.md#get_api_v1_cash_account_user_userid) | **GET** /api/v1/cash/account/user/{userId} | 
*CashApi* | [**get_api_v1_cash_balance_userid**](docs/CashApi.md#get_api_v1_cash_balance_userid) | **GET** /api/v1/cash/balance/{userId} | 
*CashApi* | [**get_api_v1_cash_rates**](docs/CashApi.md#get_api_v1_cash_rates) | **GET** /api/v1/cash/rates | 
*CashApi* | [**get_api_v1_cash_transactions_accountid**](docs/CashApi.md#get_api_v1_cash_transactions_accountid) | **GET** /api/v1/cash/transactions/{accountId} | 
*CashApi* | [**get_api_v1_cash_transactions_redemption_info**](docs/CashApi.md#get_api_v1_cash_transactions_redemption_info) | **GET** /api/v1/cash/transactions/redemption/info | 
*CashApi* | [**post_api_v1_cash_account**](docs/CashApi.md#post_api_v1_cash_account) | **POST** /api/v1/cash/account | 
*CashApi* | [**post_api_v1_cash_events**](docs/CashApi.md#post_api_v1_cash_events) | **POST** /api/v1/cash/events | 
*CashApi* | [**post_api_v1_cash_request_deposit_accountid**](docs/CashApi.md#post_api_v1_cash_request_deposit_accountid) | **POST** /api/v1/cash/request/deposit/{accountId} | 
*CashApi* | [**post_api_v1_cash_request_redemption_accountid**](docs/CashApi.md#post_api_v1_cash_request_redemption_accountid) | **POST** /api/v1/cash/request/redemption/{accountId} | 
*CashApi* | [**put_api_v1_cash_callback**](docs/CashApi.md#put_api_v1_cash_callback) | **PUT** /api/v1/cash/callback | 
*FixedDepositApi* | [**get_api_v1_fixeddeposit_placement_placementid**](docs/FixedDepositApi.md#get_api_v1_fixeddeposit_placement_placementid) | **GET** /api/v1/fixedDeposit/placement/{placementId} | 
*FixedDepositApi* | [**get_api_v1_fixeddeposit_user_userid**](docs/FixedDepositApi.md#get_api_v1_fixeddeposit_user_userid) | **GET** /api/v1/fixedDeposit/user/{userId} | 
*FixedDepositApi* | [**put_api_v1_fixeddeposit_placement_placementid**](docs/FixedDepositApi.md#put_api_v1_fixeddeposit_placement_placementid) | **PUT** /api/v1/fixedDeposit/placement/{placementId} | 
*ManagedPortfoliosApi* | [**get_api_v1_portfolio_available_userid**](docs/ManagedPortfoliosApi.md#get_api_v1_portfolio_available_userid) | **GET** /api/v1/portfolio/available/{userId} | 
*ManagedPortfoliosApi* | [**get_api_v1_portfolio_performance_investedportfolioid**](docs/ManagedPortfoliosApi.md#get_api_v1_portfolio_performance_investedportfolioid) | **GET** /api/v1/portfolio/performance/{investedPortfolioId} | 
*ManagedPortfoliosApi* | [**get_api_v1_portfolio_positions_userid**](docs/ManagedPortfoliosApi.md#get_api_v1_portfolio_positions_userid) | **GET** /api/v1/portfolio/positions/{userId} | 
*ManagedPortfoliosApi* | [**post_api_v1_portfolio_deposit**](docs/ManagedPortfoliosApi.md#post_api_v1_portfolio_deposit) | **POST** /api/v1/portfolio/deposit | 
*ManagedPortfoliosApi* | [**post_api_v1_portfolio_redemption**](docs/ManagedPortfoliosApi.md#post_api_v1_portfolio_redemption) | **POST** /api/v1/portfolio/redemption | 
*PaymentsApi* | [**get_api_v1_payments_account_accountid**](docs/PaymentsApi.md#get_api_v1_payments_account_accountid) | **GET** /api/v1/payments/account/{accountId} | 
*PaymentsApi* | [**get_api_v1_payments_account_user_userid**](docs/PaymentsApi.md#get_api_v1_payments_account_user_userid) | **GET** /api/v1/payments/account/user/{userId} | 
*PaymentsApi* | [**get_api_v1_payments_balances_userid**](docs/PaymentsApi.md#get_api_v1_payments_balances_userid) | **GET** /api/v1/payments/balances/{userId} | 
*PaymentsApi* | [**post_api_v1_payments_account**](docs/PaymentsApi.md#post_api_v1_payments_account) | **POST** /api/v1/payments/account | 
*PaymentsApi* | [**post_api_v1_payments_payout**](docs/PaymentsApi.md#post_api_v1_payments_payout) | **POST** /api/v1/payments/payout | 
*PaymentsApi* | [**post_api_v1_payments_payout_approve_accountid**](docs/PaymentsApi.md#post_api_v1_payments_payout_approve_accountid) | **POST** /api/v1/payments/payout/approve/{accountId} | 
*StatementApi* | [**get_api_v1_statement_monthly_userid**](docs/StatementApi.md#get_api_v1_statement_monthly_userid) | **GET** /api/v1/statement/monthly/{userId} | 
*TradingApi* | [**get_api_v1_trading_instrument_available_userid**](docs/TradingApi.md#get_api_v1_trading_instrument_available_userid) | **GET** /api/v1/trading/instrument/available/{userId} | 
*TradingApi* | [**get_api_v1_trading_instrument_userid_symbol**](docs/TradingApi.md#get_api_v1_trading_instrument_userid_symbol) | **GET** /api/v1/trading/instrument/{userId}/{symbol} | 
*TradingApi* | [**get_api_v1_trading_positions_userid**](docs/TradingApi.md#get_api_v1_trading_positions_userid) | **GET** /api/v1/trading/positions/{userId} | 
*TradingApi* | [**post_api_v1_trading_order_userid**](docs/TradingApi.md#post_api_v1_trading_order_userid) | **POST** /api/v1/trading/order/{userId} | 
*TransactionsApi* | [**get_api_v1_transactions_userid**](docs/TransactionsApi.md#get_api_v1_transactions_userid) | **GET** /api/v1/transactions/{userId} | 
*UserApi* | [**get_api_v1_user_userid**](docs/UserApi.md#get_api_v1_user_userid) | **GET** /api/v1/user/{userId} | 
*UserApi* | [**get_api_v1_user_userid_sign_embedded**](docs/UserApi.md#get_api_v1_user_userid_sign_embedded) | **GET** /api/v1/user/{userId}/sign/embedded | 
*UserApi* | [**post_api_v1_user**](docs/UserApi.md#post_api_v1_user) | **POST** /api/v1/user | 
*UserApi* | [**post_api_v1_user_events**](docs/UserApi.md#post_api_v1_user_events) | **POST** /api/v1/user/events | 
*UserApi* | [**post_api_v1_user_userid_documents**](docs/UserApi.md#post_api_v1_user_userid_documents) | **POST** /api/v1/user/{userId}/documents | 


## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountStatus](docs/AccountStatus.md)
 - [AccountType](docs/AccountType.md)
 - [Action](docs/Action.md)
 - [AdHocPayoutIntention](docs/AdHocPayoutIntention.md)
 - [ApprovePayout](docs/ApprovePayout.md)
 - [AssetClass](docs/AssetClass.md)
 - [AssetClassProportion](docs/AssetClassProportion.md)
 - [BadGateway](docs/BadGateway.md)
 - [BadRequest](docs/BadRequest.md)
 - [Balance](docs/Balance.md)
 - [Balances](docs/Balances.md)
 - [BankAccountDetails](docs/BankAccountDetails.md)
 - [BeneficiaryDetails](docs/BeneficiaryDetails.md)
 - [BuySell](docs/BuySell.md)
 - [CashAccountActivated](docs/CashAccountActivated.md)
 - [CashCallbackEvent](docs/CashCallbackEvent.md)
 - [CashDeposit](docs/CashDeposit.md)
 - [CashInboundCallbackEvent](docs/CashInboundCallbackEvent.md)
 - [CashRedemption](docs/CashRedemption.md)
 - [ChargeType](docs/ChargeType.md)
 - [CompanyDetails](docs/CompanyDetails.md)
 - [Composition](docs/Composition.md)
 - [CorporateBeneficiaryDetails](docs/CorporateBeneficiaryDetails.md)
 - [CountryProportion](docs/CountryProportion.md)
 - [CreateAccountRequest](docs/CreateAccountRequest.md)
 - [CreateOnboardingDocumentRequest](docs/CreateOnboardingDocumentRequest.md)
 - [CreateOnboardingDocumentResponse](docs/CreateOnboardingDocumentResponse.md)
 - [CreateOrderRequest](docs/CreateOrderRequest.md)
 - [CreateOrderResponse](docs/CreateOrderResponse.md)
 - [CreatePaymentsAccountRequest](docs/CreatePaymentsAccountRequest.md)
 - [Deposit](docs/Deposit.md)
 - [DepositInstructions](docs/DepositInstructions.md)
 - [DepositPortfolioRequest](docs/DepositPortfolioRequest.md)
 - [DepositRequest](docs/DepositRequest.md)
 - [DepositResponse](docs/DepositResponse.md)
 - [DepositSettled](docs/DepositSettled.md)
 - [EarningsToDate](docs/EarningsToDate.md)
 - [Fast](docs/Fast.md)
 - [FastParticipant](docs/FastParticipant.md)
 - [FixedDepositPlacement](docs/FixedDepositPlacement.md)
 - [FixedDepositRedemption](docs/FixedDepositRedemption.md)
 - [FixedDepositTransfer](docs/FixedDepositTransfer.md)
 - [Fund](docs/Fund.md)
 - [IndividualBeneficiaryDetails](docs/IndividualBeneficiaryDetails.md)
 - [IndividualDetails](docs/IndividualDetails.md)
 - [InstrumentInformation](docs/InstrumentInformation.md)
 - [InstrumentQuote](docs/InstrumentQuote.md)
 - [InternationalTransfer](docs/InternationalTransfer.md)
 - [InvestedPortfolio](docs/InvestedPortfolio.md)
 - [LimitOrder](docs/LimitOrder.md)
 - [LocalTransfer](docs/LocalTransfer.md)
 - [LockedFixedDeposit](docs/LockedFixedDeposit.md)
 - [MarketOrder](docs/MarketOrder.md)
 - [MonthlyStatementMetadata](docs/MonthlyStatementMetadata.md)
 - [NotFound](docs/NotFound.md)
 - [OnboardingDocumentType](docs/OnboardingDocumentType.md)
 - [Order](docs/Order.md)
 - [PaginationResultUserTransaction](docs/PaginationResultUserTransaction.md)
 - [PastReturn](docs/PastReturn.md)
 - [PaymentBalance](docs/PaymentBalance.md)
 - [PaymentBalances](docs/PaymentBalances.md)
 - [PaymentIncoming](docs/PaymentIncoming.md)
 - [PaymentOutgoing](docs/PaymentOutgoing.md)
 - [PaymentPurpose](docs/PaymentPurpose.md)
 - [PaymentType](docs/PaymentType.md)
 - [PaymentsAccount](docs/PaymentsAccount.md)
 - [PayoutIntention](docs/PayoutIntention.md)
 - [PayoutResponse](docs/PayoutResponse.md)
 - [PendingFixedDeposit](docs/PendingFixedDeposit.md)
 - [PerformanceSnapshot](docs/PerformanceSnapshot.md)
 - [PortfolioInformation](docs/PortfolioInformation.md)
 - [PortfolioPerformance](docs/PortfolioPerformance.md)
 - [Position](docs/Position.md)
 - [ProcessFixedDepositPlacementRequest](docs/ProcessFixedDepositPlacementRequest.md)
 - [ProcessingFixedDeposit](docs/ProcessingFixedDeposit.md)
 - [ProviderDetails](docs/ProviderDetails.md)
 - [QuoteDetails](docs/QuoteDetails.md)
 - [Rates](docs/Rates.md)
 - [RedeemPortfolioRequest](docs/RedeemPortfolioRequest.md)
 - [RedeemedFixedDeposit](docs/RedeemedFixedDeposit.md)
 - [Redemption](docs/Redemption.md)
 - [RedemptionInfo](docs/RedemptionInfo.md)
 - [RedemptionReconciled](docs/RedemptionReconciled.md)
 - [RedemptionRequest](docs/RedemptionRequest.md)
 - [RedemptionResponse](docs/RedemptionResponse.md)
 - [RedemptionSettled](docs/RedemptionSettled.md)
 - [RetrieveDocumentSigningLinkResponse](docs/RetrieveDocumentSigningLinkResponse.md)
 - [RoutingCodeType](docs/RoutingCodeType.md)
 - [SubscribeCallbackRequest](docs/SubscribeCallbackRequest.md)
 - [SubscribeCallbackRequestWithSignature](docs/SubscribeCallbackRequestWithSignature.md)
 - [SubscribeCallbackResponse](docs/SubscribeCallbackResponse.md)
 - [SubscribeCallbackResponsePublicKey](docs/SubscribeCallbackResponsePublicKey.md)
 - [Swift](docs/Swift.md)
 - [Transaction](docs/Transaction.md)
 - [TransactionStatus](docs/TransactionStatus.md)
 - [Transactions](docs/Transactions.md)
 - [Transfer](docs/Transfer.md)
 - [TransferDetails](docs/TransferDetails.md)
 - [Unauthorized](docs/Unauthorized.md)
 - [User](docs/User.md)
 - [UserActivated](docs/UserActivated.md)
 - [UserCallbackEvent](docs/UserCallbackEvent.md)
 - [UserDetails](docs/UserDetails.md)
 - [UserStatus](docs/UserStatus.md)
 - [UserTransaction](docs/UserTransaction.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="apiKeyAuth"></a>
### apiKeyAuth

- **Type**: API key
- **API key parameter name**: X-Api-Key
- **Location**: HTTP header

<a id="httpAuth"></a>
### httpAuth

- **Type**: Bearer authentication


## Author




