/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc;

import com.datapps.linkoopdb.jdbc.HsqlDateTime;
import com.datapps.linkoopdb.jdbc.LdbSqlException;
import com.datapps.linkoopdb.jdbc.Scanner;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.impl.JDBCConnection;
import com.datapps.linkoopdb.jdbc.lib.DataOutputStream;
import com.datapps.linkoopdb.jdbc.map.ValuePool;
import com.datapps.linkoopdb.jdbc.navigator.RowSetNavigatorClient;
import com.datapps.linkoopdb.jdbc.persist.LdbSqlProperties;
import com.datapps.linkoopdb.jdbc.result.Result;
import com.datapps.linkoopdb.jdbc.result.ResultLob;
import com.datapps.linkoopdb.jdbc.rowio.RowInputBinary;
import com.datapps.linkoopdb.jdbc.rowio.RowOutputBinary;
import com.datapps.linkoopdb.jdbc.rowio.RowOutputInterface;
import com.datapps.linkoopdb.jdbc.server.HsqlSocketFactory;
import com.datapps.linkoopdb.jdbc.types.BlobDataID;
import com.datapps.linkoopdb.jdbc.types.ClobDataID;
import com.datapps.linkoopdb.jdbc.types.TimestampData;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class ClientConnection
implements SessionInterface,
Cloneable {
    public static final String NETWORK_COMPATIBILITY_VERSION = "2.3.4.0";
    public static final int NETWORK_COMPATIBILITY_VERSION_INT = -2030400;
    static final int BUFFER_SIZE = 4096;
    final byte[] mainBuffer = new byte[4096];
    protected DataOutputStream dataOutput;
    protected DataInputStream dataInput;
    protected RowOutputInterface rowOut;
    protected RowInputBinary rowIn;
    protected int randomID;
    SimpleDateFormat simpleDateFormatGMT;
    JDBCConnection connection;
    String host;
    int port;
    String path;
    String database;
    boolean isTLS;
    boolean isTLSWrapper;
    int databaseID;
    String clientPropertiesString;
    LdbSqlProperties clientProperties;
    String databaseUniqueName;
    int queryIterator;
    String clientCharset;
    String resultCharset;
    private boolean isClosed;
    private Socket socket;
    private Result resultOut;
    private long sessionID;
    private long lobIDSequence = -1L;
    private boolean isReadOnlyDefault = false;
    private boolean isAutoCommit = true;
    private int zoneSeconds;
    private Scanner scanner;
    private String zoneString;
    private Calendar calendar;
    private Calendar calendarGMT;

    public ClientConnection(String host, int port, String path, String database, boolean isTLS, boolean isTLSWrapper, String user, String password, int timeZoneSeconds, int queryIterator) {
        this.host = host;
        this.port = port;
        this.path = path;
        this.database = database;
        this.isTLS = isTLS;
        this.isTLSWrapper = isTLSWrapper;
        this.zoneSeconds = timeZoneSeconds;
        this.zoneString = TimeZone.getDefault().getID();
        this.queryIterator = queryIterator;
        this.initStructures();
        this.initConnection(host, port, isTLS);
        Result login = Result.newConnectionAttemptRequest(user, password, database, this.zoneString, timeZoneSeconds, this.queryIterator);
        Result resultIn = this.execute(login);
        if (resultIn.isError()) {
            throw Error.error(resultIn);
        }
        this.sessionID = resultIn.getSessionId();
        this.databaseID = resultIn.getDatabaseId();
        this.databaseUniqueName = resultIn.getDatabaseName();
        this.clientPropertiesString = resultIn.getMainString();
        this.randomID = resultIn.getSessionRandomID();
    }

    public ClientConnection(String host, int port, String path, String database, boolean isTLS, boolean isTLSWrapper, String user, String password, int timeZoneSeconds, int queryIterator, String clientCharset, String resultCharset) {
        this.host = host;
        this.port = port;
        this.path = path;
        this.database = database;
        this.isTLS = isTLS;
        this.isTLSWrapper = isTLSWrapper;
        this.zoneSeconds = timeZoneSeconds;
        this.zoneString = TimeZone.getDefault().getID();
        this.queryIterator = queryIterator;
        this.clientCharset = clientCharset;
        this.resultCharset = resultCharset;
        this.initStructures();
        this.initConnection(host, port, isTLS);
        Result login = Result.newConnectionAttemptRequest(user, password, database, this.zoneString, timeZoneSeconds, this.queryIterator, clientCharset, resultCharset);
        Result resultIn = this.execute(login);
        if (resultIn.isError()) {
            throw Error.error(resultIn);
        }
        this.sessionID = resultIn.getSessionId();
        this.databaseID = resultIn.getDatabaseId();
        this.databaseUniqueName = resultIn.getDatabaseName();
        this.clientPropertiesString = resultIn.getMainString();
        this.randomID = resultIn.getSessionRandomID();
    }

    protected ClientConnection(ClientConnection other) {
        this.host = other.host;
        this.port = other.port;
        this.path = other.path;
        this.database = other.database;
        this.isTLS = other.isTLS;
        this.isTLSWrapper = other.isTLSWrapper;
        this.zoneSeconds = other.zoneSeconds;
        this.zoneString = other.zoneString;
        this.sessionID = other.sessionID;
        this.databaseID = other.databaseID;
        this.databaseUniqueName = other.databaseUniqueName;
        this.clientPropertiesString = other.clientPropertiesString;
        this.randomID = other.randomID;
        this.initStructures();
        this.initConnection(this.host, this.port, this.isTLS);
    }

    public static String toNetCompVersionString(int i) {
        StringBuffer sb = new StringBuffer();
        sb.append((i *= -1) / 1000000);
        sb.append('.');
        sb.append((i %= 1000000) / 10000);
        sb.append('.');
        sb.append((i %= 10000) / 100);
        sb.append('.');
        sb.append(i %= 100);
        return sb.toString();
    }

    private void initStructures() {
        RowOutputBinary rowOutTemp = new RowOutputBinary(this.mainBuffer);
        this.rowOut = rowOutTemp;
        this.rowIn = new RowInputBinary(rowOutTemp);
        this.resultOut = Result.newSessionAttributesResult();
    }

    protected void initConnection(String host, int port, boolean isTLS) {
        this.openConnection(host, port, isTLS);
    }

    protected void openConnection(String host, int port, boolean isTLS) {
        try {
            if (this.isTLSWrapper) {
                this.socket = HsqlSocketFactory.getInstance(false).createSocket(host, port);
            }
            this.socket = HsqlSocketFactory.getInstance(isTLS).createSocket(this.socket, host, port);
            this.socket.setTcpNoDelay(true);
            this.dataOutput = new DataOutputStream(this.socket.getOutputStream());
            this.dataInput = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.handshake();
        }
        catch (Exception e) {
            throw new LdbSqlException(e, Error.getStateString(1301), -1301);
        }
    }

    protected void closeConnection() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    @Override
    public synchronized Result execute(Result r) {
        if (this.isClosed) {
            return Result.newErrorResult(Error.error(1353));
        }
        try {
            r.setSessionId(this.sessionID);
            r.setDatabaseId(this.databaseID);
            this.write(r);
            return this.read();
        }
        catch (Throwable e) {
            throw Error.error(e, 1305, e.toString());
        }
    }

    @Override
    public synchronized RowSetNavigatorClient getRows(long navigatorId, int offset, int size) {
        try {
            this.resultOut.setResultType(13);
            this.resultOut.setResultId(navigatorId);
            this.resultOut.setUpdateCount(offset);
            this.resultOut.setFetchSize(size);
            Result result = this.execute(this.resultOut);
            return (RowSetNavigatorClient)result.getNavigator();
        }
        catch (Throwable e) {
            throw Error.error(1305, e.toString());
        }
    }

    @Override
    public synchronized void closeNavigator(long navigatorId) {
        try {
            this.resultOut.setResultType(40);
            this.resultOut.setResultId(navigatorId);
            this.execute(this.resultOut);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        try {
            this.resultOut.setResultType(32);
            this.execute(this.resultOut);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isClosed = true;
    }

    @Override
    public synchronized Object getAttribute(int id) {
        this.resultOut.setResultType(7);
        this.resultOut.setStatementType(id);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
        Object[] data = in.getSingleRowData();
        switch (id) {
            case 1: {
                return data[2];
            }
            case 2: {
                return data[2];
            }
            case 0: {
                return data[1];
            }
            case 3: {
                return data[3];
            }
        }
        return null;
    }

    @Override
    public synchronized void setAttribute(int id, Object value) {
        this.resultOut.setResultType(6);
        Object[] data = this.resultOut.getSingleRowData();
        data[0] = ValuePool.getInt(id);
        switch (id) {
            case 1: 
            case 2: {
                data[2] = value;
                break;
            }
            case 0: {
                data[1] = value;
                break;
            }
            case 3: {
                data[3] = value;
                break;
            }
        }
        Result resultIn = this.execute(this.resultOut);
        if (resultIn.isError()) {
            throw Error.error(resultIn);
        }
    }

    @Override
    public synchronized boolean isReadOnlyDefault() {
        Object info = this.getAttribute(2);
        this.isReadOnlyDefault = (Boolean)info;
        return this.isReadOnlyDefault;
    }

    @Override
    public synchronized void setReadOnlyDefault(boolean mode) {
        if (mode != this.isReadOnlyDefault) {
            this.setAttribute(2, mode ? Boolean.TRUE : Boolean.FALSE);
            this.isReadOnlyDefault = mode;
        }
    }

    @Override
    public synchronized boolean isAutoCommit() {
        Object info = this.getAttribute(1);
        this.isAutoCommit = (Boolean)info;
        return this.isAutoCommit;
    }

    @Override
    public synchronized void setAutoCommit(boolean mode) {
        if (mode != this.isAutoCommit) {
            this.setAttribute(1, mode ? Boolean.TRUE : Boolean.FALSE);
            this.isAutoCommit = mode;
        }
    }

    @Override
    public synchronized void setIsolationDefault(int level) {
        this.setAttribute(0, ValuePool.getInt(level));
    }

    @Override
    public synchronized int getIsolation() {
        Object info = this.getAttribute(0);
        return (Integer)info;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public synchronized void startPhasedTransaction() {
    }

    @Override
    public synchronized void prepareCommit() {
        this.resultOut.setAsTransactionEndRequest(12, null);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    @Override
    public synchronized void commit(boolean chain) {
        this.resultOut.setAsTransactionEndRequest(0, null);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    @Override
    public synchronized void rollback(boolean chain) {
        this.resultOut.setAsTransactionEndRequest(1, null);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    @Override
    public synchronized void rollbackToSavepoint(String name) {
        this.resultOut.setAsTransactionEndRequest(2, name);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    @Override
    public synchronized void savepoint(String name) {
        Result result = Result.newSetSavepointRequest(name);
        Result in = this.execute(result);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    @Override
    public synchronized void releaseSavepoint(String name) {
        this.resultOut.setAsTransactionEndRequest(4, name);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    @Override
    public void addWarning(LdbSqlException warning) {
    }

    @Override
    public synchronized long getId() {
        return this.sessionID;
    }

    @Override
    public int getRandomId() {
        return this.randomID;
    }

    @Override
    public synchronized void resetSession() {
        Result login = Result.newResetSessionRequest();
        Result resultIn = this.execute(login);
        if (resultIn.isError()) {
            this.isClosed = true;
            this.closeConnection();
            throw Error.error(resultIn);
        }
        this.sessionID = resultIn.getSessionId();
        this.databaseID = resultIn.getDatabaseId();
    }

    protected void write(Result r) throws IOException, LdbSqlException {
        r.write(this, this.dataOutput, this.rowOut);
    }

    protected Result read() throws IOException, LdbSqlException {
        Result result = Result.newResult(this.dataInput, this.rowIn);
        result.readAdditionalResults(this, this.dataInput, this.rowIn);
        this.rowOut.reset(this.mainBuffer);
        this.rowIn.resetRow(this.mainBuffer.length);
        return result;
    }

    @Override
    public synchronized String getInternalConnectionURL() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result cancel(Result result) {
        ClientConnection connection = new ClientConnection(this);
        try {
            Result result2 = connection.execute(result);
            return result2;
        }
        finally {
            connection.closeConnection();
        }
    }

    public synchronized long getLobId() {
        return this.lobIDSequence--;
    }

    @Override
    public BlobDataID createBlob(long length) {
        BlobDataID blob = new BlobDataID(this.getLobId());
        return blob;
    }

    @Override
    public ClobDataID createClob(long length) {
        ClobDataID clob = new ClobDataID(this.getLobId());
        return clob;
    }

    @Override
    public void allocateResultLob(ResultLob resultLob, InputStream dataInput) {
    }

    @Override
    public Scanner getScanner() {
        if (this.scanner == null) {
            this.scanner = new Scanner();
        }
        return this.scanner;
    }

    @Override
    public Calendar getCalendar() {
        if (this.calendar == null) {
            TimeZone zone = TimeZone.getTimeZone(this.zoneString);
            this.calendar = new GregorianCalendar(zone);
        }
        return this.calendar;
    }

    @Override
    public Calendar getCalendarGMT() {
        if (this.calendarGMT == null) {
            this.calendarGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"), HsqlDateTime.defaultLocale);
            this.calendarGMT.setLenient(false);
        }
        return this.calendarGMT;
    }

    @Override
    public SimpleDateFormat getSimpleDateFormatGMT() {
        if (this.simpleDateFormatGMT == null) {
            this.simpleDateFormatGMT = new SimpleDateFormat("MMMM", Locale.ENGLISH);
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"), HsqlDateTime.defaultLocale);
            cal.setLenient(false);
            this.simpleDateFormatGMT.setCalendar(cal);
        }
        return this.simpleDateFormatGMT;
    }

    @Override
    public TimestampData getCurrentDate() {
        long currentMillis = System.currentTimeMillis();
        currentMillis = HsqlDateTime.getNormalisedDate(currentMillis);
        return new TimestampData(currentMillis / 1000L);
    }

    @Override
    public int getZoneSeconds() {
        return this.zoneSeconds;
    }

    @Override
    public int getStreamBlockSize() {
        return 0x4000000;
    }

    @Override
    public LdbSqlProperties getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = this.clientPropertiesString.length() > 0 ? LdbSqlProperties.delimitedArgPairsToProps(this.clientPropertiesString, "=", ";", null) : new LdbSqlProperties();
        }
        return this.clientProperties;
    }

    @Override
    public JDBCConnection getJDBCConnection() {
        return this.connection;
    }

    @Override
    public void setJDBCConnection(JDBCConnection connection) {
        this.connection = connection;
    }

    @Override
    public String getDatabaseUniqueName() {
        return this.databaseUniqueName;
    }

    protected void handshake() throws IOException {
        this.dataOutput.writeInt(-2030400);
        this.dataOutput.flush();
    }

    @Override
    public boolean isDataCheckStrict() {
        return false;
    }

    public Result addJar(String jarPath, boolean overwrite) {
        Result result = Result.newResult(47);
        try {
            File jarFile = ClientConnection.verifyJar(jarPath);
            FileInputStream is = new FileInputStream(jarFile);
            byte[] jarData = new byte[((InputStream)is).available()];
            int count = ((InputStream)is).read(jarData);
            ((InputStream)is).close();
            result.setMainString(jarFile.getName() + " " + "ADD" + " " + overwrite);
            result.setValueObject(jarData);
            result.write(this, this.dataOutput, this.rowOut);
            return this.read();
        }
        catch (Exception e) {
            return Result.newErrorResult(Error.error(6002), "\n add jar failed !!!  Catch Error Message : " + e.getMessage(), 11876);
        }
    }

    private static File verifyJar(String jarName) {
        File file = new File(jarName);
        String fileName = file.getName();
        if (!fileName.substring(fileName.lastIndexOf(".") + 1).equals("jar")) {
            throw Error.error(6002, file.getName() + " is not a jar package");
        }
        return file;
    }

    public Result addPyzip(String pyzipPath, boolean overwrite) {
        Result result = Result.newResult(46);
        try {
            File pyzipFile = new File(pyzipPath);
            String fileName = pyzipFile.getName();
            if (!fileName.substring(fileName.lastIndexOf(".") + 1).equals("zip")) {
                throw Error.error(6010, pyzipFile.getName() + " is not a zip package");
            }
            FileInputStream is = new FileInputStream(pyzipFile);
            byte[] pyzipData = new byte[((InputStream)is).available()];
            ((InputStream)is).read(pyzipData);
            ((InputStream)is).close();
            result.setMainString(fileName + " " + "ADD" + " " + overwrite);
            result.setValueObject(pyzipData);
            result.write(this, this.dataOutput, this.rowOut);
            return this.read();
        }
        catch (Exception e) {
            return Result.newErrorResult(Error.error(6010), "\n add pyzip failed !!!  Catch Error Message : " + e.getMessage(), 11879);
        }
    }
}

