/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class RCData {
    public static final String DEFAULT_JDBC_DRIVER = "com.datapps.linkoopdb.jdbc.JdbcDriver";
    public String id;
    public String url;
    public String username;
    public String password;
    public String ti;
    public String driver;
    public String charset;
    public String clientcharset;
    public String resultcharset;
    public String truststore;
    public String libpath;
    private String defaultJdbcDriverName = "com.datapps.linkoopdb.jdbc.JdbcDriver";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RCData(File file, String dbKey) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("RC file name not specified");
        }
        if (!file.canRead()) {
            throw new IOException("Please set up authentication file '" + file + "'");
        }
        StringTokenizer tokenizer = null;
        boolean thisone = false;
        int linenum = 0;
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            String s;
            while ((s = br.readLine()) != null) {
                String value;
                String keyword;
                ++linenum;
                if ((s = s.trim()).length() == 0 || s.charAt(0) == '#') continue;
                tokenizer = new StringTokenizer(s);
                if (tokenizer.countTokens() == 1) {
                    keyword = tokenizer.nextToken();
                    value = "";
                } else if (tokenizer.countTokens() > 1) {
                    keyword = tokenizer.nextToken();
                    value = tokenizer.nextToken("").trim();
                } else {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new Exception("Corrupt line " + linenum + " in '" + file + "':  " + s);
                }
                if (dbKey == null) {
                    if (!keyword.equals("urlid")) continue;
                    System.out.println(value);
                    continue;
                }
                if (keyword.equals("urlid")) {
                    if (value.equals(dbKey)) {
                        if (this.id == null) {
                            this.id = dbKey;
                            thisone = true;
                            continue;
                        }
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new Exception("Key '" + dbKey + " redefined at" + " line " + linenum + " in '" + file);
                    }
                    thisone = false;
                    continue;
                }
                if (!thisone) continue;
                if (keyword.equals("url")) {
                    this.url = value;
                    continue;
                }
                if (keyword.equals("username")) {
                    this.username = value;
                    continue;
                }
                if (keyword.equals("driver")) {
                    this.driver = value;
                    continue;
                }
                if (keyword.equals("charset")) {
                    this.charset = value;
                    continue;
                }
                if (keyword.equals("clientcharset")) {
                    this.clientcharset = value;
                    continue;
                }
                if (keyword.equals("resultcharset")) {
                    this.resultcharset = value;
                    continue;
                }
                if (keyword.equals("truststore")) {
                    this.truststore = value;
                    continue;
                }
                if (keyword.equals("password")) {
                    this.password = value;
                    continue;
                }
                if (keyword.equals("transiso")) {
                    this.ti = value;
                    continue;
                }
                if (keyword.equals("libpath")) {
                    this.libpath = value;
                    continue;
                }
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new Exception("Bad line " + linenum + " in '" + file + "':  " + s);
            }
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
            br = null;
        }
        if (dbKey == null) {
            return;
        }
        if (this.url == null) {
            throw new Exception("url not set for '" + dbKey + "' in file '" + file + "'");
        }
        if (this.libpath != null) {
            throw new IllegalArgumentException("Sorry, 'libpath' not supported yet");
        }
    }

    public RCData(String id, String url, String username, String password, String driver, String charset, String clientcharset, String resultcharset, String truststore) throws Exception {
        this(id, url, username, password, driver, charset, clientcharset, resultcharset, truststore, null);
    }

    public RCData(String id, String url, String username, String password, String driver, String charset, String clientcharset, String resultcharset, String truststore, String libpath) throws Exception {
        this(id, url, username, password, driver, charset, clientcharset, resultcharset, truststore, libpath, null);
    }

    public RCData(String id, String url, String username, String password, String driver, String charset, String clientcharset, String resultcharset, String truststore, String libpath, String ti) throws Exception {
        this.id = id;
        this.url = url;
        this.username = username;
        this.password = password;
        this.ti = ti;
        this.driver = driver;
        this.charset = charset;
        this.clientcharset = clientcharset;
        this.resultcharset = resultcharset;
        this.truststore = truststore;
        this.libpath = libpath;
        if (libpath != null) {
            throw new IllegalArgumentException("Sorry, 'libpath' not supported yet");
        }
        if (id == null || url == null) {
            throw new Exception("id or url was not set");
        }
    }

    public static String expandSysPropVars(String inString) {
        int varEnd;
        int varOffset;
        String outString = inString;
        while ((varOffset = outString.indexOf("${")) >= 0 && (varEnd = outString.indexOf(125, varOffset + 2)) >= 0) {
            String varName = outString.substring(varOffset + 2, varEnd);
            if (varName.length() < 1) {
                throw new IllegalArgumentException("Bad variable setting");
            }
            String varVal = System.getProperty(varName);
            if (varVal == null) {
                throw new IllegalArgumentException("No Java system property with name '" + varName + "'");
            }
            outString = outString.substring(0, varOffset) + varVal + outString.substring(varEnd + 1);
        }
        return outString;
    }

    public static void setTI(Connection c, String tiString) throws SQLException {
        int i = -1;
        if (tiString.equals("TRANSACTION_READ_UNCOMMITTED")) {
            i = 1;
        }
        if (tiString.equals("TRANSACTION_READ_COMMITTED")) {
            i = 2;
        }
        if (tiString.equals("TRANSACTION_REPEATABLE_READ")) {
            i = 4;
        }
        if (tiString.equals("TRANSACTION_SERIALIZABLE")) {
            i = 8;
        }
        if (tiString.equals("TRANSACTION_NONE")) {
            i = 0;
        }
        if (i < 0) {
            throw new SQLException("Trans. isol. value not supported by " + RCData.class.getName() + ": " + tiString);
        }
        c.setTransactionIsolation(i);
    }

    public static String tiToString(int ti) {
        switch (ti) {
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
            case 0: {
                return "TRANSACTION_NONE";
            }
        }
        return "Custom Transaction Isolation numerical value: " + ti;
    }

    public void setDefaultJdbcDriver(String defaultJdbcDriverName) {
        this.defaultJdbcDriverName = defaultJdbcDriverName;
    }

    public String getDefaultJdbcDriverName() {
        return this.defaultJdbcDriverName;
    }

    public Connection getConnection() throws ClassNotFoundException, SQLException, MalformedURLException {
        return this.getConnection(null, null);
    }

    public Connection getConnection(String curDriverIn, String curTrustStoreIn) throws ClassNotFoundException, MalformedURLException, SQLException {
        Connection c;
        String curDriver = null;
        String curTrustStore = null;
        Properties sysProps = System.getProperties();
        curDriver = curDriverIn == null ? (this.driver == null ? DEFAULT_JDBC_DRIVER : this.driver) : RCData.expandSysPropVars(curDriverIn);
        if (curTrustStoreIn == null) {
            if (this.truststore != null) {
                curTrustStore = RCData.expandSysPropVars(this.truststore);
            }
        } else {
            curTrustStore = RCData.expandSysPropVars(curTrustStoreIn);
        }
        if (curTrustStore == null) {
            sysProps.remove("javax.net.ssl.trustStore");
        } else {
            sysProps.put("javax.net.ssl.trustStore", curTrustStore);
        }
        String urlString = null;
        try {
            urlString = RCData.expandSysPropVars(this.url);
        }
        catch (IllegalArgumentException iae) {
            throw new MalformedURLException(iae.toString() + " for URL '" + this.url + "'");
        }
        String userString = null;
        if (this.username != null) {
            try {
                userString = RCData.expandSysPropVars(this.username);
            }
            catch (IllegalArgumentException iae) {
                throw new MalformedURLException(iae.toString() + " for user name '" + this.username + "'");
            }
        }
        String passwordString = null;
        if (this.password != null) {
            try {
                passwordString = RCData.expandSysPropVars(this.password);
            }
            catch (IllegalArgumentException iae) {
                throw new MalformedURLException(iae.toString() + " for password");
            }
        }
        Class.forName(curDriver);
        Properties info = new Properties();
        if (userString != null) {
            info.put("user", userString);
        }
        if (passwordString != null) {
            info.put("password", passwordString);
        }
        if (this.clientcharset != null) {
            info.put("clientcharset", this.clientcharset);
        }
        if (this.resultcharset != null) {
            info.put("resultcharset", this.resultcharset);
        }
        Connection connection = c = userString == null ? DriverManager.getConnection(urlString) : DriverManager.getConnection(urlString, info);
        if (this.ti != null) {
            RCData.setTI(c, this.ti);
        }
        return c;
    }
}

