/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { JavaProjectOptions } from "projen/lib/java";
import { OpenApiGatewayJavaProject, OpenApiGatewayJavaProjectOptions } from "./open-api-gateway-java-project";
import { SmithyApiGatewayProjectOptions } from "./types";
/**
 * Configuration for the SmithyApiGatewayJavaProject
 */
export interface SmithyApiGatewayJavaProjectOptions extends JavaProjectOptions, SmithyApiGatewayProjectOptions {
}
/**
 * Synthesizes a Java Project with a Smithy model, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid smithy-api-gateway-java
 */
export declare class SmithyApiGatewayJavaProject extends OpenApiGatewayJavaProject {
    /**
     * The directory in which the smithy model files reside
     */
    readonly modelDir: string;
    constructor(options: SmithyApiGatewayJavaProjectOptions);
    protected preConstruct(options: OpenApiGatewayJavaProjectOptions): OpenApiGatewayJavaProjectOptions;
}
