/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.barcoderecognition;

import com.aspose.barcode.barcoderecognition.BaseDecodeType;
import com.aspose.barcode.barcoderecognition.ChecksumValidation;
import com.aspose.barcode.barcoderecognition.CustomerInformationInterpretingType;
import com.aspose.barcode.barcoderecognition.DecodeType;
import com.aspose.barcode.barcoderecognition.MultyDecodeType;
import com.aspose.barcode.barcoderecognition.ProcessorSettings;
import com.aspose.barcode.barcoderecognition.QualitySettings;
import com.aspose.barcode.barcoderecognition.SingleDecodeType;
import com.aspose.barcode.barcoderecognition.f;
import com.aspose.barcode.barcoderecognition.g;
import com.aspose.python.barcode.internal.do.e;
import com.aspose.python.barcode.internal.do.r;
import com.aspose.python.barcode.internal.dq.cr;
import com.aspose.python.barcode.internal.dv.ad;
import com.aspose.python.barcode.internal.dy.as;
import com.aspose.python.barcode.internal.dy.b;
import com.aspose.python.barcode.internal.ee.i;
import com.aspose.python.barcode.internal.ee.n;
import com.aspose.python.barcode.internal.ee.p;
import com.aspose.python.barcode.internal.ee.w;
import com.aspose.python.barcode.internal.p.h;
import com.aspose.python.barcode.internal.p.m;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@ad(a=true)
public class BarCodeReader {
    private static final ProcessorSettings processorSettings = new ProcessorSettings(true);
    private h _readerImplementation = new h();

    boolean isLicensed() {
        return this._readerImplementation.a().a();
    }

    public static ProcessorSettings getProcessorSettings() {
        return processorSettings;
    }

    public int getTimeout() {
        return this._readerImplementation.b();
    }

    public void setTimeout(int value) {
        this._readerImplementation.a(value);
    }

    @Deprecated
    public ChecksumValidation getChecksumValidation() {
        return this._readerImplementation.c.a();
    }

    @Deprecated
    public void setChecksumValidation(ChecksumValidation value) {
        this._readerImplementation.c.a(value);
    }

    @Deprecated
    public void setChecksumValidation(int value) {
        this.setChecksumValidation(ChecksumValidation.values()[value]);
    }

    @Deprecated
    public boolean getStripFNC() {
        return this._readerImplementation.c.b();
    }

    @Deprecated
    public void setStripFNC(boolean value) {
        this._readerImplementation.c.a(value);
    }

    @Deprecated
    public CustomerInformationInterpretingType getCustomerInformationInterpretingType() {
        return this._readerImplementation.c.d().a();
    }

    @Deprecated
    public void setCustomerInformationInterpretingType(CustomerInformationInterpretingType value) {
        this._readerImplementation.c.d().a(value);
    }

    public void setCustomerInformationInterpretingType(int value) {
        this.setCustomerInformationInterpretingType(CustomerInformationInterpretingType.values()[value]);
    }

    public void abort() {
        h h2 = this._readerImplementation;
        try {
            if (null != h2) {
                h2.e();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public f[] getFoundBarCodes() {
        return this._readerImplementation.d;
    }

    public int getFoundCount() {
        return this._readerImplementation.d.length;
    }

    public f[] readBarCodes() {
        this._readerImplementation.f();
        return this._readerImplementation.d;
    }

    public final QualitySettings getQualitySettings() {
        return this._readerImplementation.d();
    }

    public final void setQualitySettings(QualitySettings value) {
        if (null != value) {
            this._readerImplementation.a(value);
        }
    }

    public g getBarcodeSettings() {
        return this._readerImplementation.c;
    }

    @Deprecated
    public boolean getDetectEncoding() {
        return this._readerImplementation.c.c();
    }

    @Deprecated
    public void setDetectEncoding(boolean value) {
        this._readerImplementation.c.b(value);
    }

    public BarCodeReader() {
        this._readerImplementation = new h();
        this.setBarCodeReadType(DecodeType.ALL_SUPPORTED_TYPES);
    }

    public final void setBarCodeImage(BufferedImage value, Rectangle[] areas) {
        as[] asArray = new as[areas.length];
        for (int i2 = 0; i2 < areas.length; ++i2) {
            asArray[i2] = as.a(areas[i2]);
        }
        this.setBarCodeImageInternal(BarCodeReader.convertBufferedImageToBitmap(value), asArray);
    }

    public final void setBarCodeImage(BufferedImage value, Rectangle area) {
        this.setBarCodeImageInternal(BarCodeReader.convertBufferedImageToBitmap(value), as.a(area));
    }

    public final void setBarCodeImage(InputStream stream) {
        this.setBarCodeImageInternal(w.b(stream));
    }

    final void setBarCodeImageInternal(b value) {
        if (this._readerImplementation == null) {
            this._readerImplementation = new h();
        }
        b b2 = BarCodeReader.copyBitmap(value);
        com.aspose.python.barcode.internal.ms.f f2 = new com.aspose.python.barcode.internal.ms.f(b2);
        this._readerImplementation.a(b2);
        f2.a();
    }

    final void setBarCodeImageInternal(b value, as[] areas) {
        if (this._readerImplementation == null) {
            this._readerImplementation = new h();
        }
        b b2 = BarCodeReader.copyBitmap(value);
        com.aspose.python.barcode.internal.ms.f f2 = new com.aspose.python.barcode.internal.ms.f(b2, areas);
        this._readerImplementation.a(b2, areas);
        f2.a();
    }

    final void setBarCodeImageInternal(b value, as area) {
        if (this._readerImplementation == null) {
            this._readerImplementation = new h();
        }
        b b2 = BarCodeReader.copyBitmap(value);
        com.aspose.python.barcode.internal.ms.f f2 = new com.aspose.python.barcode.internal.ms.f(b2, area);
        this._readerImplementation.a(b2, area.m());
        f2.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static b getBitmapFromMemoryFile(String fileName) {
        b b2 = null;
        byte[] byArray = null;
        n n2 = new n(fileName, 3, 1, 1);
        try {
            byArray = new byte[(int)n2.e()];
            n2.a(byArray, 0, (int)n2.e());
        }
        finally {
            if (n2 != null) {
                n2.j();
            }
        }
        p p2 = new p(byArray);
        p2.a(0L);
        b2 = new b(p2);
        return b2;
    }

    public void setBarCodeImage(BufferedImage value) {
        this.setBarCodeImageInternal(BarCodeReader.convertBufferedImageToBitmap(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBarCodeImage(String filename) {
        b b2;
        if (cr.b(filename) || !com.aspose.python.barcode.internal.ee.f.c(filename)) {
            throw new IllegalArgumentException("Wrong filename passed.");
        }
        if (this._readerImplementation == null) {
            this._readerImplementation = new h();
        }
        n n2 = new n(filename, 3);
        try {
            b2 = com.aspose.python.barcode.internal.mt.b.a(n2);
        }
        catch (r r2) {
            throw new IllegalArgumentException("Wrong filename passed.");
        }
        try {
            i i2 = new i(filename);
            com.aspose.python.barcode.internal.ms.h.a().a((double)i2.c() / 1048576.0);
            this._readerImplementation.a(BarCodeReader.copyBitmap(b2));
        }
        finally {
            if (b2 != null) {
                b2.j();
            }
        }
        n2.l();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setBarCodeImageInternal(w stream) {
        if (stream == null) {
            throw new e("stream");
        }
        if (this._readerImplementation == null) {
            this._readerImplementation = new h();
        }
        com.aspose.python.barcode.internal.ms.m m2 = new com.aspose.python.barcode.internal.ms.m(stream);
        b b2 = new b(stream);
        try {
            this._readerImplementation.a(BarCodeReader.copyBitmap(b2));
        }
        finally {
            if (b2 != null) {
                b2.j();
            }
        }
        m2.a();
    }

    public void setBarCodeReadType(SingleDecodeType ... barcodeTypes) {
        this._readerImplementation.a(new MultyDecodeType(barcodeTypes));
    }

    public void setBarCodeReadType(BaseDecodeType type) {
        this._readerImplementation.a(type);
    }

    BarCodeReader(b image) {
        if (image == null) {
            throw new e("image");
        }
        this._readerImplementation = new h();
        this.setBarCodeReadType(DecodeType.ALL_SUPPORTED_TYPES);
        this.setBarCodeImageInternal(image);
    }

    private static b convertBufferedImageToBitmap(BufferedImage bufferedImage) {
        b b2 = new b(bufferedImage.getWidth(), bufferedImage.getHeight());
        for (int i2 = 0; i2 < b2.t(); ++i2) {
            for (int i3 = 0; i3 < b2.k(); ++i3) {
                b2.a(i2, i3, com.aspose.python.barcode.internal.dy.f.a(bufferedImage.getRGB(i2, i3)));
            }
        }
        return b2;
    }

    public BarCodeReader(BufferedImage image) {
        this(BarCodeReader.convertBufferedImageToBitmap(image));
    }

    public BarCodeReader(BufferedImage image, BaseDecodeType decodeType) {
        this(BarCodeReader.convertBufferedImageToBitmap(image), decodeType);
    }

    public BarCodeReader(BufferedImage image, BaseDecodeType ... decodeTypes) {
        this(BarCodeReader.convertBufferedImageToBitmap(image), decodeTypes);
    }

    BarCodeReader(b image, BaseDecodeType ... decodeTypes) {
        this(image, (BaseDecodeType)new MultyDecodeType(decodeTypes));
    }

    BarCodeReader(b image, BaseDecodeType type) {
        if (image == null) {
            throw new e("image");
        }
        this._readerImplementation = new h();
        this.setBarCodeReadType(type);
        this.setBarCodeImageInternal(image);
    }

    private static b copyBitmap(b originalBitmap) {
        return m.c(originalBitmap);
    }

    public BarCodeReader(BufferedImage image, Rectangle area, BaseDecodeType ... decodeTypes) {
        this(BarCodeReader.convertBufferedImageToBitmap(image), as.a(area), decodeTypes);
    }

    BarCodeReader(b image, as area, BaseDecodeType ... decodeTypes) {
        this(image, area.m(), (BaseDecodeType)new MultyDecodeType(decodeTypes));
    }

    BarCodeReader(b image, as[] areas, BaseDecodeType type) {
        if (image == null) {
            throw new e("image");
        }
        this._readerImplementation = new h();
        this.setBarCodeReadType(type);
        this.setBarCodeImageInternal(image, areas);
    }

    public BarCodeReader(BufferedImage image, Rectangle[] areas, BaseDecodeType type) {
        this(BarCodeReader.convertBufferedImageToBitmap(image), BarCodeReader.convertRectangleAwtArrayToMsArray(areas), type);
    }

    BarCodeReader(b image, as area, BaseDecodeType type) {
        if (image == null) {
            throw new e("image");
        }
        this._readerImplementation = new h();
        this.setBarCodeReadType(type);
        this.setBarCodeImageInternal(image, area.m());
    }

    private static as[] convertRectangleAwtArrayToMsArray(Rectangle[] areas) {
        as[] asArray = new as[areas.length];
        for (int i2 = 0; i2 < asArray.length; ++i2) {
            asArray[i2] = as.a(areas[i2]);
        }
        return asArray;
    }

    public BarCodeReader(String filename) {
        this(filename, (BaseDecodeType)DecodeType.ALL_SUPPORTED_TYPES);
    }

    public BarCodeReader(String filename, BaseDecodeType type) {
        if (cr.b(filename) || !com.aspose.python.barcode.internal.ee.f.c(filename)) {
            throw new IllegalArgumentException("Wrong filename passed.");
        }
        this._readerImplementation = new h();
        this.setBarCodeReadType(type);
        this.setBarCodeImage(filename);
    }

    public BarCodeReader(String filename, BaseDecodeType ... decodeTypes) {
        this(filename, (BaseDecodeType)new MultyDecodeType(decodeTypes));
    }

    BarCodeReader(w stream) {
        this(stream, (BaseDecodeType)DecodeType.ALL_SUPPORTED_TYPES);
    }

    public BarCodeReader(InputStream stream) {
        this(w.b(stream));
    }

    public BarCodeReader(InputStream stream, BaseDecodeType type) {
        this(w.b(stream), type);
    }

    BarCodeReader(w stream, BaseDecodeType type) {
        if (stream == null) {
            throw new e("stream");
        }
        this._readerImplementation = new h();
        this.setBarCodeImageInternal(stream);
        this.setBarCodeReadType(type);
    }

    public BarCodeReader(InputStream stream, BaseDecodeType ... decodeTypes) {
        this(w.b(stream), decodeTypes);
    }

    BarCodeReader(w stream, BaseDecodeType ... decodeTypes) {
        this(stream, (BaseDecodeType)new MultyDecodeType(decodeTypes));
    }

    public void dispose() {
        this.disposeAllResources();
    }

    private void disposeAllResources() {
        if (this._readerImplementation != null) {
            this._readerImplementation.a(true);
            this._readerImplementation = null;
        }
    }

    public BaseDecodeType getBarCodeDecodeType() {
        return this._readerImplementation.c();
    }

    public boolean exportToXml(String xmlFile) {
        com.aspose.python.barcode.internal.bt.b b2 = new com.aspose.python.barcode.internal.bt.b(this);
        return b2.b(xmlFile);
    }

    public boolean exportToXml(OutputStream xmlStream) throws IOException {
        com.aspose.python.barcode.internal.bt.b b2 = new com.aspose.python.barcode.internal.bt.b(this);
        p p2 = new p();
        boolean bl2 = b2.a(p2);
        if (bl2) {
            ((w)p2).a(0L);
            byte[] byArray = new byte[(int)((w)p2).e()];
            ((w)p2).a(byArray, 0, byArray.length);
            xmlStream.write(byArray);
        }
        return bl2;
    }

    public static BarCodeReader importFromXml(String xmlFile) {
        BarCodeReader barCodeReader = new BarCodeReader();
        com.aspose.python.barcode.internal.bt.b b2 = new com.aspose.python.barcode.internal.bt.b(barCodeReader);
        b2.c(xmlFile);
        return barCodeReader;
    }

    public static BarCodeReader importFromXml(InputStream xmlStream) {
        BarCodeReader barCodeReader = new BarCodeReader();
        com.aspose.python.barcode.internal.bt.b b2 = new com.aspose.python.barcode.internal.bt.b(barCodeReader);
        b2.b(w.b(xmlStream));
        return barCodeReader;
    }
}

