"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const alarm_state_1 = require("../common/alarm-state");
exports.handler = async (event) => {
    console.log('Event: %j', { ...event, ResponseURL: '...' });
    if (event.RequestType === 'Create' || event.RequestType === 'Update') {
        const searchTags = event.ResourceProperties.SearchTags;
        const timeout = event.ResourceProperties.MonitoringTime;
        const endTime = event.ResourceProperties.EndTime ?? Date.now() + timeout * 1000;
        if (endTime > Date.now()) {
            if (searchTags.length > 0) {
                const alarms = await alarm_state_1.getAggregateAlarmState(searchTags);
                if (alarms.state === alarm_state_1.AlarmState.ALARM) {
                    throw new Error(`Rolling back the deployment: [${alarms.summary}]`);
                }
                console.log(`Monitoring until ${new Date(endTime).toLocaleTimeString()}`);
                return { IsComplete: false };
            }
        }
        console.log('The monitoring period completed without alarm.');
        return { IsComplete: true, EndTime: endTime };
    }
    console.log('Skipping checking alarms. This resource only works during Create and Update.');
    return { IsComplete: true };
};
//# sourceMappingURL=data:application/json;base64,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