import setuptools

with open("README.md", "r") as fh:
    long_description = fh.read()

setuptools.setup(
    license='MIT',
    name="pngcoder",
    version="1.1",
    author="JenCat",
    author_email="jencat@ex.ua",
    description="Encode (obfuscate) any file to PNG and vise versa",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/jencat42/pngcoder",
    packages=["src"],
    keywords='obfuscate obfuscator encode encoder png binary',
    include_package_data=True,
    python_requires='>=3.7',
    install_requires=[
        'Pillow',
    ],
    entry_points={
        'console_scripts': ['pngcoder=src.pngcoder:main'],
    },
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3',
    ],
)