/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as lambda from "@aws-cdk/aws-lambda";
import * as ec2 from "@aws-cdk/aws-ec2";
import * as events from "@aws-cdk/aws-events";
import { Construct } from "@aws-cdk/core";
/**
 * @summary The properties for the LambdaToEventbridge class.
 */
export interface LambdaToEventbridgeProps {
    /**
     * Existing instance of Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
     *
     * @default - None
     */
    readonly existingLambdaObj?: lambda.Function;
    /**
     * User provided props to override the default props for the Lambda function.
     *
     * @default - Default properties are used.
     */
    readonly lambdaFunctionProps?: lambda.FunctionProps;
    /**
     * Existing instance of a custom EventBus.
     *
     * @default - None
     */
    readonly existingEventBusInterface?: events.IEventBus;
    /**
     * A new custom EventBus is created with provided props.
     *
     * @default - None
     */
    readonly eventBusProps?: events.EventBusProps;
    /**
     * An existing VPC for the construct to use (construct will NOT create a new VPC in this case).
     */
    readonly existingVpc?: ec2.IVpc;
    /**
     * Properties to override default properties if deployVpc is true.
     */
    readonly vpcProps?: ec2.VpcProps;
    /**
     * Whether to deploy a new VPC.
     *
     * @default - false
     */
    readonly deployVpc?: boolean;
    /**
     * Optional Name for the EventBus's name environment variable set for the Lambda function.
     *
     * @default - EVENTBUS_NAME is used
     */
    readonly eventBusEnvironmentVariableName?: string;
}
/**
 * @summary The LambdaToEventbridge class.
 */
export declare class LambdaToEventbridge extends Construct {
    readonly lambdaFunction: lambda.Function;
    readonly eventBus?: events.IEventBus;
    readonly vpc?: ec2.IVpc;
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the LambdaToEventbridge class.
     * @since 1.120.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: LambdaToEventbridgeProps);
}
