/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.ResultArray;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItem;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementStatusParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.util.UnsignedConversions;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class RecordParcel
extends Parcel {
    private byte[] nullIndicators;
    private Object[] columnValues;
    private int[] bitMasks = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private static long time = 0L;
    private int savedIndex;

    public RecordParcel(TDPacketStream tDPacketStream, GenericTeradataConnection genericTeradataConnection, StatementStatusParcel statementStatusParcel, PrepInfoParcel.PrepInfoItemIterator prepInfoItemIterator) throws SQLException {
        super(genericTeradataConnection);
        this.initResponseParcel(tDPacketStream);
        if (statementStatusParcel == null || !ActivityAnalyzer.isHUTConfig(statementStatusParcel.getActivityType())) {
            if (!genericTeradataConnection.hasResponseNullIndicatorBits()) {
                this.columnValues = new Object[1];
                this.readVarChar(tDPacketStream);
            } else if (prepInfoItemIterator != null) {
                this.setup(tDPacketStream, prepInfoItemIterator.count());
                this.buildColumns(tDPacketStream, prepInfoItemIterator);
            } else {
                this.setup(tDPacketStream, 1);
                this.readVarChar(tDPacketStream);
            }
        }
    }

    private void readVarChar(TDPacketStream tDPacketStream) throws SQLException {
        int n = UnsignedConversions.convertUnsignedShort(tDPacketStream.getShort());
        this.columnValues[0] = tDPacketStream.getString(n, this.m_con);
    }

    protected void buildColumns(TDPacketStream tDPacketStream, PrepInfoParcel.PrepInfoItemIterator prepInfoItemIterator) throws SQLException {
        boolean bl = false;
        int n = this.savedIndex;
        while (tDPacketStream.position() < tDPacketStream.limit() && prepInfoItemIterator.hasNext()) {
            bl = false;
            if ((this.nullIndicators[n / 8] & this.bitMasks[n % 8]) / this.bitMasks[n % 8] == 1) {
                bl = true;
            }
            PrepInfoItem prepInfoItem = prepInfoItemIterator.next();
            this.columnValues[n] = prepInfoItem.produce(tDPacketStream, bl);
            this.savedIndex = n;
            if (this.columnValues[n] instanceof ResultArray) {
                this.buildArrayColumn(n, tDPacketStream, prepInfoItem.getArrayBasePrepInfoItems());
            }
            ++n;
        }
    }

    protected void buildArrayColumn(int n, TDPacketStream tDPacketStream, ArrayList arrayList) throws SQLException {
        int n2 = ((ResultArray)this.columnValues[n]).getArrayCardinality();
        int n3 = (n2 * arrayList.size() + 7) / 8;
        byte[] byArray = new byte[n3];
        tDPacketStream.get(byArray);
        Object[] objectArray = new Object[n2 * arrayList.size()];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = 0;
            while (n5 < arrayList.size()) {
                boolean bl = false;
                if ((byArray[n4 / 8] & this.bitMasks[n4 % 8]) / this.bitMasks[n4 % 8] == 1) {
                    bl = true;
                }
                objectArray[n4] = ((PrepInfoItem)arrayList.get(n5)).produce(tDPacketStream, bl);
                ++n5;
                ++n4;
            }
        }
        ((ResultArray)this.columnValues[n]).setArrayElements(objectArray);
    }

    protected void setup(TDPacketStream tDPacketStream, int n) {
        this.columnValues = new Object[n];
        int n2 = (n + 7) / 8;
        this.nullIndicators = new byte[n2];
        tDPacketStream.get(this.nullIndicators);
    }

    public RecordParcelColumnValuesIterator getRecordParcelColumnValuesIterator() {
        return new RecordParcelColumnValuesIterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RecordParcel  *******************\n");
        for (int i = 0; i < this.columnValues.length; ++i) {
            if (this.columnValues[i] != null) {
                stringBuffer.append(this.columnValues[i].toString() + '\n');
                continue;
            }
            stringBuffer.append("NULL VALUE\n");
        }
        stringBuffer.append("RecordParcel END *****************\n");
        return stringBuffer.toString();
    }

    public class RecordParcelColumnValuesIterator
    implements Iterator {
        private int index = 0;

        public boolean hasNext() {
            return RecordParcel.this.columnValues != null ? this.index < RecordParcel.this.columnValues.length : false;
        }

        public Object next() {
            return this.hasNext() ? RecordParcel.this.columnValues[this.index++] : null;
        }

        public void remove() {
        }
    }
}

