"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultAuthorizerIds = exports.HttpMethods = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/**
 * HTTP Methods supported by Open API v3
 */
var HttpMethods;
(function (HttpMethods) {
    HttpMethods["GET"] = "get";
    HttpMethods["PUT"] = "put";
    HttpMethods["POST"] = "post";
    HttpMethods["DELETE"] = "delete";
    HttpMethods["OPTIONS"] = "options";
    HttpMethods["HEAD"] = "head";
    HttpMethods["PATCH"] = "patch";
    HttpMethods["TRACE"] = "trace";
})(HttpMethods = exports.HttpMethods || (exports.HttpMethods = {}));
/**
 * Default authorizer identifiers
 */
var DefaultAuthorizerIds;
(function (DefaultAuthorizerIds) {
    DefaultAuthorizerIds["NONE"] = "none";
    DefaultAuthorizerIds["IAM"] = "aws.auth.sigv4";
})(DefaultAuthorizerIds = exports.DefaultAuthorizerIds || (exports.DefaultAuthorizerIds = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uc3RhbnRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2NvbnN0cnVjdC9wcmVwYXJlLXNwZWMtZXZlbnQtaGFuZGxlci9jb25zdGFudHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUE7c0NBQ3NDO0FBQ3RDOztHQUVHO0FBQ0gsSUFBWSxXQVNYO0FBVEQsV0FBWSxXQUFXO0lBQ3JCLDBCQUFXLENBQUE7SUFDWCwwQkFBVyxDQUFBO0lBQ1gsNEJBQWEsQ0FBQTtJQUNiLGdDQUFpQixDQUFBO0lBQ2pCLGtDQUFtQixDQUFBO0lBQ25CLDRCQUFhLENBQUE7SUFDYiw4QkFBZSxDQUFBO0lBQ2YsOEJBQWUsQ0FBQTtBQUNqQixDQUFDLEVBVFcsV0FBVyxHQUFYLG1CQUFXLEtBQVgsbUJBQVcsUUFTdEI7QUFFRDs7R0FFRztBQUNILElBQVksb0JBR1g7QUFIRCxXQUFZLG9CQUFvQjtJQUM5QixxQ0FBYSxDQUFBO0lBQ2IsOENBQXNCLENBQUE7QUFDeEIsQ0FBQyxFQUhXLG9CQUFvQixHQUFwQiw0QkFBb0IsS0FBcEIsNEJBQW9CLFFBRy9CIiwic291cmNlc0NvbnRlbnQiOlsiLyohIENvcHlyaWdodCBbQW1hem9uLmNvbV0oaHR0cDovL2FtYXpvbi5jb20vKSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wICovXG4vKipcbiAqIEhUVFAgTWV0aG9kcyBzdXBwb3J0ZWQgYnkgT3BlbiBBUEkgdjNcbiAqL1xuZXhwb3J0IGVudW0gSHR0cE1ldGhvZHMge1xuICBHRVQgPSBcImdldFwiLFxuICBQVVQgPSBcInB1dFwiLFxuICBQT1NUID0gXCJwb3N0XCIsXG4gIERFTEVURSA9IFwiZGVsZXRlXCIsXG4gIE9QVElPTlMgPSBcIm9wdGlvbnNcIixcbiAgSEVBRCA9IFwiaGVhZFwiLFxuICBQQVRDSCA9IFwicGF0Y2hcIixcbiAgVFJBQ0UgPSBcInRyYWNlXCIsXG59XG5cbi8qKlxuICogRGVmYXVsdCBhdXRob3JpemVyIGlkZW50aWZpZXJzXG4gKi9cbmV4cG9ydCBlbnVtIERlZmF1bHRBdXRob3JpemVySWRzIHtcbiAgTk9ORSA9IFwibm9uZVwiLFxuICBJQU0gPSBcImF3cy5hdXRoLnNpZ3Y0XCIsXG59XG4iXX0=