"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupSmithyBuild = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const smithy_build_project_1 = require("./smithy-build-project");
/**
 * Adds the common subprojects for building a Smithy model into an OpenAPI spec
 */
exports.setupSmithyBuild = (project, options) => {
    const { serviceName } = options.serviceName;
    const smithyBuildDir = "smithy";
    const smithyBuildOutputSubDir = "output";
    // Create the smithy build project, responsible for transforming the model into an OpenAPI spec
    const smithyBuild = new smithy_build_project_1.SmithyBuildProject({
        name: `${project.name}-smithy-build`,
        parent: project,
        outdir: smithyBuildDir,
        serviceName: options.serviceName,
        smithyBuildOptions: options.smithyBuildOptions,
        buildOutputDir: smithyBuildOutputSubDir,
    });
    smithyBuild.synth();
    const smithyBuildOutputDir = path.join(smithyBuildDir, smithyBuildOutputSubDir);
    // Ignore smithy build output by default
    if (options.ignoreSmithyBuildOutput ?? true) {
        project.gitignore.addPatterns(smithyBuildOutputDir);
    }
    // Ignore gradle wrapper by default
    if (options.ignoreGradleWrapper ?? true) {
        project.gitignore.addPatterns(path.join(smithyBuildDir, "gradle"));
        project.gitignore.addPatterns(path.join(smithyBuildDir, "gradlew"));
        project.gitignore.addPatterns(path.join(smithyBuildDir, "gradlew.bat"));
    }
    // Ignore the .gradle directory
    project.gitignore.addPatterns(path.join(smithyBuildDir, ".gradle"));
    project.gitignore.addPatterns(path.join(smithyBuildDir, "build"));
    return {
        // Generated spec is written to output/<projection id>/<plugin id>/<service name>.openapi.json
        generatedSpecFilePath: path.join(smithyBuild.smithyBuildOutputPath, "openapi", "openapi", `${serviceName}.openapi.json`),
    };
};
//# sourceMappingURL=data:application/json;base64,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