import { Project, ProjectOptions } from "projen";
/**
 * Configuration for the OpenAPI spec project
 */
export interface OpenApiSpecProjectOptions extends ProjectOptions {
    /**
     * The name of the OpenAPI specification file.
     * @default "spec.yaml"
     */
    readonly specFileName?: string;
    /**
     * The name of the output parsed OpenAPI specification file. Must end with .json.
     * @default ".parsed-spec.json"
     */
    readonly parsedSpecFileName?: string;
    /**
     * The directory to write the parsed spec to, relative to the project output directory
     * @default the project outdir
     */
    readonly parsedSpecOutdir?: string;
    /**
     * Override the directory of the _input_ OpenAPI specification and skip synthesizing the sample spec.yaml
     */
    readonly overrideSpecPath?: string;
}
/**
 * Project containing the OpenAPI spec, and a parsed spec for use by the CDK construct
 */
export declare class OpenApiSpecProject extends Project {
    readonly specPath: string;
    readonly parsedSpecPath: string;
    readonly specFileName: string;
    readonly parsedSpecFileName: string;
    readonly specChanged: boolean;
    private synthed;
    constructor(options: OpenApiSpecProjectOptions);
    /**
     * @inheritDoc
     */
    synth(): void;
}
