"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsEventSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const subs = require("@aws-cdk/aws-sns-subscriptions");
/**
 * Use an Amazon SNS topic as an event source for AWS Lambda.
 *
 * @stability stable
 */
class SnsEventSource {
    /**
     * @stability stable
     */
    constructor(topic, props) {
        this.topic = topic;
        this.props = props;
    }
    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @stability stable
     */
    bind(target) {
        this.topic.addSubscription(new subs.LambdaSubscription(target, this.props));
    }
}
exports.SnsEventSource = SnsEventSource;
_a = JSII_RTTI_SYMBOL_1;
SnsEventSource[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.SnsEventSource", version: "1.108.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBRUEsdURBQXVEOzs7Ozs7QUFPdkQsTUFBYSxjQUFjOzs7O0lBR3pCLFlBQXFCLEtBQWlCLEVBQUUsS0FBMkI7UUFBOUMsVUFBSyxHQUFMLEtBQUssQ0FBWTtRQUNwQyxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDOzs7Ozs7SUFFTSxJQUFJLENBQUMsTUFBd0I7UUFDbEMsSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFlLENBQUMsSUFBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQzlFLENBQUM7O0FBVEgsd0NBVUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBzbnMgZnJvbSAnQGF3cy1jZGsvYXdzLXNucyc7XG5pbXBvcnQgKiBhcyBzdWJzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMtc3Vic2NyaXB0aW9ucyc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFNuc0V2ZW50U291cmNlUHJvcHMgZXh0ZW5kcyBzdWJzLkxhbWJkYVN1YnNjcmlwdGlvblByb3BzIHtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgU25zRXZlbnRTb3VyY2UgaW1wbGVtZW50cyBsYW1iZGEuSUV2ZW50U291cmNlIHtcbiAgcHJpdmF0ZSByZWFkb25seSBwcm9wcz86IFNuc0V2ZW50U291cmNlUHJvcHM7XG5cbiAgY29uc3RydWN0b3IocmVhZG9ubHkgdG9waWM6IHNucy5JVG9waWMsIHByb3BzPzogU25zRXZlbnRTb3VyY2VQcm9wcykge1xuICAgIHRoaXMucHJvcHMgPSBwcm9wcztcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKHRhcmdldDogbGFtYmRhLklGdW5jdGlvbikge1xuICAgIHRoaXMudG9waWMuYWRkU3Vic2NyaXB0aW9uKG5ldyBzdWJzLkxhbWJkYVN1YnNjcmlwdGlvbih0YXJnZXQsIHRoaXMucHJvcHMpKTtcbiAgfVxufVxuIl19