"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsDlq = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An SQS dead letter queue destination configuration for a Lambda event source.
 *
 * @stability stable
 */
class SqsDlq {
    /**
     * @stability stable
     */
    constructor(queue) {
        this.queue = queue;
    }
    /**
     * Returns a destination configuration for the DLQ.
     *
     * @stability stable
     */
    bind(_target, targetHandler) {
        this.queue.grantSendMessages(targetHandler);
        return {
            destination: this.queue.queueArn,
        };
    }
}
exports.SqsDlq = SqsDlq;
_a = JSII_RTTI_SYMBOL_1;
SqsDlq[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.SqsDlq", version: "1.108.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNxcy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQUlBLE1BQWEsTUFBTTs7OztJQUNqQixZQUE2QixLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0lBQzlDLENBQUM7Ozs7OztJQUdNLElBQUksQ0FBQyxPQUE0QixFQUFFLGFBQXdCO1FBQ2hFLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsYUFBYSxDQUFDLENBQUM7UUFFNUMsT0FBTztZQUNMLFdBQVcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7U0FDakMsQ0FBQztJQUNKLENBQUM7O0FBWEgsd0JBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEbHFEZXN0aW5hdGlvbkNvbmZpZywgSUV2ZW50U291cmNlRGxxLCBJRXZlbnRTb3VyY2VNYXBwaW5nLCBJRnVuY3Rpb24gfSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIHNxcyBmcm9tICdAYXdzLWNkay9hd3Mtc3FzJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgU3FzRGxxIGltcGxlbWVudHMgSUV2ZW50U291cmNlRGxxIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBxdWV1ZTogc3FzLklRdWV1ZSkge1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGJpbmQoX3RhcmdldDogSUV2ZW50U291cmNlTWFwcGluZywgdGFyZ2V0SGFuZGxlcjogSUZ1bmN0aW9uKTogRGxxRGVzdGluYXRpb25Db25maWcge1xuICAgIHRoaXMucXVldWUuZ3JhbnRTZW5kTWVzc2FnZXModGFyZ2V0SGFuZGxlcik7XG5cbiAgICByZXR1cm4ge1xuICAgICAgZGVzdGluYXRpb246IHRoaXMucXVldWUucXVldWVBcm4sXG4gICAgfTtcbiAgfVxufVxuIl19