/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/**
 * Options for typescript sample code generation
 */
export interface TypescriptSampleCodeOptions {
    /**
     * The package name which exports the OpenApiGatewayLambdaApi construct (ie this pdk package!)
     */
    readonly openApiGatewayPackageName: string;
    /**
     * The name of the generated typescript client package
     */
    readonly typescriptClientPackageName: string;
    /**
     * Whether or not to generate sample code
     */
    readonly sampleCode?: boolean;
    /**
     * Api source code directory, relative to the project root
     */
    readonly apiSrcDir: string;
    /**
     * Directory where the parsed spec is output
     */
    readonly specDir: string;
    /**
     * Name of the parsed spec file
     */
    readonly parsedSpecFileName: string;
}
/**
 * Return a map of file name to contents for the sample typescript source code
 */
export declare const getTypescriptSampleSource: (options: TypescriptSampleCodeOptions) => {
    [fileName: string]: string;
};
/**
 * Return a map of file name to contents for the sample typescript test code
 */
export declare const getTypescriptSampleTests: (options: TypescriptSampleCodeOptions) => {
    "api.test.ts": string;
};
