"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotToLambdaToDynamoDB = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iot_lambda_1 = require("@aws-solutions-constructs/aws-iot-lambda");
const aws_lambda_dynamodb_1 = require("@aws-solutions-constructs/aws-lambda-dynamodb");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
class IotToLambdaToDynamoDB extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the IotToLambdaToDynamoDB class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {IotToLambdaToDynamoDBProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Other permissions for constructs are accepted as arrays, turning tablePermissions into
        // an array to use the same validation function.
        if (props.tablePermissions) {
            defaults.CheckListValues(['All', 'Read', 'ReadWrite', 'Write'], [props.tablePermissions], 'table permission');
        }
        // Setup the LambdaToDynamoDB
        const lambdaToDynamoDB = new aws_lambda_dynamodb_1.LambdaToDynamoDB(this, 'LambdaToDynamoDB', {
            tablePermissions: props.tablePermissions,
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            dynamoTableProps: props.dynamoTableProps,
            tableEnvironmentVariableName: props.tableEnvironmentVariableName,
            existingVpc: props.existingVpc,
            deployVpc: props.deployVpc,
            vpcProps: props.vpcProps,
        });
        this.dynamoTable = lambdaToDynamoDB.dynamoTable;
        this.vpc = lambdaToDynamoDB.vpc;
        // Setup the IotToLambda
        const iotToLambda = new aws_iot_lambda_1.IotToLambda(this, 'IotToLambda', {
            existingLambdaObj: lambdaToDynamoDB.lambdaFunction,
            iotTopicRuleProps: props.iotTopicRuleProps
        });
        this.iotTopicRule = iotToLambda.iotTopicRule;
        this.lambdaFunction = iotToLambda.lambdaFunction;
    }
}
exports.IotToLambdaToDynamoDB = IotToLambdaToDynamoDB;
_a = JSII_RTTI_SYMBOL_1;
IotToLambdaToDynamoDB[_a] = { fqn: "@aws-solutions-constructs/aws-iot-lambda-dynamodb.IotToLambdaToDynamoDB", version: "2.33.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQWlCQSw2RUFBdUU7QUFDdkUsdUZBQWlGO0FBQ2pGLHdGQUF3RjtBQUN4RiwyQ0FBdUM7QUFDdkMsMkRBQTJEO0FBMkQzRCxNQUFhLHFCQUFzQixTQUFRLHNCQUFTO0lBTWxEOzs7Ozs7O09BT0c7SUFDSCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWlDO1FBQ3pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsUUFBUSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUUzQix5RkFBeUY7UUFDekYsZ0RBQWdEO1FBQ2hELElBQUksS0FBSyxDQUFDLGdCQUFnQixFQUFFO1lBQzFCLFFBQVEsQ0FBQyxlQUFlLENBQUMsQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFLFdBQVcsRUFBRSxPQUFPLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFLGtCQUFrQixDQUFDLENBQUM7U0FDL0c7UUFFRCw2QkFBNkI7UUFDN0IsTUFBTSxnQkFBZ0IsR0FBRyxJQUFJLHNDQUFnQixDQUFDLElBQUksRUFBRSxrQkFBa0IsRUFBRTtZQUN0RSxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCO1lBQ3hDLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUI7WUFDMUMsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLG1CQUFtQjtZQUM5QyxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCO1lBQ3hDLDRCQUE0QixFQUFFLEtBQUssQ0FBQyw0QkFBNEI7WUFDaEUsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7U0FDekIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLFdBQVcsR0FBRyxnQkFBZ0IsQ0FBQyxXQUFXLENBQUM7UUFDaEQsSUFBSSxDQUFDLEdBQUcsR0FBRyxnQkFBZ0IsQ0FBQyxHQUFHLENBQUM7UUFFaEMsd0JBQXdCO1FBQ3hCLE1BQU0sV0FBVyxHQUFHLElBQUksNEJBQVcsQ0FBQyxJQUFJLEVBQUUsYUFBYSxFQUFFO1lBQ3ZELGlCQUFpQixFQUFFLGdCQUFnQixDQUFDLGNBQWM7WUFDbEQsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQjtTQUMzQyxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsWUFBWSxHQUFHLFdBQVcsQ0FBQyxZQUFZLENBQUM7UUFDN0MsSUFBSSxDQUFDLGNBQWMsR0FBRyxXQUFXLENBQUMsY0FBYyxDQUFDO0lBQ25ELENBQUM7O0FBN0NILHNEQThDQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIGlvdCBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaW90JztcbmltcG9ydCAqIGFzIGVjMiBmcm9tICdhd3MtY2RrLWxpYi9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGR5bmFtb2RiIGZyb20gJ2F3cy1jZGstbGliL2F3cy1keW5hbW9kYic7XG5pbXBvcnQgeyBJb3RUb0xhbWJkYSB9IGZyb20gJ0Bhd3Mtc29sdXRpb25zLWNvbnN0cnVjdHMvYXdzLWlvdC1sYW1iZGEnO1xuaW1wb3J0IHsgTGFtYmRhVG9EeW5hbW9EQiB9IGZyb20gJ0Bhd3Mtc29sdXRpb25zLWNvbnN0cnVjdHMvYXdzLWxhbWJkYS1keW5hbW9kYic7XG4vLyBOb3RlOiBUbyBlbnN1cmUgQ0RLdjIgY29tcGF0aWJpbGl0eSwga2VlcCB0aGUgaW1wb3J0IHN0YXRlbWVudCBmb3IgQ29uc3RydWN0IHNlcGFyYXRlXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCAqIGFzIGRlZmF1bHRzIGZyb20gJ0Bhd3Mtc29sdXRpb25zLWNvbnN0cnVjdHMvY29yZSc7XG5cbi8qKlxuICogQHN1bW1hcnkgVGhlIHByb3BlcnRpZXMgZm9yIHRoZSBJb3RUb0xhbWJkYVRvRHluYW1vREIgY2xhc3MuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSW90VG9MYW1iZGFUb0R5bmFtb0RCUHJvcHMge1xuICAvKipcbiAgICogRXhpc3RpbmcgaW5zdGFuY2Ugb2YgTGFtYmRhIEZ1bmN0aW9uIG9iamVjdCwgcHJvdmlkaW5nIGJvdGggdGhpcyBhbmQgYGxhbWJkYUZ1bmN0aW9uUHJvcHNgIHdpbGwgY2F1c2UgYW4gZXJyb3IuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgZXhpc3RpbmdMYW1iZGFPYmo/OiBsYW1iZGEuRnVuY3Rpb24sXG4gIC8qKlxuICAgKiBVc2VyIHByb3ZpZGVkIHByb3BzIHRvIG92ZXJyaWRlIHRoZSBkZWZhdWx0IHByb3BzIGZvciB0aGUgTGFtYmRhIGZ1bmN0aW9uLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIERlZmF1bHQgcHJvcHMgYXJlIHVzZWRcbiAgICovXG4gIHJlYWRvbmx5IGxhbWJkYUZ1bmN0aW9uUHJvcHM/OiBsYW1iZGEuRnVuY3Rpb25Qcm9wcyxcbiAgLyoqXG4gICAqIFVzZXIgcHJvdmlkZWQgcHJvcHMgdG8gb3ZlcnJpZGUgdGhlIGRlZmF1bHQgcHJvcHNcbiAgICpcbiAgICogQGRlZmF1bHQgLSBEZWZhdWx0IHByb3BzIGFyZSB1c2VkXG4gICAqL1xuICByZWFkb25seSBpb3RUb3BpY1J1bGVQcm9wczogaW90LkNmblRvcGljUnVsZVByb3BzLFxuICAvKipcbiAgICogT3B0aW9uYWwgdXNlciBwcm92aWRlZCBwcm9wcyB0byBvdmVycmlkZSB0aGUgZGVmYXVsdCBwcm9wc1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIERlZmF1bHQgcHJvcHMgYXJlIHVzZWRcbiAgICovXG4gIHJlYWRvbmx5IGR5bmFtb1RhYmxlUHJvcHM/OiBkeW5hbW9kYi5UYWJsZVByb3BzLFxuICAvKipcbiAgICogT3B0aW9uYWwgdGFibGUgcGVybWlzc2lvbnMgdG8gZ3JhbnQgdG8gdGhlIExhbWJkYSBmdW5jdGlvbi5cbiAgICogT25lIG9mIHRoZSBmb2xsb3dpbmcgbWF5IGJlIHNwZWNpZmllZDogXCJBbGxcIiwgXCJSZWFkXCIsIFwiUmVhZFdyaXRlXCIsIFwiV3JpdGVcIi5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBSZWFkL3dyaXRlIGFjY2VzcyBpcyBnaXZlbiB0byB0aGUgTGFtYmRhIGZ1bmN0aW9uIGlmIG5vIHZhbHVlIGlzIHNwZWNpZmllZC5cbiAgICovXG4gIHJlYWRvbmx5IHRhYmxlUGVybWlzc2lvbnM/OiBzdHJpbmcsXG4gIC8qKlxuICAgKiBPcHRpb25hbCBOYW1lIGZvciB0aGUgTGFtYmRhIGZ1bmN0aW9uIGVudmlyb25tZW50IHZhcmlhYmxlIHNldCB0byB0aGUgbmFtZSBvZiB0aGUgRHluYW1vREIgdGFibGUuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gRERCX1RBQkxFX05BTUVcbiAgICovXG4gIHJlYWRvbmx5IHRhYmxlRW52aXJvbm1lbnRWYXJpYWJsZU5hbWU/OiBzdHJpbmc7XG4gIC8qKlxuICAgKiBBbiBleGlzdGluZyBWUEMgZm9yIHRoZSBjb25zdHJ1Y3QgdG8gdXNlIChjb25zdHJ1Y3Qgd2lsbCBOT1QgY3JlYXRlIGEgbmV3IFZQQyBpbiB0aGlzIGNhc2UpXG4gICAqL1xuICByZWFkb25seSBleGlzdGluZ1ZwYz86IGVjMi5JVnBjO1xuICAvKipcbiAgICogUHJvcGVydGllcyB0byBvdmVycmlkZSBkZWZhdWx0IHByb3BlcnRpZXMgaWYgZGVwbG95VnBjIGlzIHRydWVcbiAgICovXG4gIHJlYWRvbmx5IHZwY1Byb3BzPzogZWMyLlZwY1Byb3BzO1xuICAvKipcbiAgICogV2hldGhlciB0byBkZXBsb3kgYSBuZXcgVlBDXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGRlcGxveVZwYz86IGJvb2xlYW47XG59XG5cbmV4cG9ydCBjbGFzcyBJb3RUb0xhbWJkYVRvRHluYW1vREIgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgaW90VG9waWNSdWxlOiBpb3QuQ2ZuVG9waWNSdWxlO1xuICBwdWJsaWMgcmVhZG9ubHkgbGFtYmRhRnVuY3Rpb246IGxhbWJkYS5GdW5jdGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IGR5bmFtb1RhYmxlOiBkeW5hbW9kYi5UYWJsZTtcbiAgcHVibGljIHJlYWRvbmx5IHZwYz86IGVjMi5JVnBjO1xuXG4gIC8qKlxuICAgKiBAc3VtbWFyeSBDb25zdHJ1Y3RzIGEgbmV3IGluc3RhbmNlIG9mIHRoZSBJb3RUb0xhbWJkYVRvRHluYW1vREIgY2xhc3MuXG4gICAqIEBwYXJhbSB7Y2RrLkFwcH0gc2NvcGUgLSByZXByZXNlbnRzIHRoZSBzY29wZSBmb3IgYWxsIHRoZSByZXNvdXJjZXMuXG4gICAqIEBwYXJhbSB7c3RyaW5nfSBpZCAtIHRoaXMgaXMgYSBhIHNjb3BlLXVuaXF1ZSBpZC5cbiAgICogQHBhcmFtIHtJb3RUb0xhbWJkYVRvRHluYW1vREJQcm9wc30gcHJvcHMgLSB1c2VyIHByb3ZpZGVkIHByb3BzIGZvciB0aGUgY29uc3RydWN0XG4gICAqIEBzaW5jZSAwLjguMFxuICAgKiBAYWNjZXNzIHB1YmxpY1xuICAgKi9cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IElvdFRvTGFtYmRhVG9EeW5hbW9EQlByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICBkZWZhdWx0cy5DaGVja1Byb3BzKHByb3BzKTtcblxuICAgIC8vIE90aGVyIHBlcm1pc3Npb25zIGZvciBjb25zdHJ1Y3RzIGFyZSBhY2NlcHRlZCBhcyBhcnJheXMsIHR1cm5pbmcgdGFibGVQZXJtaXNzaW9ucyBpbnRvXG4gICAgLy8gYW4gYXJyYXkgdG8gdXNlIHRoZSBzYW1lIHZhbGlkYXRpb24gZnVuY3Rpb24uXG4gICAgaWYgKHByb3BzLnRhYmxlUGVybWlzc2lvbnMpIHtcbiAgICAgIGRlZmF1bHRzLkNoZWNrTGlzdFZhbHVlcyhbJ0FsbCcsICdSZWFkJywgJ1JlYWRXcml0ZScsICdXcml0ZSddLCBbcHJvcHMudGFibGVQZXJtaXNzaW9uc10sICd0YWJsZSBwZXJtaXNzaW9uJyk7XG4gICAgfVxuXG4gICAgLy8gU2V0dXAgdGhlIExhbWJkYVRvRHluYW1vREJcbiAgICBjb25zdCBsYW1iZGFUb0R5bmFtb0RCID0gbmV3IExhbWJkYVRvRHluYW1vREIodGhpcywgJ0xhbWJkYVRvRHluYW1vREInLCB7XG4gICAgICB0YWJsZVBlcm1pc3Npb25zOiBwcm9wcy50YWJsZVBlcm1pc3Npb25zLFxuICAgICAgZXhpc3RpbmdMYW1iZGFPYmo6IHByb3BzLmV4aXN0aW5nTGFtYmRhT2JqLFxuICAgICAgbGFtYmRhRnVuY3Rpb25Qcm9wczogcHJvcHMubGFtYmRhRnVuY3Rpb25Qcm9wcyxcbiAgICAgIGR5bmFtb1RhYmxlUHJvcHM6IHByb3BzLmR5bmFtb1RhYmxlUHJvcHMsXG4gICAgICB0YWJsZUVudmlyb25tZW50VmFyaWFibGVOYW1lOiBwcm9wcy50YWJsZUVudmlyb25tZW50VmFyaWFibGVOYW1lLFxuICAgICAgZXhpc3RpbmdWcGM6IHByb3BzLmV4aXN0aW5nVnBjLFxuICAgICAgZGVwbG95VnBjOiBwcm9wcy5kZXBsb3lWcGMsXG4gICAgICB2cGNQcm9wczogcHJvcHMudnBjUHJvcHMsXG4gICAgfSk7XG4gICAgdGhpcy5keW5hbW9UYWJsZSA9IGxhbWJkYVRvRHluYW1vREIuZHluYW1vVGFibGU7XG4gICAgdGhpcy52cGMgPSBsYW1iZGFUb0R5bmFtb0RCLnZwYztcblxuICAgIC8vIFNldHVwIHRoZSBJb3RUb0xhbWJkYVxuICAgIGNvbnN0IGlvdFRvTGFtYmRhID0gbmV3IElvdFRvTGFtYmRhKHRoaXMsICdJb3RUb0xhbWJkYScsIHtcbiAgICAgIGV4aXN0aW5nTGFtYmRhT2JqOiBsYW1iZGFUb0R5bmFtb0RCLmxhbWJkYUZ1bmN0aW9uLFxuICAgICAgaW90VG9waWNSdWxlUHJvcHM6IHByb3BzLmlvdFRvcGljUnVsZVByb3BzXG4gICAgfSk7XG4gICAgdGhpcy5pb3RUb3BpY1J1bGUgPSBpb3RUb0xhbWJkYS5pb3RUb3BpY1J1bGU7XG4gICAgdGhpcy5sYW1iZGFGdW5jdGlvbiA9IGlvdFRvTGFtYmRhLmxhbWJkYUZ1bmN0aW9uO1xuICB9XG59Il19