/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2jwt;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.asn1.der.ListArray;

public class JwtEncryptedPayLoad {
    private byte[] jwtToken = null;
    private byte[] extraLogdata = null;

    public byte[] getJwtToken() {
        return this.jwtToken;
    }

    public void setJwtToken(byte[] byArray) {
        this.jwtToken = byArray;
    }

    public byte[] getExtraLogdata() {
        return this.extraLogdata;
    }

    public void setExtraLogdata(byte[] byArray) {
        this.extraLogdata = byArray;
    }

    public DER getDERObject() {
        ListArray listArray = new ListArray(DER.class);
        DER dER = new DER(0, listArray);
        if (this.jwtToken == null) {
            throw new IllegalArgumentException("Argument jwt token is null");
        }
        DER dER2 = new DER(0, this.jwtToken);
        dER.add(dER2);
        if (this.extraLogdata != null) {
            dER2 = new DER(1, this.extraLogdata);
            dER.add(dER2);
        }
        return dER;
    }

    public void parseDERObject(DER dER) {
        if (0 != dER.getTagNumber()) {
            throw new IllegalArgumentException("Payload not found");
        }
        DER dER2 = dER.getChildrenWithTag(0);
        if (dER2 == null) {
            throw new IllegalArgumentException("JWT token not found ");
        }
        this.jwtToken = dER2.getValueAsOctetString();
        DER dER3 = dER.getChildrenWithTag(1);
        if (dER3 != null) {
            this.extraLogdata = dER3.getValueAsOctetString();
        }
    }
}

