"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPythonClientSourceCode = void 0;
const projen_1 = require("projen");
const languages_1 = require("../../languages");
const utils_1 = require("./utils");
/**
 * Generates the python client using OpenAPI Generator
 */
class GeneratedPythonClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        // Generate the python client
        utils_1.invokeOpenApiGenerator({
            generator: "python-experimental",
            specPath: this.options.specPath,
            outputPath: this.project.outdir,
            generatorDirectory: languages_1.ClientLanguage.PYTHON,
            additionalProperties: {
                packageName: this.project.moduleName,
                projectName: this.project.name,
            },
        });
    }
}
exports.GeneratedPythonClientSourceCode = GeneratedPythonClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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