# range-css-compiler

下の方に日本語の説明があります

## Overview
- More intuitive HTML placement and assignment tool than CSS.
- Intuitive HTML alignment instructions with "Specify by Range".
- Works by equational handling of assignment mutual binding of upper and lower levels of hierarchy like CAD.
- under construction

## Usage
You can execute the following command in the console:
```sh
rcss -i RangeCSS_style_filename.yml
```

The detailed options of the `rcss` command are specified in the following syntax:

```sh
rcss -i [input yaml file path (RangeCSS style file)] [-o [output javascript file path]] [-l]
```

The explanations of each command line argument are as follows:

- -i (--input) : Specifies the path of the input yaml file (RangeCSS style file). This is required.
- -o (--output) : Specifies the path of the output javascript file. This is optional. If omitted, the file name will only change the extension from the input file path.
- -l (--loop) : Enables loop compile mode. In loop compile mode, changes to the yaml file are detected and compilation is automatically executed. If this argument is not specified, it will only be compiled once.

Please refer to "How to write rcss_style.yml" for information on how to write a RangeCSS style file.

## How to write rcss_style.yml
```yaml
rcss_frame: # The rcss_id of the element (the outermost element must be 'rcss_frame')
  css_id: rcss_frame # The id of the element in html
  children: [header, main] # List of rcss_id of child elements
  align: vertical # Alignment of child elements (vertical(default) or horizontal)
header:
  children: []
  css_id: header
  margin_y0: 10px # Top margin in the vertical direction (omitted if 0. Not shared with the top element's margin)
  width: "~" # Width of the element. Refer to `## Range-based specification format` for the method of specifying it.
  height: 70px # Height of the element
main:
  children: [some_other_element]
  align: horizontal
  css_id: main
  margin_y0: 10px
  margin_y1: 10px # Bottom margin in the vertical direction
  width: "~"
  height: "~"
```

## Range-based specification format

- Absolute value specification: `10px`
- Range specification: `10px~20px`
- Range specification without lower limit: `~20px`
- Range specification without upper and lower limit: `~`
- Basic value specification: `10px~100px[50px]`

## Reference: List of attributes
`(default: ...)` means default value without specification
```
css_id: The id of the element in html
children: List of rcss_id of child elements (default: [])
align: Alignment direction of child elements (default: vertical)
width: Width of the element (default: ~)
height: Height of the element (default: ~)
margin_x0: Left margin in the horizontal direction (default: 0px)
margin_x1: Right margin in the horizontal direction (default: 0px)
margin_y0: Top margin in the vertical direction (default: 0px)
margin_y1: Bottom margin in the vertical direction (default: 0px)
```

## license info
The npm tool 'quadprog' is used under the MIT license. (https://www.npmjs.com/package/quadprog)


## 概略
- CSSよりも直感的なHTMLの配置・割り付けツール
- 「範囲による指定」でHTMLの配置を直感的に指示できる
- 上位・下位階層の割り付け相互束縛をCADのように方程式的に取り扱うことで動作する。
- 説明文は執筆中です

## 利用例
コンソールから下記のように実行することができます
```sh
rcss -i RangeCSS_style_filename.yml
```

`rcss`コマンドの細かいオプションの指定は下記のような文法に従います:
```sh
rcss -i [入力yamlファイルパス(RangeCSSのスタイルファイル)] [-o [出力javascriptファイルパス]] [-l]
```

各コマンドライン引数の説明は下記の通りです:

- -i (--input) : 入力yamlファイル(RangeCSSのスタイルファイル)のパスを指定します。これは必須です。
- -o (--output) : 出力javascriptファイルのパスを指定します。これは任意です。省略された場合は入力ファイルパスから同ファイル名で拡張子のみ変更されます。
- -l (--loop) : ループコンパイルモードを有効にします。ループコンパイルモードではyamlファイルの変更を検知して自動的にコンパイルが実行されます。この引数を指定しない場合、1回のみコンパイルされます

RangeCSS スタイルファイルの書き方は `## rcss_style.yml の書き方` を参照してください

## rcss_style.yml の書き方
```yaml
rcss_frame:	# その要素のrcss_id (一番外側は`rcss_frame`である必要がある)
  css_id: rcss_frame	# html内のその要素のid
  children: [header, main]	# 子要素のrcss_idのリスト
  align: vertical	# 子要素の配置 (vertical(default) もしくは horizontal)
header:
  children: []
  css_id: header
  margin_y0: 10px	# 縦方向の上側のマージン (省略されると0となる。上要素のマージンと共有されない)
  width: "~"	# 要素の幅。`~`などの指定方法は、`## 範囲による指定の形式` を参照
  height: 70px	# 要素の高さ
main:
  children: [some_other_element]
  align: horizontal
  css_id: main
  margin_y0: 10px
  margin_y1: 10px	# 縦方向の下側のマージン
  width: "~"
  height: "~"
```

## 範囲による指定の形式
- 絶対値指定: `10px`
- 範囲指定: `10px~20px`
- 下限のない範囲指定: `~20px`
- 上限・下限なし: `~`
- 基本値の指定: `10px~100px[50px]`

## 参考: 属性の一覧
`(default: ...)`は指定なしの場合のデフォルト値

```
css_id: html内のその要素のid
children: 子要素のrcss_idのリスト (default: [])
align: 子要素の配置方向 (default: vertical)
width: 要素の幅 (default: ~)
height: 要素の高さ (default: ~)
margin_x0: 横方向の左側のマージン (default: 0px)
margin_x1: 横方向の右側のマージン (default: 0px)
margin_y0: 縦方向の上側のマージン (default: 0px)
margin_y1: 縦方向の下側のマージン (default: 0px)
```
