# coding: utf-8

"""
    NiFi Rest API

    The Rest API provides programmatic access to command and control a NiFi instance in real time. Start and                                             stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.15.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ConfigurationAnalysisDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'component_id': 'str',
        'properties': 'dict(str, str)',
        'referenced_attributes': 'dict(str, str)',
        'supports_verification': 'bool'
    }

    attribute_map = {
        'component_id': 'componentId',
        'properties': 'properties',
        'referenced_attributes': 'referencedAttributes',
        'supports_verification': 'supportsVerification'
    }

    def __init__(self, component_id=None, properties=None, referenced_attributes=None, supports_verification=None):
        """
        ConfigurationAnalysisDTO - a model defined in Swagger
        """

        self._component_id = None
        self._properties = None
        self._referenced_attributes = None
        self._supports_verification = None

        if component_id is not None:
          self.component_id = component_id
        if properties is not None:
          self.properties = properties
        if referenced_attributes is not None:
          self.referenced_attributes = referenced_attributes
        if supports_verification is not None:
          self.supports_verification = supports_verification

    @property
    def component_id(self):
        """
        Gets the component_id of this ConfigurationAnalysisDTO.
        The ID of the component

        :return: The component_id of this ConfigurationAnalysisDTO.
        :rtype: str
        """
        return self._component_id

    @component_id.setter
    def component_id(self, component_id):
        """
        Sets the component_id of this ConfigurationAnalysisDTO.
        The ID of the component

        :param component_id: The component_id of this ConfigurationAnalysisDTO.
        :type: str
        """

        self._component_id = component_id

    @property
    def properties(self):
        """
        Gets the properties of this ConfigurationAnalysisDTO.
        The configured properties for the component

        :return: The properties of this ConfigurationAnalysisDTO.
        :rtype: dict(str, str)
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this ConfigurationAnalysisDTO.
        The configured properties for the component

        :param properties: The properties of this ConfigurationAnalysisDTO.
        :type: dict(str, str)
        """

        self._properties = properties

    @property
    def referenced_attributes(self):
        """
        Gets the referenced_attributes of this ConfigurationAnalysisDTO.
        The attributes that are referenced by the properties, mapped to recently used values

        :return: The referenced_attributes of this ConfigurationAnalysisDTO.
        :rtype: dict(str, str)
        """
        return self._referenced_attributes

    @referenced_attributes.setter
    def referenced_attributes(self, referenced_attributes):
        """
        Sets the referenced_attributes of this ConfigurationAnalysisDTO.
        The attributes that are referenced by the properties, mapped to recently used values

        :param referenced_attributes: The referenced_attributes of this ConfigurationAnalysisDTO.
        :type: dict(str, str)
        """

        self._referenced_attributes = referenced_attributes

    @property
    def supports_verification(self):
        """
        Gets the supports_verification of this ConfigurationAnalysisDTO.
        Whether or not the component supports verification

        :return: The supports_verification of this ConfigurationAnalysisDTO.
        :rtype: bool
        """
        return self._supports_verification

    @supports_verification.setter
    def supports_verification(self, supports_verification):
        """
        Sets the supports_verification of this ConfigurationAnalysisDTO.
        Whether or not the component supports verification

        :param supports_verification: The supports_verification of this ConfigurationAnalysisDTO.
        :type: bool
        """

        self._supports_verification = supports_verification

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ConfigurationAnalysisDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
