# coding: utf-8

"""
    NiFi Rest API

    The Rest API provides programmatic access to command and control a NiFi instance in real time. Start and                                             stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.15.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ConnectionDiagnosticsDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'connection': 'ConnectionDTO',
        'aggregate_snapshot': 'ConnectionDiagnosticsSnapshotDTO',
        'node_snapshots': 'list[ConnectionDiagnosticsSnapshotDTO]'
    }

    attribute_map = {
        'connection': 'connection',
        'aggregate_snapshot': 'aggregateSnapshot',
        'node_snapshots': 'nodeSnapshots'
    }

    def __init__(self, connection=None, aggregate_snapshot=None, node_snapshots=None):
        """
        ConnectionDiagnosticsDTO - a model defined in Swagger
        """

        self._connection = None
        self._aggregate_snapshot = None
        self._node_snapshots = None

        if connection is not None:
          self.connection = connection
        if aggregate_snapshot is not None:
          self.aggregate_snapshot = aggregate_snapshot
        if node_snapshots is not None:
          self.node_snapshots = node_snapshots

    @property
    def connection(self):
        """
        Gets the connection of this ConnectionDiagnosticsDTO.
        Details about the connection

        :return: The connection of this ConnectionDiagnosticsDTO.
        :rtype: ConnectionDTO
        """
        return self._connection

    @connection.setter
    def connection(self, connection):
        """
        Sets the connection of this ConnectionDiagnosticsDTO.
        Details about the connection

        :param connection: The connection of this ConnectionDiagnosticsDTO.
        :type: ConnectionDTO
        """

        self._connection = connection

    @property
    def aggregate_snapshot(self):
        """
        Gets the aggregate_snapshot of this ConnectionDiagnosticsDTO.
        Aggregate values for all nodes in the cluster, or for this instance if not clustered

        :return: The aggregate_snapshot of this ConnectionDiagnosticsDTO.
        :rtype: ConnectionDiagnosticsSnapshotDTO
        """
        return self._aggregate_snapshot

    @aggregate_snapshot.setter
    def aggregate_snapshot(self, aggregate_snapshot):
        """
        Sets the aggregate_snapshot of this ConnectionDiagnosticsDTO.
        Aggregate values for all nodes in the cluster, or for this instance if not clustered

        :param aggregate_snapshot: The aggregate_snapshot of this ConnectionDiagnosticsDTO.
        :type: ConnectionDiagnosticsSnapshotDTO
        """

        self._aggregate_snapshot = aggregate_snapshot

    @property
    def node_snapshots(self):
        """
        Gets the node_snapshots of this ConnectionDiagnosticsDTO.
        A list of values for each node in the cluster, if clustered.

        :return: The node_snapshots of this ConnectionDiagnosticsDTO.
        :rtype: list[ConnectionDiagnosticsSnapshotDTO]
        """
        return self._node_snapshots

    @node_snapshots.setter
    def node_snapshots(self, node_snapshots):
        """
        Sets the node_snapshots of this ConnectionDiagnosticsDTO.
        A list of values for each node in the cluster, if clustered.

        :param node_snapshots: The node_snapshots of this ConnectionDiagnosticsDTO.
        :type: list[ConnectionDiagnosticsSnapshotDTO]
        """

        self._node_snapshots = node_snapshots

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ConnectionDiagnosticsDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
