# coding: utf-8

"""
    NiFi Rest API

    The Rest API provides programmatic access to command and control a NiFi instance in real time. Start and                                             stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.15.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ParameterDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'sensitive': 'bool',
        'value': 'str',
        'value_removed': 'bool',
        'referencing_components': 'list[AffectedComponentEntity]',
        'parameter_context': 'ParameterContextReferenceEntity',
        'inherited': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'sensitive': 'sensitive',
        'value': 'value',
        'value_removed': 'valueRemoved',
        'referencing_components': 'referencingComponents',
        'parameter_context': 'parameterContext',
        'inherited': 'inherited'
    }

    def __init__(self, name=None, description=None, sensitive=None, value=None, value_removed=None, referencing_components=None, parameter_context=None, inherited=None):
        """
        ParameterDTO - a model defined in Swagger
        """

        self._name = None
        self._description = None
        self._sensitive = None
        self._value = None
        self._value_removed = None
        self._referencing_components = None
        self._parameter_context = None
        self._inherited = None

        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if sensitive is not None:
          self.sensitive = sensitive
        if value is not None:
          self.value = value
        if value_removed is not None:
          self.value_removed = value_removed
        if referencing_components is not None:
          self.referencing_components = referencing_components
        if parameter_context is not None:
          self.parameter_context = parameter_context
        if inherited is not None:
          self.inherited = inherited

    @property
    def name(self):
        """
        Gets the name of this ParameterDTO.
        The name of the Parameter

        :return: The name of this ParameterDTO.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ParameterDTO.
        The name of the Parameter

        :param name: The name of this ParameterDTO.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this ParameterDTO.
        The description of the Parameter

        :return: The description of this ParameterDTO.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ParameterDTO.
        The description of the Parameter

        :param description: The description of this ParameterDTO.
        :type: str
        """

        self._description = description

    @property
    def sensitive(self):
        """
        Gets the sensitive of this ParameterDTO.
        Whether or not the Parameter is sensitive

        :return: The sensitive of this ParameterDTO.
        :rtype: bool
        """
        return self._sensitive

    @sensitive.setter
    def sensitive(self, sensitive):
        """
        Sets the sensitive of this ParameterDTO.
        Whether or not the Parameter is sensitive

        :param sensitive: The sensitive of this ParameterDTO.
        :type: bool
        """

        self._sensitive = sensitive

    @property
    def value(self):
        """
        Gets the value of this ParameterDTO.
        The value of the Parameter

        :return: The value of this ParameterDTO.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this ParameterDTO.
        The value of the Parameter

        :param value: The value of this ParameterDTO.
        :type: str
        """

        self._value = value

    @property
    def value_removed(self):
        """
        Gets the value_removed of this ParameterDTO.
        Whether or not the value of the Parameter was removed. When a request is made to change a parameter, the value may be null. The absence of the value may be used either to indicate that the value is not to be changed, or that the value is to be set to null (i.e., removed). This denotes which of the two scenarios is being encountered.

        :return: The value_removed of this ParameterDTO.
        :rtype: bool
        """
        return self._value_removed

    @value_removed.setter
    def value_removed(self, value_removed):
        """
        Sets the value_removed of this ParameterDTO.
        Whether or not the value of the Parameter was removed. When a request is made to change a parameter, the value may be null. The absence of the value may be used either to indicate that the value is not to be changed, or that the value is to be set to null (i.e., removed). This denotes which of the two scenarios is being encountered.

        :param value_removed: The value_removed of this ParameterDTO.
        :type: bool
        """

        self._value_removed = value_removed

    @property
    def referencing_components(self):
        """
        Gets the referencing_components of this ParameterDTO.
        The set of all components in the flow that are referencing this Parameter

        :return: The referencing_components of this ParameterDTO.
        :rtype: list[AffectedComponentEntity]
        """
        return self._referencing_components

    @referencing_components.setter
    def referencing_components(self, referencing_components):
        """
        Sets the referencing_components of this ParameterDTO.
        The set of all components in the flow that are referencing this Parameter

        :param referencing_components: The referencing_components of this ParameterDTO.
        :type: list[AffectedComponentEntity]
        """

        self._referencing_components = referencing_components

    @property
    def parameter_context(self):
        """
        Gets the parameter_context of this ParameterDTO.
        A reference to the Parameter Context that contains this one

        :return: The parameter_context of this ParameterDTO.
        :rtype: ParameterContextReferenceEntity
        """
        return self._parameter_context

    @parameter_context.setter
    def parameter_context(self, parameter_context):
        """
        Sets the parameter_context of this ParameterDTO.
        A reference to the Parameter Context that contains this one

        :param parameter_context: The parameter_context of this ParameterDTO.
        :type: ParameterContextReferenceEntity
        """

        self._parameter_context = parameter_context

    @property
    def inherited(self):
        """
        Gets the inherited of this ParameterDTO.
        Whether or not the Parameter is inherited from another context

        :return: The inherited of this ParameterDTO.
        :rtype: bool
        """
        return self._inherited

    @inherited.setter
    def inherited(self, inherited):
        """
        Sets the inherited of this ParameterDTO.
        Whether or not the Parameter is inherited from another context

        :param inherited: The inherited of this ParameterDTO.
        :type: bool
        """

        self._inherited = inherited

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ParameterDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
