# coding: utf-8

"""
    NiFi Rest API

    The Rest API provides programmatic access to command and control a NiFi instance in real time. Start and                                             stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.15.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ProcessorRunStatusDetailsEntity(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'revision': 'RevisionDTO',
        'permissions': 'PermissionsDTO',
        'run_status_details': 'ProcessorRunStatusDetailsDTO'
    }

    attribute_map = {
        'revision': 'revision',
        'permissions': 'permissions',
        'run_status_details': 'runStatusDetails'
    }

    def __init__(self, revision=None, permissions=None, run_status_details=None):
        """
        ProcessorRunStatusDetailsEntity - a model defined in Swagger
        """

        self._revision = None
        self._permissions = None
        self._run_status_details = None

        if revision is not None:
          self.revision = revision
        if permissions is not None:
          self.permissions = permissions
        if run_status_details is not None:
          self.run_status_details = run_status_details

    @property
    def revision(self):
        """
        Gets the revision of this ProcessorRunStatusDetailsEntity.
        The revision for the Processor.

        :return: The revision of this ProcessorRunStatusDetailsEntity.
        :rtype: RevisionDTO
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """
        Sets the revision of this ProcessorRunStatusDetailsEntity.
        The revision for the Processor.

        :param revision: The revision of this ProcessorRunStatusDetailsEntity.
        :type: RevisionDTO
        """

        self._revision = revision

    @property
    def permissions(self):
        """
        Gets the permissions of this ProcessorRunStatusDetailsEntity.
        The permissions for the Processor.

        :return: The permissions of this ProcessorRunStatusDetailsEntity.
        :rtype: PermissionsDTO
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """
        Sets the permissions of this ProcessorRunStatusDetailsEntity.
        The permissions for the Processor.

        :param permissions: The permissions of this ProcessorRunStatusDetailsEntity.
        :type: PermissionsDTO
        """

        self._permissions = permissions

    @property
    def run_status_details(self):
        """
        Gets the run_status_details of this ProcessorRunStatusDetailsEntity.
        The details of a Processor's run status

        :return: The run_status_details of this ProcessorRunStatusDetailsEntity.
        :rtype: ProcessorRunStatusDetailsDTO
        """
        return self._run_status_details

    @run_status_details.setter
    def run_status_details(self, run_status_details):
        """
        Sets the run_status_details of this ProcessorRunStatusDetailsEntity.
        The details of a Processor's run status

        :param run_status_details: The run_status_details of this ProcessorRunStatusDetailsEntity.
        :type: ProcessorRunStatusDetailsDTO
        """

        self._run_status_details = run_status_details

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ProcessorRunStatusDetailsEntity):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
