# coding: utf-8

"""
    Apache NiFi Registry REST API

    The REST API provides an interface to a registry with operations for saving, versioning, reading NiFi flows and components.

    OpenAPI spec version: 1.15.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class BundleVersion(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'link': 'JaxbLink',
        'version_metadata': 'BundleVersionMetadata',
        'dependencies': 'list[BundleVersionDependency]',
        'bundle': 'ExtensionBundle',
        'bucket': 'Bucket',
        'filename': 'str'
    }

    attribute_map = {
        'link': 'link',
        'version_metadata': 'versionMetadata',
        'dependencies': 'dependencies',
        'bundle': 'bundle',
        'bucket': 'bucket',
        'filename': 'filename'
    }

    def __init__(self, link=None, version_metadata=None, dependencies=None, bundle=None, bucket=None, filename=None):
        """
        BundleVersion - a model defined in Swagger
        """

        self._link = None
        self._version_metadata = None
        self._dependencies = None
        self._bundle = None
        self._bucket = None
        self._filename = None

        if link is not None:
          self.link = link
        self.version_metadata = version_metadata
        if dependencies is not None:
          self.dependencies = dependencies
        if bundle is not None:
          self.bundle = bundle
        if bucket is not None:
          self.bucket = bucket
        if filename is not None:
          self.filename = filename

    @property
    def link(self):
        """
        Gets the link of this BundleVersion.
        An WebLink to this entity.

        :return: The link of this BundleVersion.
        :rtype: JaxbLink
        """
        return self._link

    @link.setter
    def link(self, link):
        """
        Sets the link of this BundleVersion.
        An WebLink to this entity.

        :param link: The link of this BundleVersion.
        :type: JaxbLink
        """

        self._link = link

    @property
    def version_metadata(self):
        """
        Gets the version_metadata of this BundleVersion.
        The metadata about this version of the extension bundle

        :return: The version_metadata of this BundleVersion.
        :rtype: BundleVersionMetadata
        """
        return self._version_metadata

    @version_metadata.setter
    def version_metadata(self, version_metadata):
        """
        Sets the version_metadata of this BundleVersion.
        The metadata about this version of the extension bundle

        :param version_metadata: The version_metadata of this BundleVersion.
        :type: BundleVersionMetadata
        """
        if version_metadata is None:
            raise ValueError("Invalid value for `version_metadata`, must not be `None`")

        self._version_metadata = version_metadata

    @property
    def dependencies(self):
        """
        Gets the dependencies of this BundleVersion.
        The set of other bundle versions that this version is dependent on

        :return: The dependencies of this BundleVersion.
        :rtype: list[BundleVersionDependency]
        """
        return self._dependencies

    @dependencies.setter
    def dependencies(self, dependencies):
        """
        Sets the dependencies of this BundleVersion.
        The set of other bundle versions that this version is dependent on

        :param dependencies: The dependencies of this BundleVersion.
        :type: list[BundleVersionDependency]
        """

        self._dependencies = dependencies

    @property
    def bundle(self):
        """
        Gets the bundle of this BundleVersion.
        The bundle this version is for

        :return: The bundle of this BundleVersion.
        :rtype: ExtensionBundle
        """
        return self._bundle

    @bundle.setter
    def bundle(self, bundle):
        """
        Sets the bundle of this BundleVersion.
        The bundle this version is for

        :param bundle: The bundle of this BundleVersion.
        :type: ExtensionBundle
        """

        self._bundle = bundle

    @property
    def bucket(self):
        """
        Gets the bucket of this BundleVersion.
        The bucket that the extension bundle belongs to

        :return: The bucket of this BundleVersion.
        :rtype: Bucket
        """
        return self._bucket

    @bucket.setter
    def bucket(self, bucket):
        """
        Sets the bucket of this BundleVersion.
        The bucket that the extension bundle belongs to

        :param bucket: The bucket of this BundleVersion.
        :type: Bucket
        """

        self._bucket = bucket

    @property
    def filename(self):
        """
        Gets the filename of this BundleVersion.

        :return: The filename of this BundleVersion.
        :rtype: str
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """
        Sets the filename of this BundleVersion.

        :param filename: The filename of this BundleVersion.
        :type: str
        """

        self._filename = filename

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, BundleVersion):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
