# Generated by Django 3.2.11 on 2022-07-06 10:18

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        (
            "django_aws_api_gateway_websockets",
            "0002_rename_author_websocketsession_user",
        ),
    ]

    operations = [
        migrations.CreateModel(
            name="ApiGateway",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("api_name", models.CharField(max_length=255, unique=True)),
                (
                    "api_description",
                    models.CharField(blank=True, default="", max_length=255),
                ),
                (
                    "default_channel_name",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Automatically sets the 'channel' on the WebSocketSession record for the connection",
                        max_length=128,
                    ),
                ),
                (
                    "domain_name",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The full domain you wish to use for the API endpoint. E.G ws.example.com",
                        max_length=255,
                    ),
                ),
                (
                    "target_base_endpoint",
                    models.URLField(
                        blank=True,
                        default=None,
                        help_text="The URL on your website where the API Gateway routes will point, including the trailing /, but excluding the final route/slug portion of the URL. E.G. If your default route will point to https://www.example.com/ws/default then enter https://www.example.com/ws/",
                        null=True,
                    ),
                ),
                (
                    "certificate_arn",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The ARN of the certificate to use from AWS Certificate Manager",
                        max_length=255,
                    ),
                ),
                (
                    "hosted_zone_id",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The Hosted Zone ID from AWs Route 53 for the domain you wish to use",
                        max_length=32,
                    ),
                ),
                (
                    "api_key_selection_expression",
                    models.CharField(
                        default="$request.header.x-api-key", max_length=255
                    ),
                ),
                (
                    "route_selection_expression",
                    models.CharField(default="$request.body.action", max_length=255),
                ),
                ("route_key", models.CharField(default="$default", max_length=255)),
                (
                    "stage_name",
                    models.CharField(blank=True, default="production", max_length=63),
                ),
                (
                    "stage_description",
                    models.CharField(blank=True, default="", max_length=63),
                ),
                (
                    "tags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text='In format {"tag-name": "tag-value"}',
                    ),
                ),
                (
                    "api_id",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The ID of the Api Gateway returned by AWS",
                        max_length=32,
                    ),
                ),
                (
                    "api_endpoint",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The Api Gateway endpoint",
                        max_length=255,
                    ),
                ),
                (
                    "api_gateway_domain_name",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The value to point your CNAME record to",
                        max_length=255,
                    ),
                ),
                (
                    "api_mapping_id",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The ApiMappingId to use with api_mapping calls",
                        max_length=128,
                    ),
                ),
                ("api_created", models.BooleanField(default=False, editable=False)),
                (
                    "custom_domain_created",
                    models.BooleanField(default=False, editable=False),
                ),
                ("created_on", models.DateTimeField(auto_now_add=True)),
                ("updated_on", models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.AddIndex(
            model_name="apigateway",
            index=models.Index(fields=["api_id"], name="django_aws__api_id_0da7ec_idx"),
        ),
        migrations.AddIndex(
            model_name="apigateway",
            index=models.Index(
                fields=["domain_name"], name="django_aws__domain__3b4423_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="apigateway",
            index=models.Index(
                fields=["custom_domain_created"], name="django_aws__custom__5e8390_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="apigateway",
            index=models.Index(
                fields=["api_created"], name="django_aws__api_cre_376add_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="apigateway",
            index=models.Index(
                fields=["created_on"], name="django_aws__created_32cf2a_idx"
            ),
        ),
        migrations.AddField(
            model_name="websocketsession",
            name="api_gateway",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="sessions",
                to="django_aws_api_gateway_websockets.apigateway",
            ),
        ),
    ]
