# Python library for single or multi-account automated trading on Zerodha, Upstox, AliceBlue, Finvasia, Angel Broking, Fyers, IIFL

## Introduction
**[AutoTrader Web](https://stocksdeveloper.in/autotrader-web/)** is our next generation automated trading & PMS software suite. **Most preferred tool by portfolio & fund managers, algorithmic traders as well as sub-brokers.**

It allows you to **trade & manage multiple trading accounts** across **different stock brokers from a single system**.

You can trade **manually or automate your trading** strategies using our APIs. We provide easy to use **API libraries in AmiBroker, MetaTrader, Excel, Java, Python, C#**. You can also use our APIs from **any other programming languages via HTTP REST or CSV files**.

Our aim is to provide advanced features to our users, which are mostly available to HNI or wealthy fund managers in their custom built trading systems.

Massively reduce trading costs based on following features:
- **No need to purchase API subscription** from your stock broker
- Reduced development efforts as you can **change stock broker with just a few clicks**
- **Multi-account trading from a single system**, so you only need one computer and one datafeed

## Features
- Trade & manage multiple trading accounts from anywhere via browser on mobile or PC
- Allows your trading strategies to place/modify/cancel orders as well as read live portfolio
- Low latency (less than 200 milliseconds on average for order placements)
- Works across all operating systems (Windows, Mac, Unix, Linux)
- Place bulk orders into one or more trading accounts
- Truly broker independent. Switch your trading account across any broker without making any code change
  - System handles broker specific implementation internally
  - System also handles broker specific trading symbol formats internally
- Support for well known brokers
  - Zerodha
  - Upstox
  - AliceBlue
  - Finvasia
  - Fyers
  - Angel Broking
  - IIFL
- A **[complete list of features](https://stocksdeveloper.in/autotrader-web-features/)**

## Help
- **[User Guide](https://stocksdeveloper.in/documentation/index/)**
- **[User Guide - Python Library](https://stocksdeveloper.in/documentation/client-setup/python-library/)**
- **[User Guide - API Docs](https://stocksdeveloper.in/documentation/api/)**
