/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.KeywordValueLongI;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.XSKeyvalI;
import oracle.jdbc.driver.XSNamespaceI;
import oracle.jdbc.driver.XSPrincipalI;
import oracle.jdbc.driver.XSSecureIdI;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.XSKeyval;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.internal.XSPrincipal;
import oracle.jdbc.internal.XSSecureId;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4CTTIoxscre
extends T4CTTIfun {
    private OracleConnection.XSSessionOperationCode opcode;
    private XSSecureId sidp;
    private byte[] cookie;
    private XSPrincipal username;
    private byte[] tenantBytes;
    private XSNamespace[] namespaces;
    private OracleConnection.XSSessionModeFlag mode;
    private XSKeyval kv;
    private byte[] sessionId = null;

    T4CTTIoxscre(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)179);
    }

    void doOXSCRE(OracleConnection.XSSessionOperationCode xSSessionOperationCode, XSSecureId xSSecureId, byte[] byArray, XSPrincipal xSPrincipal, String string, XSNamespace[] xSNamespaceArray, OracleConnection.XSSessionModeFlag xSSessionModeFlag, XSKeyval xSKeyval) throws IOException, SQLException {
        KeywordValueLong[] keywordValueLongArray;
        this.opcode = xSSessionOperationCode;
        this.sidp = xSSecureId;
        this.cookie = byArray;
        this.username = xSPrincipal;
        if (xSPrincipal != null) {
            ((XSPrincipalI)xSPrincipal).doCharConversion(this.meg.conv);
        }
        this.tenantBytes = (byte[])(string != null && string.length() > 0 ? this.meg.conv.StringToCharBytes(string) : null);
        this.namespaces = xSNamespaceArray;
        if (xSNamespaceArray != null) {
            for (int i2 = 0; i2 < xSNamespaceArray.length; ++i2) {
                ((XSNamespaceI)xSNamespaceArray[i2]).doCharConversion(this.meg.conv);
            }
        }
        this.mode = xSSessionModeFlag;
        this.kv = xSKeyval;
        if (xSKeyval != null && (keywordValueLongArray = xSKeyval.getKeyval()) != null) {
            for (int i3 = 0; i3 < keywordValueLongArray.length; ++i3) {
                ((KeywordValueLongI)keywordValueLongArray[i3]).doCharConversion(this.meg.conv);
            }
        }
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalUB4(this.opcode.getCode());
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        boolean bl = false;
        if (this.sidp != null) {
            bl = true;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        boolean bl2 = false;
        if (this.cookie != null && this.cookie.length > 0) {
            bl2 = true;
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.cookie.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        boolean bl3 = false;
        if (this.username != null) {
            bl3 = true;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        boolean bl4 = false;
        if (this.tenantBytes != null) {
            bl4 = true;
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.tenantBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        boolean bl5 = false;
        this.meg.marshalPTR();
        if (this.namespaces != null && this.namespaces.length > 0) {
            bl5 = true;
            this.meg.marshalUB4(this.namespaces.length);
        } else {
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalUB4(this.mode.getCode());
        boolean bl6 = false;
        if (this.kv != null) {
            bl6 = true;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (bl) {
            ((XSSecureIdI)this.sidp).marshal(this.meg);
        }
        if (bl2) {
            this.meg.marshalB1Array(this.cookie);
        }
        if (bl3) {
            ((XSPrincipalI)this.username).marshal(this.meg);
        }
        if (bl4) {
            this.meg.marshalCHR(this.tenantBytes);
        }
        if (bl5) {
            for (int i2 = 0; i2 < this.namespaces.length; ++i2) {
                ((XSNamespaceI)this.namespaces[i2]).marshal(this.meg);
            }
        }
        if (bl6) {
            ((XSKeyvalI)this.kv).marshal(this.meg);
        }
    }

    byte[] getSessionId() {
        return this.sessionId;
    }

    @Override
    void readRPA() throws SQLException, IOException {
        int n2 = (int)this.meg.unmarshalUB4();
        this.sessionId = null;
        if (n2 > 0) {
            this.sessionId = this.meg.unmarshalNBytes(n2);
        }
    }
}

