"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonFunction = void 0;
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const bundling_1 = require("./bundling");
/**
 * (experimental) A Python Lambda function.
 *
 * @experimental
 */
class PythonFunction extends lambda.Function {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b, _c;
        if (props.runtime && props.runtime.family !== lambda.RuntimeFamily.PYTHON) {
            throw new Error('Only `PYTHON` runtimes are supported.');
        }
        if (props.index && !/\.py$/.test(props.index)) {
            throw new Error('Only Python (.py) index files are supported.');
        }
        // Entry and defaults
        const entry = path.resolve(props.entry);
        const index = (_a = props.index) !== null && _a !== void 0 ? _a : 'index.py';
        const resolvedIndex = path.resolve(entry, index);
        if (!fs.existsSync(resolvedIndex)) {
            throw new Error(`Cannot find index file at ${resolvedIndex}`);
        }
        const handler = (_b = props.handler) !== null && _b !== void 0 ? _b : 'handler';
        const runtime = (_c = props.runtime) !== null && _c !== void 0 ? _c : lambda.Runtime.PYTHON_3_7;
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.bundle({
                ...props,
                entry,
                runtime,
            }),
            handler: `${index.slice(0, -3)}.${handler}`,
        });
    }
}
exports.PythonFunction = PythonFunction;
//# sourceMappingURL=data:application/json;base64,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