"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotToLambdaToDynamoDB = void 0;
const aws_iot_lambda_1 = require("@aws-solutions-constructs/aws-iot-lambda");
const aws_lambda_dynamodb_1 = require("@aws-solutions-constructs/aws-lambda-dynamodb");
const core_1 = require("@aws-cdk/core");
class IotToLambdaToDynamoDB extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the IotToLambdaToDynamoDB class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {IotToLambdaToDynamoDBProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        // Setup the IotToLambda
        const iotToLambda = new aws_iot_lambda_1.IotToLambda(this, 'IotToLambda', props);
        this.iotTopicRule = iotToLambda.iotTopicRule;
        this.lambdaFunction = iotToLambda.lambdaFunction;
        // Setup the LambdaToDynamoDB
        const lambdaToDynamoDB = new aws_lambda_dynamodb_1.LambdaToDynamoDB(this, 'LambdaToDynamoDB', {
            deployLambda: false,
            existingLambdaObj: this.lambdaFunction,
            dynamoTableProps: props.dynamoTableProps
        });
        this.dynamoTable = lambdaToDynamoDB.dynamoTable;
    }
}
exports.IotToLambdaToDynamoDB = IotToLambdaToDynamoDB;
//# sourceMappingURL=data:application/json;base64,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