/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.util;

import com.datapps.linkoopdb.jdbc.util.DataAccessPoint;
import com.datapps.linkoopdb.jdbc.util.DataAccessPointException;
import com.datapps.linkoopdb.jdbc.util.JDBCTypes;
import com.datapps.linkoopdb.jdbc.util.Traceable;
import com.datapps.linkoopdb.jdbc.util.TransferResultSet;
import com.datapps.linkoopdb.jdbc.util.TransferTable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

class TransferSQLText
extends DataAccessPoint {
    protected boolean StructureAlreadyParsed = false;
    protected JDBCTypes JDBCT = null;
    String sFileName = null;
    BufferedWriter WTextWrite = null;
    BufferedReader WTextRead = null;
    Hashtable DbStmts = null;

    TransferSQLText(String _FileName, Traceable t) throws DataAccessPointException {
        super(t);
        this.sFileName = _FileName;
        this.JDBCT = new JDBCTypes();
        if (this.sFileName == null) {
            throw new DataAccessPointException("File name not initialized");
        }
    }

    @Override
    boolean execute(String statement) throws DataAccessPointException {
        if (this.WTextWrite == null) {
            try {
                this.WTextWrite = new BufferedWriter(new FileWriter(this.sFileName));
            }
            catch (IOException e) {
                throw new DataAccessPointException(e.getMessage());
            }
        }
        try {
            this.WTextWrite.write(statement + "\n");
            this.WTextWrite.flush();
        }
        catch (IOException e) {
            throw new DataAccessPointException(e.getMessage());
        }
        return true;
    }

    @Override
    void putData(String statement, TransferResultSet r, int iMaxRows) throws DataAccessPointException {
        int i = 0;
        if (r == null) {
            return;
        }
        if (this.WTextWrite == null) {
            try {
                this.WTextWrite = new BufferedWriter(new FileWriter(this.sFileName));
            }
            catch (IOException e) {
                throw new DataAccessPointException(e.getMessage());
            }
        }
        try {
            while (r.next()) {
                if (i == 0) {
                    this.WTextWrite.write(statement + "\n");
                    this.WTextWrite.flush();
                }
                this.transferRow(r);
                if (iMaxRows != 0 && i == iMaxRows) {
                    break;
                }
                if (iMaxRows == 0 && ++i % 100 != 0) continue;
                this.tracer.trace("Transfered " + i + " rows");
            }
        }
        catch (Exception e) {
            throw new DataAccessPointException(e.getMessage());
        }
        finally {
            try {
                if (i > 0) {
                    this.WTextWrite.write("\tNumber of Rows=" + i + "\n\n");
                    this.WTextWrite.flush();
                }
            }
            catch (IOException e) {
                throw new DataAccessPointException(e.getMessage());
            }
        }
    }

    @Override
    void close() throws DataAccessPointException {
        if (this.WTextWrite != null) {
            try {
                this.WTextWrite.flush();
                this.WTextWrite.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void transferRow(TransferResultSet r) throws Exception {
        String sLast = "";
        int len = r.getColumnCount();
        if (this.WTextWrite == null) {
            try {
                this.WTextWrite = new BufferedWriter(new FileWriter(this.sFileName));
            }
            catch (IOException e) {
                throw new DataAccessPointException(e.getMessage());
            }
        }
        for (int i = 0; i < len; ++i) {
            int t = r.getColumnType(i + 1);
            sLast = "column=" + r.getColumnName(i + 1) + " datatype=" + (String)this.helper.getSupportedTypes().get(new Integer(t));
            Object o = r.getObject(i + 1);
            if (o == null) {
                sLast = sLast + " value=<null>";
            } else {
                o = this.helper.convertColumnValue(o, i + 1, t);
                sLast = sLast + " value='" + o.toString() + "'";
            }
            this.WTextWrite.write("\t" + sLast + "\n");
            this.WTextWrite.flush();
        }
        this.WTextWrite.write("\n");
        this.WTextWrite.flush();
        sLast = "";
    }

    ColumnDef getColumnDef(String ColumnsDesc, int curPos) {
        int nextPos = 0;
        ColumnDef columnDef = new ColumnDef();
        columnDef.start = curPos;
        if (ColumnsDesc == null || ColumnsDesc.length() == 0 || curPos >= ColumnsDesc.length()) {
            return new ColumnDef();
        }
        String stbuff = ColumnsDesc.substring(curPos);
        try {
            char c;
            int i;
            for (i = 0; i < stbuff.length() && ((c = stbuff.charAt(i)) == ',' || c == ' ' || c == ')' || c == ';'); ++i) {
            }
            if (i == stbuff.length()) {
                return new ColumnDef();
            }
            columnDef.len += i;
            stbuff = stbuff.substring(i);
            while (stbuff.charAt(nextPos) != ' ') {
                ++nextPos;
            }
            columnDef.columnName = stbuff.substring(0, nextPos);
            stbuff = stbuff.substring(nextPos);
            columnDef.len += nextPos;
            nextPos = 0;
            if (!columnDef.columnName.toUpperCase().equals("CONSTRAINT")) {
                for (i = 0; i < stbuff.length() && stbuff.charAt(i) == ' '; ++i) {
                }
                stbuff = stbuff.substring(i);
                columnDef.len += i;
                while (stbuff.charAt(nextPos) != '(' && stbuff.charAt(nextPos) != ',' && stbuff.charAt(nextPos) != ')' && stbuff.charAt(nextPos) != ';' && stbuff.charAt(nextPos) != ' ') {
                    ++nextPos;
                }
                columnDef.columnType = stbuff.substring(0, nextPos).toUpperCase();
                stbuff = stbuff.substring(nextPos);
                columnDef.len += nextPos;
                nextPos = 0;
            }
            while (stbuff.charAt(nextPos) != ',' && stbuff.charAt(nextPos) != ';' && nextPos < stbuff.length() && stbuff.charAt(nextPos) != ')') {
                if (stbuff.charAt(nextPos) == '(') {
                    while (stbuff.charAt(nextPos) != ')') {
                        ++nextPos;
                    }
                }
                ++nextPos;
            }
            columnDef.options = stbuff.substring(0, nextPos);
            columnDef.len += nextPos;
        }
        catch (Exception e) {
            columnDef = new ColumnDef();
        }
        return columnDef;
    }

    String translateTypes(String CreateLine, TransferTable TTable, DataAccessPoint Dest) throws DataAccessPointException {
        String translatedLine = "";
        JDBCTypes JDBCT = new JDBCTypes();
        int currentPos = 0;
        String columnName = "";
        String columnType = "";
        int colnum = 0;
        currentPos = CreateLine.indexOf(40) + 1;
        translatedLine = CreateLine.substring(0, currentPos);
        while (true) {
            ColumnDef cDef = this.getColumnDef(CreateLine, currentPos);
            if (cDef.len == 0) break;
            columnName = cDef.columnName;
            columnType = cDef.columnType;
            if (columnName.toUpperCase().indexOf("CONSTRAINT") >= 0) {
                translatedLine = translatedLine + CreateLine.substring(currentPos, currentPos + cDef.len) + ",";
                currentPos += cDef.len + 1;
                ++colnum;
                continue;
            }
            columnName = Dest.helper.formatIdentifier(columnName) + " ";
            try {
                Integer inttype = new Integer(Dest.helper.convertToType(JDBCT.toInt(columnType)));
                columnType = (String)TTable.hTypes.get(inttype);
            }
            catch (Exception inttype) {
                // empty catch block
            }
            if (cDef.options != null) {
                columnType = columnType + cDef.options;
            }
            try {
                columnType = Dest.helper.fixupColumnDefWrite(TTable, null, columnType, null, colnum);
            }
            catch (SQLException SQLe) {
                return CreateLine;
            }
            translatedLine = translatedLine + columnName + " " + columnType + ",";
            currentPos += cDef.len + 1;
            ++colnum;
        }
        return translatedLine.substring(0, translatedLine.length() - 1) + ");";
    }

    void parseFileForTables() throws DataAccessPointException {
        if (this.WTextRead == null) {
            try {
                this.WTextRead = new BufferedReader(new FileReader(this.sFileName));
            }
            catch (IOException e) {
                throw new DataAccessPointException(e.getMessage());
            }
        }
        String currentLine = "";
        String Token2 = "";
        String name = "";
        TransferTable relatedTable = null;
        try {
            while ((currentLine = this.WTextRead.readLine()) != null) {
                currentLine = currentLine.trim() + ";";
                StringTokenizer Tokenizer2 = new StringTokenizer(currentLine);
                try {
                    Token2 = Tokenizer2.nextToken();
                }
                catch (NoSuchElementException NSE) {
                    continue;
                }
                if (Token2 == null || !Token2.toUpperCase().equals("CREATE") || !(Token2 = Tokenizer2.nextToken().toUpperCase()).equals("TABLE") && !Token2.equals("VIEW")) continue;
                try {
                    name = Tokenizer2.nextToken(" (;");
                    relatedTable = new TransferTable(this, name, "", Token2, this.tracer);
                    relatedTable.Stmts.bCreate = false;
                    relatedTable.Stmts.bDelete = false;
                    relatedTable.Stmts.bDrop = false;
                    relatedTable.Stmts.bCreateIndex = false;
                    relatedTable.Stmts.bDropIndex = false;
                    relatedTable.Stmts.bInsert = false;
                    relatedTable.Stmts.bAlter = false;
                    this.DbStmts.put(relatedTable.Stmts.sSourceTable, relatedTable);
                }
                catch (NoSuchElementException NSE) {}
            }
        }
        catch (Exception IOe) {
            throw new DataAccessPointException(IOe.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseFileForTheRest(TransferTable TTable, DataAccessPoint Dest) throws DataAccessPointException {
        this.StructureAlreadyParsed = true;
        if (this.WTextRead == null) {
            try {
                this.WTextRead = new BufferedReader(new FileReader(this.sFileName));
            }
            catch (IOException e) {
                throw new DataAccessPointException(e.getMessage());
            }
        }
        String currentLine = "";
        String Token2 = "";
        String name = "";
        TransferTable relatedTable = null;
        try {
            while ((currentLine = this.WTextRead.readLine()) != null) {
                currentLine = currentLine.trim() + ";";
                StringTokenizer Tokenizer2 = new StringTokenizer(currentLine);
                try {
                    Token2 = Tokenizer2.nextToken();
                }
                catch (NoSuchElementException NSE) {
                    continue;
                }
                if (Token2 == null) continue;
                if (Token2.toUpperCase().equals("INSERT")) {
                    try {
                        if (!Tokenizer2.nextToken().toUpperCase().equals("INTO")) {
                            throw new DataAccessPointException("Error in INSERT statement: no INTO found");
                        }
                        Token2 = Tokenizer2.nextToken();
                        relatedTable = (TransferTable)this.DbStmts.get(Token2);
                        if (relatedTable == null) continue;
                        relatedTable.Stmts.bDelete = true;
                        relatedTable.Stmts.bInsert = true;
                        relatedTable.Stmts.sDestInsert = currentLine;
                        relatedTable.Stmts.sDestDelete = "DELETE FROM " + relatedTable.Stmts.sSourceTable + ";";
                    }
                    catch (NoSuchElementException NSE) {}
                    continue;
                }
                if (Token2.toUpperCase().equals("ALTER")) {
                    try {
                        if (!Tokenizer2.nextToken().toUpperCase().equals("TABLE")) continue;
                        name = Tokenizer2.nextToken();
                        Token2 = Tokenizer2.nextToken().toUpperCase();
                        if (!Token2.equals("ADD")) continue;
                        while (!(Token2 = Tokenizer2.nextToken().toUpperCase()).equals("CONSTRAINT")) {
                        }
                        relatedTable = (TransferTable)this.DbStmts.get(name);
                        if (relatedTable == null) {
                            throw new DataAccessPointException("table not found");
                        }
                        if (relatedTable.Stmts.sDestAlter == null) {
                            relatedTable.Stmts.sDestAlter = "";
                        }
                        relatedTable.Stmts.bAlter = true;
                        relatedTable.Stmts.sDestAlter = relatedTable.Stmts.sDestAlter + currentLine;
                        Token2 = Tokenizer2.nextToken();
                        if (relatedTable.Stmts.sDestDrop == null) {
                            relatedTable.Stmts.sDestDrop = "";
                        }
                        relatedTable.Stmts.bDrop = true;
                        relatedTable.Stmts.sDestDrop = "ALTER TABLE " + name + " DROP CONSTRAINT " + Token2 + ";" + relatedTable.Stmts.sDestDrop;
                    }
                    catch (NoSuchElementException NSE) {}
                    continue;
                }
                if (!Token2.toUpperCase().equals("CREATE")) continue;
                Token2 = Tokenizer2.nextToken().toUpperCase();
                if (Token2.equals("TABLE") || Token2.equals("VIEW")) {
                    try {
                        name = Tokenizer2.nextToken(" (;");
                        if (!this.DbStmts.containsKey(name)) {
                            throw new DataAccessPointException("error: index is created before the table");
                        }
                        relatedTable = (TransferTable)this.DbStmts.get(name);
                        relatedTable.Stmts.bCreate = true;
                        relatedTable.Stmts.bDrop = true;
                        relatedTable.Stmts.sDestCreate = this.translateTypes(currentLine, TTable, Dest);
                        relatedTable.Stmts.sDestDrop = "DROP " + relatedTable.Stmts.sType + " " + name + ";";
                        this.DbStmts.put(relatedTable.Stmts.sSourceTable, relatedTable);
                    }
                    catch (NoSuchElementException NSE) {
                        continue;
                    }
                }
                if (!Token2.equals("INDEX") && !Token2.equals("UNIQUE")) continue;
                try {
                    while ((Token2 = Tokenizer2.nextToken()).toUpperCase().equals("INDEX")) {
                    }
                    String IndexdropCommand = "DROP INDEX " + Token2 + " ;";
                    while ((Token2 = Tokenizer2.nextToken(" (")).toUpperCase().equals("ON")) {
                    }
                    name = Token2;
                    if (!this.DbStmts.containsKey(Token2)) {
                        throw new DataAccessPointException("error: index is created before the table");
                    }
                    relatedTable = (TransferTable)this.DbStmts.get(Token2);
                    if (relatedTable.Stmts.sDestCreateIndex == null) {
                        relatedTable.Stmts.sDestCreateIndex = "";
                    }
                    if (relatedTable.Stmts.sDestDropIndex == null) {
                        relatedTable.Stmts.sDestDropIndex = "";
                    }
                    relatedTable.Stmts.bCreateIndex = true;
                    relatedTable.Stmts.bDropIndex = true;
                    relatedTable.Stmts.sDestCreateIndex = relatedTable.Stmts.sDestCreateIndex + currentLine;
                    relatedTable.Stmts.sDestDropIndex = relatedTable.Stmts.sDestDropIndex + IndexdropCommand;
                }
                catch (NoSuchElementException NSE) {}
            }
            return;
        }
        catch (IOException IOe) {
            throw new DataAccessPointException(IOe.getMessage());
        }
    }

    @Override
    Vector getTables(String sCatalog, String[] sSchemas) throws DataAccessPointException {
        Vector AllTables = new Vector();
        if (this.DbStmts == null) {
            this.DbStmts = new Hashtable();
        }
        if (this.WTextRead != null) {
            try {
                this.WTextRead.close();
                this.WTextRead = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.parseFileForTables();
        this.StructureAlreadyParsed = false;
        Enumeration e = this.DbStmts.elements();
        while (e.hasMoreElements()) {
            AllTables.addElement(e.nextElement());
        }
        return AllTables;
    }

    @Override
    void getTableStructure(TransferTable TTable, DataAccessPoint Dest) throws DataAccessPointException {
        if (!this.StructureAlreadyParsed) {
            if (this.WTextRead != null) {
                try {
                    this.WTextRead.close();
                    this.WTextRead = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.parseFileForTheRest(TTable, Dest);
        }
    }

    @Override
    TransferResultSet getData(String statement) throws DataAccessPointException {
        String tableName = "";
        try {
            StringTokenizer Tokenizer2 = new StringTokenizer(statement);
            while (!Tokenizer2.nextToken().toUpperCase().equals("FROM")) {
            }
            tableName = Tokenizer2.nextToken(" ;");
        }
        catch (NoSuchElementException NSE) {
            throw new DataAccessPointException("Table name not found in statement: " + statement);
        }
        if (this.WTextRead != null) {
            try {
                this.WTextRead.close();
                this.WTextRead = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.parseFileForData(tableName);
    }

    TransferResultSet parseFileForData(String tableName) throws DataAccessPointException {
        TransferResultSet trsData = new TransferResultSet();
        if (this.WTextRead == null) {
            try {
                this.WTextRead = new BufferedReader(new FileReader(this.sFileName));
            }
            catch (IOException e) {
                throw new DataAccessPointException(e.getMessage());
            }
        }
        String currentLine = "";
        try {
            while ((currentLine = this.WTextRead.readLine()) != null) {
                String Token2;
                currentLine = currentLine.trim() + ";";
                StringTokenizer Tokenizer2 = new StringTokenizer(currentLine);
                try {
                    Token2 = Tokenizer2.nextToken();
                }
                catch (NoSuchElementException NSE) {
                    continue;
                }
                if (Token2 == null || !Token2.toUpperCase().equals("INSERT")) continue;
                try {
                    if (!Tokenizer2.nextToken().toUpperCase().equals("INTO")) {
                        throw new DataAccessPointException("Error in INSERT statement: no INTO found");
                    }
                    Token2 = Tokenizer2.nextToken();
                    if (!Token2.equals(tableName)) continue;
                    int iParsedRows = 0;
                    Vector<String> vColumnNames = new Vector<String>();
                    Vector<String> vColumnValues = new Vector<String>();
                    Vector<Integer> vColumnTypes = new Vector<Integer>();
                    while ((currentLine = this.WTextRead.readLine()) != null) {
                        boolean newLine;
                        boolean bl = newLine = (currentLine = currentLine.trim()).length() == 0;
                        if (newLine) {
                            int iColumnNb = 0;
                            ++iParsedRows;
                            iColumnNb = vColumnNames.size();
                            String[] Names = new String[iColumnNb + 1];
                            int[] Types2 = new int[iColumnNb + 1];
                            Object[] Values2 = new Object[iColumnNb + 1];
                            for (int Idx = 0; Idx < iColumnNb; ++Idx) {
                                Names[Idx + 1] = (String)vColumnNames.elementAt(Idx);
                                Types2[Idx + 1] = (Integer)vColumnTypes.elementAt(Idx);
                                Values2[Idx + 1] = vColumnValues.elementAt(Idx);
                            }
                            try {
                                trsData.addRow(Names, Types2, Values2, iColumnNb);
                            }
                            catch (Exception e) {
                                throw new DataAccessPointException(e.getMessage());
                            }
                            iColumnNb = 0;
                            vColumnNames.removeAllElements();
                            vColumnValues.removeAllElements();
                            vColumnTypes.removeAllElements();
                            continue;
                        }
                        Tokenizer2 = new StringTokenizer(currentLine);
                        Token2 = Tokenizer2.nextToken("=");
                        if (Token2.equals("Number of Rows")) {
                            int iNbRows = Integer.parseInt(Tokenizer2.nextToken());
                            if (iNbRows != iParsedRows) {
                                throw new DataAccessPointException("Number of parsed rows (" + iParsedRows + ") is different from the expected (" + iNbRows + ")");
                            }
                            return trsData;
                        }
                        if (Token2.equals("column")) {
                            Token2 = Tokenizer2.nextToken(" =");
                            vColumnNames.addElement(Token2);
                        }
                        if ((Token2 = Tokenizer2.nextToken(" =")).equals("datatype")) {
                            int iType;
                            Token2 = Tokenizer2.nextToken(" =");
                            try {
                                iType = this.JDBCT.toInt(Token2.toUpperCase());
                            }
                            catch (Exception e) {
                                throw new DataAccessPointException("Unknown type: " + Token2);
                            }
                            vColumnTypes.addElement(new Integer(iType));
                        }
                        if (!(Token2 = Tokenizer2.nextToken(" =")).equals("value")) continue;
                        int iStart = currentLine.indexOf("value=") + 6;
                        String sValue = currentLine.substring(iStart).trim();
                        if (sValue.indexOf("<null>") >= 0) {
                            vColumnValues.addElement(null);
                            continue;
                        }
                        int i = sValue.indexOf(39) + 1;
                        String sbToken = sValue.substring(i);
                        i = sbToken.lastIndexOf(39);
                        Token2 = sbToken = sbToken.substring(0, i);
                        vColumnValues.addElement(Token2);
                    }
                }
                catch (IndexOutOfBoundsException IOBe) {
                }
            }
        }
        catch (IOException IOe) {
            throw new DataAccessPointException(IOe.getMessage());
        }
        return trsData;
    }

    class ColumnDef {
        String columnName = "";
        String columnType = "";
        String options = "";
        int start = 0;
        int len = 0;
    }
}

